/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.Utils;
import com.sas.tools.deployjni.proxy.ProxyAPI;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidatorException;
import java.util.LinkedList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.util.EntityUtils;

public class FindProxy {
    private static final String probeMachine1_http = "http://hq.esd.sasinstitute.net/hello";
    private static final String probeMachine1_https = "https://tlshq.esd.sasinstitute.net/hello";
    private static final String probeMachine2_http = "http://esd.sas.com/hello";
    private static final String probeMachine2_https = "https://tlsesd.sas.com/hello";
    private static String authHost;
    private static String authPort;
    private static String authSchemeUsed;
    private static FindProxy findProxyInstance;
    private static boolean authProxyAlreadySet;
    static Pattern pattern;

    public static int findProxy() {
        String probeMachine2;
        String probeMachine1;
        int probeResults = 0;
        int probeResults1 = -1;
        int probeResults2 = -1;
        boolean certError = false;
        authSchemeUsed = null;
        if (Globals.g_httponly) {
            probeMachine1 = probeMachine1_http;
            probeMachine2 = probeMachine2_http;
        } else {
            probeMachine1 = probeMachine1_https;
            probeMachine2 = probeMachine2_https;
        }
        if ("true".equals(System.getProperty("http.proxySet"))) {
            probeResults1 = FindProxy.probe_defaults(probeMachine1);
            if (probeResults1 == 0 && !authProxyAlreadySet) {
                probeResults2 = FindProxy.probe_defaults(probeMachine2);
            }
            if (FindProxy.proxyFound(probeResults = FindProxy.combineResults(probeResults1, probeResults2))) {
                return probeResults;
            }
        }
        if (probeResults == 5) {
            certError = true;
        }
        if ((probeResults1 = FindProxy.probe_noProxy(probeMachine1)) == 0 && !authProxyAlreadySet) {
            probeResults2 = FindProxy.probe_noProxy(probeMachine2);
        }
        if (FindProxy.proxyFound(probeResults = FindProxy.combineResults(probeResults1, probeResults2))) {
            return probeResults;
        }
        if (probeResults == 5) {
            certError = true;
        }
        if (Utils.getOS() == 1) {
            probeResults1 = FindProxy.probe_Windows_AutoDetectWinHTTP(probeMachine1);
            if (probeResults1 == 0 && !authProxyAlreadySet) {
                probeResults2 = FindProxy.probe_Windows_AutoDetectWinHTTP(probeMachine2);
            }
            if (FindProxy.proxyFound(probeResults = FindProxy.combineResults(probeResults1, probeResults2))) {
                return probeResults;
            }
            if (probeResults == 5) {
                certError = true;
            }
        }
        if (Utils.getOS() == 1) {
            probeResults1 = FindProxy.probe_Windows_AutoDetectWinINet(probeMachine1);
            if (probeResults1 == 0 && !authProxyAlreadySet) {
                probeResults2 = FindProxy.probe_Windows_AutoDetectWinINet(probeMachine2);
            }
            if (FindProxy.proxyFound(probeResults = FindProxy.combineResults(probeResults1, probeResults2))) {
                return probeResults;
            }
            if (probeResults == 5) {
                certError = true;
            }
        }
        if (Utils.getOS() == 1) {
            probeResults1 = FindProxy.probe_Windows_ManualSettings(probeMachine1);
            if (probeResults1 == 0 && !authProxyAlreadySet) {
                probeResults2 = FindProxy.probe_Windows_ManualSettings(probeMachine2);
            }
            if (FindProxy.proxyFound(probeResults = FindProxy.combineResults(probeResults1, probeResults2))) {
                return probeResults;
            }
            if (probeResults == 5) {
                certError = true;
            }
        }
        if (Utils.getOS() == 9) {
            probeResults1 = FindProxy.probe_Mac_AutoDetect(probeMachine1);
            if (probeResults1 == 0 && !authProxyAlreadySet) {
                probeResults2 = FindProxy.probe_Mac_AutoDetect(probeMachine2);
            }
            if (FindProxy.proxyFound(probeResults = FindProxy.combineResults(probeResults1, probeResults2))) {
                return probeResults;
            }
            if (probeResults == 5) {
                certError = true;
            }
        }
        if (certError) {
            return 5;
        }
        return probeResults;
    }

    private static int combineResults(int probeResults1, int probeResults2) {
        int finalResult = 2;
        String finalResultStr = "ERROR";
        if (probeResults1 == 2 || probeResults2 == 2) {
            finalResult = 2;
            finalResultStr = "ERROR";
        } else if (probeResults1 == 1 || probeResults2 == 1) {
            finalResult = 1;
            finalResultStr = "AUTH";
        } else if (probeResults1 == 0 || probeResults2 == 0) {
            finalResult = 0;
            finalResultStr = "OK";
        } else if (probeResults1 == 5 || probeResults2 == 5) {
            finalResult = 5;
            finalResultStr = "CERT";
        } else {
            Logging.log.fine("Can not determine final results:" + probeResults1 + " " + probeResults2);
        }
        Logging.log.fine("Final results:" + finalResultStr);
        return finalResult;
    }

    private static int probe_defaults(String probeTarget) {
        if ("true".equals(System.getProperty("http.proxySet"))) {
            String host = System.getProperty("http.proxyHost");
            String port = System.getProperty("http.proxyPort", "80");
            String userName = System.getProperty("http.proxyUser");
            String password = System.getProperty("http.proxyPassword");
            return FindProxy.fireProbe(probeTarget, host, port, userName, password, "Defaults from system properties");
        }
        return 2;
    }

    private static int probe_noProxy(String probeTarget) {
        return FindProxy.fireProbe(probeTarget, "", "", "noProxy");
    }

    private static int probe_Windows_AutoDetectWinHTTP(String probeTarget) {
        Logging.log.finer("Calling Windows GetAutoProxyHttp JNI...");
        String proxyResults = ProxyAPI.GetAutoProxyHttp(probeTarget);
        Logging.log.fine("Called Windows GetAutoProxyHttp JNI, returned -> " + proxyResults);
        LinkedList proxyHosts = FindProxy.parseProxyResults(proxyResults);
        for (ProxyInfo proxy : proxyHosts) {
            String port;
            String host = proxy.getHost();
            int results = FindProxy.fireProbe(probeTarget, host, port = proxy.getPort(), "Windows GetAutoProxyHttp");
            if (results == 2) continue;
            return results;
        }
        return 2;
    }

    private static int probe_Windows_AutoDetectWinINet(String probeTarget) {
        Logging.log.finer("Calling Windows GetProxy JNI...");
        String proxyResults = ProxyAPI.GetProxy(FindProxy.hostForm(probeTarget), FindProxy.hostForm(probeTarget));
        Logging.log.fine("Called Windows GetProxy JNI, returned -> " + proxyResults);
        LinkedList proxyHosts = FindProxy.parseProxyResults(proxyResults);
        for (ProxyInfo proxy : proxyHosts) {
            String port;
            String host = proxy.getHost();
            int results = FindProxy.fireProbe(probeTarget, host, port = proxy.getPort(), "Windows GetProxy");
            if (results == 2) continue;
            return results;
        }
        return 2;
    }

    private static int probe_Windows_ManualSettings(String probeTarget) {
        Logging.log.finer("Calling Windows GetProxyURL JNI...");
        String proxyResults = ProxyAPI.GetProxyURL();
        Logging.log.fine("Called Windows GetProxyURL JNI, returned -> " + proxyResults);
        LinkedList proxyHosts = FindProxy.parseProxyResults(proxyResults);
        for (ProxyInfo proxy : proxyHosts) {
            String port;
            String host = proxy.getHost();
            int results = FindProxy.fireProbe(probeTarget, host, port = proxy.getPort(), "Windows GetProxyURL");
            if (results == 2) continue;
            return results;
        }
        return 2;
    }

    private static int probe_Mac_AutoDetect(String probeTarget) {
        Logging.log.finer("Calling Mac Proxy executable...");
        String macproxyLocation = Utils.joinPath(Globals.g_setupLocation, "macproxy");
        String[] command = new String[]{macproxyLocation, probeTarget};
        String[] envp = new String[]{"LANG=C", "LC_ALL=C"};
        String proxyResults = Utils.ExecuteCommand(command, envp);
        Logging.log.fine("Called Mac Proxy executable, returned -> " + proxyResults);
        LinkedList proxyHosts = FindProxy.parseProxyResults(proxyResults);
        for (ProxyInfo proxy : proxyHosts) {
            String port;
            String host = proxy.getHost();
            int results = FindProxy.fireProbe(probeTarget, host, port = proxy.getPort(), "Mac GetProxy");
            if (results == 2) continue;
            return results;
        }
        return 2;
    }

    private static int fireProbe(String probeTarget, String host, String port, String probeType) {
        return FindProxy.fireProbe(probeTarget, host, port, "", "", probeType);
    }

    private static int fireProbe(String probeTarget, String host, String port, String userName, String password, String probeType) {
        int resultOfProbe;
        try {
            resultOfProbe = FindProxy.probe(probeTarget, host, port, userName, password);
        }
        catch (IOException e) {
            Logging.log.fine("Proxy probe defaults IO exception: " + e.getMessage());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            Logging.log.fine(sw.getBuffer().toString());
            return 2;
        }
        if (resultOfProbe == 5) {
            return 5;
        }
        int results = FindProxy.processResults(resultOfProbe);
        switch (results) {
            case 1: {
                FindProxy.setProxy("true", host, port, "", "");
                Logging.log.fine("Proxy Probe " + probeType + "--requires auth: " + host + ":" + port);
                authHost = host;
                authPort = port;
                authProxyAlreadySet = true;
                break;
            }
            case 0: {
                if ("".equals(host)) {
                    if (!authProxyAlreadySet) {
                        FindProxy.setProxy("false", "", "", "", "");
                    }
                } else {
                    FindProxy.setProxy("true", host, port, userName, password);
                    if (userName != null && !"".equals(userName) && password != null && !"".equals(password)) {
                        authProxyAlreadySet = true;
                    }
                }
                if (userName == null || "".equals(userName)) {
                    Logging.log.fine("Proxy Probe " + probeType + "--ok, no auth required: " + host + ":" + port);
                    break;
                }
                Logging.log.fine("Proxy Probe " + probeType + "--ok, auth approved: " + host + ":" + port + ":" + userName + ":" + (password == null ? "" : password.replaceAll(".", "*")));
                break;
            }
            case 2: {
                Logging.log.fine("Proxy Probe " + probeType + "--error: " + host + ":" + port);
                break;
            }
            default: {
                Logging.log.fine("Proxy Probe " + probeType + "--default error, probe returned code: " + results + " for: " + host + ":" + port);
                results = 2;
            }
        }
        return results;
    }

    private static int probe(String probeTarget, String pHost, String pPort, String pUserName, String pPassword) throws IOException {
        AuthState proxyAuthState;
        BasicHttpContext localContext;
        CloseableHttpResponse httpResponse;
        int statusCode;
        DefaultHttpClient client;
        block10: {
            Logging.log.fine("Probing Proxy: target=" + probeTarget + " proxy=" + pHost + ":" + pPort + ":" + pUserName + ":" + (pPassword == null ? "" : pPassword.replaceAll(".", "*")));
            client = new DefaultHttpClient();
            client.getParams().setParameter("http.protocol.cookie-policy", "compatibility");
            client.getParams().setIntParameter("http.connection.timeout", 20000);
            client.getParams().setIntParameter("http.socket.timeout", 20000);
            HttpGet method = new HttpGet(probeTarget);
            if (!"".equals(pHost) && !"".equals(pPort)) {
                HttpHost proxy = new HttpHost(pHost, Integer.parseInt(pPort), "http");
                client.getParams().setParameter("http.route.default-proxy", proxy);
                if (pUserName != null && !"".equals(pUserName) && pPassword != null) {
                    String domain = "";
                    String username = pUserName;
                    int domainIndex = pUserName.indexOf(92);
                    if (domainIndex > 0 && pUserName.length() > domainIndex + 1) {
                        domain = pUserName.substring(0, domainIndex);
                        username = pUserName.substring(domainIndex + 1);
                    }
                    client.getCredentialsProvider().setCredentials(AuthScope.ANY, new NTCredentials(username, pPassword, InetAddress.getLocalHost().getHostName(), domain));
                }
            }
            statusCode = 0;
            httpResponse = null;
            localContext = new BasicHttpContext();
            try {
                httpResponse = client.execute((HttpUriRequest)method, localContext);
            }
            catch (Exception e) {
                Logging.log.info("Fired Proxy probe at SAS, and got an exception");
                Logging.logStackTrace(e);
                if (e.getCause() == null) break block10;
                if (Utils.getOS() == 5 || Utils.getOS() == 8) {
                    if (e.getCause().getCause() != null && e.getCause().getCause() instanceof CertPathBuilderException) {
                        Logging.log.info("The exception is most likely due to not having the correct certificate to access a SSL content-scanning proxy.");
                        return 5;
                    }
                }
                if (!(e.getCause() instanceof CertPathValidatorException) || e.getCause().getCause() == null || !(e.getCause().getCause() instanceof CertPathBuilderException)) break block10;
                Logging.log.info("The exception is most likely due to not having the correct certificate to access a SSL content-scanning proxy.");
                return 5;
            }
        }
        if (httpResponse == null || httpResponse.getStatusLine() == null) {
            return 2;
        }
        statusCode = httpResponse.getStatusLine().getStatusCode();
        Logging.log.fine("Fired Proxy probe at SAS, returned -> " + statusCode);
        if (statusCode == 200) {
            Logging.log.fine("Got response: " + EntityUtils.toString(httpResponse.getEntity()).trim());
        }
        if ((proxyAuthState = (AuthState)localContext.getAttribute("http.auth.proxy-scope")).getAuthScheme() != null) {
            authSchemeUsed = proxyAuthState.getAuthScheme().getSchemeName();
            Logging.log.info("Used proxy authentication type " + authSchemeUsed);
        }
        client.getConnectionManager().shutdown();
        return statusCode;
    }

    private static int processResults(int probeResult) {
        switch (probeResult) {
            case 200: 
            case 206: {
                return 0;
            }
            case 407: {
                return 1;
            }
        }
        return 2;
    }

    private static boolean proxyFound(int probeResults) {
        switch (probeResults) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    private static void setProxy(String set, String host, String port, String userid, String password) {
        host = host == null ? "" : host;
        port = port == null ? "" : port;
        userid = userid == null ? "" : userid;
        password = password == null ? "" : password;
        System.setProperty("http.proxyHost", host);
        System.setProperty("http.proxyPort", port);
        System.setProperty("http.proxyUser", userid);
        System.setProperty("http.proxyPassword", password);
        if ("".equals(host) || "".equals(port)) {
            Logging.log.info("Proxy: setting for no proxy");
            System.setProperty("http.proxySet", "false");
        } else {
            System.setProperty("http.proxySet", set);
            if ("true".equals(set)) {
                Logging.log.info("Setting Proxy to host=" + host + " port=" + port + " userid=" + userid + " password=" + password.replaceAll(".", "*"));
            } else {
                Logging.log.info("Proxy: setting for no proxy");
            }
        }
    }

    public static String getHost() {
        return authHost;
    }

    public static String getPort() {
        return authPort;
    }

    public static boolean authSchemeNTLM() {
        return "ntlm".equals(authSchemeUsed);
    }

    private static LinkedList parseProxyResults(String proxyHosts) {
        LinkedList<ProxyInfo> results = new LinkedList<ProxyInfo>();
        if (proxyHosts != null && proxyHosts.length() > 0) {
            Logging.log.fine("Parsing proxy host string: " + proxyHosts);
            String[] proxiesSplit = proxyHosts.trim().split(";");
            for (int i = 0; i < proxiesSplit.length; ++i) {
                String host = null;
                String port = null;
                Matcher matcher = pattern.matcher(proxiesSplit[i].trim());
                if (matcher.matches()) {
                    host = matcher.group(1);
                    port = matcher.group(2);
                    if (port == null || "".equals(port)) {
                        port = "80";
                        Logging.log.fine("Parsed proxyHost:" + host + "  proxyPort: Default port " + port);
                    } else {
                        Logging.log.fine("Parsed proxyHost:" + host + "  proxyPort:" + port);
                    }
                    FindProxy findProxy = findProxyInstance;
                    Objects.requireNonNull(findProxy);
                    results.add(findProxy.new ProxyInfo(host, port));
                    continue;
                }
                Logging.log.fine("...no useful Proxy information found for: " + proxyHosts);
            }
        }
        return results;
    }

    private static String hostForm(String URLForm) {
        return "<" + URLForm.substring(0, URLForm.lastIndexOf("/")) + ">";
    }

    static {
        authSchemeUsed = null;
        findProxyInstance = new FindProxy();
        authProxyAlreadySet = false;
        pattern = Pattern.compile("(?i:proxy )?(?i:http=)?(.*?)(?::(\\d*))?");
    }

    private class ProxyInfo {
        String host = null;
        String port = null;

        public ProxyInfo(String host, String port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }
    }
}

