/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.InstallToolConnector;
import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.Utils;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import com.sas.tools.installs.extension.ExtensionException;
import com.sas.tools.installs.extension.ExtensionRegistry;
import com.sas.tools.installs.it.AltskuProperties;
import com.sas.tools.installs.it.WindowsRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class FileTypeManagementData {
    public static final String WIN_TAG = "_win";
    public static final String WX6_TAG = "_wx6";
    public static final String WIN_BITNESS_TAG = " (32-bit)";
    public static final String WX6_BITNESS_TAG = " (64-bit)";
    protected static boolean extensionRegistryDataLoaded = false;
    private static Collection<String> sasFileTypes = new ArrayList<String>();
    private static ProductExtended pendingDefaultProduct;
    private static HashMap<String, ProductExtended> currentProductsForFileTypes;
    private static HashMap<String, ProductExtended> pendingProductsForFileTypes;
    private static HashSet<String> userChoiceExtensionDefaults;
    private static HashMap<String, Boolean> extRegResults;
    private static TreeSet<String> userModifiedFileTypes;
    private static boolean isInitialized;
    private static boolean manageByFiletype;
    private static HashMap<String, ProductExtended> userSelectedProducts;
    private ArrayList<String> productCode = new ArrayList();
    private static HashMap<String, String> productDisplayName;
    private static Map<String, ProductExtended> m_installedProducts;
    private static HashMap<String, String> progIDs;

    public FileTypeManagementData() {
        if (!isInitialized) {
            isInitialized = true;
        }
    }

    public boolean primeInstallToolFTM(String productCode, String platform) {
        boolean rc = true;
        File installXML = null;
        ProductData prodData = null;
        if (Globals.g_deploymentData != null) {
            String order = m_installedProducts.get(productCode + "_" + platform).getOrder();
            if (order != null && !order.isEmpty()) {
                prodData = platform == null || platform.isEmpty() || platform.equalsIgnoreCase("prt") ? Globals.g_deploymentData.getProduct(order, productCode, true) : Globals.g_deploymentData.getProduct(order, productCode, platform, true);
            } else {
                Logging.log.info("Order not found for " + productCode + "_" + platform);
            }
            if (prodData != null && (installXML = new File(prodData.getInstallRef(false))) != null && installXML.isFile() && !installXML.toString().toLowerCase().endsWith(".msi")) {
                try {
                    InstallToolConnector.primeInstallTool(installXML.getAbsolutePath(), prodData);
                }
                catch (Exception e) {
                    Logging.log.warning("An error occurred in primeInstallTool for " + productCode);
                    Logging.logStackTrace(e);
                    rc = false;
                }
            }
        }
        return rc;
    }

    private String getProductSku(String prodCode, String platform) {
        String spsSku = null;
        ProductData prodData = null;
        String order = m_installedProducts.get(prodCode + "_" + platform).getOrder();
        if (order != null && !order.isEmpty()) {
            prodData = platform == null || platform.isEmpty() || platform.equalsIgnoreCase("prt") ? Globals.g_deploymentData.getProduct(order, prodCode, true) : Globals.g_deploymentData.getProduct(order, prodCode, platform, true);
        }
        if (prodData != null) {
            spsSku = prodData.getSpsSku();
        } else {
            Logging.log.warning("No ProductData found for order =" + order + ", prodCode = " + prodCode + ", platform = " + platform);
        }
        return spsSku;
    }

    public void setupExtensionRegistryAccess(String extReg) {
        File extRegFile = new File(extReg);
        if (extRegFile.isFile()) {
            try {
                Globals.g_extensionRegistry = new ExtensionRegistry(extRegFile);
            }
            catch (ExtensionException e) {
                Globals.g_extensionRegistry = null;
                Logging.log.warning("An error occurred while loading the extension registry " + extRegFile.getAbsolutePath());
            }
        }
        if (Globals.g_extensionRegistry != null) {
            m_installedProducts = this.getInstalledProductsWithExtensions();
            for (String prod : m_installedProducts.keySet()) {
                Globals.g_fileTypeData.setProductDisplayName(prod, m_installedProducts.get(prod).getDisplayName());
            }
        }
        if (Globals.g_extensionRegistry != null) {
            for (String ext : Globals.g_extensionRegistry.getExtensions()) {
                ProductExtended currentProd = this.getAssignedProduct(ext);
                if (currentProd == null || currentProd.getDisplayName().equalsIgnoreCase("not found")) continue;
                sasFileTypes.add(ext);
                progIDs.put(ext, this.getProgID(ext));
                currentProductsForFileTypes.put(ext, currentProd);
            }
        }
        extensionRegistryDataLoaded = true;
    }

    public Collection<String> getSASFileTypes() {
        return sasFileTypes;
    }

    public ProductExtended getPendingDefaultProduct() {
        return pendingDefaultProduct;
    }

    public void setPendingDefaultProduct(ProductExtended prod) {
        pendingDefaultProduct = prod;
    }

    public void setPendingDefaultProduct(String pname_ex) {
        this.setPendingDefaultProduct(this.getNewProductExtended(pname_ex));
    }

    private ProductExtended getNewProductExtended(String displaynameEx) {
        String pcode = null;
        String platform = null;
        String pcode_ex = this.getProductCodeForDisplayname(displaynameEx);
        if (pcode_ex.endsWith(WIN_TAG)) {
            pcode = pcode_ex.substring(0, pcode_ex.length() - 4);
            platform = "win";
        } else if (pcode_ex.endsWith(WX6_TAG)) {
            pcode = pcode_ex.substring(0, pcode_ex.length() - 4);
            platform = "wx6";
        } else if (pcode_ex.endsWith("_prt")) {
            pcode = pcode_ex.substring(0, pcode_ex.length() - 4);
            platform = "prt";
        } else {
            pcode = pcode_ex;
            platform = "";
        }
        return new ProductExtended(pcode, displaynameEx, platform);
    }

    public TreeSet<String> getUserModifiedFileTypes() {
        return userModifiedFileTypes;
    }

    public void setUserModifiedFileTypes(TreeSet<String> exts) {
        userModifiedFileTypes = exts;
    }

    public ProductExtended getUserSelectedProductForFileType(String ext) {
        return userSelectedProducts.get(ext);
    }

    public void clearUserSelectedData() {
        userSelectedProducts.clear();
        pendingProductsForFileTypes.clear();
        userModifiedFileTypes.clear();
    }

    public String getCurrentProductForFileType(String ext) {
        if (currentProductsForFileTypes.containsKey(ext)) {
            return currentProductsForFileTypes.get(ext).getDisplayName();
        }
        return "";
    }

    public void setUserSelectedProductForFileType(String ext, ProductExtended prod) {
        pendingProductsForFileTypes.put(ext, prod);
        userModifiedFileTypes.add(ext);
        userSelectedProducts.put(ext, prod);
    }

    public void setUserSelectedProductForFileType(String ext, String pname_ex) {
        this.setUserSelectedProductForFileType(ext, this.getNewProductExtended(pname_ex));
    }

    public void setUserChoiceNoChange(String ext, ProductExtended prod) {
        pendingProductsForFileTypes.put(ext, prod);
        userSelectedProducts.put(ext, prod);
    }

    public void setUserChoiceNoChange(String ext, String pname_ex) {
        this.setUserChoiceNoChange(ext, this.getNewProductExtended(pname_ex));
    }

    public void clearPendingProductsForFileTypes() {
        pendingProductsForFileTypes.clear();
    }

    public void setProductDisplayName(String pcode, String pname) {
        if (!(this.productCode.contains(pcode) || productDisplayName.containsKey(pcode) || productDisplayName.containsValue(pname))) {
            this.productCode.add(pcode);
            productDisplayName.put(pcode, pname);
        }
    }

    public String getProductDisplayname(String pcode) {
        return productDisplayName.get(pcode);
    }

    public String getProductCodeForDisplayname(String prodname) {
        String prodcode = "";
        for (String p : productDisplayName.keySet()) {
            if (!this.getProductDisplayname(p).equalsIgnoreCase(prodname)) continue;
            prodcode = p;
        }
        return prodcode;
    }

    public void setSASFileTypes(Collection<String> sasExtensions) {
        sasFileTypes = sasExtensions;
    }

    public boolean isManageByFiletype() {
        return manageByFiletype;
    }

    public void setManageByFiletype(boolean mbft) {
        manageByFiletype = mbft;
    }

    public boolean isUserChoiceExtensionDefault(String ext) {
        return userChoiceExtensionDefaults.contains(ext);
    }

    public boolean getExtRegResults(String extension) {
        return extRegResults.get(extension);
    }

    public String getProgID(String extension) {
        String progID = "";
        progID = WinRegAPI.getWindowsRegistryValue(1, extension, "");
        if (progID == null || progID.isEmpty()) {
            return "";
        }
        String curVer = WinRegAPI.getWindowsRegistryValue(1, progID.concat("\\CurVer"), "");
        if (curVer != null && !curVer.isEmpty()) {
            progID = curVer;
        }
        return progID;
    }

    public ArrayList<String> getExtensionsForProgID(String progID) {
        ArrayList<String> extset = new ArrayList<String>();
        for (String ext : progIDs.keySet()) {
            if (!progIDs.get(ext).equalsIgnoreCase(progID)) continue;
            extset.add(ext);
        }
        return extset;
    }

    public void addProgID(String ext, String progid) {
        progIDs.put(ext, progid);
    }

    public ProductExtended getAssignedProduct(String extension) {
        ProductExtended currentDefaultProduct = null;
        String progID = "";
        String defaultVerb = "";
        String[] verbs = null;
        String defaultCommand = "";
        String userChoiceValue = "";
        if (WinRegAPI.isWindowsRegistryKey64(4, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + extension + "\\UserChoice") || WinRegAPI.isWindowsRegistryKey64(4, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + extension + "\\UserChoice")) {
            userChoiceValue = WinRegAPI.getWindowsRegistryValue(4, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + extension + "\\UserChoice", "Progid");
            userChoiceExtensionDefaults.add(extension);
        }
        if (userChoiceValue.length() > 0) {
            if (!this.getActionsForExt(extension).isEmpty()) {
                currentDefaultProduct = new ProductExtended("", userChoiceValue, Utils.getOS_Suffix());
            }
        } else {
            progID = WinRegAPI.getWindowsRegistryValue(1, extension, "");
            if (progID == null || progID.isEmpty()) {
                currentDefaultProduct = new ProductExtended("", "", "");
            } else {
                defaultVerb = WinRegAPI.getWindowsRegistryValue(1, progID + "\\shell", "");
                if (defaultVerb == null || defaultVerb.isEmpty()) {
                    defaultCommand = WinRegAPI.getWindowsRegistryValue(1, progID + "\\shell\\open\\command", "");
                    if (defaultCommand == null || defaultCommand.isEmpty()) {
                        if (WinRegAPI.isWindowsRegistryKey64(1, progID + "\\shell")) {
                            verbs = WinRegAPI.childrenForKey64(1, progID + "\\shell");
                        } else if (WinRegAPI.isWindowsRegistryKey32(1, progID + "\\shell")) {
                            verbs = WinRegAPI.childrenForKey32(1, progID + "\\shell");
                        }
                        defaultCommand = verbs != null && verbs.length > 0 ? WinRegAPI.getWindowsRegistryValue(1, progID + "\\shell\\" + verbs[0].toString() + "\\command", "") : "";
                    }
                } else {
                    defaultCommand = WinRegAPI.getWindowsRegistryValue(1, progID + "\\shell\\" + defaultVerb + "\\command", "");
                }
                currentDefaultProduct = defaultCommand == null || defaultCommand.isEmpty() ? null : this.determineTargetProductFromCommand(extension, progID, defaultCommand);
            }
        }
        return currentDefaultProduct;
    }

    private List<String> getActionsForExt(String extension) {
        ArrayList<String> actionverbs = new ArrayList<String>();
        String[] verbArray = null;
        String progID = WinRegAPI.getWindowsRegistryValue(1, extension, "");
        if (progID != null && !progID.isEmpty()) {
            if (WinRegAPI.isWindowsRegistryKey64(1, progID + "\\shell")) {
                verbArray = WinRegAPI.childrenForKey64(1, progID + "\\shell");
            } else if (WinRegAPI.isWindowsRegistryKey32(1, progID + "\\shell")) {
                verbArray = WinRegAPI.childrenForKey32(1, progID + "\\shell");
            }
            if (verbArray != null) {
                for (String verb : verbArray) {
                    actionverbs.add(verb);
                }
            }
        }
        return actionverbs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProductExtended determineTargetProductFromCommand(String extension, String progID, String commandString) {
        ProductExtended rtnProd;
        block20: {
            rtnProd = null;
            String[] platforms = new String[]{"win", "wx6"};
            File deploymntRegJar = new File(Globals.g_wizardData.getPreference("SASHome", "") + File.separator + "deploymntreg", "sas.tools.deploymntreg.jar");
            if (deploymntRegJar.exists()) {
                RegistryAccess registryAccess = null;
                try {
                    RegistryData.setRegistry(Globals.g_wizardData.getPreference("SASHome", ""));
                    registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                    registryAccess.open();
                    if (commandString.toLowerCase().contains("notepad.exe") && extension.equalsIgnoreCase(".cfg") || commandString.toLowerCase().contains("sasoact.exe") || commandString.toLowerCase().contains("sas.exe")) {
                        ProductData prodData = null;
                        String displayName = null;
                        String host = null;
                        String bitness = null;
                        if (Utils.getOS_Suffix() == "wx6") {
                            if (FileTypeManagementData.getActiveSasLocation().contains("x86")) {
                                host = "win";
                                bitness = WIN_BITNESS_TAG;
                            } else {
                                host = "wx6";
                                bitness = WX6_BITNESS_TAG;
                            }
                        } else {
                            host = "win";
                            bitness = "";
                        }
                        for (String version : registryAccess.getInstallVersions("base", host)) {
                            String order = registryAccess.getInstallOrderNum("base", version, host);
                            displayName = registryAccess.getInstallDisplayName("base", version, host);
                            prodData = Globals.g_deploymentData.getProduct(order, "base", host, true);
                            if (displayName != null && !displayName.isEmpty() && prodData != null) break;
                        }
                        if (Utils.getOS_Suffix() == "wx6") {
                            displayName = displayName.concat(bitness);
                        }
                        rtnProd = new ProductExtended("base", displayName, host);
                        break block20;
                    }
                    for (String product : Globals.g_extensionRegistry.getProductsWithExtensions()) {
                        String order = null;
                        String bitnessTag = null;
                        for (String platform : platforms) {
                            for (String version : registryAccess.getInstallVersions(product, platform)) {
                                order = registryAccess.getInstallOrderNum(product, version, platform);
                                ProductData prodData = Globals.g_deploymentData.getProduct(order, product, platform, true);
                                String location = registryAccess.getInstallLoc(product, version, platform);
                                String platformFromSku = Globals.g_deploymentData.getSpsSku(prodData.getSpsSku()).getPlatform();
                                bitnessTag = Utils.getOS_Suffix() != "wx6" ? "" : (platformFromSku.equals("win") ? WIN_BITNESS_TAG : (platformFromSku.equals("wx6") ? WX6_BITNESS_TAG : ""));
                                if (location == null || location.equals("") || !commandString.contains(location)) continue;
                                rtnProd = new ProductExtended(product, prodData.getProdName().concat(bitnessTag), platformFromSku);
                            }
                            if (rtnProd != null) break;
                        }
                        if (rtnProd == null) continue;
                        break;
                    }
                }
                catch (FileNotFoundException e) {
                    Logging.logStackTrace(e);
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                }
                finally {
                    if (null != registryAccess) {
                        registryAccess.close();
                    }
                }
            }
        }
        if (rtnProd == null) {
            rtnProd = new ProductExtended("Not found", "unknown product", "");
        }
        return rtnProd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyFileTypeAssociations() {
        boolean result = true;
        boolean easyReg = !this.isManageByFiletype();
        String productToRegister = null;
        ProductExtended prodTmp = null;
        for (String ext : this.getSASFileTypes()) {
            boolean extRegistered = false;
            String extensionToRegister = null;
            String pcode = null;
            String platform = null;
            if (userChoiceExtensionDefaults.contains(ext) && pendingProductsForFileTypes.containsKey(ext) && !pendingProductsForFileTypes.get(ext).getCode().equalsIgnoreCase(this.getAssignedProduct(ext).getCode()) && (WinRegAPI.isWindowsRegistryKey64(4, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + ext + "\\UserChoice") || WinRegAPI.isWindowsRegistryKey32(4, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + ext + "\\UserChoice"))) {
                if (WinRegAPI.DelRegKey(4, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + ext + "\\UserChoice")) {
                    Logging.log.info("FileType Utility has removed the " + ext + " UserChoice default for user id " + System.getProperty("user.name"));
                } else {
                    Logging.log.warning("FileType Utility failed to remove the " + ext + " UserChoice default for user id " + System.getProperty("user.name"));
                }
            }
            if (userModifiedFileTypes.contains(ext)) {
                productToRegister = pendingProductsForFileTypes.get(ext).getDisplayName();
                pcode = pendingProductsForFileTypes.get(ext).getCode();
                platform = pendingProductsForFileTypes.get(ext).getPlatform();
            } else if (easyReg && Globals.g_extensionRegistry.getProductsForExtension(ext).contains(pendingDefaultProduct.getCode())) {
                productToRegister = pendingDefaultProduct.getDisplayName();
                pcode = pendingDefaultProduct.getCode();
                platform = pendingDefaultProduct.getPlatform();
            } else if (easyReg) {
                productToRegister = this.getPriorityProductForExtension(ext, pendingDefaultProduct.getCode());
            } else {
                prodTmp = this.getAssignedProduct(ext);
                productToRegister = prodTmp.getDisplayName();
                pcode = prodTmp.getCode();
                platform = prodTmp.getPlatform();
            }
            if (productToRegister.isEmpty()) {
                prodTmp = this.getAssignedProduct(ext);
                productToRegister = prodTmp.getDisplayName();
                pcode = prodTmp.getCode();
                platform = prodTmp.getPlatform();
            }
            if (pcode == null) {
                for (String prod : this.productCode) {
                    if (!productDisplayName.get(prod).equalsIgnoreCase(productToRegister)) continue;
                    pcode = prod;
                    break;
                }
            }
            if (pcode != null && !pcode.isEmpty()) {
                if (Globals.g_extensionRegistry.isAlias(ext, pcode)) {
                    extensionToRegister = this.getExtWithActions(ext);
                    Logging.log.info("Extension " + ext + " is an alias file type for extension " + extensionToRegister);
                }
                if (extensionToRegister == null || extensionToRegister.isEmpty()) {
                    extensionToRegister = ext;
                }
                AltskuProperties props = new AltskuProperties(InstallToolConnector.itController(), this.getProductSku(pcode, platform));
                WindowsRegistry winReg = new WindowsRegistry();
                if (this.primeInstallToolFTM(pcode, platform)) {
                    try {
                        Globals.g_extensionRegistry.registerDefault(extensionToRegister, winReg, props);
                        extRegistered = true;
                    }
                    catch (ExtensionException e) {
                        Logging.log.warning(e.getMessage());
                        result = false;
                    }
                    finally {
                        InstallToolConnector.clearITController();
                    }
                }
            } else {
                Logging.log.info("Product code for " + productToRegister + " not found.");
            }
            extRegResults.put(ext, extRegistered);
            if (!extRegistered) {
                Logging.log.warning(ext + " could not be associated with " + productToRegister);
                continue;
            }
            Logging.log.info(ext + " has been associated with " + productToRegister);
        }
        return result;
    }

    public String getPriorityProductForExtension(String extension, String defaultProduct) {
        return "";
    }

    protected boolean installedExtensionsShared(RegistryAccess regAccess) {
        return this.getInstalledSharedExtensions(regAccess).size() > 0;
    }

    protected boolean installedExtensionsShared() {
        boolean result = false;
        RegistryAccess regAccess = null;
        try {
            RegistryData.setRegistry(Globals.g_cmtSASHome);
            regAccess = new RegistryAccess(RegistryData.getDeployRegJar());
        }
        catch (Exception e) {
            regAccess = null;
            Logging.log.warning("Could not access deployment registry");
            Logging.logStackTrace(e);
        }
        if (regAccess != null && regAccess.open()) {
            result = this.installedExtensionsShared(regAccess);
        }
        if (regAccess != null) {
            regAccess.close();
        }
        return result;
    }

    public boolean isProductInstalled(String product, RegistryAccess regAccess) {
        boolean result = false;
        if (regAccess != null) {
            String[] hosts = regAccess.getInstallHosts();
            for (int h = 0; h < hosts.length; ++h) {
                String[] prodCodes = regAccess.getInstallCodes(hosts[h]);
                if (!result) {
                    String prod;
                    String[] stringArray = prodCodes;
                    int n = stringArray.length;
                    for (int i = 0; i < n && !(result = (prod = stringArray[i]).equalsIgnoreCase(product)); ++i) {
                    }
                    continue;
                }
                break;
            }
        } else {
            result = this.isProductInstalled(product);
        }
        return result;
    }

    public boolean isProductInstalled(String product) {
        boolean result = false;
        RegistryAccess regAccess = null;
        try {
            if (Globals.g_cmtSASHome != null) {
                File deployRegJar = new File(Utils.joinPath(Globals.g_cmtSASHome, "deploymntreg"), "sas.tools.deploymntreg.jar");
                regAccess = new RegistryAccess(deployRegJar.getAbsolutePath());
            } else {
                regAccess = new RegistryAccess(RegistryData.getDeployRegJar());
            }
        }
        catch (Exception e) {
            regAccess = null;
            Logging.log.warning("Could not access deployment registry");
            Logging.logStackTrace(e);
        }
        if (regAccess != null && regAccess.open()) {
            result = this.isProductInstalled(product, regAccess);
        }
        if (regAccess != null) {
            regAccess.close();
        }
        return result;
    }

    public int extensionProductsInstalled(RegistryAccess regAccess) {
        int productsInstalled = 0;
        for (String product : Globals.g_extensionRegistry.getProductsWithExtensions()) {
            if (!this.isProductInstalled(product, regAccess)) continue;
            ++productsInstalled;
        }
        return productsInstalled;
    }

    public Collection<String> getInstalledSharedExtensions(RegistryAccess regAccess) {
        TreeSet<String> extensions = new TreeSet<String>();
        extensions.addAll(Globals.g_extensionRegistry.getSharedExtensions());
        for (String product : Globals.g_extensionRegistry.getProductsWithExtensions()) {
            String[] hosts;
            if (product.equalsIgnoreCase("base")) continue;
            String thirtyTwoBitLoc = null;
            String sixtyFourBitLoc = null;
            for (String host : hosts = new String[]{"win", "wx6"}) {
                for (String version : regAccess.getInstallVersions(product, host)) {
                    File loc = new File(regAccess.getInstallLoc(product, version, host));
                    if (loc == null || loc.length() <= 0L || !loc.exists()) continue;
                    if (host.equals("win")) {
                        thirtyTwoBitLoc = loc.getAbsolutePath();
                        continue;
                    }
                    if (!host.equals("wx6")) continue;
                    sixtyFourBitLoc = loc.getAbsolutePath();
                }
            }
            if (thirtyTwoBitLoc == null || thirtyTwoBitLoc.equals("") || sixtyFourBitLoc == null || sixtyFourBitLoc.equals("")) continue;
            extensions.addAll(Globals.g_extensionRegistry.getExtensions(product));
        }
        return extensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getInstalledSharedExtensions() {
        TreeSet<String> extensions = new TreeSet<String>();
        File deploymntRegJar = new File(Globals.g_wizardData.getPreference("SASHome", "") + File.separator + "deploymntreg", "sas.tools.deploymntreg.jar");
        if (deploymntRegJar.exists()) {
            RegistryAccess registryAccess = null;
            try {
                RegistryData.setRegistry(Globals.g_wizardData.getPreference("SASHome", ""));
                registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                registryAccess.open();
                extensions.addAll(this.getInstalledSharedExtensions(registryAccess));
            }
            catch (FileNotFoundException e) {
                Logging.logStackTrace(e);
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
            finally {
                if (null != registryAccess) {
                    registryAccess.close();
                }
            }
        }
        return extensions;
    }

    private String getExtWithActions(String aliasExtension) {
        String result = "";
        Iterator<String> iterator = Globals.g_extensionRegistry.getProductsForExtension(aliasExtension).iterator();
        if (iterator.hasNext()) {
            String product = iterator.next();
            for (String ext : this.getExtensionsForProgID(this.getProgID(aliasExtension))) {
                if (Globals.g_extensionRegistry.isAlias(ext, product) || !this.isProductInstalled(product)) continue;
                result = ext;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getInstalledProductsForExtension(String extension) {
        TreeSet<String> products = new TreeSet<String>();
        String[] platforms = new String[]{"win", "wx6"};
        String order = null;
        File deploymntRegJar = new File(Globals.g_wizardData.getPreference("SASHome", "") + File.separator + "deploymntreg", "sas.tools.deploymntreg.jar");
        if (deploymntRegJar.exists()) {
            RegistryAccess registryAccess = null;
            try {
                RegistryData.setRegistry(Globals.g_wizardData.getPreference("SASHome", ""));
                registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                registryAccess.open();
                String prodex = null;
                for (String product : Globals.g_extensionRegistry.getProductsForExtension(extension)) {
                    block8: for (String platform : platforms) {
                        for (String version : registryAccess.getInstallVersions(product, platform)) {
                            order = registryAccess.getInstallOrderNum(product, version, platform);
                            ProductData prodData = Globals.g_deploymentData.getProduct(order, product, platform, true);
                            String location = registryAccess.getInstallLoc(product, version, platform);
                            if (location == null || location.equals("") || !new File(location).exists()) continue;
                            if (product.equalsIgnoreCase("base") && !FileTypeManagementData.getActiveSasLocation().contains(location)) continue block8;
                            prodex = product + "_" + Globals.g_deploymentData.getSpsSku(prodData.getSpsSku()).getPlatform();
                            products.add(prodex);
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                Logging.logStackTrace(e);
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
            finally {
                if (null != registryAccess) {
                    registryAccess.close();
                }
            }
        }
        return products;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ProductExtended> getInstalledProductsWithExtensions() {
        HashMap<String, ProductExtended> installedProductsWithExtensions = new HashMap<String, ProductExtended>();
        String[] platforms = new String[]{"win", "wx6"};
        File deploymntRegJar = new File(Globals.g_wizardData.getPreference("SASHome", "") + File.separator + "deploymntreg", "sas.tools.deploymntreg.jar");
        if (deploymntRegJar.exists()) {
            RegistryAccess registryAccess = null;
            try {
                RegistryData.setRegistry(Globals.g_wizardData.getPreference("SASHome", ""));
                registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                registryAccess.open();
                for (String product : Globals.g_extensionRegistry.getProductsWithExtensions()) {
                    String order = null;
                    String prodCodeEx = null;
                    String bitnessTag = null;
                    String prodName = null;
                    block8: for (String platform : platforms) {
                        for (String version : registryAccess.getInstallVersions(product, platform)) {
                            order = registryAccess.getInstallOrderNum(product, version, platform);
                            ProductData prodData = Globals.g_deploymentData.getProduct(order, product, platform, true);
                            String location = registryAccess.getInstallLoc(product, version, platform);
                            if (location == null || location.equals("") || !new File(location).exists()) continue;
                            if (product.equalsIgnoreCase("base") && !FileTypeManagementData.getActiveSasLocation().contains(location)) continue block8;
                            prodCodeEx = product + "_" + Globals.g_deploymentData.getSpsSku(prodData.getSpsSku()).getPlatform();
                            bitnessTag = Utils.getOS_Suffix() != "wx6" ? "" : (prodCodeEx.contains(WIN_TAG) ? WIN_BITNESS_TAG : (prodCodeEx.contains(WX6_TAG) ? WX6_BITNESS_TAG : ""));
                            prodName = registryAccess.getInstallDisplayName(product, version, platform).concat(bitnessTag);
                            ProductExtended prodExtd = new ProductExtended(product, prodName, Globals.g_deploymentData.getSpsSku(prodData.getSpsSku()).getPlatform());
                            prodExtd.setOrder(order);
                            prodExtd.setLocation(location);
                            installedProductsWithExtensions.put(prodCodeEx, prodExtd);
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                Logging.logStackTrace(e);
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
            finally {
                if (null != registryAccess) {
                    registryAccess.close();
                }
            }
        }
        return installedProductsWithExtensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getInstalledProductsWithSharedExtensions() {
        TreeSet<String> products = new TreeSet<String>();
        String[] platforms = new String[]{"win", "wx6"};
        String order = null;
        TreeSet<String> sharedProductsFromExtReg = new TreeSet<String>();
        sharedProductsFromExtReg.addAll(Globals.g_extensionRegistry.getProductsWithSharedExtensions());
        File deploymntRegJar = new File(Globals.g_wizardData.getPreference("SASHome", "") + File.separator + "deploymntreg", "sas.tools.deploymntreg.jar");
        if (deploymntRegJar.exists()) {
            RegistryAccess registryAccess = null;
            try {
                RegistryData.setRegistry(Globals.g_wizardData.getPreference("SASHome", ""));
                registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                registryAccess.open();
                for (String product : Globals.g_extensionRegistry.getProductsWithExtensions()) {
                    String thirtyTwoBitLoc = null;
                    String sixtyFourBitLoc = null;
                    for (String platform : platforms) {
                        for (String version : registryAccess.getInstallVersions(product, platform)) {
                            order = registryAccess.getInstallOrderNum(product, version, platform);
                            String location = registryAccess.getInstallLoc(product, version, platform);
                            if (location == null || location.equals("")) continue;
                            if (platform.equals("win")) {
                                thirtyTwoBitLoc = location;
                                continue;
                            }
                            if (!platform.equals("wx6")) continue;
                            sixtyFourBitLoc = location;
                        }
                    }
                    if (thirtyTwoBitLoc != null && !thirtyTwoBitLoc.equals("") && sixtyFourBitLoc != null && !sixtyFourBitLoc.equals("")) {
                        String prod32;
                        if (product.equalsIgnoreCase("base")) {
                            if (FileTypeManagementData.getActiveSasLocation().contains(thirtyTwoBitLoc)) {
                                prod32 = product.concat(WIN_TAG);
                                products.add(prod32);
                                continue;
                            }
                            if (!FileTypeManagementData.getActiveSasLocation().contains(sixtyFourBitLoc)) continue;
                            String prod64 = product.concat(WX6_TAG);
                            products.add(prod64);
                            continue;
                        }
                        prod32 = product.concat(WIN_TAG);
                        String prod64 = product.concat(WX6_TAG);
                        products.add(prod32);
                        products.add(prod64);
                        continue;
                    }
                    if (!sharedProductsFromExtReg.contains(product)) continue;
                    if (thirtyTwoBitLoc != null && !thirtyTwoBitLoc.equals("")) {
                        products.add(product.concat(WIN_TAG));
                        continue;
                    }
                    if (sixtyFourBitLoc == null || sixtyFourBitLoc.equals("")) continue;
                    products.add(product.concat(WX6_TAG));
                }
            }
            catch (FileNotFoundException e) {
                Logging.logStackTrace(e);
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
            finally {
                if (null != registryAccess) {
                    registryAccess.close();
                }
            }
        }
        return products;
    }

    public static String getActiveSasLocation() {
        String sasLoc = null;
        String curVerKey = WinRegAPI.getWindowsRegistryValue(1, "SAS.Application\\CurVer", "");
        String clsid = WinRegAPI.getWindowsRegistryValue(1, curVerKey + "\\CLSID", "");
        String keyToCheck = "CLSID\\" + clsid + "\\LocalServer32";
        String sasExeOpenCmd = WinRegAPI.getWindowsRegistryValue(1, keyToCheck, "");
        if (sasExeOpenCmd.contains("sas.exe")) {
            int sasDotExePos = sasExeOpenCmd.indexOf("sas.exe");
            sasLoc = sasExeOpenCmd.substring(0, sasDotExePos - 1);
        }
        if (sasLoc == null) {
            sasLoc = "NotFound";
        }
        return sasLoc;
    }

    static {
        currentProductsForFileTypes = new HashMap();
        pendingProductsForFileTypes = new HashMap();
        userChoiceExtensionDefaults = new HashSet();
        extRegResults = new HashMap();
        userModifiedFileTypes = new TreeSet();
        manageByFiletype = false;
        userSelectedProducts = new HashMap();
        productDisplayName = new HashMap();
        m_installedProducts = new HashMap<String, ProductExtended>();
        progIDs = new HashMap();
    }

    public class ProductExtended {
        private String m_prodCode = null;
        private String m_displayname = null;
        private String m_platform = null;
        private String m_order = null;
        private String m_location = null;

        public ProductExtended(String pcode, String name, String platform) {
            this.m_prodCode = pcode;
            this.m_displayname = name;
            this.m_platform = platform;
        }

        public String getCode() {
            return this.m_prodCode;
        }

        public String getDisplayName() {
            return this.m_displayname;
        }

        public String getPlatform() {
            return this.m_platform;
        }

        public void setOrder(String orderNum) {
            this.m_order = orderNum;
        }

        public String getOrder() {
            return this.m_order;
        }

        public void setLocation(String loc) {
            this.m_location = loc;
        }

        public String getLocation() {
            return this.m_location;
        }
    }

    private static enum productPriority {
        EG,
        SAS,
        UV;

    }
}

