/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Utils;
import com.sas.tools.deployjni.disk.DiskInfoAPI;
import java.io.File;
import java.io.FileNotFoundException;

public class FileMode {
    public static final int OWNERRWX = 448;
    public static final int OWNERR = 256;
    public static final int OWNERW = 128;
    public static final int OWNERX = 64;
    public static final int GROUPRWX = 56;
    public static final int GROUPR = 32;
    public static final int GROUPW = 16;
    public static final int GROUPX = 8;
    public static final int OTHERRWX = 7;
    public static final int OTHERR = 4;
    public static final int OTHERW = 2;
    public static final int OTHERX = 1;
    private String filename;
    private int mode = -1;

    public FileMode(File filepath) throws NullPointerException, FileNotFoundException {
        if (filepath == null) {
            throw new NullPointerException();
        }
        if (!filepath.exists()) {
            throw new FileNotFoundException();
        }
        this.filename = filepath.getAbsolutePath();
        this.mode = Utils.getOS() == 1 ? 0 : DiskInfoAPI.GetFileMode(this.filename);
    }

    public FileMode(String filepath) throws NullPointerException, FileNotFoundException {
        this(new File(filepath));
    }

    public int getPerm() {
        return this.mode;
    }

    public boolean checkPerm(int flag) {
        int result = this.mode & flag;
        return result != 0;
    }

    public void addPerm(int flag) {
        this.mode |= flag;
    }

    public void remPerm(int flag) {
        this.mode &= ~flag;
    }

    public void setPerm(int permission) {
        this.mode = permission;
    }

    public int commit() {
        if (Utils.getOS() == 1) {
            return 0;
        }
        return DiskInfoAPI.SetFileMode(this.filename, this.mode);
    }
}

