/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.DeploymentData;
import com.sas.ssn.Logging;
import com.sas.ssn.UnicodeInputStream;
import com.sas.ssn.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ExtendedOrderData
implements Cloneable {
    private File file;
    private Document doc;
    private Element root;
    private DeploymentData deploymentData;
    private String time;
    private String user;
    private Hashtable description = new Hashtable();
    private Hashtable note = new Hashtable();

    public ExtendedOrderData(String file, DeploymentData deploymentData) throws IOException, ParserConfigurationException, SAXException {
        this(new File(file), deploymentData);
    }

    public ExtendedOrderData(File file, DeploymentData deploymentData) throws IOException, ParserConfigurationException, SAXException {
        this.file = file;
        this.deploymentData = deploymentData;
        if (file.isFile()) {
            this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(file));
            this.root = this.doc.getDocumentElement();
        } else {
            this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            if (this.doc != null) {
                this.root = this.doc.createElement("order_ext");
                this.doc.appendChild(this.root);
            }
        }
        this.parse();
    }

    public Object clone() throws CloneNotSupportedException {
        ExtendedOrderData clone = (ExtendedOrderData)super.clone();
        clone.file = new File(this.file.toString());
        clone.doc = (Document)this.doc.cloneNode(true);
        clone.root = clone.doc.getDocumentElement();
        clone.deploymentData = this.deploymentData;
        clone.description = (Hashtable)this.description.clone();
        clone.note = (Hashtable)this.note.clone();
        return clone;
    }

    public ExtendedOrderData clone(String newOrder) {
        return this.clone(newOrder, this.deploymentData.getMediaRoot());
    }

    public ExtendedOrderData clone(String newOrder, String destDir) {
        ExtendedOrderData clone = null;
        try {
            clone = (ExtendedOrderData)this.clone();
            clone.file = new File(clone.deploymentData.getOrderDir(destDir) + File.separator + newOrder + File.separator + "order_ext.xml");
            clone.write();
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
        }
        return clone;
    }

    private void parse() {
        NodeList data;
        this.time = null;
        this.user = null;
        this.description.clear();
        this.note.clear();
        if (this.root != null && "order_ext".equals(this.root.getTagName()) && (data = this.root.getChildNodes()) != null) {
            for (int i = 0; i < data.getLength(); ++i) {
                if (data.item(i).getNodeType() != 1) continue;
                Element element = (Element)data.item(i);
                if ("description".equals(element.getTagName())) {
                    this.description.put(element.getAttribute("loc").toLowerCase(Locale.ENGLISH), element.getAttribute("v"));
                    continue;
                }
                if ("note".equals(element.getTagName())) {
                    this.note.put(element.getAttribute("loc").toLowerCase(Locale.ENGLISH), element.getAttribute("v"));
                    continue;
                }
                if (!"creation".equals(element.getTagName())) continue;
                this.time = element.getAttribute("time");
                this.user = element.getAttribute("user");
            }
        }
    }

    private Element getElement(String tagName) {
        NodeList nodes = this.root.getElementsByTagName(tagName);
        Element element = (Element)nodes.item(0);
        if (element == null) {
            element = (Element)this.root.appendChild(this.doc.createElement(tagName));
        }
        return element;
    }

    public boolean setDescription(String description) {
        boolean valid = true;
        Element element = this.getElement("description");
        element.setAttribute("loc", "en");
        element.setAttribute("v", description);
        this.parse();
        return valid;
    }

    public boolean setNote(String note) {
        boolean valid = true;
        Element element = this.getElement("note");
        element.setAttribute("loc", "en");
        element.setAttribute("v", note);
        this.parse();
        return valid;
    }

    public boolean setTime(String time) {
        boolean valid = true;
        this.getElement("creation").setAttribute("time", time);
        this.parse();
        return valid;
    }

    public boolean setUser(String user) {
        boolean valid = true;
        this.getElement("creation").setAttribute("user", user);
        this.parse();
        return valid;
    }

    public boolean removeDescription() {
        boolean valid = true;
        NodeList nodes = this.root.getElementsByTagName("description");
        Node node = nodes.item(0);
        if (node != null) {
            this.root.removeChild(node);
        }
        this.parse();
        return valid;
    }

    public boolean removeNote() {
        boolean valid = true;
        NodeList nodes = this.root.getElementsByTagName("note");
        Node node = nodes.item(0);
        if (node != null) {
            this.root.removeChild(node);
        }
        this.parse();
        return valid;
    }

    public String getDescription() {
        return (String)this.description.get("en");
    }

    public String getNote() {
        return (String)this.note.get("en");
    }

    public String getTime() {
        return this.time;
    }

    public String getUser() {
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write() throws IOException {
        boolean valid = false;
        if ((this.file.getParentFile().isDirectory() || this.file.getParentFile().mkdirs()) && !this.file.isFile()) {
            this.file.createNewFile();
        }
        if (this.file.isFile()) {
            FileOutputStream stream = null;
            try {
                stream = new FileOutputStream(this.file);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.transform(new DOMSource(this.doc), new StreamResult(stream));
                valid = true;
            }
            catch (Exception e) {
                Logging.log.info(e.getMessage());
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        valid = false;
                    }
                }
            }
            Utils.removeBlankLines(this.file);
        }
        return valid;
    }
}

