/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.Timer;

public class EsdDownloadStats
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient SSNResource bundle = new SSNResource(EsdDownloadStats.class);
    private static final int SIZE_PREVCOUNTS = 10;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int RETRY = 3;
    public static final int SERVER_DISCONNECT = 4;
    public static final int SERVER_TIMEOUT = 5;
    public static final int SUCCESSFUL_DOWNLOAD = 6;
    public static final int SUCCESSFUL_UNZIP = 7;
    public static final int USER_INTERRUPT = 8;
    public static final int SERVER_INTERRUPT = 9;
    private Stats stats = null;
    private Timer timer = null;
    private boolean newText = false;
    private int newTextStartingPoint = 0;
    private int prevTextStartingPoint = 0;
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("'['HH:mm:ss']: '");
    private ArrayList<String> eventWindowText = new ArrayList();
    private boolean resetProgressBar = false;

    public EsdDownloadStats() {
        this.stats = new Stats();
        this.stats.startTime = System.currentTimeMillis();
        this.startTimer();
    }

    public void startTimer() {
        this.timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EsdDownloadStats.this.timerEvent();
            }
        });
        this.timer.start();
    }

    private void timerEvent() {
        if (this.stats == null || this.stats.tasks == null) {
            return;
        }
        for (Task task : this.stats.tasks.values()) {
            if (!task.active) continue;
            Collections.rotate(task.prevCounts, 1);
            task.prevCounts.set(0, new Long(0L));
        }
    }

    public void addTask(String name, long currCount, long totalCount) {
        this.stats.tasks.remove(name);
        Task task = new Task();
        task.currCount = currCount;
        task.totalCount = totalCount;
        task.startingCount = 0L;
        task.prevCounts.add(0, new Long(currCount));
        task.active = true;
        this.stats.tasks.put(name, task);
        Logging.log.finer("Adding Task: " + name + " Count: " + currCount + " of " + totalCount);
    }

    public void addTask(String name, long totalCount) {
        this.addTask(name, 0L, totalCount);
    }

    public void addTask(String name, int totalCount) {
        this.addTask(name, 0L, totalCount);
    }

    public void addToTask(String name, long count) {
        try {
            Task task = (Task)this.stats.tasks.get(name);
            task.currCount += count;
            Long prevCountObj = (Long)task.prevCounts.get(0);
            long prevCount = prevCountObj;
            task.prevCounts.set(0, new Long(prevCount += count));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addToTask(String name, int count) {
        this.addToTask(name, (long)count);
    }

    public void delFromTask(String name, long count) {
        try {
            Task task = (Task)this.stats.tasks.get(name);
            task.currCount -= count;
            if (task.currCount < 0L) {
                task.currCount = 0L;
            }
        }
        catch (Exception e) {
            Logging.log.severe("Bug!  Could not find task " + name);
        }
    }

    public void delFromTask(String name, int count) {
        this.delFromTask(name, (long)count);
    }

    public void resetTask(String name, long currCount, long totalCount) {
        try {
            Task task = (Task)this.stats.tasks.get(name);
            task.reset();
            task.currCount = currCount;
            task.totalCount = totalCount;
            task.startingCount = currCount;
            task.active = true;
        }
        catch (Exception e) {
            Logging.log.severe("Bug!  Could not find task " + name);
        }
    }

    public void finishTask(String name, long count) {
        try {
            Task task = (Task)this.stats.tasks.get(name);
            task.currCount = count;
            task.totalCount = count;
            task.active = false;
        }
        catch (Exception e) {
            Logging.log.severe("Bug!  Could not find task " + name);
        }
    }

    public void finishTask(String name, int count) {
        this.finishTask(name, (long)count);
    }

    public void finishTask(String name) {
        this.finishTask(name, ((Task)this.stats.tasks.get(name)).totalCount);
    }

    public double getAvg(String name) {
        double avg = 0.0;
        if (this.stats.tasks.get(name) == null) {
            return 0.0;
        }
        Task task = (Task)this.stats.tasks.get(name);
        if (!task.active) {
            return 0.0;
        }
        Iterator iter = task.prevCounts.iterator();
        double sum = 0.0;
        while (iter.hasNext()) {
            Long count = (Long)iter.next();
            sum += count.doubleValue();
        }
        avg = sum / 10.0;
        return avg;
    }

    public double getCurrCount() {
        double count = 0.0;
        for (Task task : this.stats.tasks.values()) {
            count += (double)task.currCount;
        }
        return count;
    }

    public double getTotalCount() {
        double count = 0.0;
        for (Task task : this.stats.tasks.values()) {
            count += (double)task.totalCount;
        }
        return count;
    }

    public double getStartingCount() {
        double count = 0.0;
        for (Task task : this.stats.tasks.values()) {
            count += (double)task.startingCount;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addText(String text) {
        Date dNow = new Date();
        ArrayList<String> arrayList = this.eventWindowText;
        synchronized (arrayList) {
            this.eventWindowText.add(this.dateFormatter.format(dNow) + text);
        }
        this.newText = true;
        ++this.newTextStartingPoint;
    }

    public boolean newText() {
        return this.newText;
    }

    public ArrayList<String> getText() {
        this.newText = false;
        this.newTextStartingPoint = this.eventWindowText.size();
        return this.eventWindowText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getNewText() {
        this.newText = false;
        int currTextLength = this.eventWindowText.size();
        ArrayList<String> returnList = null;
        ArrayList<String> arrayList = this.eventWindowText;
        synchronized (arrayList) {
            returnList = new ArrayList<String>(this.eventWindowText.subList(this.prevTextStartingPoint, currTextLength));
        }
        this.prevTextStartingPoint = currTextLength;
        return returnList;
    }

    public long getCurrCountAsLong(String task) {
        if (this.stats.tasks.get(task) != null) {
            return ((Task)this.stats.tasks.get(task)).currCount;
        }
        return 0L;
    }

    public void setCurrCountFromLong(String task, long count) {
        if (this.stats.tasks.get(task) != null) {
            ((Task)this.stats.tasks.get(task)).currCount = count;
        }
    }

    public double getCurrCount(String task) {
        if (this.stats.tasks.get(task) != null) {
            return ((Task)this.stats.tasks.get(task)).currCount;
        }
        return 0.0;
    }

    public double getTotalCount(String task) {
        if (this.stats.tasks.get(task) != null) {
            return ((Task)this.stats.tasks.get(task)).totalCount;
        }
        return 0.0;
    }

    public long getStartTime() {
        return this.stats.startTime;
    }

    public void saveStats() {
        try {
            if (new File(Globals.g_downloadDir).exists()) {
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(Utils.joinPath(Globals.g_downloadDir, "stats")));
                oos.writeObject(this.stats);
                oos.close();
            }
        }
        catch (IOException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            Logging.log.severe("Trying to write stats to directory " + Globals.g_downloadDir + " but got error...");
            e.printStackTrace(pw);
        }
    }

    public boolean loadStats() {
        try {
            File statFile = new File(Globals.g_downloadDir, "stats");
            if (statFile.exists()) {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(Utils.joinPath(Globals.g_downloadDir, "stats")));
                this.stats = (Stats)ois.readObject();
                ois.close();
                statFile.delete();
                return this.stats == null || this.stats.tasks == null || !this.stats.tasks.isEmpty();
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            Logging.log.severe("Trying to reads stats from " + Globals.g_downloadDir + " but got error...");
            e.printStackTrace(pw);
        }
        return false;
    }

    public void stopped(String name) {
        if (this.stats.tasks.get(name) == null) {
            return;
        }
        Task task = (Task)this.stats.tasks.get(name);
        task.active = false;
    }

    public void started(String name) {
        if (this.stats.tasks.get(name) == null) {
            return;
        }
        Task task = (Task)this.stats.tasks.get(name);
        task.active = true;
    }

    public boolean activeTask(String name) {
        if (this.stats.tasks.get(name) == null) {
            return false;
        }
        return ((Task)((Stats)this.stats).tasks.get((Object)name)).active;
    }

    public void eventMsg(String msg) {
        this.addText(this.bundle.messageString(msg));
    }

    public void eventMsg(String msg, Object obj1) {
        this.addText(this.bundle.messageString(msg, obj1));
    }

    public void eventMsg(String msg, int int1) {
        this.addText(this.bundle.messageString(msg, new Integer(int1)));
    }

    public void eventMsg(String msg, Object obj1, Object obj2) {
        this.addText(this.bundle.messageString(msg, obj1, obj2));
    }

    public void eventMsg(String msg, int int1, int int2) {
        this.addText(this.bundle.messageString(msg, new Integer(int1), new Integer(int2)));
    }

    public void eventMsg(String msg, Object obj1, Object obj2, Object obj3) {
        this.addText(this.bundle.messageString(msg, obj1, obj2, obj3));
    }

    public void eventMsg(String msg, int int1, int int2, int int3) {
        this.addText(this.bundle.messageString(msg, new Integer(int1), new Integer(int2), new Integer(int3)));
    }

    public void resetProgressBar() {
        this.resetProgressBar = true;
    }

    public boolean resetProgressBarHappened() {
        boolean result = this.resetProgressBar;
        this.resetProgressBar = false;
        return result;
    }

    private class Stats
    implements Serializable {
        private static final long serialVersionUID = -3666959398462208129L;
        private LinkedHashMap tasks = new LinkedHashMap();
        private long startTime = 0L;

        private Stats() {
        }
    }

    private class Task
    implements Serializable {
        private static final long serialVersionUID = -3784992435371224501L;
        private long currCount = 0L;
        private long totalCount = 0L;
        private long startingCount = 0L;
        private ArrayList<Long> prevCounts = new ArrayList(10);
        public boolean active = true;

        Task() {
            for (int i = 0; i < 10; ++i) {
                this.prevCounts.add(new Long(0L));
            }
        }

        public void reset() {
            this.currCount = 0L;
            this.totalCount = 0L;
            this.startingCount = 0L;
            this.active = true;
            this.prevCounts.clear();
            for (int i = 0; i < 10; ++i) {
                this.prevCounts.add(new Long(0L));
            }
        }
    }
}

