/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.EsdPart;
import com.sas.ssn.Globals;
import com.sas.ssn.UnicodeInputStream;
import com.sas.ssn.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EsdControlData {
    private String version;
    private String type;
    private String status;
    private String message;
    private String message_class;
    private String pipeline = null;
    private LinkedList parts = new LinkedList();

    public EsdControlData(String file) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        this(new File(file));
    }

    public EsdControlData(File file) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException, SAXParseException {
        Element root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(file)).getDocumentElement();
        NodeList data = root.getChildNodes();
        if (data != null) {
            this.version = root.getAttribute("version");
            this.type = root.getAttribute("type");
            for (int i = 0; i < data.getLength(); ++i) {
                if (data.item(i).getNodeType() != 1) continue;
                Element element = (Element)data.item(i);
                if ("status".equals(element.getTagName())) {
                    this.status = element.getAttribute("v");
                }
                if ("message".equals(element.getTagName())) {
                    this.message_class = element.getAttribute("class");
                    this.message = (CharacterData)element.getFirstChild() == null ? "" : ((CharacterData)element.getFirstChild()).getData().trim();
                }
                if ("pipeline".equals(element.getTagName())) {
                    this.pipeline = element.getAttribute("v");
                }
                if (!"parts".equals(element.getTagName())) continue;
                this.parseParts(element);
            }
        }
    }

    private void parseParts(Element partElement) {
        NodeList data = partElement.getChildNodes();
        for (int i = 0; i < data.getLength(); ++i) {
            if (data.item(i).getNodeType() != 1 || !"part".equals(data.item(i).getNodeName())) continue;
            EsdPart newPart = new EsdPart();
            Element element = (Element)data.item(i);
            newPart.setLink(element.getAttribute("link"));
            newPart.setLocalFilename(element.getAttribute("localfilename"));
            newPart.setSizeCompressed(Long.parseLong(element.getAttribute("compressed")));
            newPart.setSizeUncompressed(Long.parseLong(element.getAttribute("uncompressed")));
            newPart.setType(element.getAttribute("type"));
            newPart.setChecksum(element.getAttribute("checksum"));
            this.parts.add(newPart);
        }
    }

    public int getVersion() {
        return new Integer(this.version);
    }

    public String getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessageClass() {
        return this.message_class;
    }

    public String getStatus() {
        return this.status;
    }

    public String getPipeline() {
        return this.pipeline;
    }

    public LinkedList getParts() {
        return this.parts;
    }

    public void savePartsList() {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(Utils.joinPath(Globals.g_downloadDir, "resume3")));
            oos.writeObject(this.parts);
            oos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void smackPartsList() {
        File f = new File(Utils.joinPath(Globals.g_downloadDir, "resume3"));
        f.delete();
    }
}

