/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Configure;
import com.sas.ssn.ConfigureData;
import com.sas.ssn.ConfigureDefaults;
import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DialogData;
import com.sas.ssn.DlgBusyMsg;
import com.sas.ssn.Globals;
import com.sas.ssn.InstallDefaults;
import com.sas.ssn.InstanceData;
import com.sas.ssn.Kit;
import com.sas.ssn.KitAction;
import com.sas.ssn.Language;
import com.sas.ssn.Logging;
import com.sas.ssn.MetadataAccess;
import com.sas.ssn.PanelDynamic;
import com.sas.ssn.Plan;
import com.sas.ssn.ProductData;
import com.sas.ssn.PropertyRules;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SASLocale;
import com.sas.ssn.SSNResource;
import com.sas.ssn.ThirdParty;
import com.sas.ssn.Utils;
import com.sas.ssn.WizardPromptedIface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class DynamicDialogs
implements HyperlinkListener {
    public static final int DIALOGS_TYPE_CONFIG = 0;
    public static final int DIALOGS_TYPE_INSTALL = 1;
    public static boolean useDefaultPropertyValue = false;
    public static final String INSTALL_SUBDIR = "install";
    public static final String CONFIGURE_SUBDIR = "configure";
    public static final String GROOVY_SRC_SUBDIR = Utils.joinPath("groovy", "src");
    public static final String INSTALL_BUNDLE_FILE_NAME = "installBundle.xml";
    public static final String INSTALL_SDM_BUNDLE_FILE_NAME = "installSDMBundle.xml";
    private static SSNResource bundle = new SSNResource(DynamicDialogs.class);
    private static Properties m_enInstallProperties = null;
    private static Properties m_enInstallHelpProperties = null;
    private static Properties m_locInstallProperties = null;
    private static Properties m_locInstallHelpProperties = null;
    private static Properties m_enConfigProperties = null;
    private static Properties m_enConfigHelpProperties = null;
    private static Properties m_locConfigProperties = null;
    private static Properties m_locConfigHelpProperties = null;
    private static String m_prevOrder = "";
    private static String m_prevPlan = "";
    private static String m_prevMachine = "";
    private static String m_prevSMUDir = "";
    private static String m_prevFQDNHostName = "";
    private static String m_prevShortHostName = "";
    private static String m_prevSASHome = "";
    private static String m_previousSchema = "";
    private static int m_prevPromptLevel = -1;
    private static boolean m_prevSingleAccount = false;
    private static String[] m_selectedConfigs = null;
    private static ArrayList m_prevThirdPtyDirs = null;
    private static DialogData.Dialog[] m_excludeDialogs = null;
    private static String[] m_searchPlats = new String[]{"win", "wx6", "s64", "sax", "lnx", "lax", "r64", "h6i", "h64", "mvs", "mac", "m64", "w64", "lix", "vmi", "alx"};

    public static void createDialogs(int dialogType) {
        DynamicDialogs.removeDialogs(dialogType);
        PropertyRules.resetOrderData();
        PropertyRules.resetPlanData();
        String osType = DynamicDialogs.getOSType();
        DynamicDialogs.loadDialogDefaults(osType, dialogType);
        DialogData dialogData = null;
        DialogData.Dialog[] dialogs = null;
        String dialogPropertiesFile = null;
        if (dialogType == 1) {
            String productDataDir = Globals.g_deploymentData.getProductDataDir(Globals.g_order, "deploywiz", true, true);
            dialogPropertiesFile = Globals.g_mode == 2 ? Utils.joinPath(productDataDir, INSTALL_SUBDIR, INSTALL_SDM_BUNDLE_FILE_NAME) : Utils.joinPath(productDataDir, INSTALL_SUBDIR, INSTALL_BUNDLE_FILE_NAME);
        }
        try {
            dialogData = dialogType == 1 ? new DialogData(dialogPropertiesFile) : DialogData.getConfigDialogData();
            dialogs = dialogData.getDialogs(osType);
        }
        catch (Exception e) {
            if (dialogType == 1) {
                Logging.log.severe("Error loading install dialog properties file: " + dialogPropertiesFile);
            } else {
                Logging.log.severe("Error loading configure dialog properties file: " + dialogPropertiesFile);
            }
            Logging.logStackTrace(e);
        }
        if (dialogType == 1) {
            Globals.g_installKnownProps = new HashMap();
            Globals.g_installPasswords = new HashMap();
            Globals.g_installExcludeProps = new HashMap();
        } else {
            Globals.g_configKnownProps = new HashMap();
            Globals.g_configPasswords = new HashMap();
            Globals.g_configPasswords.put("metadata.connection.passwd", null);
        }
        if (Globals.g_mode != 2) {
            if (!osType.equals("zos")) {
                DynamicDialogs.addKnownProperties(dialogData.getDialogs("zos"), dialogType);
            }
            if (!osType.equals("win")) {
                DynamicDialogs.addKnownProperties(dialogData.getDialogs("win"), dialogType);
            }
            if (!osType.equals("unx")) {
                DynamicDialogs.addKnownProperties(dialogData.getDialogs("unx"), dialogType);
            }
        }
        boolean valid = false;
        boolean displayDialog = false;
        boolean persist = false;
        String name = null;
        int type = 0;
        String rule = null;
        String owner = null;
        float version = 0.0f;
        String panelID = null;
        int dynamicCount = 0;
        ArrayList<String> dynamicList = new ArrayList<String>();
        DialogData.Property[] dialogProperties = null;
        HashMap<String, Object> ownedProperties = null;
        if (dialogData != null) {
            for (int i = 0; i < dialogs.length; ++i) {
                dialogProperties = dialogs[i].getProperties();
                displayDialog = false;
                for (int j = 0; j < dialogProperties.length; ++j) {
                    name = dialogProperties[j].getName();
                    type = dialogProperties[j].getType(Globals.g_mode == 2 && Globals.g_cmtTask == 5);
                    rule = dialogProperties[j].getRule().trim();
                    valid = PropertyRules.resolveBooleanRule(rule, true, dialogType);
                    if (dialogType == 0) {
                        owner = dialogProperties[j].getOwner().toLowerCase(Locale.ENGLISH);
                        ownedProperties = (HashMap<String, Object>)Globals.g_propertyOwners.get(owner);
                        if (ownedProperties != null) {
                            ownedProperties.put(name, null);
                        } else {
                            ownedProperties = new HashMap<String, Object>();
                            ownedProperties.put(name, null);
                            Globals.g_propertyOwners.put(owner, ownedProperties);
                        }
                    }
                    if (Globals.g_mode == 2 && Globals.g_cmtTask == 5 && valid) {
                        version = dialogProperties[j].getVersion();
                        if (version == 0.0f) {
                            persist = dialogProperties[j].getPersist();
                            valid = persist && !DynamicDialogs.isPropertyPersisted(name, owner);
                        } else if (version == -1.0f) {
                            valid = true;
                        } else {
                            boolean bl = valid = version > Globals.g_cmtFromDialogVer && version <= Globals.g_cmtToDialogVer;
                        }
                    }
                    if (dialogType == 1) {
                        Globals.g_installKnownProps.put(name, null);
                    } else if (Globals.g_mode != 2 || Globals.g_cmtTask == 26) {
                        Globals.g_configKnownProps.put(name, null);
                    }
                    if (type == 8 || type == 34 || type == 11 || type == 12 || type == 9 || type == 10 || type == 13) {
                        if (dialogType == 1) {
                            Globals.g_installPasswords.put(name, null);
                        } else {
                            Globals.g_configPasswords.put(name, null);
                        }
                    }
                    if (dialogType == 0 && (type == 8 || type == 34 || type == 11 || type == 12 || type == 13)) {
                        DynamicDialogs.checkSharedPassword(dialogProperties[j]);
                    }
                    if (valid) {
                        displayDialog = true;
                        continue;
                    }
                    if (dialogType != 1 || Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.updatesRequired()) continue;
                    Globals.g_installExcludeProps.put(name, null);
                }
                if (!displayDialog) continue;
                panelID = dialogs[i].getGroup();
                Globals.g_wizard.addPanel(panelID, new PanelDynamic(dynamicCount, panelID, dialogProperties, dialogType));
                ++dynamicCount;
                dynamicList.add(panelID);
            }
        }
        if (dialogType == 1) {
            Globals.g_dynamicInstallDialogs = dynamicList.toArray(new String[0]);
        } else {
            Globals.g_dynamicConfigDialogs = dynamicList.toArray(new String[0]);
        }
    }

    public static HashMap getSDMExcludeList(String prodCode) {
        boolean updateOwnersList = false;
        boolean updatePasswordList = false;
        HashMap<String, Object> excludeList = new HashMap<String, Object>();
        if (m_excludeDialogs == null) {
            String osType = DynamicDialogs.getOSType();
            try {
                DialogData dialogData = DialogData.getConfigDialogData();
                m_excludeDialogs = dialogData.getDialogs(osType);
            }
            catch (Exception e) {
                Logging.log.severe("Error loading configure dialog properties file: " + DialogData.getCfgwizardConfigBundlePath());
                Logging.logStackTrace(e);
            }
            updateOwnersList = true;
            Globals.g_cmtGlobalrootProps = new HashMap();
            Globals.g_cmtLevdirrootProps = new HashMap();
            updatePasswordList = true;
            Globals.g_configPasswords = new HashMap();
        }
        if (m_excludeDialogs != null) {
            boolean persist = false;
            boolean exclude = false;
            boolean self = false;
            int type = 0;
            String name = null;
            String owner = null;
            DialogData.Property[] dialogProperties = null;
            for (int i = 0; i < m_excludeDialogs.length; ++i) {
                dialogProperties = m_excludeDialogs[i].getProperties();
                for (int j = 0; j < dialogProperties.length; ++j) {
                    name = dialogProperties[j].getName();
                    owner = dialogProperties[j].getOwner();
                    type = dialogProperties[j].getType(Globals.g_mode == 2 && Globals.g_cmtTask == 5);
                    persist = dialogProperties[j].getPersist();
                    exclude = false;
                    if (owner.equalsIgnoreCase("temp")) {
                        if (Globals.g_cmtTask == 5) {
                            if (Globals.g_cmtDynamicProps == null) {
                                exclude = true;
                                Logging.log.severe("Dynamic property list not available to filter properties passed to configurations.");
                            } else {
                                exclude = !Globals.g_cmtDynamicProps.containsKey(name);
                            }
                        } else {
                            exclude = true;
                        }
                    } else if (persist) {
                        if (Globals.g_cmtTask == 5) {
                            self = Utils.isWebAppServerCode(prodCode) ? owner.equalsIgnoreCase("webappsrv") : (prodCode.equalsIgnoreCase("cfgwizard") ? owner.equalsIgnoreCase("globalroot") || owner.equalsIgnoreCase("levdirroot") : owner.equalsIgnoreCase(prodCode));
                            if (self) {
                                if (Globals.g_cmtDynamicProps == null) {
                                    exclude = true;
                                    Logging.log.severe("Dynamic property list not available to filter properties passed to configurations.");
                                } else {
                                    exclude = !Globals.g_cmtDynamicProps.containsKey(name);
                                }
                            } else {
                                exclude = true;
                            }
                        } else {
                            exclude = true;
                        }
                        if (updateOwnersList) {
                            if (owner.equalsIgnoreCase("globalroot")) {
                                Globals.g_cmtGlobalrootProps.put(name, null);
                            } else if (owner.equalsIgnoreCase("levdirroot")) {
                                Globals.g_cmtLevdirrootProps.put(name, null);
                            }
                        }
                    }
                    if (exclude) {
                        excludeList.put(name, null);
                    }
                    if (!updatePasswordList || type != 8 && type != 34 && type != 11 && type != 12 && type != 9 && type != 10 && type != 13) continue;
                    Globals.g_configPasswords.put(name, null);
                }
            }
        }
        return excludeList;
    }

    public static void loadDialogDefaults(String osType, int dialogType) {
        if (osType == null) {
            osType = DynamicDialogs.getOSType();
        }
        if (dialogType == 1) {
            if (Globals.g_installDefaults == null) {
                Globals.g_installDefaults = new InstallDefaults();
            }
        } else if (Globals.g_configDefaults == null) {
            Globals.g_configDefaults = new ConfigureDefaults();
        }
        String language = Language.gs_SelectedLanguage;
        if (dialogType == 1) {
            DynamicDialogs.loadProductDefaults("deploywiz", osType, language, dialogType);
            if (Utils.getOS_Suffix() == "mvs") {
                String installDataDir = null;
                installDataDir = Globals.g_mode == 2 ? Globals.g_cmtSASHome : Globals.g_wizardData.getPreference("SASHome", "");
                File installPropsFile = new File(installDataDir, "install.properties");
                Properties installProperties = new Properties();
                if (installPropsFile.isFile()) {
                    try {
                        FileInputStream fis = new FileInputStream(installPropsFile);
                        installProperties.load(fis);
                        fis.close();
                        String key = null;
                        String value = null;
                        Enumeration<Object> e = installProperties.keys();
                        while (e.hasMoreElements()) {
                            key = (String)e.nextElement();
                            if ((!Globals.g_z64 || !key.equalsIgnoreCase("zos.install.action") && !key.equalsIgnoreCase("zos.high.level.qualifier") && !key.equalsIgnoreCase("zos.sms") && !key.equalsIgnoreCase("zos.sms.sc") && !key.equalsIgnoreCase("zos.sms.mc") && !key.equalsIgnoreCase("zos.sms.dc") && !key.equalsIgnoreCase("zos.sms.pdse") && !key.equalsIgnoreCase("zos.sms.pdse.sc") && !key.equalsIgnoreCase("zos.sms.pdse.mc") && !key.equalsIgnoreCase("zos.sms.pdse.dc") && !key.equalsIgnoreCase("zos.job.diskunit") && !key.equalsIgnoreCase("zos.job.voldisk")) && (Globals.g_z64 || !key.equalsIgnoreCase("z64.install.action") && !key.equalsIgnoreCase("z64.high.level.qualifier") && !key.equalsIgnoreCase("z64.sms") && !key.equalsIgnoreCase("z64.sms.sc") && !key.equalsIgnoreCase("z64.sms.mc") && !key.equalsIgnoreCase("z64.sms.dc") && !key.equalsIgnoreCase("z64.sms.pdse") && !key.equalsIgnoreCase("z64.sms.pdse.sc") && !key.equalsIgnoreCase("z64.sms.pdse.mc") && !key.equalsIgnoreCase("z64.sms.pdse.dc") && !key.equalsIgnoreCase("z64.job.diskunit") && !key.equalsIgnoreCase("z64.job.voldisk")) || (value = installProperties.getProperty(key, null)) == null) continue;
                            Globals.g_installDefaults.setDefault(key, value);
                        }
                    }
                    catch (Exception e) {
                        Logging.log.warning("Error loading install properties file: " + installPropsFile.getAbsolutePath());
                    }
                } else {
                    Logging.log.fine("Install properties file does not exist: " + installPropsFile.getAbsolutePath());
                }
            }
            if (Globals.g_zosJobSubmit) {
                if (Globals.g_z64) {
                    Globals.g_installData.setProperty("z64.job.submit", "TRUE");
                    Globals.g_installData.setProperty("z64.job.chain", "FALSE");
                } else {
                    Globals.g_installData.setProperty("zos.job.submit", "TRUE");
                    Globals.g_installData.setProperty("zos.job.chain", "FALSE");
                }
                if (Globals.g_zosUseFtp) {
                    if (Globals.g_z64) {
                        Globals.g_installData.setProperty("z64.use.ftp", "TRUE");
                    } else {
                        Globals.g_installData.setProperty("zos.use.ftp", "TRUE");
                    }
                } else if (Globals.g_z64) {
                    Globals.g_installData.setProperty("z64.use.ftp", "FALSE");
                } else {
                    Globals.g_installData.setProperty("zos.use.ftp", "FALSE");
                }
            } else if (Globals.g_z64) {
                Globals.g_installData.setProperty("z64.job.submit", "FALSE");
                if (Globals.g_zosJobChain) {
                    Globals.g_installData.setProperty("z64.job.chain", "TRUE");
                } else {
                    Globals.g_installData.setProperty("z64.job.chain", "FALSE");
                }
            } else {
                Globals.g_installData.setProperty("zos.job.submit", "FALSE");
                if (Globals.g_zosJobChain) {
                    Globals.g_installData.setProperty("zos.job.chain", "TRUE");
                } else {
                    Globals.g_installData.setProperty("zos.job.chain", "FALSE");
                }
            }
            if (Globals.g_overrideInstallPropertiesFile != null) {
                Globals.g_installDefaults.load(Globals.g_overrideInstallPropertiesFile);
            }
        } else {
            DynamicDialogs.loadProductDefaults("cfgwizard", osType, language, dialogType);
            if (Globals.g_mode == 2 || Globals.g_mode == 5) {
                String webAppServer;
                StringTokenizer parts;
                String token;
                StringTokenizer webAppServers;
                ProductData[] allProdData = Globals.g_deploymentData.getAllProducts(Globals.g_order, true);
                if (allProdData != null) {
                    String prodCode = null;
                    for (int i = 0; i < allProdData.length; ++i) {
                        prodCode = allProdData[i].getProdCode();
                        if (prodCode.equalsIgnoreCase("jboss") || prodCode.equalsIgnoreCase("vfabrictcsvr") || prodCode.equalsIgnoreCase("tcsclusterc") || prodCode.equalsIgnoreCase("weblogic") || prodCode.equalsIgnoreCase("websphereba") || prodCode.equalsIgnoreCase("webspherend") || prodCode.equalsIgnoreCase("cfgwizard")) continue;
                        DynamicDialogs.loadProductDefaults(prodCode, osType, language, dialogType, allProdData[i]);
                    }
                }
                String webAppList = MetadataAccess.metaQuery(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, "<xmlselect search=\"SoftwareComponent[@ClassIdentifier='webappsrv']\"/>");
                String webAppSrvFQID = null;
                if (webAppList != null && (webAppServers = new StringTokenizer(webAppList, "|")).hasMoreTokens() && (token = webAppServers.nextToken()) != null && (parts = new StringTokenizer(token, "=")).countTokens() == 2) {
                    String name = parts.nextToken();
                    webAppSrvFQID = parts.nextToken();
                }
                if (webAppSrvFQID != null && (webAppServer = MetadataAccess.propQuery(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, webAppSrvFQID, "webappsrv.12byte", null)) != null) {
                    if (webAppServer.equalsIgnoreCase("vfabrictcsvr") || webAppServer.equalsIgnoreCase("tcsclusterc")) {
                        DynamicDialogs.loadProductDefaults("vfabrictcsvr", osType, language, dialogType);
                        DynamicDialogs.loadProductDefaults("tcsclusterc", osType, language, dialogType);
                    } else {
                        DynamicDialogs.loadProductDefaults(webAppServer, osType, language, dialogType);
                    }
                }
            }
            if (Globals.g_machine != null) {
                String[] components = Globals.g_machine.getDeployedComponentIds();
                for (int i = 0; i < components.length; ++i) {
                    DynamicDialogs.loadProductDefaults(components[i], osType, language, dialogType);
                }
            }
            if (Globals.g_plan != null) {
                Plan.Machine[] machines = Globals.g_plan.getMachines();
                for (int i = 0; i < machines.length; ++i) {
                    String[] components = machines[i].getConfiguredComponentIds();
                    for (int j = 0; j < components.length; ++j) {
                        DynamicDialogs.loadProductDefaults(components[j], osType, language, dialogType);
                    }
                }
            }
            if (Globals.g_migrate && DynamicDialogs.saveGenDefaultProps()) {
                for (int i = 0; i < Globals.g_planConfigs.length; ++i) {
                    if (Globals.g_skipGendefaultList != null && Globals.g_skipGendefaultList.contains(Globals.g_planConfigs[i].toLowerCase(Locale.ENGLISH))) continue;
                    DynamicDialogs.loadGenDefaults(Globals.g_planConfigs[i]);
                }
            }
            if (Globals.g_overridePropertiesFile != null) {
                Globals.g_configDefaults.load(Globals.g_overridePropertiesFile);
            }
            if (Globals.g_debug) {
                Globals.g_configDefaults.save(Utils.joinPath(Globals.g_tempLocation, "configuration_defaults.properties"));
            }
        }
    }

    private static void removeDialogs(int dialogType) {
        if (dialogType == 1) {
            if (Globals.g_dynamicInstallDialogs != null) {
                for (int i = 0; i < Globals.g_dynamicInstallDialogs.length; ++i) {
                    Globals.g_wizard.removePanel(Globals.g_dynamicInstallDialogs[i]);
                }
                Globals.g_dynamicInstallDialogs = null;
            }
        } else if (Globals.g_dynamicConfigDialogs != null) {
            for (int i = 0; i < Globals.g_dynamicConfigDialogs.length; ++i) {
                Globals.g_wizard.removePanel(Globals.g_dynamicConfigDialogs[i]);
            }
            Globals.g_dynamicConfigDialogs = null;
        }
    }

    public static void loadProductDefaults(String productCode, String osType, String language, int dialogType) {
        DynamicDialogs.loadProductDefaults(Globals.g_order, productCode, osType, language, dialogType, null);
    }

    public static void loadProductDefaults(String productCode, String osType, String language, int dialogType, ProductData prodData) {
        DynamicDialogs.loadProductDefaults(Globals.g_order, productCode, osType, language, dialogType, prodData);
    }

    public static void loadProductDefaults(String order, String productCode, String osType, String language, int dialogType) {
        DynamicDialogs.loadProductDefaults(order, productCode, osType, language, dialogType, null);
    }

    public static void loadProductDefaults(String order, String productCode, String osType, String language, int dialogType, ProductData prodData) {
        if (osType == null) {
            osType = DynamicDialogs.getOSType();
        }
        String productDataDir = null;
        if (prodData != null) {
            productDataDir = Globals.g_deploymentData.getProductDataDir(order, prodData, true);
        } else {
            for (int i = 0; i < m_searchPlats.length && productDataDir == null; ++i) {
                productDataDir = Globals.g_deploymentData.getProductDataDir(order, productCode, m_searchPlats[i], true, true);
            }
        }
        if (productDataDir != null) {
            String productRequiresMetadatatConn;
            String maintDataDir = null;
            String maintDefaultsDir = null;
            ProductData maintData = null;
            if (prodData != null) {
                maintData = Globals.g_deploymentData.getMaintenance(order, Utils.getOS_Suffix(), "xx", prodData, true);
            } else {
                for (int i = 0; i < m_searchPlats.length && maintData == null; ++i) {
                    maintData = Globals.g_deploymentData.getMaintenance(order, productCode, m_searchPlats[i], "xx", true);
                }
            }
            if (maintData != null && (maintDataDir = Globals.g_deploymentData.getSpsSkuDataDir(order, maintData.getSpsSku(), true)) != null) {
                maintDefaultsDir = dialogType == 1 ? Utils.joinPath(maintDataDir, INSTALL_SUBDIR) : Utils.joinPath(maintDataDir, CONFIGURE_SUBDIR);
            }
            String prodDefaultsDir = null;
            prodDefaultsDir = dialogType == 1 ? Utils.joinPath(productDataDir, INSTALL_SUBDIR) : Utils.joinPath(productDataDir, CONFIGURE_SUBDIR);
            String lcProductCode = productCode.toLowerCase(Locale.ENGLISH);
            String propertyFile = null;
            String maintPropFile = null;
            DynamicDialogs.loadConfigPropertiesFile(prodDefaultsDir, maintDefaultsDir, lcProductCode);
            if (maintDefaultsDir != null) {
                maintPropFile = Utils.joinPath(maintDefaultsDir, lcProductCode + "_default.properties");
            }
            propertyFile = Utils.joinPath(prodDefaultsDir, lcProductCode + "_default.properties");
            DynamicDialogs.loadDefaults(propertyFile, maintPropFile, dialogType);
            if (maintDefaultsDir != null) {
                maintPropFile = Utils.joinPath(maintDefaultsDir, lcProductCode + "_" + osType + "_default.properties");
            }
            propertyFile = Utils.joinPath(prodDefaultsDir, lcProductCode + "_" + osType + "_default.properties");
            DynamicDialogs.loadDefaults(propertyFile, maintPropFile, dialogType);
            if (maintDefaultsDir != null) {
                maintPropFile = Utils.joinPath(maintDefaultsDir, "en", lcProductCode + "_default.properties");
            }
            propertyFile = Utils.joinPath(prodDefaultsDir, "en", lcProductCode + "_default.properties");
            DynamicDialogs.loadDefaults(propertyFile, maintPropFile, dialogType);
            if (maintDefaultsDir != null) {
                maintPropFile = Utils.joinPath(maintDefaultsDir, "en", lcProductCode + "_" + osType + "_default.properties");
            }
            propertyFile = Utils.joinPath(prodDefaultsDir, "en", lcProductCode + "_" + osType + "_default.properties");
            DynamicDialogs.loadDefaults(propertyFile, maintPropFile, dialogType);
            if (dialogType == 0 && PropertyRules.resolveProperties("@plan.selected.config.list@", dialogType, true).contains(productCode.toUpperCase(Locale.ENGLISH)) && (productRequiresMetadatatConn = Globals.g_configDefaults.getDefault(lcProductCode + ".metadatasrv.connection.is_required", "false")).equalsIgnoreCase("true")) {
                String metadataConnectionRequiredList = Globals.g_configDefaults.getDefault(ConfigureData.REQUIRE_METADATASRV_CONNECTION_LIST, "");
                Globals.g_configData.setCalculatedProperty(ConfigureData.REQUIRE_METADATASRV_CONNECTION_LIST, Utils.appendToList(metadataConnectionRequiredList, lcProductCode));
            }
            if (Globals.g_sasDefaultLocale == null) {
                SASLocale sasLocaleFromDeploymentReg;
                Globals.g_sasDefaultLocale = sasLocaleFromDeploymentReg = SASLocale.getSASLocaleFromDeploymentReg();
            }
            if (Globals.g_sasDefaultLocale != null) {
                String sashome_locale_name = Globals.g_sasDefaultLocale == null ? "en_US" : Globals.g_sasDefaultLocale.getMVAPosixName();
                List<String> supportedLanguages = Kit.getDeploymentXMLReader().getLocalizationLanguages(sashome_locale_name);
                String supportedLanguageDir = null;
                for (String lang : supportedLanguages) {
                    String langDir = maintDefaultsDir != null ? Utils.joinPath(maintDefaultsDir, lang) : Utils.joinPath(prodDefaultsDir, lang);
                    if (!new File(langDir).isDirectory()) continue;
                    supportedLanguageDir = lang;
                    break;
                }
                if (supportedLanguageDir != null) {
                    if (maintDefaultsDir != null) {
                        maintPropFile = Utils.joinPath(maintDefaultsDir, supportedLanguageDir, lcProductCode + "_default.properties");
                    }
                    propertyFile = Utils.joinPath(prodDefaultsDir, supportedLanguageDir, lcProductCode + "_default.properties");
                    DynamicDialogs.loadDefaults(propertyFile, maintPropFile, dialogType);
                    if (maintDefaultsDir != null) {
                        maintPropFile = Utils.joinPath(maintDefaultsDir, supportedLanguageDir, lcProductCode + "_" + osType + "_default.properties");
                    }
                    propertyFile = Utils.joinPath(prodDefaultsDir, supportedLanguageDir, lcProductCode + "_" + osType + "_default.properties");
                    DynamicDialogs.loadDefaults(propertyFile, maintPropFile, dialogType);
                }
            }
        }
    }

    private static void loadDefaults(String propertyFile, String maintPropFile, int dialogType) {
        File maintFile = null;
        if (maintPropFile != null) {
            maintFile = new File(maintPropFile);
        }
        if (dialogType == 1) {
            if (maintFile != null && maintFile.isFile()) {
                Globals.g_installDefaults.load(maintPropFile);
            } else {
                Globals.g_installDefaults.load(propertyFile);
            }
        } else if (maintFile != null && maintFile.isFile()) {
            Globals.g_configDefaults.load(maintPropFile);
        } else {
            Globals.g_configDefaults.load(propertyFile);
        }
    }

    public static void loadConfigPropertiesFile(String productDataDir, String maintDefaultsDir, String lcProductCode) {
        String configBundleProperties = lcProductCode + "_configBundle.properties";
        String configHelpBundleProperties = lcProductCode + "_configHelpBundle.properties";
        if (m_enConfigProperties == null) {
            m_enConfigProperties = new Properties();
            m_enConfigHelpProperties = new Properties();
        }
        m_enConfigProperties = DynamicDialogs.loadPropertiesFile(configBundleProperties, productDataDir, maintDefaultsDir, "en", m_enConfigProperties);
        m_enConfigHelpProperties = DynamicDialogs.loadPropertiesFile(configHelpBundleProperties, productDataDir, maintDefaultsDir, "en", m_enConfigHelpProperties);
        if (lcProductCode.equalsIgnoreCase("cfgwizard")) {
            m_enConfigProperties = DynamicDialogs.loadPropertiesFile("configBundle.properties", productDataDir, maintDefaultsDir, "en", m_enConfigProperties);
            m_enConfigHelpProperties = DynamicDialogs.loadPropertiesFile("configHelpBundle.properties", productDataDir, maintDefaultsDir, "en", m_enConfigHelpProperties);
        }
        if (!Language.gs_SelectedLanguage.equalsIgnoreCase("en")) {
            if (m_locConfigProperties == null) {
                m_locConfigProperties = new Properties();
                m_locConfigHelpProperties = new Properties();
            }
            m_locConfigProperties = DynamicDialogs.loadPropertiesFile(configBundleProperties, productDataDir, maintDefaultsDir, Language.gs_SelectedLanguage, m_locConfigProperties);
            m_locConfigHelpProperties = DynamicDialogs.loadPropertiesFile(configHelpBundleProperties, productDataDir, maintDefaultsDir, Language.gs_SelectedLanguage, m_locConfigProperties);
            if (lcProductCode.equalsIgnoreCase("cfgwizard")) {
                m_locConfigProperties = DynamicDialogs.loadPropertiesFile("configBundle.properties", productDataDir, maintDefaultsDir, Language.gs_SelectedLanguage, m_locConfigProperties);
                m_locConfigHelpProperties = DynamicDialogs.loadPropertiesFile("configHelpBundle.properties", productDataDir, maintDefaultsDir, Language.gs_SelectedLanguage, m_locConfigProperties);
            }
        }
    }

    public static Properties loadPropertiesFile(String propsFileName, String productDataDir, String maintDefaultsDir, String lang, Properties g_propsFile) {
        File propsFile = null;
        if (maintDefaultsDir != null) {
            propsFile = new File(Utils.joinPath(maintDefaultsDir, lang), propsFileName);
        }
        if (propsFile == null || !propsFile.isFile()) {
            propsFile = new File(Utils.joinPath(productDataDir, lang), propsFileName);
        }
        if (!propsFile.isFile()) {
            String defaultProductDataDir = Globals.g_deploymentData.getProductDataDir(Globals.g_order, "cfgwizard", true, true);
            propsFile = new File(Utils.joinPath(defaultProductDataDir, CONFIGURE_SUBDIR, lang), propsFileName);
        }
        if (propsFile.isFile()) {
            try {
                FileInputStream fis = new FileInputStream(propsFile);
                g_propsFile.load(fis);
                fis.close();
            }
            catch (Exception e) {
                Logging.log.warning("Error loading configuration dialog properties file: " + propsFile.toString());
                Logging.logStackTrace(e);
            }
        }
        return g_propsFile;
    }

    public static String getConfigDialogProperty(String property) {
        String propertyString = null;
        if (m_locConfigHelpProperties != null) {
            propertyString = m_locConfigHelpProperties.getProperty(property, null);
        }
        if (propertyString == null && m_enConfigHelpProperties != null) {
            propertyString = m_enConfigHelpProperties.getProperty(property, null);
        }
        if (propertyString == null && m_locConfigProperties != null) {
            propertyString = m_locConfigProperties.getProperty(property, null);
        }
        if (propertyString == null && m_enConfigProperties != null) {
            propertyString = m_enConfigProperties.getProperty(property, null);
        }
        if (propertyString == null) {
            propertyString = property;
        }
        return propertyString;
    }

    public static String getInstallDialogProperty(String property) {
        String propertyString = null;
        if (m_enInstallProperties == null) {
            File enHelpPropsFile;
            String productDataDir = Globals.g_deploymentData.getProductDataDir(Globals.g_order, "deploywiz", true, true);
            File enPropsFile = new File(Utils.joinPath(productDataDir, INSTALL_SUBDIR, "en"), "installBundle.properties");
            if (enPropsFile.isFile()) {
                m_enInstallProperties = new Properties();
                try {
                    FileInputStream fis = new FileInputStream(enPropsFile);
                    m_enInstallProperties.load(fis);
                    fis.close();
                }
                catch (Exception e) {
                    Logging.log.warning("Error loading install dialog properties file: " + enPropsFile.toString());
                    Logging.logStackTrace(e);
                }
            }
            if ((enHelpPropsFile = new File(Utils.joinPath(productDataDir, INSTALL_SUBDIR, "en"), "installHelpBundle.properties")).isFile()) {
                m_enInstallHelpProperties = new Properties();
                try {
                    FileInputStream fis = new FileInputStream(enHelpPropsFile);
                    m_enInstallHelpProperties.load(fis);
                    fis.close();
                }
                catch (Exception e) {
                    Logging.log.warning("Error loading install dialog help properties file: " + enHelpPropsFile.toString());
                    Logging.logStackTrace(e);
                }
            }
            if (!Language.gs_SelectedLanguage.equalsIgnoreCase("en")) {
                File locHelpPropsFile;
                File locPropsFile = new File(Utils.joinPath(productDataDir, INSTALL_SUBDIR, Language.gs_SelectedLanguage), "installBundle.properties");
                if (locPropsFile.isFile()) {
                    m_locInstallProperties = new Properties();
                    try {
                        FileInputStream fis = new FileInputStream(locPropsFile);
                        m_locInstallProperties.load(fis);
                        fis.close();
                    }
                    catch (Exception e) {
                        Logging.log.warning("Error loading install dialog properties file: " + locPropsFile.toString());
                        Logging.logStackTrace(e);
                    }
                }
                if ((locHelpPropsFile = new File(Utils.joinPath(productDataDir, INSTALL_SUBDIR, Language.gs_SelectedLanguage), "installHelpBundle.properties")).isFile()) {
                    m_locInstallHelpProperties = new Properties();
                    try {
                        FileInputStream fis = new FileInputStream(locHelpPropsFile);
                        m_locInstallHelpProperties.load(fis);
                        fis.close();
                    }
                    catch (Exception e) {
                        Logging.log.warning("Error loading install dialog help properties file: " + locHelpPropsFile.toString());
                        Logging.logStackTrace(e);
                    }
                }
            }
        }
        if (m_locInstallHelpProperties != null) {
            propertyString = m_locInstallHelpProperties.getProperty(property, null);
        }
        if (propertyString == null && m_enInstallHelpProperties != null) {
            propertyString = m_enInstallHelpProperties.getProperty(property, null);
        }
        if (propertyString == null && m_locInstallProperties != null) {
            propertyString = m_locInstallProperties.getProperty(property, null);
        }
        if (propertyString == null && m_enInstallProperties != null) {
            propertyString = m_enInstallProperties.getProperty(property, null);
        }
        if (propertyString == null) {
            propertyString = property;
        }
        return propertyString;
    }

    public static void checkSharedPassword(DialogData.Property property) {
        String name = property.getName();
        String sharePasswordUsersList = Globals.g_configDefaults.getDefault(property.getOwner().toLowerCase() + ".credentials.shared.password.list", null);
        if (sharePasswordUsersList == null) {
            return;
        }
        if (sharePasswordUsersList.length() > 0) {
            String passwdDefault = Globals.g_configDefaults.getDefault(name, null);
            String gendefault = null;
            gendefault = passwdDefault != null ? "@gendefault[if(@oma.person.admin.login.share_passwd@ == TRUE) {@oma.person.admin.login.passwd@} else { " + passwdDefault + " }]@" : "@gendefault[if(@oma.person.admin.login.share_passwd@ == TRUE) {@oma.person.admin.login.passwd@} else {}]@";
            Object userid = null;
            StringTokenizer credentials = new StringTokenizer(sharePasswordUsersList);
            while (credentials.hasMoreTokens()) {
                String credential = credentials.nextToken();
                if (!property.getName().toLowerCase(Locale.ENGLISH).contains(credential)) continue;
                Globals.g_configDefaults.setDefault(property.getName(), gendefault);
                Logging.log.info("setting " + property.getName().toUpperCase() + " to gendefault expression: [" + gendefault + "]");
                break;
            }
        }
    }

    private static void addKnownProperties(DialogData.Dialog[] dialogs, int dialogType) {
        if (dialogs != null) {
            DialogData.Property[] dialogProperties = null;
            for (int i = 0; i < dialogs.length; ++i) {
                dialogProperties = dialogs[i].getProperties();
                for (int j = 0; j < dialogProperties.length; ++j) {
                    if (dialogType == 1) {
                        Globals.g_installKnownProps.put(dialogProperties[j].getName(), null);
                        continue;
                    }
                    Globals.g_configKnownProps.put(dialogProperties[j].getName(), null);
                }
            }
        }
    }

    private static boolean saveGenDefaultProps() {
        boolean valid = true;
        String key = null;
        String value = null;
        Properties props = new Properties();
        Enumeration<Object> e = Globals.g_configDefaults.getNames();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            if (!key.toLowerCase(Locale.ENGLISH).endsWith(".config.dir.name") || (value = Globals.g_configDefaults.getDefault(key, null)) == null) continue;
            props.setProperty(key, value);
        }
        e = Globals.g_configData.getProperties().keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            value = Globals.g_configData.getProperty(key, null);
            if (value == null) continue;
            props.setProperty(key, value);
        }
        File propsFile = new File(Globals.g_configData.getFilePath());
        try {
            FileOutputStream fos = new FileOutputStream(propsFile);
            props.store(fos, null);
            fos.close();
        }
        catch (Exception e2) {
            valid = false;
            Logging.log.severe("Error writing configuration properties file for generating defaults: " + propsFile.toString());
            Logging.logStackTrace(e2);
        }
        return valid;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            KitAction.launchWebBrowser(event.getURL());
        }
    }

    private static void loadGenDefaults(String productCode) {
        String productDataDir = Globals.g_deploymentData.getProductDataDir(Globals.g_order, productCode, true, true);
        if (productDataDir != null) {
            String maintDataDir;
            File scriptFile = null;
            ProductData maintData = Globals.g_deploymentData.getMaintenance(Globals.g_order, productCode, Utils.getOS_Suffix(), "xx", true);
            if (maintData != null && (maintDataDir = Globals.g_deploymentData.getSpsSkuDataDir(Globals.g_order, maintData.getSpsSku(), true)) != null && !(scriptFile = new File(Utils.joinPath(maintDataDir, CONFIGURE_SUBDIR), productCode + "_gendefaults.xml")).isFile()) {
                scriptFile = null;
            }
            if (scriptFile == null) {
                scriptFile = new File(Utils.joinPath(productDataDir, CONFIGURE_SUBDIR), productCode + "_gendefaults.xml");
            }
            if (scriptFile.isFile()) {
                int returnCode = -1;
                String prodGroovyPath = Configure.getDefaultGroovyFilePath();
                String path = Configure.getDefaultGroovyFilePath();
                File propertyFile = new File(Globals.g_configData.getProperty("config.migration.smu.file", ""), "configuration.properties");
                String javaCmd = "\"" + new File(System.getProperty("java.home"), "bin/java").getAbsolutePath() + "\"";
                String javaCmdArgs = " -classpath \"" + new File(Globals.g_setupLocation, "ant-launcher.jar").getAbsolutePath() + "\" -Dant.home=\"" + Globals.g_setupLocation + "\" org.apache.tools.ant.launch.Launcher";
                if (Globals.g_logLevel == 1) {
                    javaCmdArgs = javaCmdArgs + " -verbose";
                } else if (Globals.g_logLevel == 2) {
                    javaCmdArgs = javaCmdArgs + " -debug";
                }
                String cfgwizUtil = Utils.joinPath(Globals.g_deploymentData.getProductDir(Globals.g_order, "cfgwizard", false, false), "Utilities");
                String antCmdArgs = " -f \"" + scriptFile.getAbsolutePath() + "\" -l \"" + Utils.joinPath(Globals.g_tempLocation, productCode + "_gendefaults.log") + "\" -Dtemp.dir=\"" + Globals.g_tempLocation + "\" -Dproduct.code=\"" + productCode + "\" -Dconfiguration.properties.file=\"" + Globals.g_configData.getFilePath() + "\" -Dinstall.cfgwizard.utilities.dir=\"" + cfgwizUtil + "\" -lib \"" + path + "\" -Ddefault.groovy.path=\"" + Configure.getDefaultGroovyFilePath() + "\"";
                if ("zos".equals(DynamicDialogs.getOSType())) {
                    antCmdArgs = antCmdArgs + " -Dcfgwizard.groovy.encoding=\"UTF-8\"";
                    Logging.log.finer("Added encoding parameter UTF-8 to antCmdArgs for all to depot-side groovy script.");
                }
                if (propertyFile.isFile()) {
                    antCmdArgs = antCmdArgs + " -Dproperties.file=\"" + propertyFile.getAbsolutePath() + "\"";
                }
                antCmdArgs = antCmdArgs + " gendefaults";
                String command = javaCmd + javaCmdArgs + antCmdArgs;
                Logging.log.info("GENERATE DEFAULTS: Launching Ant script: " + command);
                try {
                    returnCode = KitAction.executeProcess(command, Utils.joinPath(Globals.g_tempLocation, "antscript"), Utils.joinPath(Globals.g_tempLocation, ".antlog"));
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                }
                Logging.log.info("Return Code: " + returnCode);
                if (returnCode == 0) {
                    File gendefaultsProps = new File(Globals.g_tempLocation, productCode + "_gendefaults.properties");
                    if (gendefaultsProps.isFile()) {
                        Globals.g_configDefaults.load(gendefaultsProps.getAbsolutePath());
                    }
                } else if (!Globals.g_skipMigrationCheck) {
                    File logFile = null;
                    File tempLog = new File(Globals.g_tempLocation, productCode + "_gendefaults.log");
                    if (tempLog.isFile()) {
                        File logsDir = new File(Utils.joinPath(Globals.g_configData.getProperty("config.home.dir", ""), Globals.g_configData.getProperty("config.level.name", ""), "Logs"), "Configure");
                        if (logsDir.isDirectory() || logsDir.mkdirs()) {
                            String timeStamp = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss").format(new Date());
                            String newName = productCode + "_gendefaults_" + timeStamp + ".log";
                            logFile = new File(logsDir, newName);
                            if (Utils.copyFile(tempLog, logFile) != 0) {
                                logFile = tempLog;
                            }
                        } else {
                            logFile = tempLog;
                        }
                    }
                    String productName = "";
                    String[] codeList = new String[]{productCode};
                    ProductData[] prodData = Globals.g_deploymentData.getConfigured(Globals.g_order, codeList, true);
                    if (prodData != null && prodData.length == 1) {
                        productName = prodData[0].getProdName();
                    }
                    if (logFile != null) {
                        Logging.log.severe("A problem was encountered while accessing information in the SAS Migration Utility Package for " + productName + ".\n   Log File: " + logFile.getAbsolutePath());
                    } else {
                        Logging.log.severe("A problem was encountered while accessing information in the SAS Migration Utility Package for " + productName + ".");
                    }
                    if (!Globals.g_quietMode) {
                        String msgPrefix = "<html>";
                        String msgPostfix = "</html>";
                        JFrame parent = null;
                        if (Globals.g_wizard != null) {
                            msgPrefix = msgPrefix + "<font size=-1 face=\"" + Globals.g_wizard.getCancelButton().getFont().getFontName() + "\">";
                            msgPostfix = "</font>" + msgPostfix;
                            parent = Globals.g_wizard.getFrame();
                        }
                        JEditorPane msgArea = new JEditorPane();
                        msgArea.setOpaque(false);
                        msgArea.setEditable(false);
                        msgArea.setContentType("text/html");
                        msgArea.addHyperlinkListener(new DynamicDialogs());
                        String msgText = null;
                        if (logFile != null) {
                            String logLink = "<a href=\"" + Utils.pathToURL(logFile.getAbsolutePath()) + "\">" + logFile.getAbsolutePath() + "</a>";
                            msgText = bundle.messageString("DynamicDialogs.GendefaultErrorMsg.txt", productName, logLink);
                        } else {
                            msgText = bundle.messageString("DynamicDialogs.GendefaultErrorMsg.NoLogFile.txt", productName);
                        }
                        msgArea.setText(msgPrefix + msgText + msgPostfix);
                        msgArea.setCaretPosition(0);
                        CustMsgBox.showMessageDialog(parent, msgArea, bundle.getString("Common.Error.txt"), 0);
                    }
                    if (Globals.g_wizard != null) {
                        Globals.g_wizard.exitWizard(-1);
                    } else {
                        Globals.g_kit.exitKit(-1);
                    }
                }
            }
        }
    }

    private static String getOSType() {
        String osType = null;
        osType = Globals.g_zos || Utils.getOS() == 8 ? "zos" : (Utils.getOS() == 1 ? "win" : "unx");
        return osType;
    }

    public static boolean isPropertyPersisted(String name, String owner) {
        boolean persisted = true;
        boolean found = false;
        if (Globals.g_instances != null) {
            if (owner.equalsIgnoreCase("levdirroot")) {
                if (Globals.g_levdirrootProps != null) {
                    persisted = Globals.g_levdirrootProps.containsKey(name);
                }
            } else {
                InstanceData instanceData = null;
                for (int i = 0; i < Globals.g_instances.length && !found; ++i) {
                    instanceData = Globals.g_instances[i].getInstanceData();
                    if (instanceData == null) continue;
                    if (owner.equalsIgnoreCase("webappsrv")) {
                        if (Utils.isWebAppServerCode(instanceData.getCode())) {
                            found = true;
                        }
                    } else if (owner.equalsIgnoreCase(instanceData.getCode())) {
                        found = true;
                    }
                    if (!found) continue;
                    Properties instanceProps = instanceData.getProperties();
                    persisted = instanceProps != null ? instanceProps.containsKey(name) : false;
                }
            }
        }
        return persisted;
    }

    public static void loadConfigDialogs() {
        int i;
        boolean selectedConfigsChanged = false;
        if (m_selectedConfigs == null) {
            selectedConfigsChanged = true;
        } else if (m_selectedConfigs.length != Globals.g_planConfigs.length) {
            selectedConfigsChanged = true;
        } else {
            for (i = 0; i < m_selectedConfigs.length && !selectedConfigsChanged; ++i) {
                if (m_selectedConfigs[i].equals(Globals.g_planConfigs[i])) continue;
                selectedConfigsChanged = true;
            }
        }
        if (selectedConfigsChanged) {
            m_selectedConfigs = new String[Globals.g_planConfigs.length];
            for (i = 0; i < Globals.g_planConfigs.length; ++i) {
                DynamicDialogs.m_selectedConfigs[i] = Globals.g_planConfigs[i];
            }
        }
        boolean thirdPartyDirsChanged = false;
        if (Globals.g_install && Globals.g_promptedInstalls != null) {
            int i2;
            WizardPromptedIface promptedPanel;
            if (m_prevThirdPtyDirs == null) {
                thirdPartyDirsChanged = true;
            } else if (m_prevThirdPtyDirs.size() != Globals.g_promptedInstalls.length) {
                thirdPartyDirsChanged = true;
            } else {
                promptedPanel = null;
                for (i2 = 0; !thirdPartyDirsChanged && i2 < Globals.g_promptedInstalls.length; ++i2) {
                    promptedPanel = (WizardPromptedIface)Globals.g_wizard.getPanel(Globals.g_promptedInstalls[i2]);
                    if (promptedPanel.getLocation().equals((String)m_prevThirdPtyDirs.get(i2))) continue;
                    thirdPartyDirsChanged = true;
                }
            }
            if (thirdPartyDirsChanged) {
                m_prevThirdPtyDirs = new ArrayList();
                promptedPanel = null;
                for (i2 = 0; i2 < Globals.g_promptedInstalls.length; ++i2) {
                    promptedPanel = (WizardPromptedIface)Globals.g_wizard.getPanel(Globals.g_promptedInstalls[i2]);
                    m_prevThirdPtyDirs.add(promptedPanel.getLocation());
                }
            }
        } else if (m_prevThirdPtyDirs != null) {
            thirdPartyDirsChanged = true;
            m_prevThirdPtyDirs = null;
        }
        boolean migrationSchemaChanged = false;
        if (Globals.g_migrationSchema != null) {
            migrationSchemaChanged = !Globals.g_migrationSchema.equals(m_previousSchema);
        }
        String smuDir = Globals.g_configData.getProperty("config.migration.smu.file", "");
        boolean planChanged = false;
        if (Globals.g_plan != null) {
            planChanged = !m_prevPlan.equals(Globals.g_plan.getFile());
        }
        boolean machineChanged = false;
        if (Globals.g_machine != null) {
            boolean bl = machineChanged = !m_prevMachine.equals(Globals.g_machine.getName());
        }
        if (!m_prevOrder.equals(Globals.g_order) || planChanged || machineChanged || !m_prevSMUDir.equals(smuDir) || !m_prevFQDNHostName.equals(Globals.g_fqHostName) || !m_prevShortHostName.equals(Globals.g_hostName) || !m_prevSASHome.equals(Globals.g_wizardData.getPreference("SASHome", "")) || m_prevPromptLevel != Globals.g_configPromptLevel || m_prevSingleAccount != Globals.g_singleAccount || migrationSchemaChanged || selectedConfigsChanged || thirdPartyDirsChanged || Globals.g_apprentice) {
            if (Globals.g_quietMode) {
                CreateDynamicConfigDialogs createDialogs = new CreateDynamicConfigDialogs();
                createDialogs.run();
            } else if (Globals.g_consoleMode) {
                ConsoleMode.busyMsgStart(bundle.getString("DynamicDialogs.LoadingMsg.txt"));
                CreateDynamicConfigDialogs createDialogs = new CreateDynamicConfigDialogs();
                createDialogs.run();
                ConsoleMode.busyMsgStop();
            } else {
                DlgBusyMsg busyMsg = new DlgBusyMsg(Globals.g_wizard.getFrame(), Globals.g_wizard.getWizardTitle(), bundle.getString("DynamicDialogs.LoadingMsg.txt"));
                busyMsg.execute(new CreateDynamicConfigDialogs());
            }
            m_prevOrder = Globals.g_order;
            m_prevSMUDir = smuDir;
            m_prevFQDNHostName = Globals.g_fqHostName;
            m_prevShortHostName = Globals.g_hostName;
            m_prevSASHome = Globals.g_wizardData.getPreference("SASHome", "");
            m_prevPromptLevel = Globals.g_configPromptLevel;
            m_prevSingleAccount = Globals.g_singleAccount;
            if (Globals.g_migrationSchema != null) {
                m_previousSchema = Globals.g_migrationSchema.toString();
            }
            if (Globals.g_plan != null) {
                m_prevPlan = Globals.g_plan.getFile();
            }
            if (Globals.g_machine != null) {
                m_prevMachine = Globals.g_machine.getName();
            }
        }
    }

    public static void loadSDMConfigDialogs() {
        if (Globals.g_quietMode) {
            CreateDynamicSDMConfigDialogs createDialogs = new CreateDynamicSDMConfigDialogs();
            createDialogs.run();
        } else if (Globals.g_consoleMode) {
            ConsoleMode.busyMsgStart(bundle.getString("DynamicDialogs.LoadingMsg.txt"));
            CreateDynamicSDMConfigDialogs createDialogs = new CreateDynamicSDMConfigDialogs();
            createDialogs.run();
            ConsoleMode.busyMsgStop();
        } else {
            DlgBusyMsg busyMsg = new DlgBusyMsg(Globals.g_wizard.getFrame(), Globals.g_wizard.getWizardTitle(), bundle.getString("DynamicDialogs.LoadingMsg.txt"));
            busyMsg.execute(new CreateDynamicSDMConfigDialogs());
        }
    }

    private static class CreateDynamicSDMConfigDialogs
    implements Runnable {
        private CreateDynamicSDMConfigDialogs() {
        }

        @Override
        public void run() {
            DynamicDialogs.createDialogs(0);
        }
    }

    private static class CreateDynamicConfigDialogs
    implements Runnable {
        private CreateDynamicConfigDialogs() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            if (Globals.g_configDefaults == null) {
                Globals.g_configDefaults = new ConfigureDefaults();
            }
            Globals.g_propertyOwners = new HashMap<K, V>();
            Globals.g_configData.calculateProperties();
            if (Globals.g_migrationSchema != null && Globals.g_migrationSchema.write(outputSchema = new File(Globals.g_tempLocation, "schema.xml"))) {
                Globals.g_configData.setSDWProperty("config.migration.schema.file", outputSchema.getAbsolutePath());
            }
            if (Globals.g_plan != null) {
                planProps = Globals.g_plan.getProperties();
                key = null;
                value = null;
                e = planProps.keys();
                while (e.hasMoreElements()) {
                    key = (String)e.nextElement();
                    value = (String)planProps.get(key);
                    if (!(key = key.toLowerCase(Locale.ENGLISH)).startsWith("plan.")) continue;
                    Globals.g_configData.setSDWProperty(key, value);
                }
            }
            if (Globals.g_install && Globals.g_promptedInstalls != null) {
                code = null;
                selectedVer = null;
                promptedPanel = null;
                for (i = 0; i < Globals.g_promptedInstalls.length; ++i) {
                    promptedPanel = (WizardPromptedIface)Globals.g_wizard.getPanel(Globals.g_promptedInstalls[i]);
                    code = promptedPanel.getProductCode();
                    selectedVer = promptedPanel.getSelectedVersion();
                    Globals.g_configData.setSDWProperty(code + ".selected.version", selectedVer);
                    if (code.equalsIgnoreCase("weblogic") && (beaHome = ThirdParty.getBEAHomePath(promptedPanel.getLocation())) != null) {
                        Globals.g_configData.setSDWProperty("bea.home.dir", beaHome);
                    }
                    if (code.equalsIgnoreCase("websphereba") || code.equalsIgnoreCase("webspherend")) {
                        extractedIdentifiers = ThirdParty.extractWebsphereVersionIdentifiers(selectedVer);
                        for (String identifier : extractedIdentifiers.keySet()) {
                            Globals.g_configData.setSDWProperty(identifier, extractedIdentifiers.get(identifier));
                        }
                    }
                    if (!code.equalsIgnoreCase("jdk")) continue;
                    jdkVMName = ThirdParty.getVMName(promptedPanel.getLocation());
                    jvmCode = "UNKNOWN";
                    if (jdkVMName.toLowerCase(Locale.ENGLISH).contains("jrockit")) {
                        jvmCode = "JROCKIT";
                    } else if (jdkVMName.toLowerCase(Locale.ENGLISH).contains("hotspot")) {
                        jvmCode = "HOTSPOT";
                    } else if (jdkVMName.toLowerCase(Locale.ENGLISH).contains("ibm")) {
                        jvmCode = "IBM";
                    }
                    Globals.g_configData.setSDWProperty("jdk.java.vm.name", jvmCode);
                }
            } else if (Globals.g_machine != null) {
                registryAccess = null;
                try {
                    registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                    if (registryAccess == null || !registryAccess.open()) ** GOTO lbl111
                    code = null;
                    version = null;
                    location = null;
                    selectedVer = null;
                    products = Globals.g_deploymentData.getThirdParty(Globals.g_order, Globals.g_machine.getDeployedComponentIds(), true);
                    for (i = 0; i < products.length; ++i) {
                        code = products[i].getProdCode();
                        version = products[i].getProdVersion();
                        location = registryAccess.getInstallLoc(code, Globals.g_majorReleaseVersion);
                        if (code.equalsIgnoreCase("weblogic") && (beaHome = ThirdParty.getBEAHomePath(location)) == null) {
                            location = ThirdParty.getWebLogicPath(location);
                        }
                        if (code.equalsIgnoreCase("websphereba") || code.equalsIgnoreCase("webspherend")) {
                            extractedIdentifiers = null;
                            unabridgedVer = null;
                            unabridgedVer = ThirdParty.getVersion(code, location, true);
                            extractedIdentifiers = unabridgedVer != null ? ThirdParty.extractWebsphereVersionIdentifiers(unabridgedVer) : ThirdParty.extractWebsphereVersionIdentifiers(version);
                            for (String identifier : extractedIdentifiers.keySet()) {
                                Globals.g_configData.setSDWProperty(identifier, extractedIdentifiers.get(identifier));
                            }
                        }
                        if (code.equalsIgnoreCase("jdk")) {
                            jdkVMName = ThirdParty.getVMName(location);
                            jvmCode = "UNKNOWN";
                            if (jdkVMName.toLowerCase(Locale.ENGLISH).contains("jrockit")) {
                                jvmCode = "JROCKIT";
                            } else if (jdkVMName.toLowerCase(Locale.ENGLISH).contains("hotspot")) {
                                jvmCode = "HOTSPOT";
                            } else if (jdkVMName.toLowerCase(Locale.ENGLISH).contains("ibm")) {
                                jvmCode = "IBM";
                            }
                            Globals.g_configData.setSDWProperty("jdk.java.vm.name", jvmCode);
                        }
                        if (location != null && new File(location).isDirectory()) {
                            selectedVer = ThirdParty.getVersion(code, location, true);
                            if (selectedVer != null) {
                                Globals.g_configData.setSDWProperty(code + ".selected.version", selectedVer);
                                if (!code.equalsIgnoreCase("weblogic") || (beaHome = ThirdParty.getBEAHomePath(location)) == null) continue;
                                Globals.g_configData.setSDWProperty("bea.home.dir", beaHome);
                                continue;
                            }
                            Globals.g_configData.removeProperty(code + ".selected.version");
                            if (code.equalsIgnoreCase("weblogic")) {
                                Globals.g_configData.removeProperty("bea.home.dir");
                            }
                            Logging.log.warning("Unable to determine the version of the product located here: " + location);
                            continue;
                        }
                        Globals.g_configData.removeProperty(code + ".selected.version");
                        if (!code.equalsIgnoreCase("weblogic")) continue;
                        Globals.g_configData.removeProperty("bea.home.dir");
                    }
                }
                catch (Exception e) {
                    Logging.log.severe(e.getMessage());
                    Logging.logStackTrace(e);
                }
                finally {
                    if (registryAccess != null) {
                        registryAccess.close();
                    }
                    registryAccess = null;
                }
            }
lbl111:
            // 6 sources

            if (Globals.g_remoteWebApps) {
                Globals.g_configData.setSDWProperty("jdk.java.vm.name", "UNKNOWN");
            }
            Globals.g_configData.setCalculatedProperty("os.localhost.fqdn.host.name", Globals.g_fqHostName);
            Globals.g_configData.setCalculatedProperty("os.localhost.host.name", Globals.g_hostName);
            Globals.g_configData.setSDWProperty("config.dir.name", Globals.g_configData.getProperty("config.dir.name", ""));
            Globals.g_configData.setSDWProperty("config.home.dir", Globals.g_configData.getProperty("config.home.dir", ""));
            Globals.g_configData.setSDWProperty("config.level.name", Globals.g_configData.getProperty("config.level.name", ""));
            Globals.g_configData.setSDWProperty("config.level.num", Globals.g_configData.getProperty("config.level.num", ""));
            Globals.g_configData.setSDWProperty("config.singlelogin.is_enabled", Globals.g_configData.getProperty("config.singlelogin.is_enabled", ""));
            Globals.g_configData.setSDWProperty("config.migration.is_selected", Globals.g_configData.getProperty("config.migration.is_selected", ""));
            Globals.g_configData.setSDWProperty("config.migration.smu.file", Globals.g_configData.getProperty("config.migration.smu.file", ""));
            Globals.g_configData.setSDWProperty("config.migration.package.tier.dir", Globals.g_configData.getProperty("config.migration.package.tier.dir", ""));
            Globals.g_configData.setSDWProperty("config.migration.sas.version", Globals.g_configData.getProperty("config.migration.sas.version", ""));
            DynamicDialogs.createDialogs(0);
        }
    }
}

