/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.EsdInternet;
import com.sas.ssn.EsdPart;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.apache.http.cookie.Cookie;

public class DownloadLogger {
    public static final String SUCCESS = "success";
    public static final String USER_QUIT = "userQuit";
    public static final String USER_QUIT_FROM_HOLD = "userQuitFromHold";
    public static final String CONTROL_DOWNLOAD_ERRORS = "controlDownloadErrors";
    public static final String ALTSKU_DOWNLOAD_ERRORS = "skuDownloadErrors";
    public static final String ORDER_CANCELED = "orderCanceled";
    public static final String BAD_CONTROL = "badControl";
    private StringBuffer log = new StringBuffer();
    private long startTime;
    private static String ip = null;
    private boolean crcErrorReported = false;
    private String currentNonce;

    public DownloadLogger() {
        this.log.append("timestamp=" + System.currentTimeMillis() + "\n");
    }

    public void finalStatus(String finalStatusStr) {
        this.log.append("finalStatus=" + finalStatusStr + "\n");
    }

    public DownloadLogger(EsdPart part, int totalParts) {
        this.startTime = System.currentTimeMillis();
        if (ip == null) {
            ip = this.getIP();
        }
        this.log.append("order=" + Globals.g_order + "\n");
        this.log.append("altsku=" + part.getAltSku() + "\n");
        this.log.append("ip=" + ip + "\n");
        this.log.append("filenum=" + part.getFileNum() + "\n");
        this.log.append("outof=" + totalParts + "\n");
        this.log.append("expectedcrc=" + part.getChecksum() + "\n");
        this.log.append("starttime=" + this.startTime + "\n");
        HashMap<String, String> cookies = new HashMap<String, String>();
        for (Cookie cookie : Globals.g_cookies) {
            cookies.put(cookie.getName(), cookie.getValue());
            if (!"esd-nonce".equals(cookie.getName())) continue;
            this.currentNonce = cookie.getValue();
        }
        if (this.currentNonce != null && !this.currentNonce.equals(Globals.g_control.getLastNonce())) {
            this.log.append("firstnonce=" + Globals.g_control.getFirstNonce() + "\n");
            this.log.append("lastnonce=" + Globals.g_control.getLastNonce() + "\n");
            Globals.g_control.setLastNonce(this.currentNonce);
        }
        for (String key : cookies.keySet()) {
            this.log.append("cookie-" + key + "=" + cookies.get(key) + "\n");
        }
    }

    public void reportBadStatusError(int status) {
        this.log.append("badStatus=" + status + "\n");
    }

    public void reportCheckSumError(String wanted, String got) {
        if (!this.crcErrorReported) {
            this.log.append("checksumError=wanted:" + wanted + ",got:" + got + "\n");
            this.crcErrorReported = true;
        }
    }

    public void exception(String message) {
        this.log.append("exception=" + message + "\n");
    }

    public void finalLogEntries(String link, EsdPart part, EsdInternet internet, boolean completed) {
        this.log.append("link=" + link + "\n");
        this.log.append("stopTime=" + System.currentTimeMillis() + "\n");
        this.log.append("timestamp=" + System.currentTimeMillis() + "\n");
        this.log.append("retries=" + part.getRetries() + "\n");
        this.log.append("bytes-moved-expected=" + part.getSizeCompressed() + "\n");
        this.log.append("bytes-moved-actual=" + Globals.g_bytesMoved + "\n");
        this.log.append("completed=" + completed + "\n");
        if (internet != null) {
            this.log.append("actualcrc=" + internet.getChecksum() + "\n");
        } else {
            this.log.append("actualcrc=null\n");
        }
    }

    public boolean Send() {
        return true;
    }

    private String getIP() {
        int server_port;
        String server_name;
        String result = "";
        if (Globals.g_httponly) {
            server_name = "esd.sas.com";
            server_port = 80;
        } else {
            server_name = "tlsesd.sas.com";
            server_port = 443;
        }
        if ("true".equals(System.getProperty("http.proxySet"))) {
            server_name = System.getProperty("http.proxyHost");
            server_port = new Integer(System.getProperty("http.proxyPort", "80"));
        }
        Socket sock = null;
        try {
            sock = new Socket(server_name, server_port);
        }
        catch (UnknownHostException e) {
            Logging.log.info("Could not find IP while probing " + server_name + ":" + server_port + ": " + e.getMessage());
            return "unknown";
        }
        catch (IOException e) {
            Logging.log.info("Could not find IP while probing " + server_name + ":" + server_port + ": " + e.getMessage());
            return "unknown";
        }
        result = sock.getLocalAddress().toString().substring(1);
        if (result == null) {
            return "unknown";
        }
        try {
            sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Logging.log.info("Found IP for localhost while probing " + server_name + ":" + server_port + ": " + result);
        return result;
    }
}

