/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Logging;
import com.sas.ssn.SSNResource;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class DlgSelectOrder {
    private SSNResource m_bundle = new SSNResource(DlgSelectOrder.class);
    private JFrame m_frame = null;
    private JDialog m_dialog = null;
    private JTextArea m_description = null;
    private JComboBox m_orderList = null;
    private JButton m_okButton = new JButton();
    private JButton m_cancelButton = new JButton();
    private String[] m_orderNums = null;
    private String[] m_orderNames = null;

    public DlgSelectOrder(String[] orderNums, String[] orderNames, int initSelect) {
        this.m_orderNums = orderNums;
        this.m_orderNames = orderNames;
        try {
            this.m_frame = new JFrame();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_dialog = new JDialog(this.m_frame, this.m_bundle.getString("DlgSelectOrder.Title.txt"), true);
        this.m_dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Logging.closeLog();
                System.exit(-1);
            }
        });
        this.m_frame.setTitle(this.m_bundle.getString("DlgSelectOrder.Title.txt"));
        this.m_description = new JTextArea(){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                if (size.width < size.height) {
                    size.width = (int)((double)size.height * 1.8);
                }
                if (size.width < 280) {
                    size.width = 280;
                } else if (size.width > 700) {
                    size.width = 700;
                }
                if (size.height < 30) {
                    size.height = 30;
                } else if (size.height > 700) {
                    size.height = 700;
                }
                return size;
            }
        };
        this.m_description.setLineWrap(true);
        this.m_description.setWrapStyleWord(true);
        this.m_description.setBackground(this.m_frame.getBackground());
        this.m_description.setText(this.m_bundle.getString("DlgSelectOrder.Description.txt"));
        this.m_description.setEnabled(true);
        this.m_description.setEditable(false);
        this.m_description.setFocusable(false);
        this.m_description.getPreferredSize();
        this.m_orderList = new JComboBox<String>(this.m_orderNames);
        this.m_orderList.setFocusable(true);
        this.m_orderList.setSelectedIndex(initSelect);
        this.m_frame.setBounds(-1000, -1000, 0, 0);
        ImageIcon myIcon = this.m_bundle.getImageIcon("Common.icon.image");
        this.m_frame.setIconImage(myIcon.getImage());
        this.m_dialog.getContentPane().setLayout(new GridBagLayout());
        String mtxt = this.m_bundle.getString("Common.OK2.txt");
        String txt = Util.getLabelWithoutMnemonic(mtxt);
        this.m_okButton.setText(txt);
        this.m_cancelButton.setText(this.m_bundle.getString("Common.Cancel.txt"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 11;
        c.insets = new Insets(10, 10, 0, 10);
        this.m_dialog.getContentPane().add((Component)this.m_description, c);
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 11;
        c.insets = new Insets(10, 10, 0, 10);
        this.m_dialog.getContentPane().add((Component)this.m_orderList, c);
        c.fill = 0;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 15;
        c.insets = new Insets(10, 10, 10, 10);
        this.m_dialog.getContentPane().add((Component)new navButtons(), c);
        this.m_okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgSelectOrder.this.m_dialog.dispose();
                DlgSelectOrder.this.m_frame.dispose();
            }
        });
        this.m_cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgSelectOrder.this.m_dialog.dispose();
                DlgSelectOrder.this.m_frame.dispose();
                Logging.closeLog();
                System.exit(-1);
            }
        });
        this.m_dialog.getRootPane().setDefaultButton(this.m_okButton);
        this.m_frame.setVisible(true);
        this.m_dialog.pack();
        this.m_dialog.setSize(this.m_dialog.getPreferredSize());
        Dimension screenSize = this.m_dialog.getToolkit().getScreenSize();
        Dimension dialogSize = this.m_dialog.getSize();
        this.m_dialog.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
        this.addKeyListeners(this.m_dialog, new cKeyHandler());
        this.m_dialog.setVisible(true);
        this.m_dialog.toFront();
    }

    public String getSelectedOrder() {
        return this.m_orderNums[this.m_orderList.getSelectedIndex()];
    }

    protected void addKeyListeners(Container container, cKeyHandler keyHandler) {
        Component[] aComps = container.getComponents();
        int nComps = aComps.length;
        for (int iComp = 0; iComp < nComps; ++iComp) {
            aComps[iComp].addKeyListener(keyHandler);
            if (!(aComps[iComp] instanceof Container)) continue;
            this.addKeyListeners((Container)aComps[iComp], keyHandler);
        }
    }

    private class navButtons
    extends JPanel {
        public navButtons() {
            GridBagConstraints c = new GridBagConstraints();
            JPanel okPanel = new JPanel();
            JPanel cancelPanel = new JPanel();
            okPanel.setLayout(new GridBagLayout());
            cancelPanel.setLayout(new GridBagLayout());
            c.fill = 2;
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 0, 0, 4);
            c.anchor = 10;
            okPanel.add((Component)DlgSelectOrder.this.m_okButton, c);
            c.fill = 2;
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 4, 0, 0);
            c.anchor = 10;
            cancelPanel.add((Component)DlgSelectOrder.this.m_cancelButton, c);
            this.setLayout(new GridLayout(1, 2));
            this.add(okPanel);
            this.add(cancelPanel);
        }
    }

    protected class cKeyHandler
    extends KeyAdapter {
        protected cKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int eKeyCode = e.getKeyCode();
            switch (eKeyCode) {
                case 27: {
                    DlgSelectOrder.this.m_dialog.dispose();
                    Logging.closeLog();
                    System.exit(-1);
                    break;
                }
                case 38: {
                    DlgSelectOrder.this.m_orderList.showPopup();
                }
            }
        }
    }
}

