/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.RetryIface;
import com.sas.ssn.SSNResource;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.Timer;

public class DlgRetryESD
extends JDialog
implements ActionListener {
    private SSNResource bundle = new SSNResource(DlgRetryESD.class);
    private JPanel m_contentPane = new JPanel(new GridBagLayout());
    private JPanel m_buttonPanel = new JPanel();
    private JTextArea m_message;
    private JTextArea m_countdown;
    private JButton m_retryButton;
    private JButton m_cancelButton;
    private Timer m_timer;
    private ActionListener m_timerAction;
    private int m_remainingTime = 0;
    private int m_timeout = 0;
    private cKeyHandler m_keyHandler;
    private RetryIface m_retryObject;

    public DlgRetryESD(JFrame parent, RetryIface retryObject, int countdown, String titleTxt, String messageTxt, String countdownTxt, String cancelTxt) {
        this.m_retryObject = retryObject;
        this.m_keyHandler = new cKeyHandler();
        this.m_remainingTime = countdown;
        this.m_timeout = countdown;
        this.initialize(messageTxt, countdownTxt, cancelTxt);
        this.layoutWidgets();
        this.setTitle(titleTxt);
        this.pack();
        this.resizeButtons();
        this.setAlwaysOnTop(true);
        Dimension size = this.getPreferredSize();
        this.setSize(size);
        this.setLocationRelativeTo(parent);
        this.setResizable(true);
        this.setModal(true);
        this.m_timer.start();
    }

    private void initialize(String messageTxt, final String countdownTxt, String cancelTxt) {
        this.m_message = new JTextArea(messageTxt);
        this.m_message.setEditable(false);
        this.m_message.setFocusable(false);
        this.m_message.setLineWrap(true);
        this.m_message.setWrapStyleWord(true);
        this.m_message.setOpaque(false);
        this.m_countdown = new JTextArea(countdownTxt);
        this.m_countdown.setEditable(false);
        this.m_countdown.setFocusable(false);
        this.m_countdown.setLineWrap(true);
        this.m_countdown.setWrapStyleWord(true);
        this.m_countdown.setOpaque(false);
        String mtxt = this.bundle.getString("Common.RetryButton.txt");
        this.m_retryButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_retryButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_retryButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_retryButton.addActionListener(this);
        mtxt = cancelTxt;
        this.m_cancelButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_cancelButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_cancelButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_cancelButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.m_retryButton);
        this.m_timerAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DlgRetryESD.this.timerEvent(countdownTxt);
            }
        };
        this.m_timer = new Timer(1000, this.m_timerAction);
    }

    private void timerEvent(String countdownTxt) {
        --this.m_remainingTime;
        int minutes = this.m_remainingTime / 60;
        int seconds = this.m_remainingTime % 60;
        String countdown = minutes + ":" + (seconds < 10 ? "0" : "") + seconds;
        Object[] args = new Object[]{countdown};
        this.m_countdown.setText(MessageFormat.format(countdownTxt, args));
        if (this.m_remainingTime < 1) {
            this.retry();
            this.m_remainingTime = this.m_timeout;
        }
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        this.layoutButtons();
        c.gridy = 0;
        c.anchor = 18;
        c.insets = new Insets(10, 10, 0, 10);
        this.m_contentPane.add((Component)this.m_message, c);
        c.gridy = 1;
        c.anchor = 18;
        c.insets = new Insets(10, 10, 0, 10);
        this.m_contentPane.add((Component)this.m_countdown, c);
        c.gridy = 2;
        c.anchor = 15;
        c.insets = new Insets(10, 10, 10, 10);
        this.m_contentPane.add((Component)this.m_buttonPanel, c);
        this.m_contentPane.setOpaque(true);
        this.setContentPane(this.m_contentPane);
        this.addKeyListeners(this, this.m_keyHandler);
    }

    private void layoutButtons() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weighty = 1.0;
        c.fill = 0;
        c.gridx = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_buttonPanel.add((Component)this.m_retryButton, c);
        c.gridx = 1;
        c.weightx = 0.0;
        c.anchor = 13;
        c.insets = new Insets(0, 10, 0, 0);
        this.m_buttonPanel.add((Component)this.m_cancelButton, c);
    }

    private void resizeButtons() {
        Dimension buttonSize = this.m_cancelButton.getSize();
        double maxWidth = buttonSize.getWidth();
        double maxHeight = buttonSize.getHeight();
        if ((buttonSize = this.m_retryButton.getSize(buttonSize)).getWidth() > maxWidth) {
            maxWidth = buttonSize.getWidth();
        }
        if (buttonSize.getHeight() > maxHeight) {
            maxHeight = buttonSize.getHeight();
        }
        if (maxWidth < 75.0) {
            maxWidth = 75.0;
        }
        if (maxHeight < 23.0) {
            maxHeight = 23.0;
        }
        buttonSize.setSize(maxWidth, maxHeight);
        this.m_retryButton.setPreferredSize(buttonSize);
        this.m_cancelButton.setPreferredSize(buttonSize);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_retryButton) {
            this.retry();
        }
        this.dispose();
    }

    private void retry() {
        this.m_retryObject.retry();
        this.dispose();
    }

    protected void addKeyListeners(Container container, cKeyHandler keyHandler) {
        Component[] componentArray = container.getComponents();
        int nComps = componentArray.length;
        for (int iComp = 0; iComp < nComps; ++iComp) {
            componentArray[iComp].addKeyListener(keyHandler);
            if (!(componentArray[iComp] instanceof Container)) continue;
            this.addKeyListeners((Container)componentArray[iComp], keyHandler);
        }
    }

    protected class cKeyHandler
    extends KeyAdapter {
        protected cKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int eKeyCode = e.getKeyCode();
            switch (eKeyCode) {
                case 27: {
                    DlgRetryESD.this.dispose();
                }
            }
        }
    }
}

