/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Language;
import com.sas.ssn.OrderData;
import com.sas.ssn.SSNResource;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class DlgOrderDetails
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -7592449840041106250L;
    private SSNResource bundle = new SSNResource(DlgOrderDetails.class);
    private JPanel m_contentPane = new JPanel(new GridBagLayout());
    private JPanel m_buttonPanel = new JPanel();
    private JLabel m_dateLabel;
    private JTextField m_date;
    private JLabel m_descLabel;
    private KitTextField m_descTxt;
    private JLabel m_notesLabel;
    private JEditorPane m_notes;
    private JScrollPane m_notesScrollPane;
    private JButton m_okButton;
    private JButton m_cancelButton;
    private boolean m_descChanged = false;
    private boolean m_editable = false;
    private String m_order = null;
    private OrderData m_orderData = null;
    private cKeyHandler m_keyHandler;

    public DlgOrderDetails(JFrame parent, String order, boolean editable) {
        this.m_order = order;
        this.m_orderData = Globals.g_deploymentData.getOrder(order);
        this.m_editable = editable;
        this.m_keyHandler = new cKeyHandler();
        this.initialize();
        this.layoutWidgets();
        this.setTitle(this.bundle.getString("DlgOrderDetails.Title.txt"));
        this.pack();
        this.resizeButtons();
        this.setSize(new Dimension(450, 250));
        this.setLocationRelativeTo(parent);
        this.setResizable(false);
        this.setModal(true);
    }

    private void initialize() {
        String dateAdded = null;
        try {
            dateAdded = DateFormat.getDateTimeInstance(2, 3).format(new SimpleDateFormat("yyyyMMddHHmmss").parse(this.m_orderData.getExtendedData().getTime(), new ParsePosition(0)));
        }
        catch (Exception e) {
            dateAdded = this.bundle.getString("DlgOrderDetails.NotAvailable.txt");
        }
        this.m_date = new JTextField(dateAdded);
        this.m_date.setEditable(false);
        String mtxt = this.bundle.getString("DlgOrderDetails.DateAdded.txt");
        this.m_dateLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_dateLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_dateLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_dateLabel.setLabelFor(this.m_date);
        this.m_descTxt = new KitTextField(this.m_orderData.getDescription(Language.gs_SelectedLanguage));
        this.m_descTxt.setEditable(this.m_editable);
        mtxt = this.bundle.getString("DlgOrderDetails.OrderDesc.txt");
        this.m_descLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_descLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_descLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_descLabel.setLabelFor(this.m_descTxt);
        this.m_notes = new JEditorPane();
        this.m_notes.setOpaque(this.m_editable);
        this.m_notes.setEditable(this.m_editable);
        this.m_notes.setContentType("text/plain");
        this.m_notes.setText(this.m_orderData.getExtendedData().getNote());
        this.m_notesScrollPane = new JScrollPane(this.m_notes);
        mtxt = this.bundle.getString("DlgOrderDetails.Notes.txt");
        this.m_notesLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_notesLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_notesLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_notesLabel.setLabelFor(this.m_notes);
        mtxt = this.bundle.getString("Common.OK.txt");
        this.m_okButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_okButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_okButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_okButton.addActionListener(this);
        mtxt = this.bundle.getString("Common.Cancel.txt");
        this.m_cancelButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_cancelButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_cancelButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_cancelButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.m_okButton);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        this.layoutButtons();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(10, 10, 0, 5);
        this.m_contentPane.add((Component)this.m_dateLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 13;
        c.insets = new Insets(10, 0, 0, 10);
        this.m_contentPane.add((Component)this.m_date, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(10, 10, 0, 5);
        this.m_contentPane.add((Component)this.m_descLabel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 13;
        c.insets = new Insets(10, 0, 0, 10);
        this.m_contentPane.add((Component)this.m_descTxt, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 18;
        c.insets = new Insets(13, 10, 0, 5);
        this.m_contentPane.add((Component)this.m_notesLabel, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 13;
        c.insets = new Insets(10, 0, 0, 10);
        this.m_contentPane.add((Component)this.m_notesScrollPane, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 15;
        c.insets = new Insets(10, 10, 10, 10);
        this.m_contentPane.add((Component)this.m_buttonPanel, c);
        this.m_contentPane.setOpaque(true);
        this.setContentPane(this.m_contentPane);
        this.addKeyListeners(this, this.m_keyHandler);
    }

    private void layoutButtons() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weighty = 1.0;
        c.fill = 0;
        c.gridx = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_buttonPanel.add((Component)this.m_okButton, c);
        if (this.m_editable) {
            c.gridx = 1;
            c.weightx = 0.0;
            c.anchor = 13;
            c.insets = new Insets(0, 10, 0, 0);
            this.m_buttonPanel.add((Component)this.m_cancelButton, c);
        }
    }

    private void resizeButtons() {
        Dimension buttonSize = this.m_cancelButton.getSize();
        double maxWidth = buttonSize.getWidth();
        double maxHeight = buttonSize.getHeight();
        if ((buttonSize = this.m_okButton.getSize(buttonSize)).getWidth() > maxWidth) {
            maxWidth = buttonSize.getWidth();
        }
        if (buttonSize.getHeight() > maxHeight) {
            maxHeight = buttonSize.getHeight();
        }
        if (maxWidth < 75.0) {
            maxWidth = 75.0;
        }
        if (maxHeight < 23.0) {
            maxHeight = 23.0;
        }
        buttonSize.setSize(maxWidth, maxHeight);
        this.m_okButton.setPreferredSize(buttonSize);
        this.m_cancelButton.setPreferredSize(buttonSize);
    }

    public boolean descChanged() {
        return this.m_descChanged;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_okButton && this.m_editable) {
            this.save();
        }
        this.dispose();
    }

    private void save() {
        if (Globals.g_depotManager.setDescription(this.m_order, this.m_descTxt.getText().trim())) {
            this.m_descChanged = true;
        }
        Globals.g_depotManager.setNote(this.m_order, this.m_notes.getText());
    }

    protected void addKeyListeners(Container container, cKeyHandler keyHandler) {
        Component[] componentArray = container.getComponents();
        int nComps = componentArray.length;
        for (int iComp = 0; iComp < nComps; ++iComp) {
            componentArray[iComp].addKeyListener(keyHandler);
            if (!(componentArray[iComp] instanceof Container)) continue;
            this.addKeyListeners((Container)componentArray[iComp], keyHandler);
        }
    }

    protected class cKeyHandler
    extends KeyAdapter {
        protected cKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int eKeyCode = e.getKeyCode();
            switch (eKeyCode) {
                case 27: {
                    DlgOrderDetails.this.dispose();
                }
            }
        }
    }
}

