/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Logging;
import com.sas.ssn.Reboot;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.swing.visuals.util.Util;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;

public class DlgAutoLogon
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private SSNResource bundle = new SSNResource(DlgAutoLogon.class);
    private JPanel m_contentPane = new JPanel(new GridBagLayout());
    private JPanel m_buttonPanel = new JPanel();
    private JTextArea m_headerDesc = null;
    private JCheckBox m_autologinOption = null;
    private JLabel m_domainLabel = null;
    private KitTextField m_domainName = null;
    private JLabel m_userNameLabel = null;
    private KitTextField m_userName = null;
    private JLabel m_passwordLabel = null;
    private JPasswordField m_password = null;
    private JButton m_allowButton = null;
    private JButton m_skipButton = null;
    private JButton m_exitButton = null;
    private PrintWriter m_chainResponseFile = null;
    static String m_domainNameValue = null;
    static String m_userNameValue = null;
    static String m_passwordValue = null;
    private cKeyHandler m_keyHandler = new cKeyHandler();
    private boolean m_skip = false;
    private boolean m_exit = false;
    private boolean m_allow = false;

    public DlgAutoLogon(JFrame parent) {
        this.initialize();
        this.layoutWidgets();
        this.setTitle(this.getHeader());
        this.pack();
        this.resizeButtons();
        this.setSize(new Dimension(450, 215));
        this.setLocationRelativeTo(parent);
        this.setResizable(true);
        this.setModal(true);
    }

    private void initialize() {
        String mtxt = this.getHeaderDesc();
        this.m_headerDesc = new JTextArea(Util.getLabelWithoutMnemonic(mtxt));
        this.m_headerDesc.setEditable(false);
        this.m_headerDesc.setFocusable(false);
        this.m_headerDesc.setLineWrap(true);
        this.m_headerDesc.setWrapStyleWord(true);
        this.m_headerDesc.setOpaque(false);
        mtxt = this.bundle.getString("DlgAutoLogon.AutoLogon.txt");
        this.m_autologinOption = new JCheckBox(Util.getLabelWithoutMnemonic(mtxt));
        this.m_autologinOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_autologinOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_autologinOption.setSelected(false);
        this.m_autologinOption.addActionListener(this);
        this.m_domainName = new KitTextField();
        mtxt = this.bundle.getString("DlgAutoLogon.DomainName.txt");
        this.m_domainLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_domainLabel.setLabelFor(this.m_domainName);
        this.m_domainName.setEnabled(false);
        this.m_domainName.setText(m_domainNameValue);
        this.m_userName = new KitTextField();
        mtxt = this.bundle.getString("DlgAutoLogon.UserName.txt");
        this.m_userNameLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_userNameLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_userNameLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_userNameLabel.setLabelFor(this.m_userName);
        this.m_userName.setEnabled(false);
        this.m_password = new JPasswordField();
        mtxt = this.bundle.getString("DlgAutoLogon.Password.txt");
        this.m_passwordLabel = new JLabel(Util.getLabelWithoutMnemonic(mtxt));
        this.m_passwordLabel.setDisplayedMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_passwordLabel.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_passwordLabel.setLabelFor(this.m_password);
        this.m_password.setEnabled(false);
        mtxt = this.bundle.getString("Common.Allow.txt");
        this.m_allowButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_allowButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_allowButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_allowButton.addActionListener(this);
        mtxt = this.bundle.getString("Common.Skip.txt");
        this.m_skipButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_skipButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_skipButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_skipButton.addActionListener(this);
        mtxt = this.bundle.getString("Common.Exit.txt");
        this.m_exitButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_exitButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_exitButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_exitButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.m_allowButton);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.weighty = 0.0;
        this.layoutButtons();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 10, 0, 5);
        this.m_contentPane.add((Component)this.m_headerDesc, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 15;
        c.insets = new Insets(10, 10, 10, 10);
        this.m_contentPane.add((Component)this.m_buttonPanel, c);
        this.m_contentPane.setOpaque(true);
        this.setContentPane(this.m_contentPane);
        this.addKeyListeners(this, this.m_keyHandler);
    }

    private void layoutButtons() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weighty = 1.0;
        c.fill = 0;
        c.gridx = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_buttonPanel.add((Component)this.m_allowButton, c);
        c.gridx = 1;
        c.weightx = 0.0;
        c.anchor = 10;
        c.insets = new Insets(20, 10, 0, 0);
        this.m_buttonPanel.add((Component)this.m_skipButton, c);
        c.gridx = 2;
        c.weightx = 0.0;
        c.anchor = 13;
        c.insets = new Insets(40, 20, 0, 0);
        this.m_buttonPanel.add((Component)this.m_exitButton, c);
    }

    private void resizeButtons() {
        double width = Math.max(this.m_allowButton.getSize().getWidth(), Math.max(this.m_skipButton.getSize().getWidth(), this.m_exitButton.getSize().getWidth()));
        double height = Math.max(this.m_allowButton.getSize().getHeight(), Math.max(this.m_skipButton.getSize().getHeight(), this.m_exitButton.getSize().getHeight()));
        Dimension buttonSize = new Dimension();
        buttonSize.setSize(width, height);
        this.m_allowButton.setPreferredSize(buttonSize);
        this.m_skipButton.setPreferredSize(buttonSize);
        this.m_exitButton.setPreferredSize(buttonSize);
        float ratio = (float)this.bundle.getString("DlgAutoLogon.Title.txt").length() / (float)this.bundle.getString("DlgAutoLogon.UserName.txt").length();
        Dimension size = new Dimension();
        size.setSize(width * (double)ratio, height);
        this.m_userName.setPreferredSize(size);
        this.m_password.setPreferredSize(size);
    }

    private void onSkip() {
        this.m_skip = true;
        this.m_domainName.setText("");
        this.m_userName.setText("");
        this.m_password.setText("");
    }

    private void onExit() {
        this.m_exit = true;
    }

    public boolean skipped() {
        return this.m_skip;
    }

    public boolean exited() {
        return this.m_exit;
    }

    public boolean allowed() {
        return this.m_allow;
    }

    public String getUserName() {
        String user = String.valueOf(this.m_userName.getText());
        if (user == null || user.length() == 0) {
            user = m_userNameValue;
        }
        return user;
    }

    String getDecodedPassword() {
        String password = String.valueOf(this.m_password.getPassword());
        if (password == null || password.length() == 0) {
            password = m_passwordValue;
        }
        return password;
    }

    public String getPassword() {
        String value = this.getDecodedPassword();
        try {
            value = SasPasswordString.encode("sas002", value);
        }
        catch (SasPasswordEncodingException e) {
            Logging.log.severe("Unable to encode the password for: " + this.m_password);
            Logging.logStackTrace(e);
        }
        return value;
    }

    public String getDomainName() {
        String domain = String.valueOf(this.m_domainName.getText());
        if (domain == null || domain.length() == 0) {
            domain = m_domainNameValue;
        }
        return domain;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.m_autologinOption) {
            boolean enabled = this.m_autologinOption.isSelected();
            this.m_domainName.setEnabled(enabled);
            this.m_userName.setEnabled(enabled);
            this.m_password.setEnabled(enabled);
        } else {
            if (obj == this.m_skipButton) {
                this.onSkip();
            } else if (obj == this.m_allowButton) {
                this.onAllow();
            } else if (obj == this.m_exitButton) {
                this.onExit();
            }
            this.dispose();
        }
    }

    private String getHeader() {
        return this.bundle.getString("DlgAutoLogon.Title.txt");
    }

    private String getHeaderDesc() {
        if (Globals.g_recordMode && Globals.g_recordOnly) {
            return this.bundle.getString("DlgAutoLogon.TitleDesc.record.txt");
        }
        return this.bundle.getString("DlgAutoLogon.TitleDesc.txt");
    }

    private void onAllow() {
        this.m_allow = true;
        if (this.m_autologinOption.isSelected()) {
            Reboot myreboot = new Reboot();
            String domain = this.getDomainName();
            String user = this.getUserName();
            String password = this.getDecodedPassword();
            myreboot.setUserInfo(domain, user, password);
            String[] data = this.responseData();
            try {
                String responsefile = null;
                responsefile = Globals.g_recordMode && Globals.g_recordOnly ? Globals.g_responseFile : Globals.g_chainData.getResponseFile();
                this.m_chainResponseFile = new PrintWriter(new BufferedWriter(new FileWriter(responsefile, true)));
                if (this.m_chainResponseFile != null) {
                    this.m_chainResponseFile.println();
                    this.m_chainResponseFile.println("# " + this.getHeader());
                    this.m_chainResponseFile.println("# " + this.getHeaderDesc());
                    for (int i = 0; i < data.length; ++i) {
                        this.m_chainResponseFile.println(data[i]);
                    }
                }
                if (this.m_chainResponseFile != null) {
                    this.m_chainResponseFile.flush();
                }
                if (this.m_chainResponseFile != null) {
                    this.m_chainResponseFile.close();
                }
            }
            catch (IOException e) {
                Logging.log.severe("Error creating chain response file: " + Globals.g_chainData.getResponseFile());
            }
        }
    }

    public static boolean loadResponseData() {
        boolean valid = false;
        String response = null;
        if (Globals.g_restartDomain != null && Globals.g_restartDomain.length() > 0) {
            m_domainNameValue = Globals.g_restartDomain;
            valid = true;
        } else {
            response = Wizard.getResponse("AUTOLOGON_DOMAINNAME", null);
            if (response != null) {
                m_domainNameValue = response;
                valid = true;
            } else {
                Logging.log.fine("Missing autologon domain.");
            }
        }
        if (Globals.g_restartUserID != null && Globals.g_restartUserID.length() > 0) {
            m_userNameValue = Globals.g_restartUserID;
            valid = true;
        } else {
            response = Wizard.getResponse("AUTOLOGON_USERID", null);
            if (response != null) {
                m_userNameValue = response;
                valid = true;
            } else {
                Logging.log.fine("Missing autologon user id.");
            }
        }
        if (Globals.g_restartPassword != null && Globals.g_restartPassword.length() > 0) {
            m_passwordValue = Globals.g_restartPassword;
            valid = true;
        } else {
            response = Wizard.getResponse("AUTOLOGON_PASSWORD", null);
            String decodedPassword = "";
            if (response != null) {
                try {
                    decodedPassword = SasPasswordString.decode(response);
                }
                catch (SasPasswordEncodingException e) {
                    decodedPassword = "";
                    Logging.log.warning("Unable to decode the password for: " + m_userNameValue);
                    Logging.logStackTrace(e);
                }
                m_passwordValue = decodedPassword;
                valid = true;
            } else {
                Logging.log.fine("Missing autologon user password.");
            }
        }
        return valid;
    }

    public String[] responseData() {
        String[] data = new String[]{"#AUTOLOGON_DOMAINNAME=<domain name>", " AUTOLOGON_DOMAINNAME=", "#AUTOLOGON_USERID=<user name>", " AUTOLOGON_USERID=", "#AUTOLOGON_PASSWORD=<password in plain text>", " AUTOLOGON_PASSWORD="};
        if (this.m_autologinOption.isSelected()) {
            data[1] = " AUTOLOGON_DOMAINNAME=" + this.m_domainName.getText();
            data[3] = " AUTOLOGON_USERID=" + this.m_userName.getText();
            data[5] = " AUTOLOGON_PASSWORD=" + this.getPassword();
        }
        return data;
    }

    protected void addKeyListeners(Container container, cKeyHandler keyHandler) {
        Component[] componentArray = container.getComponents();
        int nComps = componentArray.length;
        for (int iComp = 0; iComp < nComps; ++iComp) {
            componentArray[iComp].addKeyListener(keyHandler);
            if (!(componentArray[iComp] instanceof Container)) continue;
            this.addKeyListeners((Container)componentArray[iComp], keyHandler);
        }
    }

    protected class cKeyHandler
    extends KeyAdapter {
        protected cKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int eKeyCode = e.getKeyCode();
            switch (eKeyCode) {
                case 27: {
                    DlgAutoLogon.this.onSkip();
                    DlgAutoLogon.this.dispose();
                }
            }
        }
    }
}

