/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;

public class DepotSubsetListData
implements Comparable<DepotSubsetListData>,
Serializable {
    private static final long serialVersionUID = -1232962951696979275L;
    private HashSet<String> altskus = null;
    private String name = null;
    private String code = null;
    private boolean selectedByUser = false;
    private boolean selectedByDependency = false;
    private boolean selectableByPolicy = false;
    private boolean selectableByDependency = true;
    private boolean omittedByPolicy = false;
    private HashSet<DepotSubsetListData> dependencies = null;
    private HashSet<DepotSubsetListData> revDependencies = null;

    public DepotSubsetListData(HashSet<String> altskus, String name, String code, boolean selectable, boolean force_selection) {
        this.altskus = altskus;
        this.name = name;
        this.code = code;
        this.selectableByPolicy = selectable;
        this.selectableByDependency = selectable;
        this.selectedByUser = force_selection;
    }

    public DepotSubsetListData(HashSet<String> altskus, String name, String code, boolean selectable) {
        this(altskus, name, code, selectable, false);
    }

    public HashSet<String> getAltSkus() {
        return this.altskus;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public boolean isSelectedByUser() {
        return this.selectedByUser;
    }

    public void setSelectedByUser(boolean select) {
        if (this.selectableByPolicy && this.selectableByDependency) {
            this.selectedByUser = select;
        }
    }

    public boolean isSelectedByDependency() {
        return this.selectedByDependency;
    }

    public void setSelectedByDependency(boolean select) {
        if (this.selectableByPolicy) {
            this.selectedByDependency = select;
        }
    }

    public boolean isSelected() {
        return this.isSelectedByUser() || this.isSelectedByDependency();
    }

    public boolean isSelectable() {
        return this.isSelectableByPolicy() || this.isSelectableByDependency();
    }

    public void setSelectableByPolicy(boolean selectable) {
        this.selectableByPolicy = selectable;
        if (!selectable) {
            this.selectedByUser = true;
        }
    }

    public boolean isSelectableByPolicy() {
        return this.selectableByPolicy;
    }

    public boolean isSelectableByDependency() {
        return this.selectableByDependency;
    }

    public void setSelectableByDependency(boolean selectableByDependency) {
        if (this.isSelectableByPolicy()) {
            this.selectableByDependency = selectableByDependency;
        }
    }

    public void setOmittedByPolicy(boolean omit) {
        this.omittedByPolicy = omit;
    }

    public boolean isOmittedByPolicy() {
        return this.omittedByPolicy;
    }

    @Override
    public int compareTo(DepotSubsetListData o) {
        return this.name.compareTo(o.getName());
    }

    public void addDependency(DepotSubsetListData dependency) {
        if (this.dependencies == null) {
            this.dependencies = new HashSet();
        }
        this.dependencies.add(dependency);
    }

    public void addDependencies(Collection<DepotSubsetListData> dependencyList) {
        if (this.dependencies == null) {
            this.dependencies = new HashSet<DepotSubsetListData>(dependencyList);
        } else {
            this.dependencies.addAll(dependencyList);
        }
    }

    public void addRevDependency(DepotSubsetListData revDependency) {
        if (this.revDependencies == null) {
            this.revDependencies = new HashSet();
        }
        this.revDependencies.add(revDependency);
    }

    public void addRevDependencies(HashSet<DepotSubsetListData> revDependencyList) {
        if (this.revDependencies == null) {
            this.revDependencies = new HashSet<DepotSubsetListData>(revDependencyList);
        } else {
            this.revDependencies.addAll(revDependencyList);
        }
    }

    public HashSet<DepotSubsetListData> getRevDependencies() {
        return this.revDependencies;
    }

    public HashSet<DepotSubsetListData> getDependencies() {
        return this.dependencies;
    }

    public String toString() {
        return this.name;
    }
}

