/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.InstallToolConnector;
import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import com.sas.tools.installs.extension.ExtensionException;
import com.sas.tools.installs.extension.ExtensionRegistry;
import com.sas.tools.installs.it.AltskuProperties;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.WindowsRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class DefaultFileTypeAssociations {
    private ExtensionRegistry extRegistry = null;
    private String defaultProductForFileTypes = null;
    private Map<String, ProductData> selectedProductsWithExtensions = new HashMap<String, ProductData>();
    private File extRegFile = null;
    private static final List<String> productsWithSharedExtensions = Arrays.asList("base", "eguide", "sasuniviewer");

    public DefaultFileTypeAssociations(File extensionRegistryFile, String defaultProduct, ProductData[] selectedInstalls) {
        this.extRegFile = extensionRegistryFile;
        if (this.extRegFile.exists()) {
            try {
                this.extRegistry = new ExtensionRegistry(this.extRegFile);
            }
            catch (ExtensionException e) {
                this.extRegistry = null;
                Logging.log.warning(e.getMessage());
                Logging.logStackTrace(e);
            }
        }
        this.defaultProductForFileTypes = defaultProduct;
        if (selectedInstalls != null) {
            for (ProductData product : selectedInstalls) {
                String productCode = product.getProdCode();
                if (productCode.equals("sasinstall")) {
                    productCode = "base";
                }
                if (this.extRegistry.getExtensions(productCode).isEmpty()) continue;
                this.selectedProductsWithExtensions.put(productCode, product);
            }
        }
    }

    private Map<String, ProductData> getSelectedProductsWithSharedExtensions() {
        HashMap<String, ProductData> selectedProductsWithSharedExtensions = new HashMap<String, ProductData>();
        for (String product : productsWithSharedExtensions) {
            if (!this.selectedProductsWithExtensions.keySet().contains(product)) continue;
            selectedProductsWithSharedExtensions.put(product, this.selectedProductsWithExtensions.get(product));
        }
        return selectedProductsWithSharedExtensions;
    }

    private String getProductAlternative(String extension) {
        String product = null;
        Collection<String> productsForSharedExtension = this.extRegistry.getProductsForExtension(extension);
        if (!productsForSharedExtension.isEmpty()) {
            product = this.findPriorityProduct(productsForSharedExtension);
        }
        return product;
    }

    public boolean register(boolean productsAlreadyInstalled) {
        boolean results = true;
        if (this.extRegistry == null) {
            Logging.log.warning("An error occurred while opening the extension registry " + this.extRegFile.getAbsolutePath() + ", default file type actions will not be registered.");
            return false;
        }
        WindowsRegistry winRegistry = null;
        try {
            winRegistry = new WindowsRegistry();
        }
        catch (InstallException e) {
            Logging.log.warning("An error occurred while opening the Windows registry, default file type actions will not be registered.");
            Logging.logStackTrace(e);
            return false;
        }
        Collection<String> sharedExtensions = this.getSharedExtensions();
        for (String product : this.extRegistry.getProductsWithExtensions()) {
            if (!this.selectedProductsWithExtensions.keySet().contains(product)) continue;
            for (String extension : this.extRegistry.getExtensions(product)) {
                String productToRegister = null;
                if (sharedExtensions.contains(extension)) {
                    if (this.defaultProductForFileTypes == null) {
                        if (!productsAlreadyInstalled) {
                            productToRegister = this.getProductAlternative(extension);
                            if (productToRegister == null) {
                                productToRegister = product;
                            }
                        } else if (product.equals("base") && Globals.g_updatingBase && this.getDefaultActionCommand(extension).contains(Globals.g_activeSasLocation)) {
                            productToRegister = product;
                        }
                    } else if (product.equals(this.defaultProductForFileTypes)) {
                        productToRegister = product;
                    } else {
                        Collection<String> extensionsForSelectedDefaultProd = this.extRegistry.getExtensions(this.defaultProductForFileTypes);
                        if (extensionsForSelectedDefaultProd != null && !extensionsForSelectedDefaultProd.contains(extension)) {
                            productToRegister = this.getProductAlternative(extension);
                        }
                    }
                } else {
                    productToRegister = product;
                }
                if (productToRegister == null || this.registerDefaultActionForExtension(winRegistry, this.extRegistry, extension, productToRegister)) continue;
                Logging.log.warning("There was a problem registering the extension " + extension + " to " + productToRegister);
                results = false;
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> getSharedExtensions() {
        TreeSet<String> sharedExtensions = new TreeSet<String>();
        sharedExtensions.addAll(this.extRegistry.getSharedExtensions());
        for (String product : productsWithSharedExtensions) {
            File deploymntRegJar;
            if (product == "base" || !(deploymntRegJar = new File(Globals.g_wizardData.getPreference("SASHome", "") + File.separator + "deploymntreg", "sas.tools.deploymntreg.jar")).exists()) continue;
            RegistryAccess registryAccess = null;
            try {
                RegistryData.setRegistry(Globals.g_wizardData.getPreference("SASHome", ""));
                registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                registryAccess.open();
                ProductData productData = this.getSelectedProductsWithSharedExtensions().get(product);
                if (productData == null) continue;
                String thirtyTwoBitLoc = registryAccess.getInstallLoc(product, productData.getProdVersion(), "win");
                String sixtyFourBitLoc = registryAccess.getInstallLoc(product, productData.getProdVersion(), "wx6");
                if (thirtyTwoBitLoc == null || thirtyTwoBitLoc.equals("") || sixtyFourBitLoc == null || sixtyFourBitLoc.equals("")) continue;
                sharedExtensions.addAll(this.extRegistry.getExtensions(product));
            }
            catch (FileNotFoundException e) {
                Logging.logStackTrace(e);
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
            finally {
                if (null == registryAccess) continue;
                registryAccess.close();
            }
        }
        return sharedExtensions;
    }

    private String findPriorityProduct(Collection<String> productsForSharedExtension) {
        for (String product : productsWithSharedExtensions) {
            if (!productsForSharedExtension.contains(product) || !this.selectedProductsWithExtensions.containsKey(product)) continue;
            return product;
        }
        return null;
    }

    private boolean registerDefaultActionForExtension(WindowsRegistry winRegistry, ExtensionRegistry extRegistry, String extension, String productToRegister) {
        ProductData productData = this.selectedProductsWithExtensions.get(productToRegister);
        if (productData == null) {
            Logging.log.warning("Product data is not availabe for: order: " + productToRegister);
            return false;
        }
        String sku = productData.getSpsSku();
        AltskuProperties props = new AltskuProperties(InstallToolConnector.itController(), sku);
        Logging.log.info("Registering extension " + extension + " default open(double click) action for " + productToRegister);
        try {
            extRegistry.registerDefault(extension, winRegistry, props, true);
        }
        catch (ExtensionException e) {
            Logging.log.warning(e.getMessage());
            Logging.logStackTrace(e);
            return false;
        }
        return true;
    }

    private String getDefaultActionCommand(String extension) {
        String progID = "";
        String defaultVerb = "";
        String[] verbs = null;
        String defaultCommand = "";
        progID = WinRegAPI.getWindowsRegistryValue(1, extension, "");
        if (progID == null || progID.isEmpty()) {
            defaultCommand = "Not Found";
        } else {
            defaultVerb = WinRegAPI.getWindowsRegistryValue(1, progID + "\\shell", "");
            if (defaultVerb == null || defaultVerb.isEmpty()) {
                defaultCommand = WinRegAPI.getWindowsRegistryValue(1, progID + "\\shell\\open\\command", "");
                if (defaultCommand == null || defaultCommand.isEmpty()) {
                    if (WinRegAPI.isWindowsRegistryKey64(1, progID + "\\shell")) {
                        verbs = WinRegAPI.childrenForKey64(1, progID + "\\shell");
                    } else if (WinRegAPI.isWindowsRegistryKey32(1, progID + "\\shell")) {
                        verbs = WinRegAPI.childrenForKey32(1, progID + "\\shell");
                    }
                    defaultCommand = verbs != null && verbs.length > 0 ? WinRegAPI.getWindowsRegistryValue(1, progID + "\\shell\\" + verbs[0].toString() + "\\command", "") : "";
                }
            } else {
                defaultCommand = WinRegAPI.getWindowsRegistryValue(1, progID + "\\shell\\" + defaultVerb + "\\command", "");
            }
        }
        return defaultCommand;
    }
}

