/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

class DashedBorder
implements Border {
    int dashWidth = 2;
    int dashHeight = 2;
    int THICKNESS = 1;

    public DashedBorder() {
        this(2, 2);
    }

    public DashedBorder(int width, int height) {
        if (width < 1) {
            throw new IllegalArgumentException("Invalid width: " + width);
        }
        if (height < 1) {
            throw new IllegalArgumentException("Invalid height: " + height);
        }
        this.dashWidth = width;
        this.dashHeight = height;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int startPoint;
        int i;
        Color color = c.getBackground();
        color = c.getForeground();
        g.setColor(color);
        Insets insets = this.getBorderInsets(c);
        int numWide = Math.round(width / this.dashWidth);
        int numHigh = Math.round(height / this.dashHeight);
        for (i = 0; i <= numWide; i += this.dashWidth) {
            startPoint = x + this.dashWidth * i;
            g.fillRect(startPoint, y, this.dashWidth, this.THICKNESS);
            g.fillRect(startPoint, y + height - insets.bottom, this.dashWidth, this.THICKNESS);
        }
        for (i = 0; i <= numHigh; i += this.dashHeight) {
            startPoint = x + this.dashHeight * i;
            g.fillRect(x, startPoint, this.THICKNESS, this.dashHeight);
            g.fillRect(x + width - insets.right, startPoint, this.THICKNESS, this.dashHeight);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.THICKNESS, this.THICKNESS, this.THICKNESS, this.THICKNESS);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

