/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;

public class CustMsgBox
extends JOptionPane {
    protected static SSNResource bundle = new SSNResource(CustMsgBox.class);

    public static int showMessageDialog(Component comp, String message, String title) {
        if (Globals.g_consoleMode) {
            ConsoleMode.genericMsg(Utils.removeHTMLTags(message));
            return 0;
        }
        Object[] options = CustMsgBox.GetOptions(-1);
        return CustMsgBox.showOptionDialog(comp, message, title, -1, -1, null, options, options[0]);
    }

    public static int showMessageDialog(Component comp, String message, String title, int messageType) {
        if (Globals.g_consoleMode) {
            if (messageType == 2 || messageType == 0) {
                ConsoleMode.errorMsg(Utils.removeHTMLTags(message));
            } else {
                ConsoleMode.genericMsg(Utils.removeHTMLTags(message));
            }
            return 0;
        }
        Object[] options = CustMsgBox.GetOptions(-1);
        return CustMsgBox.showOptionDialog(comp, message, title, -1, messageType, null, options, options[0]);
    }

    public static void showErrorMessage(String message) {
        CustMsgBox.showMessageDialog(null, message, "Error Message", 0);
    }

    public static int showConfirmDialog(Component comp, String message) {
        String title = bundle.getString("Common.options.txt");
        return CustMsgBox.showConfirmDialog(comp, message, title, 1, 3);
    }

    public static int showConfirmDialog(Component comp, String message, String title, int optionType) {
        return CustMsgBox.showConfirmDialog(comp, message, title, optionType, -1);
    }

    public static int showConfirmDialog(Component comp, String message, String title, int optionType, int messageType) {
        if (Globals.g_consoleMode) {
            if (optionType == 0) {
                if (Globals.g_mode == 1) {
                    if (ConsoleMode.confirmPrompt(message, "y")) {
                        return 0;
                    }
                    return 1;
                }
                if (ConsoleMode.confirmPrompt(message)) {
                    return 0;
                }
                return 1;
            }
            return 0;
        }
        Object[] options = CustMsgBox.GetOptions(optionType);
        return CustMsgBox.showOptionDialog(comp, message, title, optionType, messageType, null, options, options[0]);
    }

    public static int showConfirmDialog(Component comp, String message, String title, int optionType, int messageType, int default_option) {
        if (Globals.g_consoleMode) {
            if (optionType == 0) {
                if (ConsoleMode.confirmPrompt(message, default_option == 0 ? "y" : "n")) {
                    return 0;
                }
                return 1;
            }
            return default_option;
        }
        Object[] options = CustMsgBox.GetOptions(optionType);
        Object default_options = CustMsgBox.GetDefOptions(default_option);
        return CustMsgBox.showOptionDialog(comp, message, title, optionType, messageType, null, options, default_options);
    }

    private static Object[] GetOptions(int optionType) {
        Object[] options = optionType == 0 ? new Object[]{Util.getLabelWithoutMnemonic(bundle.getString("Common.Yes.txt")), Util.getLabelWithoutMnemonic(bundle.getString("Common.No.txt"))} : (optionType == 1 ? new Object[]{Util.getLabelWithoutMnemonic(bundle.getString("Common.Yes.txt")), Util.getLabelWithoutMnemonic(bundle.getString("Common.No.txt")), Util.getLabelWithoutMnemonic(bundle.getString("Common.Cancel.txt"))} : (optionType == 2 ? new Object[]{Util.getLabelWithoutMnemonic(bundle.getString("Common.OK2.txt")), Util.getLabelWithoutMnemonic(bundle.getString("Common.Cancel.txt"))} : new Object[]{Util.getLabelWithoutMnemonic(bundle.getString("Common.OK2.txt"))}));
        return options;
    }

    private static Object GetDefOptions(int default_option) {
        String options = default_option == 0 ? Util.getLabelWithoutMnemonic(bundle.getString("Common.Yes.txt")) : (default_option == 1 ? Util.getLabelWithoutMnemonic(bundle.getString("Common.No.txt")) : (default_option == 2 ? Util.getLabelWithoutMnemonic(bundle.getString("Common.Cancel.txt")) : (default_option == 0 ? Util.getLabelWithoutMnemonic(bundle.getString("Common.OK2.txt")) : Util.getLabelWithoutMnemonic(bundle.getString("Common.OK2.txt")))));
        return options;
    }

    public static int showConfirmRetryNoQuitPrompt(String message) {
        int promptVal = 0;
        int PROMPT_RETRY = 0;
        int PROMPT_NO = 1;
        int PROMPT_CANCEL = 2;
        JEditorPane msgArea = new JEditorPane();
        msgArea.setOpaque(false);
        msgArea.setEditable(false);
        msgArea.setContentType("text/html");
        Object[] options = null;
        int defaultButton = 0;
        options = new String[]{Util.getLabelWithoutMnemonic(bundle.getString("Common.RetryButton.txt")), Util.getLabelWithoutMnemonic(bundle.getString("Common.No.txt")), Util.getLabelWithoutMnemonic(bundle.getString("Common.Quit.txt"))};
        defaultButton = 0;
        if (Globals.g_consoleMode) {
            ConsoleMode.printInfoText(message);
            int returnCode = ConsoleMode.promptSingleChoice((String[])options, null, null, defaultButton, true);
            if (returnCode == 0) {
                promptVal = PROMPT_RETRY;
            } else if (returnCode == 1) {
                promptVal = PROMPT_NO;
            } else if (returnCode == 2) {
                promptVal = PROMPT_CANCEL;
            }
        } else {
            switch (JOptionPane.showOptionDialog(Globals.g_wizard.getFrame(), message, Globals.g_wizard.getWizardTitle(), 1, 0, null, options, options[defaultButton])) {
                case 0: {
                    promptVal = PROMPT_RETRY;
                    break;
                }
                case 1: {
                    promptVal = PROMPT_NO;
                    break;
                }
                case 2: {
                    promptVal = PROMPT_CANCEL;
                    break;
                }
                default: {
                    promptVal = PROMPT_RETRY;
                }
            }
        }
        return promptVal;
    }
}

