/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleModeEventDriven;
import com.sas.ssn.Globals;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Logging;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;

public class ConsoleMode {
    public static final int MAX_PAGE_WIDTH = 80;
    public static final int CONSOLE_RC_ERROR = -1;
    public static final int CONSOLE_RC_QUIT = -2;
    public static final int CONSOLE_RC_BACK = -3;
    public static final int CONSOLE_RC_HELP = -4;
    public static final String CONSOLE_BACK = "<b>";
    public static final String CONSOLE_HELP = "<h>";
    public static final String CONSOLE_QUIT = "<q>";
    public static final String SELECT_ALL = "<s>";
    public static final String CLEAR_ALL = "<c>";
    public static final String TREE_GROUP_TAG = "@group@";
    public static final String COLUMN_DIVIDER = "~";
    private static SSNResource bundle = new SSNResource(ConsoleMode.class);
    private static int m_charCount = 0;
    private static int m_lineCount = 0;
    private static Timer m_timer = null;
    private static ActionListener m_timerAction = null;
    private static PrintWriter m_consoleLog = null;

    public static int promptPause() {
        return ConsoleMode.promptPause(false);
    }

    public static int promptPause(boolean skipInstructions) {
        return ConsoleMode.promptPause(skipInstructions, false);
    }

    public static int promptPause(boolean skipInstructions, boolean finishDialog) {
        int returnCode = 0;
        ConsoleMode.busyMsgStop();
        ConsoleMode.println();
        if (finishDialog) {
            ConsoleMode.print(bundle.getString("ConsoleMode.FinishPrompt.txt"));
        } else {
            if (!skipInstructions) {
                if (Globals.g_wizard != null && Globals.g_wizard.getWizardActive()) {
                    if (Globals.g_wizard.firstDialog()) {
                        ConsoleMode.println(bundle.getString("ConsoleMode.InstructionsFirst.txt"));
                    } else {
                        ConsoleMode.println(bundle.getString("ConsoleMode.Instructions.txt"));
                    }
                } else {
                    ConsoleMode.println(bundle.getString("ConsoleMode.InstructionsSimple.txt"));
                }
                ConsoleMode.println(bundle.getString("ConsoleMode.AdditionalInstructions.txt"));
            }
            ConsoleMode.print(bundle.getString("ConsoleMode.PausePrompt.txt"));
        }
        String input = ConsoleMode.readLine();
        if (input == null) {
            returnCode = -1;
        } else if (input.equalsIgnoreCase(CONSOLE_QUIT)) {
            returnCode = -2;
        } else if (input.equalsIgnoreCase(CONSOLE_BACK) && Globals.g_wizard != null && !Globals.g_wizard.firstDialog()) {
            returnCode = -3;
        } else if (input.equalsIgnoreCase(CONSOLE_HELP) && Globals.g_wizard != null) {
            returnCode = -4;
        }
        return returnCode;
    }

    public static int promptBoolean(JCheckBox checkBox) {
        int returnCode = -1;
        ConsoleMode.busyMsgStop();
        while (returnCode == -1) {
            String selection = null;
            selection = checkBox.isSelected() ? "Yes" : "No";
            ConsoleMode.println();
            if (Globals.g_wizard != null && Globals.g_wizard.getWizardActive()) {
                if (Globals.g_wizard.firstDialog()) {
                    ConsoleMode.println(bundle.getString("ConsoleMode.InstructionsFirst.txt"));
                } else {
                    ConsoleMode.println(bundle.getString("ConsoleMode.Instructions.txt"));
                }
            } else {
                ConsoleMode.println(bundle.getString("ConsoleMode.InstructionsSimple.txt"));
            }
            ConsoleMode.println(bundle.getString("ConsoleMode.AdditionalInstructions.txt"));
            ConsoleMode.println(bundle.getString("ConsoleMode.BooleanPrompt1.txt"));
            ConsoleMode.print(bundle.messageString("ConsoleMode.BooleanPrompt2.txt", checkBox.getText().trim(), selection));
            String input = ConsoleMode.readLine();
            if (input == null) continue;
            if (input.equalsIgnoreCase(CONSOLE_QUIT)) {
                returnCode = -2;
                continue;
            }
            if (input.equalsIgnoreCase(CONSOLE_BACK) && Globals.g_wizard != null && !Globals.g_wizard.firstDialog()) {
                returnCode = -3;
                continue;
            }
            if (input.equalsIgnoreCase(CONSOLE_HELP) && Globals.g_wizard != null) {
                returnCode = -4;
                continue;
            }
            if (input.equalsIgnoreCase("y") || input.equalsIgnoreCase("yes")) {
                checkBox.setSelected(true);
                returnCode = 0;
                continue;
            }
            if (input.equalsIgnoreCase("n") || input.equalsIgnoreCase("no")) {
                checkBox.setSelected(false);
                returnCode = 0;
                continue;
            }
            if (input.length() != 0) continue;
            returnCode = 0;
        }
        return returnCode;
    }

    public static int promptStaticText(String label, JTextArea textArea) {
        ConsoleMode.busyMsgStop();
        ConsoleMode.println();
        ConsoleMode.println(label.trim() + " " + textArea.getText());
        return 0;
    }

    public static int promptStaticText(String label, KitTextField textField) {
        ConsoleMode.busyMsgStop();
        ConsoleMode.println();
        ConsoleMode.println(label.trim() + " " + textField.getText());
        return 0;
    }

    public static int promptPassword(String label, JPasswordField password) {
        int returnCode = 0;
        String input = null;
        ConsoleMode.busyMsgStop();
        ConsoleMode.println();
        if (Globals.g_wizard != null && Globals.g_wizard.getWizardActive()) {
            if (Globals.g_wizard.firstDialog()) {
                ConsoleMode.println(bundle.getString("ConsoleMode.InstructionsFirst.txt"));
            } else {
                ConsoleMode.println(bundle.getString("ConsoleMode.Instructions.txt"));
            }
        } else {
            ConsoleMode.println(bundle.getString("ConsoleMode.InstructionsSimple.txt"));
        }
        ConsoleMode.println(bundle.getString("ConsoleMode.AdditionalInstructions.txt"));
        ConsoleMode.print(label.trim() + " ");
        if ((double)Utils.getJREVersion() >= 1.6) {
            try {
                Class<System> systemClass = System.class;
                Method consoleMethod = systemClass.getMethod("console", new Class[0]);
                Object consoleInvoke = consoleMethod.invoke(null, new Object[0]);
                if (consoleInvoke != null) {
                    Class<?> consoleClass = consoleInvoke.getClass();
                    Method readPasswordMethod = consoleClass.getMethod("readPassword", new Class[0]);
                    input = String.valueOf((char[])readPasswordMethod.invoke(consoleInvoke, new Object[0]));
                }
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
                input = null;
            }
        }
        if (input == null) {
            input = ConsoleMode.readLine();
        }
        if (input == null) {
            returnCode = -1;
        } else if (input.equalsIgnoreCase(CONSOLE_QUIT)) {
            returnCode = -2;
        } else if (input.equalsIgnoreCase(CONSOLE_BACK) && Globals.g_wizard != null && !Globals.g_wizard.firstDialog()) {
            returnCode = -3;
        } else if (input.equalsIgnoreCase(CONSOLE_HELP) && Globals.g_wizard != null) {
            returnCode = -4;
        } else if (input.length() > 0) {
            password.setText(input);
        }
        return returnCode;
    }

    public static int promptText(String label, KitTextField textField) {
        if (!textField.isEnabled() || !textField.isEditable()) {
            return ConsoleMode.promptStaticText(label, textField);
        }
        int returnCode = 0;
        ConsoleMode.busyMsgStop();
        ConsoleMode.println();
        if (Globals.g_wizard != null && Globals.g_wizard.getWizardActive()) {
            if (Globals.g_wizard.firstDialog()) {
                ConsoleMode.println(bundle.getString("ConsoleMode.InstructionsFirst.txt"));
            } else {
                ConsoleMode.println(bundle.getString("ConsoleMode.Instructions.txt"));
            }
        } else {
            ConsoleMode.println(bundle.getString("ConsoleMode.InstructionsSimple.txt"));
        }
        ConsoleMode.println(bundle.getString("ConsoleMode.AdditionalInstructions.txt"));
        ConsoleMode.println(bundle.getString("ConsoleMode.TextPrompt1.txt"));
        ConsoleMode.println(bundle.messageString("ConsoleMode.Default.txt", textField.getText()));
        if (label.trim().endsWith(":")) {
            ConsoleMode.print(label.trim() + " ");
        } else {
            ConsoleMode.print(label.trim() + ": ");
        }
        String input = ConsoleMode.readLine();
        if (input == null) {
            returnCode = -1;
        } else if (input.equalsIgnoreCase(CONSOLE_QUIT)) {
            returnCode = -2;
        } else if (input.equalsIgnoreCase(CONSOLE_BACK) && Globals.g_wizard != null && !Globals.g_wizard.firstDialog()) {
            returnCode = -3;
        } else if (input.equalsIgnoreCase(CONSOLE_HELP) && Globals.g_wizard != null) {
            returnCode = -4;
        } else if (input.length() > 0) {
            textField.setText(input);
        }
        return returnCode;
    }

    public static int promptComboBox(JComboBox combo) {
        int selection = combo.getSelectedIndex();
        ConsoleMode.busyMsgStop();
        String[] optionText = new String[combo.getItemCount()];
        for (int i = 0; i < combo.getItemCount(); ++i) {
            optionText[i] = combo.getItemAt(i).toString();
        }
        if ((selection = ConsoleMode.promptSingleChoice(optionText, null, null, selection)) > -1) {
            combo.setSelectedIndex(selection);
        }
        return selection;
    }

    public static int promptEditableComboBox(JComboBox combo) {
        int returnCode = -1;
        String line = null;
        String numOffset = null;
        String[] optionText = new String[combo.getItemCount()];
        ConsoleMode.busyMsgStop();
        ConsoleMode.println();
        int count = 0;
        for (int i = 0; i < combo.getItemCount(); ++i) {
            ++count;
            optionText[i] = (String)combo.getItemAt(i);
            numOffset = "";
            if (optionText.length > 99) {
                if (count < 10) {
                    numOffset = "  ";
                } else if (count < 100) {
                    numOffset = " ";
                }
            } else if (optionText.length > 9 && count < 10) {
                numOffset = " ";
            }
            line = line + Integer.toString(count) + numOffset + " - " + optionText[i];
            ConsoleMode.println(line);
        }
        if (Globals.g_wizard != null && Globals.g_wizard.getWizardActive()) {
            if (Globals.g_wizard.firstDialog()) {
                ConsoleMode.println(bundle.getString("ConsoleMode.InstructionsFirst.txt"));
            } else {
                ConsoleMode.println(bundle.getString("ConsoleMode.Instructions.txt"));
            }
        } else {
            ConsoleMode.println(bundle.getString("ConsoleMode.InstructionsSimple.txt"));
        }
        ConsoleMode.println(bundle.getString("ConsoleMode.AdditionalInstructions.txt"));
        ConsoleMode.println(bundle.getString("ConsoleMode.SingleEditPrompt1.txt"));
        ConsoleMode.println(bundle.messageString("ConsoleMode.Default.txt", ((JTextField)combo.getEditor().getEditorComponent()).getText()));
        ConsoleMode.print(bundle.getString("ConsoleMode.Selection.txt"));
        String input = ConsoleMode.readLine();
        if (input.length() == 0) {
            returnCode = 0;
        } else if (input.equalsIgnoreCase(CONSOLE_QUIT)) {
            returnCode = -2;
        } else if (input.equalsIgnoreCase(CONSOLE_BACK) && Globals.g_wizard != null && !Globals.g_wizard.firstDialog()) {
            returnCode = -3;
        } else if (input.equalsIgnoreCase(CONSOLE_HELP) && Globals.g_wizard != null) {
            returnCode = -4;
        } else {
            try {
                int newSelection = Integer.parseInt(input) - 1;
                ((JTextField)combo.getEditor().getEditorComponent()).setText(optionText[newSelection]);
            }
            catch (Exception e) {
                ((JTextField)combo.getEditor().getEditorComponent()).setText(input);
            }
        }
        return returnCode;
    }

    public static int promptRadioButtons(JRadioButton[] options, JTextArea[] infos) {
        int selection = 0;
        ArrayList<JRadioButton> validOptions = new ArrayList<JRadioButton>();
        ArrayList<String> validInfos = new ArrayList<String>();
        ConsoleMode.busyMsgStop();
        for (int i = 0; i < options.length; ++i) {
            if (options[i] == null || !options[i].isVisible() || !options[i].isEnabled()) continue;
            validOptions.add(options[i]);
            if (infos == null || infos[i] == null) continue;
            if (infos[i].isVisible()) {
                validInfos.add(infos[i].getText());
                continue;
            }
            validInfos.add(null);
        }
        String[] optionText = new String[validOptions.size()];
        for (int i = 0; i < validOptions.size(); ++i) {
            optionText[i] = ((JRadioButton)validOptions.get(i)).getText();
            if (!((JRadioButton)validOptions.get(i)).isSelected()) continue;
            selection = i;
        }
        String[] infoText = null;
        if (validInfos.size() > 0) {
            infoText = validInfos.toArray(new String[0]);
        }
        if ((selection = ConsoleMode.promptSingleChoice(optionText, infoText, null, selection)) > -1) {
            ((JRadioButton)validOptions.get(selection)).setSelected(true);
        }
        return selection;
    }

    public static int promptSingleChoice(String[] options, String[] infoText, String header, int initialSelection) {
        return ConsoleMode.promptSingleChoice(options, infoText, header, initialSelection, false);
    }

    public static int promptSingleChoice(String[] options, String[] infoText, String header, int initialSelection, boolean skipInstructions) {
        int i;
        boolean finished = false;
        boolean showOptions = initialSelection < options.length;
        int returnCode = -1;
        int selection = initialSelection;
        String line = null;
        String infoLine = null;
        String indentation = "";
        String infoIndent = null;
        String numOffset = "";
        ConsoleMode.busyMsgStop();
        ArrayList<String> text = new ArrayList<String>();
        if (header != null) {
            text.add(header);
        }
        for (int i2 = 0; i2 < options.length; ++i2) {
            text.add(options[i2]);
        }
        String[] alignedText = ConsoleMode.alignText(text.toArray(new String[0]));
        String alignedHeader = null;
        String[] alignedOptions = null;
        if (header != null) {
            alignedHeader = alignedText[0];
            alignedOptions = new String[alignedText.length - 1];
            for (i = 1; i < alignedText.length; ++i) {
                alignedOptions[i - 1] = alignedText[i];
            }
        } else {
            alignedOptions = new String[alignedText.length];
            for (i = 0; i < alignedText.length; ++i) {
                alignedOptions[i] = alignedText[i];
            }
        }
        while (returnCode == -1 && !finished) {
            ConsoleMode.println();
            if (alignedHeader != null) {
                if (showOptions) {
                    if (alignedOptions.length > 99) {
                        ConsoleMode.println("          " + alignedHeader);
                    } else if (alignedOptions.length > 9) {
                        ConsoleMode.println("         " + alignedHeader);
                    } else {
                        ConsoleMode.println("        " + alignedHeader);
                    }
                } else if (alignedOptions.length > 99) {
                    ConsoleMode.println("      " + alignedHeader);
                } else if (alignedOptions.length > 9) {
                    ConsoleMode.println("     " + alignedHeader);
                } else {
                    ConsoleMode.println("    " + alignedHeader);
                }
            }
            int count = 0;
            for (int i3 = 0; i3 < alignedOptions.length; ++i3) {
                infoLine = null;
                if (alignedOptions[i3].startsWith(TREE_GROUP_TAG)) {
                    line = alignedOptions[i3].substring(TREE_GROUP_TAG.length());
                    indentation = "   ";
                } else {
                    ++count;
                    line = showOptions ? (i3 == selection ? indentation + "(*) " : indentation + "( ) ") : indentation;
                    numOffset = "";
                    if (alignedOptions.length > 99) {
                        if (count < 10) {
                            numOffset = "  ";
                        } else if (count < 100) {
                            numOffset = " ";
                        }
                    } else if (alignedOptions.length > 9 && count < 10) {
                        numOffset = " ";
                    }
                    line = line + Integer.toString(count) + numOffset + " - " + alignedOptions[i3];
                    if (infoText != null && i3 < infoText.length && infoText[i3] != null) {
                        infoIndent = showOptions ? (alignedOptions.length > 99 ? "          " : (alignedOptions.length > 9 ? "         " : "        ")) : (alignedOptions.length > 99 ? "      " : (alignedOptions.length > 9 ? "     " : "    "));
                        infoLine = Utils.removeHTMLTags(infoText[i3]);
                    }
                }
                ConsoleMode.println(line);
                if (infoLine == null) continue;
                ConsoleMode.printlongln(infoIndent, infoLine);
                ConsoleMode.println();
            }
            if (infoText == null) {
                ConsoleMode.println();
            }
            if (showOptions) {
                ConsoleMode.println(bundle.getString("ConsoleMode.SinglePrompt1.txt"));
                ConsoleMode.println(bundle.getString("ConsoleMode.SinglePrompt2.txt"));
            }
            if (!skipInstructions) {
                if (Globals.g_wizard != null && Globals.g_wizard.getWizardActive()) {
                    if (Globals.g_wizard.firstDialog()) {
                        ConsoleMode.println(bundle.getString("ConsoleMode.InstructionsFirst.txt"));
                    } else {
                        ConsoleMode.println(bundle.getString("ConsoleMode.Instructions.txt"));
                    }
                } else {
                    ConsoleMode.println(bundle.getString("ConsoleMode.InstructionsSimple.txt"));
                }
                ConsoleMode.println(bundle.getString("ConsoleMode.AdditionalInstructions.txt"));
            }
            if (showOptions) {
                ConsoleMode.println(bundle.getString("ConsoleMode.SinglePrompt3.txt"));
            } else {
                ConsoleMode.println(bundle.getString("ConsoleMode.SinglePromptNoOptions.txt"));
            }
            ConsoleMode.print(bundle.getString("ConsoleMode.Selection.txt"));
            String input = ConsoleMode.readLine();
            if (input.length() == 0) {
                finished = true;
                if (showOptions) {
                    returnCode = selection;
                    continue;
                }
                returnCode = options.length;
                continue;
            }
            if (input.equalsIgnoreCase(CONSOLE_QUIT)) {
                returnCode = -2;
                continue;
            }
            if (input.equalsIgnoreCase(CONSOLE_BACK) && Globals.g_wizard != null && !Globals.g_wizard.firstDialog()) {
                returnCode = -3;
                continue;
            }
            if (input.equalsIgnoreCase(CONSOLE_HELP) && Globals.g_wizard != null) {
                returnCode = -4;
                continue;
            }
            int newSelection = -1;
            try {
                newSelection = Integer.parseInt(input);
                count = 0;
                boolean found = false;
                for (int i4 = 0; i4 < alignedOptions.length && !found; ++i4) {
                    if (alignedOptions[i4].startsWith(TREE_GROUP_TAG) || ++count != newSelection) continue;
                    found = true;
                    newSelection = i4;
                }
                if (found) {
                    returnCode = selection = newSelection;
                    finished = true;
                    continue;
                }
                newSelection = -1;
            }
            catch (Exception e) {
                newSelection = -1;
            }
        }
        return returnCode;
    }

    public static int promptMultiChoice(SelectionItem[] options, String header) {
        int i;
        boolean finished = false;
        int returnCode = -1;
        String line = null;
        String numOffset = "";
        ConsoleMode.busyMsgStop();
        ArrayList<String> text = new ArrayList<String>();
        if (header != null) {
            text.add(header);
        }
        for (int i2 = 0; i2 < options.length; ++i2) {
            text.add(options[i2].getText());
        }
        String[] alignedText = ConsoleMode.alignText(text.toArray(new String[0]));
        String alignedHeader = null;
        String[] alignedOptions = null;
        if (header != null) {
            alignedHeader = alignedText[0];
            alignedOptions = new String[alignedText.length - 1];
            for (i = 1; i < alignedText.length; ++i) {
                alignedOptions[i - 1] = alignedText[i];
            }
        } else {
            alignedOptions = new String[alignedText.length];
            for (i = 0; i < alignedText.length; ++i) {
                alignedOptions[i] = alignedText[i];
            }
        }
        while (returnCode == -1 && !finished) {
            int i3;
            ConsoleMode.println();
            if (alignedHeader != null) {
                if (options.length > 99) {
                    ConsoleMode.println("          " + alignedHeader);
                } else if (options.length > 9) {
                    ConsoleMode.println("         " + alignedHeader);
                } else {
                    ConsoleMode.println("        " + alignedHeader);
                }
            }
            int count = 0;
            for (int i4 = 0; i4 < options.length; ++i4) {
                ++count;
                line = options[i4].getSelected() ? "(*) " : "( ) ";
                numOffset = "";
                if (options.length > 99) {
                    if (count < 10) {
                        numOffset = "  ";
                    } else if (count < 100) {
                        numOffset = " ";
                    }
                } else if (options.length > 9 && count < 10) {
                    numOffset = " ";
                }
                line = line + Integer.toString(i4 + 1) + numOffset + " - " + alignedOptions[i4];
                if (options[i4].getRequired()) {
                    line = line + " " + bundle.getString("ConsoleMode.RequiredTag.txt");
                }
                ConsoleMode.println(line);
            }
            ConsoleMode.println();
            ConsoleMode.println(bundle.getString("ConsoleMode.MultiPrompt1.txt"));
            ConsoleMode.println(bundle.getString("ConsoleMode.MultiPrompt2.txt"));
            if (Globals.g_wizard != null && Globals.g_wizard.getWizardActive()) {
                if (Globals.g_wizard.firstDialog()) {
                    ConsoleMode.println(bundle.getString("ConsoleMode.InstructionsFirst.txt"));
                } else {
                    ConsoleMode.println(bundle.getString("ConsoleMode.Instructions.txt"));
                }
            } else {
                ConsoleMode.println(bundle.getString("ConsoleMode.InstructionsSimple.txt"));
            }
            ConsoleMode.println(bundle.getString("ConsoleMode.MultiPrompt3.txt"));
            ConsoleMode.println(bundle.getString("ConsoleMode.AdditionalInstructions.txt"));
            ConsoleMode.print(bundle.getString("ConsoleMode.MultiPrompt4.txt"));
            String input = ConsoleMode.readLine();
            if (input.length() == 0) {
                finished = true;
                returnCode = 0;
                continue;
            }
            if (input.equalsIgnoreCase(CONSOLE_QUIT)) {
                returnCode = -2;
                continue;
            }
            if (input.equalsIgnoreCase(CONSOLE_BACK) && Globals.g_wizard != null && !Globals.g_wizard.firstDialog()) {
                returnCode = -3;
                continue;
            }
            if (input.equalsIgnoreCase(CONSOLE_HELP) && Globals.g_wizard != null) {
                returnCode = -4;
                continue;
            }
            if (input.equalsIgnoreCase(SELECT_ALL)) {
                for (i3 = 0; i3 < options.length; ++i3) {
                    if (options[i3].getRequired()) continue;
                    options[i3].setSelected(true);
                }
                continue;
            }
            if (input.equalsIgnoreCase(CLEAR_ALL)) {
                for (i3 = 0; i3 < options.length; ++i3) {
                    if (options[i3].getRequired()) continue;
                    options[i3].setSelected(false);
                }
                continue;
            }
            int selection = -1;
            String[] selections = input.split(" ");
            for (int i5 = 0; i5 < selections.length; ++i5) {
                try {
                    selection = Integer.parseInt(selections[i5].trim()) - 1;
                }
                catch (Exception e) {
                    selection = -1;
                }
                if (selection <= -1 || selection >= options.length || options[selection].getRequired()) continue;
                options[selection].setSelected(!options[selection].getSelected());
            }
        }
        return returnCode;
    }

    public static void errorMsg(String msg) {
        ConsoleMode.busyMsgStop();
        ConsoleMode.println();
        ConsoleMode.println(bundle.messageString("ConsoleMode.ErrorMsg.txt", msg));
    }

    public static void warningMsg(String msg) {
        ConsoleMode.busyMsgStop();
        ConsoleMode.println();
        ConsoleMode.println(bundle.messageString("ConsoleMode.WarningMsg.txt", msg));
    }

    public static void genericMsg(String msg) {
        ConsoleMode.busyMsgStop();
        ConsoleMode.println();
        ConsoleMode.println(msg);
    }

    public static boolean confirmPrompt(String msg) {
        return ConsoleMode.confirmPrompt(msg, "");
    }

    public static boolean confirmPrompt(String msg, String mydefault) {
        boolean confirm = false;
        boolean valid = false;
        ConsoleMode.busyMsgStop();
        if (mydefault == null) {
            mydefault = "";
        }
        while (!valid) {
            ConsoleMode.println();
            ConsoleMode.println(msg);
            if (!"".equals(mydefault)) {
                ConsoleMode.println(bundle.messageString("ConsoleMode.Default.txt", mydefault));
            }
            ConsoleMode.print(bundle.getString("ConsoleMode.ConfirmPrompt1.txt"));
            String input = ConsoleMode.readLine();
            if (input == null) continue;
            if ("".equals(input = input.trim())) {
                input = mydefault;
            }
            if (input.equalsIgnoreCase("y") || input.equalsIgnoreCase("yes")) {
                valid = true;
                confirm = true;
                continue;
            }
            if (!input.equalsIgnoreCase("n") && !input.equalsIgnoreCase("no")) continue;
            valid = true;
        }
        return confirm;
    }

    public static void busyMsgStart(String msg) {
        ConsoleMode.println();
        ConsoleMode.print(msg);
        m_charCount = msg.length();
        m_timerAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConsoleMode.print(".");
                m_charCount++;
                if (m_charCount == Globals.g_consolePageWidth) {
                    ConsoleMode.println();
                    m_charCount = 0;
                }
            }
        };
        m_timer = new Timer(1000, m_timerAction);
        m_timer.start();
    }

    public static void busyMsgStop() {
        m_charCount = 0;
        if (m_timer != null && m_timer.isRunning()) {
            m_timer.stop();
            ConsoleMode.println();
        }
    }

    public static void busyMsgAddMsg(String msg) {
        if (m_charCount + msg.length() > Globals.g_consolePageWidth) {
            ConsoleMode.println();
            m_charCount = 0;
        }
        ConsoleMode.print(msg);
        if ((m_charCount += msg.length()) == Globals.g_consolePageWidth) {
            ConsoleMode.println();
            m_charCount = 0;
        }
    }

    public static void printDivider() {
        String line = "";
        for (int i = 0; i < Globals.g_consolePageWidth; ++i) {
            line = line + "-";
        }
        ConsoleMode.println(line);
    }

    public static String[] alignText(String[] lines) {
        String[] newLines = new String[lines.length];
        if (lines.length > 0) {
            int[] maxSize = new int[lines[0].split(COLUMN_DIVIDER).length];
            if (maxSize.length == 1) {
                newLines = lines;
            } else {
                int length = 0;
                String[] columns = null;
                for (int i = 0; i < lines.length; ++i) {
                    columns = lines[i].split(COLUMN_DIVIDER);
                    for (int j = 0; j < columns.length; ++j) {
                        if (j >= maxSize.length || (length = columns[j].length()) <= maxSize[j]) continue;
                        maxSize[j] = length;
                    }
                }
                int padding = 0;
                String newLine = null;
                for (int i = 0; i < lines.length; ++i) {
                    newLine = "";
                    columns = lines[i].split(COLUMN_DIVIDER);
                    for (int j = 0; j < columns.length; ++j) {
                        if (newLine.length() > 0) {
                            newLine = newLine + "  ";
                        }
                        newLine = newLine + columns[j];
                        if (j >= maxSize.length) continue;
                        length = columns[j].length();
                        padding = maxSize[j] - length;
                        for (int k = 0; k < padding; ++k) {
                            newLine = newLine + " ";
                        }
                    }
                    newLines[i] = newLine;
                }
            }
        }
        return newLines;
    }

    public static void printTable(String[] text) {
        ConsoleMode.println();
        String[] alignedText = ConsoleMode.alignText(text);
        for (int i = 0; i < alignedText.length; ++i) {
            ConsoleMode.println(alignedText[i]);
        }
    }

    public static void printInfoText(String text) {
        ConsoleMode.println();
        ConsoleMode.printlongln(null, Utils.removeHTMLTags(text));
    }

    public static void print(String text) {
        System.out.print(text);
        ConsoleMode.printLog(text);
    }

    public static void println() {
        System.out.println();
        ConsoleMode.incrementLineCount();
        ConsoleMode.printlnLog();
    }

    public static void println(String text) {
        System.out.println(text);
        ConsoleMode.incrementLineCount();
        ConsoleMode.printlnLog(text);
    }

    public static void printlongln(String indentation, String text) {
        String line = "";
        String[] words = text.split(" ");
        for (int i = 0; i < words.length; ++i) {
            if (line.length() + words[i].length() + 1 > Globals.g_consolePageWidth) {
                ConsoleMode.println(line);
                if (indentation != null) {
                    line = indentation + words[i];
                    continue;
                }
                line = words[i];
                continue;
            }
            line = line.length() == 0 || indentation != null && indentation.length() == line.length() ? (indentation != null ? indentation + words[i] : words[i]) : line + " " + words[i];
            if (!line.contains("\n")) continue;
            ConsoleMode.print(line + " ");
            line = "";
        }
        if (line.length() > 0) {
            ConsoleMode.println(line);
        }
    }

    public static String readLine() {
        String line = null;
        if (ConsoleModeEventDriven.active()) {
            line = ConsoleModeEventDriven.readLine();
        } else {
            try {
                line = Globals.g_consoleStdIn.readLine();
            }
            catch (Exception e) {
                line = "";
            }
        }
        m_lineCount = 0;
        ConsoleMode.printlnLog(line);
        return line;
    }

    public static String stripEllipses(String inText) {
        String outText = inText;
        if (outText != null && outText.endsWith("...")) {
            outText = outText.substring(0, outText.length() - 3);
        }
        return outText;
    }

    private static void incrementLineCount() {
        if (Globals.g_consolePageSize > 0 && ++m_lineCount == Globals.g_consolePageSize) {
            ConsoleMode.print(bundle.getString("ConsoleMode.PagePrompt.txt"));
            ConsoleMode.readLine();
        }
    }

    private static void initLogFile() {
        String timeStamp = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss").format(new Date());
        String logFile = Utils.joinPath(Utils.getSDWDataPath(true), "console_" + timeStamp + ".log");
        try {
            m_consoleLog = new PrintWriter(new BufferedWriter(new FileWriter(logFile)));
        }
        catch (Exception e) {
            m_consoleLog = null;
            Logging.log.info("Error creating console log file: " + logFile);
            Logging.logStackTrace(e);
        }
    }

    public static void printLog(String text) {
        if (m_consoleLog == null) {
            ConsoleMode.initLogFile();
        }
        if (m_consoleLog != null) {
            m_consoleLog.print(text);
            m_consoleLog.flush();
        }
    }

    public static void printlnLog() {
        if (m_consoleLog == null) {
            ConsoleMode.initLogFile();
        }
        if (m_consoleLog != null) {
            m_consoleLog.println();
            m_consoleLog.flush();
        }
    }

    public static void printlnLog(String text) {
        if (m_consoleLog == null) {
            ConsoleMode.initLogFile();
        }
        if (m_consoleLog != null) {
            m_consoleLog.println(text);
            m_consoleLog.flush();
        }
    }

    public static class SelectionItem {
        private String m_text = null;
        private boolean m_selected = false;
        private boolean m_required = false;

        public SelectionItem(String text, boolean selected) {
            this.m_text = text;
            this.m_selected = selected;
        }

        public SelectionItem(String text, boolean selected, boolean required) {
            this.m_text = text;
            this.m_selected = selected;
            this.m_required = required;
        }

        public String getText() {
            return this.m_text;
        }

        public void setText(String text) {
            this.m_text = text;
        }

        public boolean getSelected() {
            return this.m_selected;
        }

        public void setSelected(boolean selected) {
            this.m_selected = selected;
        }

        public boolean getRequired() {
            return this.m_required;
        }

        public void setRequired(boolean required) {
            this.m_required = required;
        }
    }
}

