/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TreeMap;

public class ConfigureDefaults {
    private Properties m_configDefaults = new Properties();

    public ConfigureDefaults() {
        Globals.g_configPropsSource = new TreeMap<String, String>();
    }

    public boolean load(String properties) {
        boolean valid = false;
        try {
            File propsFile = new File(properties);
            if (propsFile.isFile()) {
                FileInputStream fis = new FileInputStream(propsFile);
                this.m_configDefaults.load(fis);
                fis.close();
                valid = true;
                Logging.log.fine("Properties loaded from: " + properties);
                Properties props = new Properties();
                fis = new FileInputStream(propsFile);
                props.load(fis);
                fis.close();
                Enumeration<Object> e = props.keys();
                while (e.hasMoreElements()) {
                    Globals.g_configPropsSource.put((String)e.nextElement(), properties);
                }
            } else {
                Logging.log.fine("Properties file does not exist: " + properties);
            }
        }
        catch (Exception e) {
            Logging.log.info("Error loading properties file: " + properties);
            Logging.logStackTrace(e);
        }
        return valid;
    }

    public boolean save(String filePath) {
        boolean valid = false;
        try {
            File defaultsFile = new File(filePath);
            FileOutputStream fos = new FileOutputStream(defaultsFile);
            this.m_configDefaults.store(fos, null);
            fos.close();
            valid = true;
        }
        catch (Exception e) {
            Logging.log.info("Error saving configuration all default properties file: " + filePath);
            Logging.logStackTrace(e);
        }
        return valid;
    }

    public Enumeration getNames() {
        return this.m_configDefaults.propertyNames();
    }

    public void setDefault(String key, String value) {
        this.m_configDefaults.setProperty(key, value);
    }

    public String getDefault(String key, String defaultValue) {
        return this.m_configDefaults.getProperty(key, defaultValue);
    }
}

