/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.UnicodeInputStream;
import com.sas.ssn.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigStatus {
    private final String ATTRIBUTE_FQID = "fqid";
    private final String ATTRIBUTE_CODE = "code";
    private final String ATTRIBUTE_ORDER = "order";
    private final String ATTRIBUTE_HOTFIX = "hotfix";
    private final String ATTRIBUTE_HOTFIXDATE = "hotfixdate";
    private final String ROOT_NAME = "ConfigStatus";
    private final String ELEMENT_NAME = "ConfiguredObject";
    private File m_file = null;
    private Document m_doc = null;
    private Element m_root = null;
    private Hashtable<String, StatusEntry> m_statusHash = new Hashtable();
    private static final String BACKUP_TIMESTAMP_FORMAT = "yyyy-MM-dd-HH.mm";
    private static final SimpleDateFormat BACKUP_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH.mm");

    public static ConfigStatus loadDefaultConfigStatus() throws IOException, ParserConfigurationException, SAXException {
        File statusFile = new File(Utils.joinPath(Globals.g_cmtConfigDir, "ConfigData", "status.xml"));
        return new ConfigStatus(statusFile);
    }

    public ConfigStatus(String file) throws IOException, ParserConfigurationException, SAXException {
        this(new File(file));
    }

    public ConfigStatus(File file) throws IOException, ParserConfigurationException, SAXException {
        this.m_file = file;
        if (file.exists()) {
            this.m_doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(file));
            this.m_root = this.m_doc.getDocumentElement();
            if (this.m_root != null && "ConfigStatus".equals(this.m_root.getTagName())) {
                Element nodeElement = null;
                NodeList nodes = this.m_root.getElementsByTagName("ConfiguredObject");
                for (int i = 0; i < nodes.getLength(); ++i) {
                    nodeElement = (Element)nodes.item(i);
                    this.addStatusEntry(new StatusEntry(nodeElement));
                }
            }
        } else {
            this.m_doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            this.m_root = this.m_doc.createElement("ConfigStatus");
            this.m_doc.appendChild(this.m_root);
        }
    }

    protected boolean addStatusEntry(StatusEntry statusEntry) {
        boolean ret = false;
        String fqid = statusEntry.getFQID();
        if (!this.m_statusHash.contains(fqid)) {
            this.m_statusHash.put(fqid, statusEntry);
            ret = true;
        }
        return ret;
    }

    public boolean setStatus(String fqid, String prodCode, String order) {
        return this.setStatus(fqid, prodCode, order, "", "");
    }

    public boolean setStatus(String fqid, String prodCode, String order, String hotfix, String hotfixdate) {
        boolean success = false;
        StatusEntry entry = this.m_statusHash.get(fqid);
        if (entry == null) {
            success = this.addStatusEntry(new StatusEntry(fqid, prodCode, order, hotfix, hotfixdate));
        } else {
            entry.setCode(prodCode);
            entry.setHotFix(hotfix);
            entry.setHotFixDate(hotfixdate);
            entry.setOrder(order);
            success = true;
        }
        return success;
    }

    public boolean updateOrder(String fqid, String order) {
        boolean success = false;
        StatusEntry entry = this.m_statusHash.get(fqid);
        if (entry != null) {
            entry.setOrder(order);
            entry.setHotFix("");
            entry.setHotFixDate("");
            success = true;
        }
        return success;
    }

    public boolean updateFQID(String fqid, String newFQID) {
        boolean success = false;
        StatusEntry entry = this.m_statusHash.get(fqid);
        if (entry != null) {
            entry.setFQID(newFQID);
            success = true;
        }
        return success;
    }

    public File getFile() {
        return this.m_file;
    }

    public StatusEntry getStatusEntry(String fqid) {
        return this.m_statusHash.get(fqid);
    }

    public boolean removeStatusEntry(String fqid) {
        boolean success = false;
        StatusEntry statusEntry = this.m_statusHash.get(fqid);
        if (statusEntry != null) {
            statusEntry.delete();
            success = true;
        }
        return success;
    }

    public StatusEntry[] getStatusEntries() {
        ArrayList<StatusEntry> entries = new ArrayList<StatusEntry>();
        if (this.m_statusHash != null) {
            String fqid = null;
            StatusEntry entry = null;
            Enumeration<String> e = this.m_statusHash.keys();
            while (e.hasMoreElements()) {
                fqid = e.nextElement();
                entry = this.m_statusHash.get(fqid);
                if (entry == null) continue;
                entries.add(entry);
            }
        }
        return entries.toArray(new StatusEntry[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backup() throws IOException {
        if (!this.m_file.exists()) {
            return;
        }
        String timeStamp = BACKUP_DATE_FORMAT.format(new Date());
        String fileName = this.m_file.getName() + "_" + timeStamp + ".bak";
        File backupFile = new File(Utils.joinPath(this.m_file.getParent(), fileName));
        try {
            AbstractInterruptibleChannel ic = null;
            AbstractInterruptibleChannel oc = null;
            FileInputStream inputStream = null;
            FileOutputStream outputStream = null;
            try {
                inputStream = new FileInputStream(this.m_file);
                ic = inputStream.getChannel();
                outputStream = new FileOutputStream(backupFile);
                oc = outputStream.getChannel();
                ((FileChannel)oc).transferFrom((ReadableByteChannel)((Object)ic), 0L, ((FileChannel)ic).size());
            }
            finally {
                if (ic != null) {
                    ic.close();
                }
                if (oc != null) {
                    oc.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        catch (IOException e) {
            Logging.log.info(e.getMessage());
            Logging.logStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write() {
        boolean retVal = false;
        if ((this.m_file.getParentFile().isDirectory() || this.m_file.getParentFile().mkdirs()) && !this.m_file.isFile()) {
            try {
                this.m_file.createNewFile();
            }
            catch (IOException e) {
                Logging.log.info(e.getMessage());
                Logging.logStackTrace(e);
            }
        }
        if (this.m_file.isFile()) {
            FileOutputStream stream = null;
            try {
                stream = new FileOutputStream(this.m_file);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                this.m_doc.normalizeDocument();
                transformer.transform(new DOMSource(this.m_doc), new StreamResult(stream));
                retVal = true;
            }
            catch (Exception e) {
                Logging.log.info(e.getMessage());
                Logging.logStackTrace(e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        retVal = false;
                        Logging.logStackTrace(e);
                    }
                }
            }
        }
        Utils.removeBlankLines(this.m_file);
        return retVal;
    }

    public boolean checkStatusFileForProductCode(String prodcode) {
        String code = null;
        try {
            ConfigStatus status = new ConfigStatus(this.m_file);
            StatusEntry[] statusEntries = status.getStatusEntries();
            for (int i = 0; i < statusEntries.length; ++i) {
                code = statusEntries[i].getCode();
                if (!code.equalsIgnoreCase(prodcode)) continue;
                return true;
            }
        }
        catch (Exception e) {
            Logging.log.info("Unable to check status.xml for code " + code);
            Logging.log.info(e.getMessage());
        }
        return false;
    }

    public class StatusEntry {
        Element statusElement = null;

        public StatusEntry(String fqid, String code, String order, String hotfix, String hotfixdate) {
            this.statusElement = ConfigStatus.this.m_doc.createElement("ConfiguredObject");
            this.statusElement.setAttribute("fqid", fqid);
            this.statusElement.setAttribute("code", code.toLowerCase(Locale.ENGLISH));
            this.statusElement.setAttribute("order", order);
            ConfigStatus.this.m_root.appendChild(this.statusElement);
            if (hotfix != null && hotfix.trim().length() > 0) {
                this.statusElement.setAttribute("hotfix", hotfix);
            }
            if (hotfixdate != null && hotfixdate.trim().length() > 0) {
                this.statusElement.setAttribute("hotfixdate", hotfixdate);
            }
        }

        public StatusEntry(Element statusElement) {
            this.statusElement = statusElement;
        }

        protected Element getStatusElement() {
            return this.statusElement;
        }

        public String getCode() {
            return this.statusElement.getAttribute("code");
        }

        public void setCode(String prodCode) {
            this.statusElement.setAttribute("code", prodCode.toLowerCase(Locale.ENGLISH));
        }

        public String getFQID() {
            return this.statusElement.getAttribute("fqid");
        }

        public void setFQID(String fqid) {
            String oldfqid = this.statusElement.getAttribute("fqid");
            if (!oldfqid.equalsIgnoreCase(fqid)) {
                ConfigStatus.this.m_statusHash.remove(oldfqid);
                this.statusElement.setAttribute("fqid", fqid);
                ConfigStatus.this.m_statusHash.put(fqid, this);
            }
        }

        public String getOrder() {
            return this.statusElement.getAttribute("order");
        }

        public void setOrder(String order) {
            this.statusElement.setAttribute("order", order);
        }

        public String getHotFix() {
            return this.statusElement.getAttribute("hotfix");
        }

        public void setHotFix(String hotfix) {
            if (hotfix != null && hotfix.trim().length() > 0) {
                this.statusElement.setAttribute("hotfix", hotfix);
            }
        }

        public String getHotFixDate() {
            return this.statusElement.getAttribute("hotfixdate");
        }

        public void setHotFixDate(String hotfixdate) {
            if (hotfixdate != null && hotfixdate.trim().length() > 0) {
                this.statusElement.setAttribute("hotfixdate", hotfixdate);
            }
        }

        public void delete() {
            ConfigStatus.this.m_statusHash.remove(this.getFQID());
            Node prev = this.statusElement.getPreviousSibling();
            if (prev != null && prev.getNodeType() == 3 && prev.getNodeValue().trim().length() == 0) {
                ConfigStatus.this.m_root.removeChild(prev);
            }
            ConfigStatus.this.m_root.removeChild(this.statusElement);
        }
    }
}

