/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.ResponseData;
import com.sas.ssn.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public class ChainingData {
    public static final int INSTALLSTATUS_NOT_STARTED = 0;
    public static final int INSTALLSTATUS_SUCCESS = 1;
    public static final int INSTALLSTATUS_FAILURE = 2;
    public static final int INSTALLSTATUS_RUNNING = 3;
    public static final int INSTALLSTATUS_WARNING = 4;
    public static final int INSTALLSTATUS_INSTALLED = 5;
    public static final int BATCHSTATUS_SUCCESS = 6;
    public static final int BATCHSTATUS_FAILURE = 7;
    public static final int RESUMESTATUS_FAILURE = 8;
    public static final int POSTINSTALL_WARNING = 9;
    public static final int INSTALLSTATUS_AUTOUPDATE_DETECTED = 10;
    private final String STAGE_COUNT = "stage_count";
    private final String STAGE = "stage";
    private final String _STEP_COUNT = "_step_count";
    private final String _STEP_PRODCODE = "_step_prodcode";
    private final String _STEP_INSTALLSTATUS = "_step_installstatus";
    private Properties m_chainProps = new Properties();
    private File m_propsFile = null;
    private String m_chainRFile = null;
    private ResponseData m_chainRData = null;
    private String m_serializedFile = null;
    private String m_cmacroFile = null;
    private String m_fontsFile = null;

    public ChainingData() {
        String propsFile = Utils.joinPath(Utils.getSDWDataPath(true), "sdwchain.txt");
        this.m_propsFile = new File(propsFile);
        this.m_chainRFile = Utils.joinPath(Utils.getSDWDataPath(true), "sdwchainrfile.properties");
        this.m_chainRData = ResponseData.getInstance();
        this.m_serializedFile = Utils.joinPath(Utils.getSDWDataPath(true), "postProcessingTasks.ser");
        this.m_cmacroFile = Utils.joinPath(Utils.getSDWDataPath(true), "concatenateCmacro.ser");
        this.m_fontsFile = Utils.joinPath(Utils.getSDWDataPath(true), "registerFonts.ser");
    }

    public boolean load(boolean loadDefault) {
        boolean valid = false;
        try {
            if (this.m_propsFile.isFile()) {
                FileInputStream fis = new FileInputStream(this.m_propsFile);
                this.m_chainProps.load(fis);
                fis.close();
                if (new File(this.m_chainRFile).isFile() && (Globals.g_incompleteConfiguration || this.serializedFileCheck())) {
                    valid = true;
                    if (loadDefault) {
                        this.m_chainRData.loadDefaultSelection();
                    }
                }
            }
        }
        catch (Exception e) {
            Logging.log.warning("Error loading chain data: " + this.m_propsFile.toString());
        }
        return valid;
    }

    public String getChainRFile() {
        return this.m_chainRFile;
    }

    public boolean save() {
        boolean valid = false;
        try {
            FileOutputStream fos = new FileOutputStream(this.m_propsFile);
            this.m_chainProps.store(fos, null);
            fos.close();
            valid = true;
        }
        catch (Exception e) {
            Logging.log.info("Error saving chain data: " + this.m_propsFile.toString());
        }
        return valid;
    }

    public boolean delete() {
        boolean valid = false;
        if (Globals.g_deleteChainData) {
            try {
                File configRetryPropFile;
                this.deleteChainRFile();
                File installRetryPropFile = new File(Utils.getSDWDataPath(false), "installRetry.properties");
                if (installRetryPropFile.exists()) {
                    installRetryPropFile.delete();
                }
                if ((configRetryPropFile = new File(Utils.getSDWDataPath(false), "configRetry.properties")).exists()) {
                    configRetryPropFile.delete();
                }
            }
            catch (Exception e) {
                Logging.log.warning("Error deleting chain response data: " + this.m_chainRFile);
            }
            try {
                if (this.m_propsFile.isFile()) {
                    valid = this.m_propsFile.delete();
                }
            }
            catch (Exception e) {
                Logging.log.warning("Error deleting chain data: " + this.m_propsFile.toString());
            }
            try {
                File serializedFile = new File(this.m_serializedFile);
                serializedFile.delete();
            }
            catch (Exception e) {
                Logging.log.warning("Error deleting serialized file: " + this.m_serializedFile);
            }
            try {
                File cmacroFile = new File(this.m_cmacroFile);
                cmacroFile.delete();
            }
            catch (Exception e) {
                Logging.log.warning("Error deleting serialized file: " + this.m_cmacroFile);
            }
            try {
                File fontsFile = new File(this.m_fontsFile);
                fontsFile.delete();
            }
            catch (Exception e) {
                Logging.log.warning("Error deleting serialized file: " + this.m_fontsFile);
            }
        } else {
            valid = true;
        }
        return valid;
    }

    public boolean deleteChainRFile() {
        File responseFile = new File(this.m_chainRFile);
        return responseFile.delete();
    }

    public void clear() {
        this.m_chainProps.clear();
    }

    public String getResponseFile() {
        return this.m_chainRFile;
    }

    public void setResponseFile(String filename) {
        this.m_chainRFile = filename;
        this.m_chainRData = ResponseData.getInstance();
    }

    public String getResponse(String key, String defaultValue) {
        String response = null;
        response = this.m_chainRData != null ? this.m_chainRData.getProperty(key, defaultValue) : defaultValue;
        return response;
    }

    public int getStageCount() {
        int count = Integer.parseInt(this.m_chainProps.getProperty("stage_count", "0"));
        return count;
    }

    public void setStageCount(int count) {
        this.m_chainProps.setProperty("stage_count", Integer.toString(count));
    }

    public int getStageStepCount(int stage) {
        int count = Integer.parseInt(this.m_chainProps.getProperty("stage" + Integer.toString(stage) + "_step_count", "0"));
        return count;
    }

    public void setStageStepCount(int stage, int count) {
        this.m_chainProps.setProperty("stage" + Integer.toString(stage) + "_step_count", Integer.toString(count));
    }

    public String getProductSpsSku(int stage, int offset) {
        String code = this.m_chainProps.getProperty("stage" + Integer.toString(stage) + "_step_prodcode" + Integer.toString(offset), "");
        return code;
    }

    public void setProductSpsSku(int stage, int offset, String sku) {
        this.m_chainProps.setProperty("stage" + Integer.toString(stage) + "_step_prodcode" + Integer.toString(offset), sku);
    }

    public int getInstallStatus(int stage, int offset) {
        int status = Integer.parseInt(this.m_chainProps.getProperty("stage" + Integer.toString(stage) + "_step_installstatus" + Integer.toString(offset), Integer.toString(0)));
        return status;
    }

    public void setInstallStatus(int stage, int offset, int status) {
        this.m_chainProps.setProperty("stage" + Integer.toString(stage) + "_step_installstatus" + Integer.toString(offset), Integer.toString(status));
    }

    private boolean serializedFileCheck() {
        if (Globals.g_wizardData.getPreference("Configure", false) && !Globals.g_wizardData.getPreference("Install", false)) {
            return true;
        }
        return new File(this.m_serializedFile).isFile();
    }
}

