/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConfigStatus;
import com.sas.ssn.Configure;
import com.sas.ssn.ConsoleMode;
import com.sas.ssn.DepotManager;
import com.sas.ssn.DialogData;
import com.sas.ssn.DynamicDialogs;
import com.sas.ssn.FileMode;
import com.sas.ssn.Globals;
import com.sas.ssn.HotFix;
import com.sas.ssn.HotFixInstructions;
import com.sas.ssn.HotFixPackageData;
import com.sas.ssn.HotFixPackages;
import com.sas.ssn.InstallToolConnector;
import com.sas.ssn.InstanceData;
import com.sas.ssn.JREData;
import com.sas.ssn.KitAction;
import com.sas.ssn.Language;
import com.sas.ssn.Logging;
import com.sas.ssn.MetadataAccess;
import com.sas.ssn.MsiInstallData;
import com.sas.ssn.PanelExecute;
import com.sas.ssn.ProductData;
import com.sas.ssn.PropertyRules;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SASHomeStatus;
import com.sas.ssn.SASSharedComponents;
import com.sas.ssn.SSNResource;
import com.sas.ssn.ThirdParty;
import com.sas.ssn.Unzip;
import com.sas.ssn.Utils;
import com.sas.ssn.VJR_Pruner;
import com.sas.ssn.WizardPromptedIface;
import com.sas.ssn.install.GroovyInstallTask;
import com.sas.ssn.utils.DocPartUtils;
import com.sas.ssn.utils.GroovyLauncher;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import com.sas.tools.installs.it.NotificationHandler;
import com.sas.tools.installs.it.PerfLog;
import com.sas.util.SasPasswordString;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;

public class Chaining
extends Thread {
    public static final int INSTALL_STATUS_CUSTOM_MSG = -990;
    public static final int INSTALL_STATUS_INITIAL = -1000;
    private static String deploymentRegistryViewLink = null;
    final String UNINSTALL_REGKEY = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall";
    final String UNINSTALL_GUID = Globals.UNINSTALL_GUID;
    final String UNINSTALL_NAME = "SAS " + Globals.g_majorReleaseVersion;
    public final int PROMPT_STOP = 0;
    public final int PROMPT_RETRY = 1;
    public final int PROMPT_CONTINUE = 2;
    private final String TIMESTAMP_FORMAT = "yyyy-MM-dd-HH.mm.ss";
    private final String DISPLAY_TIMESTAMP_FORMAT = "yyyy MMM dd HH:mm:ss";
    private static final String BACKUP_TIMESTAMP_FORMAT = "yyyy-MM-dd-HH.mm";
    private final SimpleDateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss");
    private final SimpleDateFormat DISPLAY_DATE_FORMAT = new SimpleDateFormat("yyyy MMM dd HH:mm:ss");
    private static final SimpleDateFormat BACKUP_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH.mm");
    private static String startTimestamp = null;
    private SSNResource bundle = new SSNResource(Chaining.class);
    private boolean m_uninstallDataAdded = false;
    private String m_antLog = "";
    private boolean m_abort = false;
    private boolean m_finished = false;
    private boolean m_lastStep = false;
    private boolean m_oneInstalled = false;
    private boolean m_oneFailed = false;
    private boolean m_configError = false;
    private boolean m_configDataSaved = false;
    private boolean m_installDataSaved = false;
    private ArrayList m_stageData = null;
    private ArrayList m_stageTargets = null;
    private ArrayList m_stageNames = null;
    private PanelExecute m_panelExecute = null;
    private ProductData m_currentProdData = null;
    private RegistryAccess m_registryAccess = null;
    private String m_currentTarget = null;
    private File m_summaryFile = null;
    private PrintStream m_deploySummary = null;
    private int m_currentStage = 0;
    private int m_stageCount = 0;
    private int m_currentStep = 0;
    private int m_stepCount = 0;
    private boolean m_hasSavedConfigBundle = false;
    private boolean startedMetadataServerOnce = false;

    public static String getStartTimestamp() {
        if (startTimestamp == null) {
            startTimestamp = BACKUP_DATE_FORMAT.format(new Date());
        }
        return startTimestamp;
    }

    public Chaining(ArrayList stageData, ArrayList stageTargets, ArrayList stageNames, PanelExecute panelExecute) {
        this.setPriority(1);
        this.m_stageData = stageData;
        this.m_stageTargets = stageTargets;
        this.m_stageNames = stageNames;
        this.m_panelExecute = panelExecute;
        if (!Globals.g_srwOnly) {
            try {
                if (Globals.g_cmtSASHome != null) {
                    File deployRegJar = new File(Utils.joinPath(Globals.g_cmtSASHome, "deploymntreg"), "sas.tools.deploymntreg.jar");
                    this.m_registryAccess = new RegistryAccess(deployRegJar.getAbsolutePath());
                } else {
                    this.m_registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                }
            }
            catch (Exception e) {
                this.m_registryAccess = null;
                Logging.logStackTrace(e);
            }
        }
        this.createDeploymentSummary();
    }

    private void createDeploymentSummary() {
        String timeStamp = this.DEFAULT_DATE_FORMAT.format(new Date());
        this.m_summaryFile = new File(Utils.getSDWDataPath(true), "DeploymentSummary_" + timeStamp + ".html");
        try {
            this.m_deploySummary = new PrintStream((OutputStream)new FileOutputStream(this.m_summaryFile), false, "UTF-8");
        }
        catch (Exception e) {
            this.m_deploySummary = null;
            Logging.logStackTrace(e);
        }
        Logging.log.info("DeploymentSummary file: " + this.m_summaryFile);
        if (this.m_deploySummary != null) {
            try {
                HotFixInstructions hfInstructions;
                this.m_deploySummary.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">");
                this.m_deploySummary.println("<HTML>");
                this.m_deploySummary.println("<head>");
                this.m_deploySummary.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
                this.m_deploySummary.println("</head>");
                this.m_deploySummary.println("<BODY>");
                String displayTimeStamp = new SimpleDateFormat("yyyy MMM dd HH:mm:ss").format(new Date());
                if (Globals.g_resumeChain) {
                    this.m_deploySummary.println("<H1>" + this.bundle.messageString("Chaining.ResumeSummaryTitle.txt", displayTimeStamp) + "</H1>");
                } else {
                    this.m_deploySummary.println("<H1>" + this.bundle.messageString("Chaining.SummaryTitle.txt", displayTimeStamp) + "</H1>");
                }
                if (Globals.g_mode != 2 && Globals.g_install && (hfInstructions = new HotFixInstructions()).writeInstructionsFile()) {
                    String hfHeader = this.bundle.messageString("PanelFinish.HotFixHeader.txt");
                    String hfPath = hfInstructions.getHotFixInstructionsPath();
                    String hfUrl = Utils.pathToURL(hfPath);
                    String link = "<a href=\"" + hfUrl + "\">SAS Hot Fix Post-Installation Instructions</a>";
                    String hfMsg = Utils.getOS() != 8 ? this.bundle.messageString("PanelFinish.HotFixMessage.txt", link) : this.bundle.messageString("PanelFinish.HotFixMessage.txt", hfPath);
                    this.m_deploySummary.println("<h2><b>" + hfHeader + "</b></h2><br>");
                    this.m_deploySummary.println(hfMsg + "<br><br>");
                }
                if (Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.updatesRequired()) {
                    this.m_deploySummary.println(this.bundle.getString("Chaining.UpdateDesc1.txt"));
                    this.m_deploySummary.println(this.bundle.getString("Chaining.UpdateDesc2.txt"));
                    this.m_deploySummary.println(this.bundle.getString("Chaining.UpdateDesc3.txt"));
                    this.m_deploySummary.println(this.bundle.getString("Chaining.UpdateDesc4.txt"));
                    this.m_deploySummary.println(this.bundle.getString("Chaining.UpdateDesc5.txt"));
                    this.m_deploySummary.println(this.bundle.getString("Chaining.UpdateDesc6.txt"));
                    this.m_deploySummary.println("<H2>" + this.bundle.getString("Chaining.UpdateHeader.txt") + "</H2>");
                    if (Globals.g_sasHomeStatus.visibleRequiredInstalls() || Globals.g_sasHomeStatus.visibleRequiredMaintenance()) {
                        this.m_deploySummary.println("<TABLE>");
                        if (Globals.g_sasHomeStatus.visibleRequiredInstalls()) {
                            this.m_deploySummary.println("<TR>");
                            this.m_deploySummary.println("<TD NOWRAP>" + this.bundle.getString("PanelUpdateSummary.InstallHeader.txt") + "</TD>");
                            this.m_deploySummary.println("<TD NOWRAP ALIGN=CENTER>" + this.bundle.getString("PanelUpdateSummary.Column.Installed.txt") + "</TD>");
                            this.m_deploySummary.println("<TD NOWRAP ALIGN=CENTER>" + this.bundle.getString("PanelUpdateSummary.Column.Updated.txt") + "</TD>");
                            this.m_deploySummary.println("</TR>");
                            SASHomeStatus.UpdateEntity[] installs = Globals.g_sasHomeStatus.getRequiredInstalls();
                            for (int i = 0; i < installs.length; ++i) {
                                if (installs[i].isUpdateHidden()) continue;
                                this.m_deploySummary.println("<TR>");
                                this.m_deploySummary.println("<TD NOWRAP>" + installs[i].getExistingProductName() + "</TD>");
                                this.m_deploySummary.println("<TD NOWRAP ALIGN=CENTER>" + installs[i].getExistingCustomerVersion() + "</TD>");
                                this.m_deploySummary.println("<TD NOWRAP ALIGN=CENTER>" + installs[i].getUpdatedCustomerVersion() + "</TD>");
                                this.m_deploySummary.println("</TR>");
                            }
                            if (Globals.g_sasHomeStatus.visibleRequiredMaintenance()) {
                                this.m_deploySummary.println("<TR>");
                                this.m_deploySummary.println("<TD NOWRAP>&nbsp;</TD>");
                                this.m_deploySummary.println("<TD NOWRAP>&nbsp;</TD>");
                                this.m_deploySummary.println("<TD NOWRAP>&nbsp;</TD>");
                                this.m_deploySummary.println("</TR>");
                            }
                        }
                        if (Globals.g_sasHomeStatus.visibleRequiredMaintenance()) {
                            this.m_deploySummary.println("<TR>");
                            this.m_deploySummary.println("<TD NOWRAP>" + this.bundle.getString("PanelUpdateSummary.MaintHeader.txt") + "</TD>");
                            this.m_deploySummary.println("<TD NOWRAP ALIGN=CENTER>" + this.bundle.getString("PanelUpdateSummary.Column.Installed.txt") + "</TD>");
                            this.m_deploySummary.println("<TD NOWRAP ALIGN=CENTER>" + this.bundle.getString("PanelUpdateSummary.Column.Updated.txt") + "</TD>");
                            this.m_deploySummary.println("</TR>");
                            SASHomeStatus.UpdateEntity[] maint = Globals.g_sasHomeStatus.getRequiredMaintenance();
                            for (int i = 0; i < maint.length; ++i) {
                                if (maint[i].isUpdateHidden()) continue;
                                this.m_deploySummary.println("<TR>");
                                this.m_deploySummary.println("<TD NOWRAP>" + maint[i].getExistingProductName() + "</TD>");
                                this.m_deploySummary.println("<TD NOWRAP ALIGN=CENTER>" + maint[i].getExistingCustomerVersion() + "</TD>");
                                this.m_deploySummary.println("<TD NOWRAP ALIGN=CENTER>" + maint[i].getUpdatedCustomerVersion() + "</TD>");
                                this.m_deploySummary.println("</TR>");
                            }
                        }
                        this.m_deploySummary.println("</TABLE>");
                    }
                }
                this.m_deploySummary.flush();
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        File destSummary;
        if (Globals.g_configStatus != null) {
            try {
                Globals.g_configStatus.backup();
            }
            catch (IOException e1) {
                Logging.logStackTrace(e1);
            }
        }
        if (Globals.g_cmtTaskName != null) {
            try {
                if (DocPartUtils.createInstructionsDocPartsForTask(Globals.g_cmtTaskName) != null) {
                    DocPartUtils.createConfigErrorDocParts();
                }
            }
            catch (IOException ioe) {
                Logging.logStackTrace(ioe);
            }
        }
        if (!Globals.g_resumeChain && Globals.g_installData != null) {
            Globals.g_installData.saveWithPasswordHashes(Utils.joinPath(Utils.getSDWDataPath(false), "installRetry.properties"));
        }
        if (!Globals.g_resumeChain && Globals.g_configData != null) {
            Globals.g_configData.saveWithPasswordHashes(Utils.joinPath(Utils.getSDWDataPath(false), "configRetry.properties"));
        }
        boolean isBaseInChain = this.isProductInHotFixChain("base");
        if (Globals.g_configurableHotFixes != null && Globals.g_configurableHotFixes.size() > 0 && isBaseInChain) {
            MetadataAccess.restartMetadataServer(false);
        }
        this.copyBeanShell();
        this.m_stageCount = this.m_stageData.size();
        for (int stage = 0; !this.m_abort && stage < this.m_stageData.size(); ++stage) {
            this.m_currentStage = stage + 1;
            if (this.m_deploySummary != null) {
                try {
                    this.m_deploySummary.println("<H2>" + (String)this.m_stageNames.get(stage) + "</H2>");
                    this.m_deploySummary.flush();
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                }
            }
            ArrayList stageData = (ArrayList)this.m_stageData.get(stage);
            this.m_stepCount = stageData.size();
            for (int step = 0; !this.m_abort && step < stageData.size(); ++step) {
                this.m_currentStep = step + 1;
                if (stage == this.m_stageData.size() - 1 && step == stageData.size() - 1) {
                    this.m_lastStep = true;
                }
                this.m_currentProdData = (ProductData)stageData.get(step);
                try {
                    if (Globals.g_debug) {
                        PerfLog.getInstance().newEntry(this, "installNext", (String)this.m_stageNames.get(stage), this.m_currentProdData.getProdCode(), this.m_currentProdData.getSpsSku());
                    }
                    int n = this.installNext(stage, step);
                }
                finally {
                    if (Globals.g_debug) {
                        PerfLog.getInstance().finishLastEntry();
                    }
                }
                if (step != stageData.size() - 1) continue;
                this.m_panelExecute.reboot();
            }
        }
        if (Globals.g_mode == 0 && Globals.g_install) {
            boolean doSDMCleanUp = true;
            String sasHome = Globals.g_wizardData.getPreference("SASHome", "");
            ProductData webinfdsvrInOrder = Globals.g_deploymentData.getMaintenance(Globals.g_order, "webinfdsvr", Utils.getOS_Suffix(), "xx", true);
            String webinfdsvrMaintVersionInOrder = webinfdsvrInOrder != null ? webinfdsvrInOrder.getProdMaint() : null;
            String[] webinfdsvrInstalledMaintVersions = this.getWebinfdsvrInstalledMaintVersions(sasHome);
            if (webinfdsvrMaintVersionInOrder != null && webinfdsvrInstalledMaintVersions != null && webinfdsvrInstalledMaintVersions.length > 0) {
                if (!Arrays.stream(webinfdsvrInstalledMaintVersions).anyMatch(webinfdsvrMaintVersionInOrder::equals)) {
                    Logging.log.info("Maintenance version in order does not match maintenance version in deployment registry for webinfdsvr. SDM cleanup will not occur.");
                    doSDMCleanUp = false;
                }
            }
            if (doSDMCleanUp) {
                String deploywiz = new File(Utils.joinPath(Utils.getSDMHome(Globals.g_wizardData.getPreference("SASHome", "")), Globals.g_deploymentData.getProductDir(Globals.g_order, "deploywiz", true, false), "deploywiz")).getAbsolutePath();
                String logFile = new SimpleDateFormat("'sdmcleanup_'yyyy-MM-dd-HH.mm.ss'.log'").format(new Date());
                String groovy = Utils.joinPath(deploywiz, "groovy", "groovy.jar");
                String sdmcleanup = Utils.joinPath(deploywiz, "SDMCleanup.groovy");
                String privatejre = Utils.joinPath(Globals.g_jreHome, "bin", "java");
                String logDir = Utils.joinPath(sasHome, "InstallMisc", "InstallLogs");
                ArrayList<String> command = new ArrayList<String>(Arrays.asList(privatejre, "-cp", groovy, "groovy.lang.GroovyShell", sdmcleanup, "sashome=" + sasHome, "logdir=" + logDir, "logfile=" + logFile));
                Logging.log.info("Executing SDM cleanup process with the following params:  " + command);
                ProcessBuilder pb = new ProcessBuilder(command);
                pb.redirectErrorStream(true);
                try {
                    Process p = pb.start();
                    p.waitFor();
                    int exitValue = p.exitValue();
                    Logging.log.info("SDM cleanup process completed with exit code of " + exitValue);
                    Logging.log.info("Log file " + logFile + " is located at " + logDir);
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                }
            }
        }
        boolean vjrprune = false;
        if (Globals.g_mode == 0) {
            if (Globals.g_sasHomeStatus != null && Globals.g_sasHomeStatus.updatesRequired()) {
                Logging.log.info("For purposes of VJR pruning, the SAS Deployment Wizard is in update mode.");
                if (Globals.g_install) {
                    if (!Globals.g_plannedInstall) {
                        Logging.log.info("Unplanned install detected, VJR pruning will be enabled at the end of the update install chain.");
                        vjrprune = true;
                    } else {
                        Logging.log.info("Planned install detected, VJR pruning will be enabled at the end of the update config chain.");
                        vjrprune = false;
                    }
                }
            } else {
                Logging.log.info("SAS Deployment Wizard is performing either a new or addon install. VJR pruning will not be enabled.");
                vjrprune = false;
            }
        } else if (Globals.g_mode == 2) {
            Logging.log.info("For purposes of VJR pruning, SAS Deployment Manager mode (SDM) detected. Checking the SDM task selected to see if VJR pruning should be enabled.");
            switch (Globals.g_cmtTask) {
                case 5: {
                    Logging.log.info("Update existing configuration task selected, VJR pruning will be enabled.");
                    vjrprune = true;
                    break;
                }
                case 11: {
                    Logging.log.info("Apply hot fix task selected, VJR pruning will be enabled.");
                    vjrprune = true;
                    break;
                }
                case 28: {
                    Logging.log.info("Uninstall task selected, VJR pruning will be enabled.");
                    vjrprune = true;
                    break;
                }
                default: {
                    Logging.log.info("No qualifying SDM task was selected for VJR pruning. VJR pruning will not be enabled.");
                    vjrprune = false;
                }
            }
        }
        if (vjrprune) {
            Logging.log.info("VJR pruning was enabled.");
            VJR_Pruner.prune(Globals.g_wizardData.getPreference("SASHome", ""));
        } else {
            Logging.log.info("VJR pruning was not enabled.");
        }
        if (Globals.g_cmtTask == 28 && Utils.getOS() == 1) {
            this.removeWindowsUninstallLink();
        }
        if (Globals.g_install && !Globals.g_configure) {
            this.executePermsScript(Globals.g_vjrHome);
        }
        this.m_deploySummary.println("</BODY>");
        this.m_deploySummary.println("</HTML>");
        this.m_deploySummary.close();
        boolean bl = this.m_finished = !this.m_abort;
        if (Globals.g_install && !Globals.g_srwOnly && Utils.copyFile(this.m_summaryFile, destSummary = new File(Globals.g_wizardData.getPreference("SASHome", ""), "InstallMisc/InstallLogs/DeploymentSummary.html")) != 0) {
            Logging.log.warning("Error copying deployment summary file: " + this.m_summaryFile.getAbsolutePath() + " -> " + destSummary.getAbsolutePath());
        }
        if ((Globals.g_install || Globals.g_cmtTask == 11) && !Globals.g_srwOnly) {
            Chaining.createDeploymentRegistryViewLink();
            String sdmHome = "";
            sdmHome = Globals.g_mode == 2 ? Utils.getSDMHome(Globals.g_cmtSASHome) : Utils.getSDMHome(Globals.g_wizardData.getPreference("SASHome", ""));
            if (sdmHome != null && !sdmHome.equals("")) {
                HotFixPackages.extractProductDataForConfigOnlyHotFixes(sdmHome);
                HotFixPackageData.copyHotFixManifests(sdmHome);
            }
        }
        if (Globals.g_configure) {
            if (Globals.g_mode != 2 || Globals.g_cmtTask == 26 || Globals.g_cmtTask == 5) {
                String utilitiesDir = Globals.g_configData.getProperty("config.lev.utilities.dir", null);
                this.resolveConfigProperties();
                if (utilitiesDir != null) {
                    Globals.g_configData.saveWithoutPasswords(Utils.joinPath(utilitiesDir, "configuration.properties"));
                    if (Globals.g_internal) {
                        Globals.g_configData.save();
                        String sourceFile = Globals.g_configData.getFilePath();
                        String destFile = Utils.joinPath(utilitiesDir, "configuration_internal.properties");
                        if (Utils.copyFile(sourceFile, destFile) != 0) {
                            Logging.log.severe("Error copying configuration properties file: " + sourceFile + " -> " + destFile);
                        }
                    }
                }
            }
            SimpleDateFormat formatter = new SimpleDateFormat(BACKUP_TIMESTAMP_FORMAT);
            Date my_time = new Date();
            String timestamp = formatter.format(my_time);
            if (DocPartUtils.getCurrentInstructionsFile() != null) {
                timestamp = Chaining.getStartTimestamp();
            }
            if (Globals.g_mode != 2 || DocPartUtils.getCurrentInstructionsFile() != null || Globals.g_mode == 2 && Globals.g_cmtTask == 5 || Globals.g_cmtTask == 26) {
                String errorLog;
                String summaryFileName = "DeploymentSummary.html";
                File summaryFile = new File(Globals.g_configData.getProperty("config.lev.documents.dir", ""), summaryFileName);
                if (summaryFile.isFile()) {
                    String backupSummaryFileName = summaryFileName + "_" + timestamp + ".bak";
                    File backupSummaryFile = new File(Utils.joinPath(Globals.g_configData.getProperty("config.lev.documents.dir", ""), Globals.g_configData.getProperty("config.backup.dir.name", ""), backupSummaryFileName));
                    Utils.copyFile(summaryFile, backupSummaryFile);
                }
                if (Utils.copyFile(this.m_summaryFile, summaryFile) != 0) {
                    Logging.log.warning("Error copying deployment summary file: " + this.m_summaryFile.toString() + " -> " + summaryFile.toString());
                }
                if (Globals.g_configData != null && !this.m_configError && (errorLog = Globals.g_configData.getProperty("config.lev.errorlog.file", null)) != null && !new File(errorLog).delete()) {
                    Logging.log.info("Failure to delete " + errorLog);
                }
                DocPartUtils.finalizeAllDocPartFiles();
            }
        }
        if (Globals.g_configure) {
            if (Globals.g_mode == 2 && !Globals.g_cmtNewConfigDir) {
                if (Globals.g_cmtTask == 4) {
                    File connectionFile = new File(Utils.joinPath(Globals.g_cmtConfigDir, "Utilities", "metadata.connection.properties"));
                    this.setConnectionProperties(connectionFile);
                }
            } else {
                String connect = Globals.g_configData.getProperty("iomsrv.metadatasrv.connection.is_required", "false");
                File connectionFile = new File(Utils.joinPath(Globals.g_configData.getProperty("config.lev.utilities.dir", ""), "metadata.connection.properties"));
                if (connect.equalsIgnoreCase("true") && !connectionFile.isFile()) {
                    this.setConnectionProperties(connectionFile);
                }
            }
        }
        if (!Globals.g_quietMode) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Chaining.this.m_panelExecute.morphToSummary();
                    if (Globals.g_skipStatusPanels && !Chaining.this.oneFailed()) {
                        Globals.g_wizard.getNextButton().doClick();
                    }
                }
            });
        }
        if (Globals.g_wizard.getReturnCode() == 9999) {
            Globals.g_kit.exitKit(9999);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getWebinfdsvrInstalledMaintVersions(String sasHome) {
        ArrayList<String> webinfdsvrInstalledMaintVersions = new ArrayList<String>();
        String product = "webinfdsvr";
        try (RegistryAccess registryAccess = null;){
            RegistryData.setRegistry(sasHome);
            registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
            if (registryAccess.open()) {
                String[] hosts = registryAccess.getInstallHosts();
                for (int i = 0; i < hosts.length; ++i) {
                    String[] versions = registryAccess.getInstallVersions(product, hosts[i]);
                    for (int j = 0; j < versions.length; ++j) {
                        String[] maints = registryAccess.getMaintVersions(product, versions[j], hosts[i]);
                        webinfdsvrInstalledMaintVersions.addAll(Arrays.asList(maints));
                    }
                }
                String[] stringArray = webinfdsvrInstalledMaintVersions.toArray(new String[webinfdsvrInstalledMaintVersions.size()]);
                return stringArray;
            }
        }
        return new String[0];
    }

    private boolean isProductInHotFixChain(String prodCode) {
        if (prodCode == null || Globals.g_selectedHotFixesToInstall == null || Globals.g_selectedHotFixesToConfig == null) {
            return false;
        }
        for (ProductData hotFixToInstall : Globals.g_selectedHotFixesToInstall) {
            String str = hotFixToInstall.getProdCode();
            if (!prodCode.equalsIgnoreCase(str)) continue;
            return true;
        }
        for (ProductData hotFixToInstall : Globals.g_selectedHotFixesToConfig) {
            String str = hotFixToInstall.getProdCode();
            if (!prodCode.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    private int installNext(int stage, int step) {
        boolean retry = true;
        boolean retrySetting = false;
        int retVal = -1;
        while (retry && !this.m_abort) {
            retry = false;
            if (this.m_deploySummary != null && Globals.g_chainData.getInstallStatus(stage, step) == 1) {
                try {
                    this.m_deploySummary.println(this.bundle.getString("PanelExecute.SuccessLegend.txt") + " - " + this.m_currentProdData.getProdNameExtended() + " (installed in a previous deployment attempt)<br>");
                    this.m_deploySummary.flush();
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                }
            }
            if (Globals.g_chainData.getInstallStatus(stage, step) != 0 && Globals.g_chainData.getInstallStatus(stage, step) != 3 && Globals.g_chainData.getInstallStatus(stage, step) != 2 && Globals.g_chainData.getInstallStatus(stage, step) != 9) continue;
            int status = 3;
            Globals.g_chainData.setInstallStatus(stage, step, 3);
            Globals.g_chainData.save();
            this.m_currentTarget = (String)this.m_stageTargets.get(stage);
            if (!Globals.g_quietMode || Globals.g_quietStatus) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Chaining.this.m_panelExecute.updateStatus();
                    }
                });
            }
            String startupLocation = null;
            if (Globals.g_cmtTask == 41 || Globals.g_cmtTask == 40) {
                startupLocation = Globals.g_deploywizDepotLocation;
            } else if ("installtool".equals(this.m_currentProdData.getProdCode()) || this.m_currentProdData.getType() == 2 || Globals.g_mode == 2 || this.m_currentProdData.getType() == 4) {
                startupLocation = "cfgwizard";
            } else {
                startupLocation = this.m_panelExecute.getCorrectCD(this.m_currentProdData);
                if (this.m_currentProdData.getChainingRef(false).endsWith(".html") && startupLocation != null) {
                    startupLocation = Utils.pathToURL(startupLocation);
                }
            }
            String displayNameExtended = this.m_currentProdData.getProdNameExtended();
            if (startupLocation != null && startupLocation.length() > 0) {
                Logging.log.info("Stage #" + Integer.toString(stage + 1) + " Step #" + Integer.toString(step + 1) + " (" + this.m_currentProdData.getProdName() + ")");
                if (this.m_currentProdData.getType() == 4) {
                    ((HotFix)this.m_currentProdData).setSuccessfulInstall(false);
                }
                if ((retVal = this.launchInstall(startupLocation, (String)this.m_stageTargets.get(stage), retrySetting)) == 0 || retVal == 10 || retVal == -5) {
                    if (this.m_currentProdData.getType() == 4) {
                        ((HotFix)this.m_currentProdData).setSuccessfulInstall(true);
                        String sdmHome = "";
                        sdmHome = Globals.g_mode == 2 ? Utils.getSDMHome(Globals.g_cmtSASHome) : Utils.getSDMHome(Globals.g_wizardData.getPreference("SASHome", ""));
                        if (sdmHome != null && !sdmHome.equals("") && !((HotFix)this.m_currentProdData).copyProductData(sdmHome)) {
                            Logging.log.warning("A problem occurred while copying product data for hot fix " + ((HotFix)this.m_currentProdData).getHotFixName());
                        }
                    }
                    status = this.m_currentProdData.isInstalled() && !Globals.g_createBatch ? 5 : (this.m_currentProdData.isInstalled() && Globals.g_createBatch ? 6 : (!this.m_currentProdData.isApplicable() ? 4 : 1));
                    if (this.m_deploySummary != null) {
                        try {
                            if (status == 1) {
                                if (retVal == 10) {
                                    this.m_deploySummary.println(this.bundle.getString("PanelExecute.SuccessLegend.txt") + " - " + displayNameExtended + " (installed in a previous deployment attempt)<br>");
                                } else {
                                    this.m_deploySummary.println(this.bundle.getString("PanelExecute.SuccessLegend.txt") + " - " + displayNameExtended + "<br>");
                                }
                            } else if (status == 6) {
                                this.m_deploySummary.println(this.bundle.getString("PanelExecute.SuccessBatchLegend.txt") + " - " + displayNameExtended + "<br>");
                            } else if (status == 4) {
                                this.m_deploySummary.println(this.bundle.getString("PanelExecute.NotApplicableLegend.txt") + " - " + displayNameExtended + "<br>");
                            } else {
                                this.m_deploySummary.println(this.bundle.getString("PanelExecute.InstalledLegend.txt") + " - " + displayNameExtended + "<br>");
                            }
                            this.m_deploySummary.flush();
                        }
                        catch (Exception e) {
                            Logging.logStackTrace(e);
                        }
                    }
                } else if (retVal == 5 && (this.m_currentProdData.getType() == 2 || this.m_currentProdData.getProdCode().equalsIgnoreCase("zosinstwiz") || Globals.g_cmtTask == 41)) {
                    status = 4;
                    if (Globals.g_cmtTask == 41) {
                        this.m_panelExecute.setWarning(true);
                    }
                    if (this.m_deploySummary != null) {
                        try {
                            this.m_deploySummary.println(this.bundle.getString("PanelExecute.WarningLegend.txt") + " - " + displayNameExtended + "<br>");
                            this.m_deploySummary.flush();
                        }
                        catch (Exception e) {
                            Logging.logStackTrace(e);
                        }
                    }
                    if (this.m_currentProdData.getType() == 2) {
                        Logging.log.warning("Configure warning for: " + this.m_currentProdData.getProdName());
                    }
                    if (this.m_currentProdData.getProdCode().equalsIgnoreCase("zosinstwiz")) {
                        if (Globals.g_consoleMode) {
                            ConsoleMode.busyMsgStop();
                        }
                        this.m_panelExecute.promptWithWarning();
                        if (Globals.g_consoleMode) {
                            ConsoleMode.busyMsgStart("");
                        }
                    }
                } else if (InstallToolConnector.itController() != null && InstallToolConnector.itController().isInstallCancelled()) {
                    if (retVal == -4) {
                        Logging.log.info("The user chose to cancel the installation.  Rollback of the last installation unit was attempted, but could not be completed.  Details can be found in the IT log.  Exiting...");
                    } else if (retVal == -3) {
                        Logging.log.info("The user chose to cancel the installation.  Rollback of the last installation unit was completed.  Exiting...");
                    } else {
                        Logging.log.info("The user chose to cancel the installation.  Status of the rollback of the last installation unit could not be determined from the exit code (" + retVal + ").  Exiting...");
                    }
                    if (status == 3 || this.m_currentProdData.getType() != 2) {
                        Globals.g_chainData.setInstallStatus(stage, step, 0);
                        Globals.g_chainData.save();
                    }
                    Globals.g_kit.exitKit(-9999);
                } else {
                    status = 2;
                }
            } else {
                status = !Globals.g_createBatch ? 2 : 7;
            }
            if (status == 2 || status == 7) {
                int promptVal = 0;
                if (Globals.g_quietMode) {
                    if (Globals.g_yesToAll) {
                        promptVal = 2;
                    }
                } else if (this.m_abort) {
                    promptVal = 0;
                } else if (Globals.g_yesToAll) {
                    promptVal = 2;
                } else {
                    if (Globals.g_consoleMode) {
                        ConsoleMode.busyMsgStop();
                    }
                    promptVal = this.m_panelExecute.promptToContinue(this.m_lastStep, retVal, this.m_antLog);
                    if (Globals.g_consoleMode) {
                        ConsoleMode.busyMsgStart("");
                    }
                }
                if (promptVal == 0) {
                    this.m_abort = true;
                } else if (promptVal == 1) {
                    retry = true;
                    retrySetting = true;
                    status = 3;
                } else if (promptVal == 2 && this.m_currentProdData.getType() == 2) {
                    status = 8;
                }
                if (!retry) {
                    this.m_oneFailed = true;
                    if (Globals.g_mode == 0 && status == 2) {
                        Globals.g_deleteChainData = false;
                    }
                    if (this.m_deploySummary != null) {
                        try {
                            if (status == 7) {
                                this.m_deploySummary.println(this.bundle.getString("PanelExecute.FailureBatchLegend.txt") + " - " + displayNameExtended + "<br>");
                            } else {
                                this.m_deploySummary.println(this.bundle.getString("PanelExecute.FailureLegend.txt") + " - " + displayNameExtended + "<br>");
                            }
                            this.m_deploySummary.flush();
                        }
                        catch (Exception e) {
                            Logging.logStackTrace(e);
                        }
                    }
                    String logMsg = null;
                    if (this.m_currentProdData.getType() == 2) {
                        File antLog;
                        logMsg = "Configure failure for: " + this.m_currentProdData.getProdName();
                        String errorMsg = this.getConfigErrorMsg(this.m_currentProdData.getProdCode());
                        if (errorMsg != null) {
                            logMsg = logMsg + "\n   Error message: " + errorMsg;
                            if (this.m_deploySummary != null) {
                                try {
                                    this.m_deploySummary.println("&nbsp;&nbsp;&nbsp;" + this.bundle.messageString("Chaining.ConfigError.txt", errorMsg) + "<br>");
                                    this.m_deploySummary.flush();
                                }
                                catch (Exception e) {
                                    Logging.logStackTrace(e);
                                }
                            }
                        }
                        if ((antLog = new File(this.m_antLog)).isFile()) {
                            logMsg = logMsg + "\n   Log file:      " + this.m_antLog;
                            if (this.m_deploySummary != null) {
                                try {
                                    if (Utils.getOS() == 8) {
                                        this.m_deploySummary.println("&nbsp;&nbsp;&nbsp;" + this.bundle.messageString("Chaining.ConfigLog.txt", "<a href=\"" + this.m_antLog + "\">" + this.m_antLog + "</a><br>"));
                                    } else {
                                        this.m_deploySummary.println("&nbsp;&nbsp;&nbsp;" + this.bundle.messageString("Chaining.ConfigLog.txt", "<a href=\"" + Utils.pathToURL(this.m_antLog) + "\">" + this.m_antLog + "</a><br>"));
                                    }
                                    this.m_deploySummary.flush();
                                }
                                catch (Exception e) {
                                    Logging.logStackTrace(e);
                                }
                            }
                        }
                    } else {
                        logMsg = "Install failure for: " + this.m_currentProdData.getProdName();
                    }
                    if (logMsg != null) {
                        Logging.log.severe(logMsg);
                    }
                }
                if (!retry && this.m_currentProdData.getType() == 2) {
                    this.m_configError = true;
                    if (retVal == -1) {
                        this.launchInstall(startupLocation, "reportMissingScript", retrySetting);
                    } else {
                        this.launchInstall(startupLocation, "reportFailures", retrySetting);
                    }
                }
            } else if (status == 1 || status == 4 || status == 5 || status == 6) {
                this.m_oneInstalled = true;
            }
            if (!(retry || this.m_currentProdData.getType() != 2 || Globals.g_mode == 2 && Globals.g_processInstances)) {
                String utilitiesDir;
                File antScript;
                this.loadConfigProperties();
                Properties configProps = null;
                String prodCode = this.m_currentProdData.getProdCode();
                String prodName = this.m_currentProdData.getProdName();
                String fqid = Globals.g_configData.getProperty(prodCode + ".configobj.fqid", null);
                if (fqid != null) {
                    configProps = MetadataAccess.getObjectProperties(Globals.g_configData.getProperty("iomsrv.metadatasrv.host", null), Globals.g_configData.getProperty("iomsrv.metadatasrv.port", null), Globals.g_configData.getProperty("oma.repository.foundation.name", null), Globals.g_configData.getProperty("oma.person.admin.login.userid", null), Globals.g_configData.getProperty("oma.person.admin.login.passwd", null), fqid);
                }
                if (configProps != null) {
                    String key = null;
                    String value = null;
                    Enumeration<?> e = configProps.propertyNames();
                    while (e.hasMoreElements()) {
                        key = (String)e.nextElement();
                        if (key == null || (value = configProps.getProperty(key, null)) == null) continue;
                        Globals.g_configData.getProperties().setProperty(key, value);
                    }
                    if (Globals.g_debug) {
                        String logEntry = "Properties for " + fqid + " (" + prodCode + ")";
                        Enumeration<?> e2 = configProps.propertyNames();
                        while (e2.hasMoreElements()) {
                            key = (String)e2.nextElement();
                            if (key == null || (value = configProps.getProperty(key, null)) == null) continue;
                            logEntry = logEntry + "\n" + key + " = " + value;
                        }
                        Logging.log.info(logEntry);
                    }
                }
                if ((antScript = new File(Globals.g_configData.getProperty(prodCode + ".config.script.file", ""))) != null && antScript.isFile() && (utilitiesDir = Globals.g_configData.getProperty("config.lev.utilities.dir", null)) != null) {
                    File tempConfigBundle = new File(DialogData.getTempConfigBundlePath());
                    if (tempConfigBundle.exists()) {
                        File copyForUtilities = new File(DialogData.getLevUtilitiesConfigBundlePath());
                        long tempLastModified = tempConfigBundle.lastModified();
                        long levUtilsLastModified = copyForUtilities.lastModified();
                        if (!copyForUtilities.exists() || tempLastModified > levUtilsLastModified) {
                            if (Utils.copyFile(tempConfigBundle, copyForUtilities) != 0) {
                                Logging.log.severe("Error copying configBundle.xml file: " + tempConfigBundle.getAbsolutePath() + " -> " + copyForUtilities.getAbsolutePath());
                            } else {
                                Logging.log.info("Successfully copied configBundle.xml file: " + tempConfigBundle.getAbsolutePath() + " -> " + copyForUtilities.getAbsolutePath());
                            }
                        } else {
                            Logging.log.finer(copyForUtilities.getAbsolutePath() + " is up-to-date when compared to " + tempConfigBundle.getAbsolutePath());
                        }
                    }
                    String destFile = Utils.joinPath(utilitiesDir, prodCode + ".configuration.properties");
                    if (Globals.g_internal) {
                        String antTarget = this.m_currentTarget;
                        File propertyFile = this.saveConfigProperties(prodCode, prodName, antScript.getParent(), antTarget);
                        String sourceFile = propertyFile.getAbsolutePath();
                        if (Utils.copyFile(sourceFile, destFile) != 0) {
                            Logging.log.severe("Error copying configuration properties file: " + sourceFile + " -> " + destFile);
                        }
                    } else if (Globals.g_configData.saveProductList(prodCode, prodName, antScript.getParent(), destFile, true) == null) {
                        Logging.log.severe("Error saving configuration properties file: " + destFile);
                    }
                    File[] tempFiles = new File(Globals.g_tempLocation).listFiles();
                    if (tempFiles != null) {
                        for (int i = 0; i < tempFiles.length; ++i) {
                            if (!tempFiles[i].isFile() || !tempFiles[i].getName().startsWith(prodCode) || tempFiles[i].getName().indexOf(".configuration.properties") <= prodCode.length()) continue;
                            Properties props = new Properties();
                            try {
                                FileInputStream fis = new FileInputStream(tempFiles[i]);
                                props.load(fis);
                                fis.close();
                                String key = null;
                                Enumeration<Object> e = props.keys();
                                while (e.hasMoreElements()) {
                                    key = (String)e.nextElement();
                                    if (Globals.g_configPasswords == null || !Globals.g_configPasswords.containsKey(key)) continue;
                                    props.remove(key);
                                }
                                destFile = Utils.joinPath(utilitiesDir, tempFiles[i].getName());
                                FileOutputStream fos = new FileOutputStream(destFile);
                                props.store(fos, null);
                                fos.close();
                                continue;
                            }
                            catch (Exception e) {
                                Logging.logStackTrace(e);
                            }
                        }
                    }
                }
            }
            if (this.m_oneFailed && "installtool".equals(this.m_currentProdData.getProdCode()) && status != 2) {
                status = 9;
            }
            Globals.g_chainData.setInstallStatus(stage, step, status);
            Globals.g_chainData.save();
            if (Globals.g_quietMode) continue;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Chaining.this.m_panelExecute.updateStatus();
                }
            });
        }
        return retVal;
    }

    private boolean startTimerForITPackage(ProductData pd) {
        return pd.getProdCode().equalsIgnoreCase("eguide") || pd.getProdCode().equalsIgnoreCase("msofficeint");
    }

    private int launchInstall(String startupLocation, String antTarget, boolean retrySetting) {
        int retVal = 0;
        this.m_antLog = "";
        String antPlatformLogStr = this.m_currentProdData.getPlatform();
        antPlatformLogStr = antPlatformLogStr != null && antPlatformLogStr != "" ? "_" + antPlatformLogStr : "";
        File defaultLogDir = Globals.g_mode == 2 ? new File(Globals.g_cmtSASHome, "InstallMisc/InstallLogs") : new File(Globals.g_wizardData.getPreference("SASHome", ""), "InstallMisc/InstallLogs");
        String chainingRef = this.m_currentProdData.getChainingRef(false);
        if (chainingRef != null && (chainingRef.toLowerCase().endsWith(".html") || chainingRef.toLowerCase().endsWith(".htm"))) {
            String fullExe = Utils.joinPath(startupLocation, chainingRef);
            retVal = this.m_panelExecute.showOEMDialog(this.m_currentProdData.getProdCode(), fullExe) ? 0 : -1;
        } else {
            String installRef;
            ProductData pd;
            block114: {
                pd = this.m_currentProdData;
                installRef = null;
                if (pd != null) {
                    installRef = pd.getInstallRef(pd.isInteractive());
                    if (Globals.g_cmtTask == 28 || installRef != null && !installRef.toLowerCase().endsWith("install.xml") || pd.getType() == 0 || Globals.g_cmtTask == 41 || Globals.g_cmtTask == 40 || pd.getType() == 4) {
                        if (!Globals.g_quietMode) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Chaining.this.m_panelExecute.startTimer();
                                }
                            });
                        }
                    } else if (this.startTimerForITPackage(pd) && !Globals.g_quietMode) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Chaining.this.m_panelExecute.startTimer();
                            }
                        });
                    }
                }
                if (Globals.g_mode == 2 && this.m_currentProdData.getType() != 5 && Globals.g_cmtInstallTargets != null) {
                    block113: {
                        if (!Globals.g_quietMode) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Chaining.this.m_panelExecute.startTimer();
                                }
                            });
                        }
                        if (this.m_abort) {
                            retVal = -1;
                        } else {
                            String prodCode = this.m_currentProdData.getProdCode();
                            String prodVer = this.m_currentProdData.getProdVersion();
                            String platform = this.m_currentProdData.getPlatform();
                            String installDir = null;
                            if (this.m_registryAccess != null && this.m_registryAccess.open()) {
                                String jreDir;
                                ProductData prodData;
                                if (platform != null) {
                                    installDir = this.m_registryAccess.getInstallLoc(prodCode, prodVer, platform);
                                    if (installDir == null) {
                                        installDir = this.m_registryAccess.getInstallLoc(prodCode, "default", platform);
                                    }
                                } else {
                                    installDir = this.m_registryAccess.getInstallLoc(prodCode, prodVer);
                                    if (installDir == null) {
                                        installDir = this.m_registryAccess.getInstallLoc(prodCode, "default");
                                    }
                                }
                                if (Globals.g_jreHome == null && (prodData = Globals.g_deploymentData.getProduct(Globals.g_order, "javaruntime", true)) != null && (jreDir = this.m_registryAccess.getInstallLoc("javaruntime", Globals.g_majorReleaseVersion)) != null) {
                                    Globals.g_jreHome = jreDir;
                                }
                                this.m_registryAccess.close();
                                if (installDir != null) {
                                    Globals.g_installData.setProperty(prodCode + ".install.dir", installDir);
                                }
                                Logging.log.fine(prodCode + ".install.dir=" + installDir);
                            }
                            if (Globals.g_cmtRunITTarget) {
                                if ("installtool".equalsIgnoreCase(this.m_currentProdData.getProdCode())) {
                                    try {
                                        this.m_panelExecute.hideOverallProgress();
                                        retVal = new InstallToolConnector().postProcess();
                                    }
                                    catch (Exception e) {
                                        Logging.logStackTrace(e);
                                        retVal = -1;
                                    }
                                } else {
                                    retVal = KitAction.kitClickAction(this.m_currentProdData, startupLocation, false);
                                }
                            } else {
                                String script = Globals.g_installDefaults.getDefault("deploywiz." + antTarget + ".script.file", "");
                                if (PropertyRules.containsProperty(script)) {
                                    script = PropertyRules.resolveProperties(script, 1);
                                }
                                Logging.log.finer("Chaining::launchInstall() Finding script: " + script);
                                File scriptFile = new File(script);
                                if (scriptFile.isFile()) {
                                    Globals.g_installData.makeTemporary();
                                    Globals.g_installData.save();
                                    String timeStamp = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss").format(new Date());
                                    String logDir = Globals.g_installDefaults.getDefault("deploywiz." + antTarget + ".log.dir", null);
                                    File antLogFile = null;
                                    if (logDir != null) {
                                        if (PropertyRules.containsProperty(logDir)) {
                                            logDir = PropertyRules.resolveProperties(logDir, 1);
                                        }
                                        antLogFile = new File(logDir, prodCode + antPlatformLogStr + "_" + antTarget + "_" + timeStamp + ".log");
                                    } else {
                                        antLogFile = new File(defaultLogDir, prodCode + antPlatformLogStr + "_" + antTarget + "_" + timeStamp + ".log");
                                    }
                                    this.m_antLog = antLogFile.getAbsolutePath();
                                    if (script.endsWith(".groovy")) {
                                        try {
                                            Logging.log.finer("Chaining::launchInstall() Found groovy script: " + script);
                                            Object o = null;
                                            if (Utils.getOS() == 8) {
                                                String scriptClassName = null;
                                                if (script.endsWith("ConfigAgentCredentials.groovy")) {
                                                    scriptClassName = "com.sas.ssn.install.ConfigAgentCredentials";
                                                } else if (script.endsWith("PushAgentMetadata.groovy")) {
                                                    scriptClassName = "com.sas.ssn.install.PushAgentMetadata";
                                                }
                                                if (scriptClassName != null) {
                                                    Logging.log.finer("Chaining::launchInstall() On MVS loading Java class " + scriptClassName);
                                                    o = Class.forName(scriptClassName).newInstance();
                                                }
                                            } else {
                                                GroovyLauncher groovyLauncher = GroovyLauncher.getDefaultGroovyLauncher();
                                                o = groovyLauncher.constructGroovyInstance(scriptFile);
                                            }
                                            if (o instanceof GroovyInstallTask) {
                                                Logging.log.finer("Chaining::launchInstall() Constructed GroovyInstallTask from: " + script);
                                                GroovyInstallTask installTask = (GroovyInstallTask)o;
                                                installTask.init(Globals.g_installData, this.m_currentProdData);
                                                installTask.setLogger(Logging.log);
                                                Logging.log.finer("Chaining::launchInstall() Launching GroovyInstallTask from: " + script);
                                                retVal = installTask.execute(antTarget);
                                                Logging.log.finer("Chaining::launchInstall() Finished executing GroovyInstallTask from: " + script);
                                                break block113;
                                            }
                                            Logging.log.severe("Chaining::launchInstall() This groovy class does not implement GroovyInstallTask: " + script);
                                            retVal = -1;
                                        }
                                        catch (Exception e) {
                                            Logging.logStackTrace(e);
                                            retVal = -1;
                                        }
                                    } else {
                                        retVal = Configure.runInstallAntScript(prodCode, this.m_currentProdData.getProdName(), prodVer, this.m_currentProdData.getProdCustVersion(), this.m_currentProdData.getProdMaint(), this.m_currentProdData.getProdSASRelease(), Globals.g_deploymentData.getOrder(Globals.g_order).getEncoding(), scriptFile.getAbsolutePath(), antLogFile.getAbsolutePath(), Globals.g_installData.getFilePath(), antTarget);
                                    }
                                } else {
                                    retVal = -1;
                                }
                            }
                        }
                    }
                    this.m_panelExecute.stopTimer();
                } else if (this.m_currentProdData.getType() == 2 || this.m_currentProdData.getType() == 5) {
                    if (this.m_currentProdData.getType() == 5 && !this.startedMetadataServerOnce) {
                        MetadataAccess.restartMetadataServer(true);
                        this.startedMetadataServerOnce = true;
                    }
                    if (!this.m_configDataSaved) {
                        this.checkSASPermissions();
                        if (Globals.g_mode != 2 && Globals.g_install) {
                            this.executePermsScript(Globals.g_vjrHome);
                        }
                        if (!this.m_abort) {
                            this.saveConfigData();
                        }
                        this.m_configDataSaved = true;
                    }
                    if (Globals.g_cmtTask == 2 && this.m_currentProdData.getOrder() != null && !Globals.g_order.equalsIgnoreCase(this.m_currentProdData.getOrder())) {
                        this.saveCurrentProductOrderInstallDirs();
                    }
                    if (!Globals.g_quietMode) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Chaining.this.m_panelExecute.startTimer();
                            }
                        });
                    }
                    retVal = this.m_abort ? -1 : this.launchConfigScripts(antTarget, retrySetting);
                    this.m_panelExecute.stopTimer();
                } else if ("cfgwizard".equalsIgnoreCase(this.m_currentProdData.getProdCode())) {
                    DepotManager cmtDepot = new DepotManager(new File(Utils.getSDMHome(Globals.g_wizardData.getPreference("SASHome", ""))));
                    DepotManager.AddJob cmtJob = cmtDepot.createAddJob(Globals.g_deploymentData, Globals.g_order);
                    cmtJob.setMode(4);
                    cmtJob.run();
                    if (cmtJob.getStatus() != 4) {
                        retVal = -1;
                    }
                } else if ("installtool".equalsIgnoreCase(this.m_currentProdData.getProdCode()) || "mit".equalsIgnoreCase(this.m_currentProdData.getProdCode())) {
                    ProductData sasinstallData;
                    try {
                        this.m_panelExecute.hideOverallProgress();
                        retVal = new InstallToolConnector().postProcess();
                    }
                    catch (Exception e) {
                        Logging.logStackTrace(e);
                        retVal = -1;
                    }
                    if (retVal == 0 && Utils.getOS() == 8 && (sasinstallData = Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", false)) != null) {
                        String prodCode = sasinstallData.getProdCode();
                        String zipFile = sasinstallData.getChainingRef(false);
                        String sasHome = Globals.g_wizardData.getPreference("SASHome", "");
                        if (zipFile != null && zipFile.toLowerCase(Locale.ENGLISH).endsWith(".zip")) {
                            try {
                                String installDir = Unzip.getEntryPath(new File(Globals.g_startupLocation, zipFile), prodCode + "_install.xml", sasHome);
                                if (installDir == null) break block114;
                                installDir = sasHome + File.separator + installDir;
                                Unzip.getAll(Globals.g_startupLocation + File.separator + zipFile, sasHome);
                                File scriptFile = new File(installDir, prodCode + "_install.xml");
                                if (scriptFile.isFile()) {
                                    if (Globals.g_zosJobSubmit) {
                                        String timeStamp = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss").format(new Date());
                                        File antLogFile = new File(defaultLogDir, prodCode + antPlatformLogStr + "_add-svc_" + timeStamp + ".log");
                                        this.m_antLog = antLogFile.getAbsolutePath();
                                        retVal = Configure.runInstallAntScript(prodCode, sasinstallData.getProdName(), sasinstallData.getProdVersion(), sasinstallData.getProdCustVersion(), sasinstallData.getProdMaint(), sasinstallData.getProdSASRelease(), Globals.g_deploymentData.getOrder(Globals.g_order).getEncoding(), scriptFile.getAbsolutePath(), antLogFile.getAbsolutePath(), Globals.g_installData.getFilePath(), "add-svc");
                                        if (retVal == 0) {
                                            timeStamp = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss").format(new Date());
                                            antLogFile = new File(defaultLogDir, prodCode + antPlatformLogStr + "_fix-tkmvsenv_" + timeStamp + ".log");
                                            this.m_antLog = antLogFile.getAbsolutePath();
                                            retVal = Configure.runInstallAntScript(prodCode, sasinstallData.getProdName(), sasinstallData.getProdVersion(), sasinstallData.getProdCustVersion(), sasinstallData.getProdMaint(), sasinstallData.getProdSASRelease(), Globals.g_deploymentData.getOrder(Globals.g_order).getEncoding(), scriptFile.getAbsolutePath(), antLogFile.getAbsolutePath(), Globals.g_installData.getFilePath(), "fix-tkmvsenv");
                                        }
                                    } else {
                                        String timeStamp = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss").format(new Date());
                                        File antLogFile = new File(defaultLogDir, prodCode + antPlatformLogStr + "_install-nosubmit_" + timeStamp + ".log");
                                        this.m_antLog = antLogFile.getAbsolutePath();
                                        retVal = Configure.runInstallAntScript(prodCode, sasinstallData.getProdName(), sasinstallData.getProdVersion(), sasinstallData.getProdCustVersion(), sasinstallData.getProdMaint(), sasinstallData.getProdSASRelease(), Globals.g_deploymentData.getOrder(Globals.g_order).getEncoding(), scriptFile.getAbsolutePath(), antLogFile.getAbsolutePath(), Globals.g_installData.getFilePath(), "install-nosubmit");
                                    }
                                    break block114;
                                }
                                Logging.log.fine("Install script not found: " + scriptFile.getPath());
                            }
                            catch (Exception e) {
                                Logging.logStackTrace(e);
                                retVal = -1;
                            }
                        }
                    }
                } else {
                    String prodCode;
                    if (this.m_currentProdData.getType() != 0 && !"zosinstwiz".equalsIgnoreCase(this.m_currentProdData.getProdCode())) {
                        if (Globals.g_cmtTask != 28 && Globals.g_cmtTask != 41 && Globals.g_cmtTask != 40) {
                            if (this.m_registryAccess != null && this.m_registryAccess.open()) {
                                String version = this.m_currentProdData.getProdVersion();
                                if ("javaruntime".equalsIgnoreCase(this.m_currentProdData.getProdCode())) {
                                    version = Globals.g_majorReleaseVersion;
                                }
                                String platform = this.m_currentProdData.getPlatform();
                                if (this.m_currentProdData.getProdCode().equals("eguide") || this.m_currentProdData.getProdCode().equals("msofficeint")) {
                                    MsiInstallData msi;
                                    ArrayList<String> versionsList = new ArrayList<String>();
                                    this.m_registryAccess.close();
                                    this.m_registryAccess.open("9.4");
                                    String[] versions1 = this.m_registryAccess.getInstallVersions(this.m_currentProdData.getProdCode(), platform);
                                    if (versions1 != null && versions1.length > 0) {
                                        List<String> tmp = Arrays.asList(versions1);
                                        versionsList.addAll(tmp);
                                    }
                                    this.m_registryAccess.close();
                                    this.m_registryAccess.open("9.4SA");
                                    String[] versions2 = this.m_registryAccess.getInstallVersions(this.m_currentProdData.getProdCode(), platform);
                                    if (versions2 != null && versions2.length > 0) {
                                        List<String> tmp = Arrays.asList(versions2);
                                        versionsList.addAll(tmp);
                                    }
                                    if ((msi = new MsiInstallData(this.m_currentProdData, versionsList.toArray(new String[0]))).isAutoUpdate()) {
                                        this.m_registryAccess.close();
                                        Logging.log.info("The product " + this.m_currentProdData.getProdCode() + " is verified installed.");
                                        return 10;
                                    }
                                    this.m_registryAccess.close();
                                    this.m_registryAccess.open();
                                }
                                this.setRegistryData(version, platform);
                                this.m_registryAccess.close();
                            }
                        } else {
                            String dfLog;
                            prodCode = this.m_currentProdData.getProdCode();
                            if (this.m_currentProdData.getProdCode().equals("txtandocconv")) {
                                if (Utils.getOS() == 1) {
                                    this.m_currentProdData.setSilentArgs("/S");
                                }
                                this.m_currentProdData.setInteractiveArgs("");
                            } else if (this.m_currentProdData.getProdCode().equals("dffedsas") || this.m_currentProdData.getProdCode().equals("dfscrfedsas")) {
                                dfLog = new File(installRef).getParent().concat("\\INSTALL.LOG");
                                if (new File(dfLog).exists()) {
                                    this.m_currentProdData.setSilentArgs("/S \"" + dfLog + "\"");
                                }
                                if (this.m_currentProdData.getProdCode().equals("dfscrfedsas")) {
                                    Globals.PRODVER_DFSCRFEDSAS = this.m_currentProdData.getProdVersion();
                                }
                            } else if (Globals.g_dataFluxProductList.indexOf(this.m_currentProdData.getProdCode()) >= 0 && Utils.getOS() == 1 && new File(dfLog = new File(installRef).getParent().concat("\\INSTALL.LOG")).exists()) {
                                if (this.m_currentProdData.getProdCode().equals("knwldgebseci")) {
                                    this.m_currentProdData.setSilentArgs("/S /REMOVE_DATA=y");
                                } else {
                                    this.m_currentProdData.setSilentArgs("/S \"" + dfLog + "\"");
                                }
                            }
                        }
                    }
                    retVal = KitAction.kitClickAction(this.m_currentProdData, startupLocation, this.m_currentProdData.isInteractive());
                    prodCode = this.m_currentProdData.getProdCode();
                    if (retVal == 0) {
                        try {
                            if (Utils.getOS() == 1 && Globals.g_cmtTask != 28 && !Globals.g_srwOnly && !this.m_uninstallDataAdded && Globals.g_sdmSelected) {
                                this.setupWindowsUninstallLink();
                            }
                            if (this.m_registryAccess != null && this.m_registryAccess.open()) {
                                String installDir = null;
                                String platform = this.m_currentProdData.getPlatform();
                                if (platform != null) {
                                    installDir = this.m_registryAccess.getInstallLoc(prodCode, this.m_currentProdData.getProdVersion(), platform);
                                    if (installDir == null) {
                                        installDir = this.m_registryAccess.getInstallLoc(prodCode, "default", platform);
                                    }
                                } else {
                                    installDir = this.m_registryAccess.getInstallLoc(prodCode, this.m_currentProdData.getProdVersion());
                                    if (installDir == null) {
                                        installDir = this.m_registryAccess.getInstallLoc(prodCode, "default");
                                    }
                                }
                                this.m_registryAccess.close();
                                if (installDir != null && new File(installDir).isDirectory()) {
                                    if (!this.m_installDataSaved) {
                                        this.saveInstallData();
                                        this.m_installDataSaved = true;
                                    }
                                    if (Globals.g_installExcludeProps != null) {
                                        String key2 = null;
                                        String value = null;
                                        for (String key2 : Globals.g_installExcludeProps.keySet()) {
                                            if (key2 == null || (value = Globals.g_installData.getProperty(key2, null)) == null) continue;
                                            Globals.g_installData.removeProperty(key2);
                                        }
                                    }
                                    Globals.g_installData.setProperty(prodCode + ".install.dir", installDir);
                                    Logging.log.fine(prodCode + ".install.dir=" + installDir);
                                    if (Utils.getOS() == 8) {
                                        Globals.g_installData.setProperty("zos.install.locale", Language.gs_SelectedLanguage);
                                        Globals.g_installData.setProperty("ssd.dir", Globals.g_startupLocation);
                                        int strlen = 0;
                                        int start = 0;
                                        strlen = Globals.g_startupLocation.length();
                                        for (int count = 1; count <= 3 && start <= strlen; ++count) {
                                            if (strlen - start <= 55) {
                                                Globals.g_installData.setProperty("ssd.dir" + count, Globals.g_startupLocation.substring(start) + "/products/");
                                                start = strlen + 1;
                                                continue;
                                            }
                                            if (strlen - start >= 65) {
                                                Globals.g_installData.setProperty("ssd.dir" + count, Globals.g_startupLocation.substring(start, start + 65));
                                                start += 65;
                                                continue;
                                            }
                                            Globals.g_installData.setProperty("ssd.dir" + count, Globals.g_startupLocation.substring(start, strlen));
                                            start = strlen;
                                        }
                                        Globals.g_installData.setProperty("orderdata.dir", Utils.joinPath(Globals.g_deploymentData.getOrderDir(), Globals.g_order));
                                    }
                                    Globals.g_installData.makeTemporary();
                                    Globals.g_installData.save();
                                    boolean maintMode = false;
                                    String maintLevel = this.m_currentProdData.getProdMaint();
                                    if (maintLevel != null && maintLevel.length() > 0 && Integer.parseInt(maintLevel) > 0) {
                                        maintMode = true;
                                    }
                                    if (this.m_currentProdData.getType() != 4) {
                                        if (maintMode) {
                                            String scriptName = prodCode + "_update.xml";
                                            File scriptFile = new File(Utils.joinPath(installDir, scriptName));
                                            if (scriptFile.isFile()) {
                                                String timeStamp = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss").format(new Date());
                                                File antLogFile = new File(defaultLogDir, prodCode + antPlatformLogStr + "_update_" + timeStamp + ".log");
                                                this.m_antLog = antLogFile.getAbsolutePath();
                                                retVal = Configure.runInstallAntScript(prodCode, this.m_currentProdData.getProdName(), this.m_currentProdData.getProdVersion(), this.m_currentProdData.getProdCustVersion(), this.m_currentProdData.getProdMaint(), this.m_currentProdData.getProdSASRelease(), Globals.g_deploymentData.getOrder(Globals.g_order).getEncoding(), scriptFile.getAbsolutePath(), antLogFile.getAbsolutePath(), Globals.g_installData.getFilePath(), "update");
                                            } else {
                                                Logging.log.fine("Update script not found: " + scriptFile.getPath());
                                            }
                                        } else {
                                            String scriptName = prodCode + "_install.xml";
                                            File scriptFile = new File(Utils.joinPath(installDir, scriptName));
                                            if (scriptFile.isFile()) {
                                                String timeStamp = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss").format(new Date());
                                                File antLogFile = new File(defaultLogDir, prodCode + antPlatformLogStr + "_install_" + timeStamp + ".log");
                                                this.m_antLog = antLogFile.getAbsolutePath();
                                                retVal = Configure.runInstallAntScript(prodCode, this.m_currentProdData.getProdName(), this.m_currentProdData.getProdVersion(), this.m_currentProdData.getProdCustVersion(), this.m_currentProdData.getProdMaint(), this.m_currentProdData.getProdSASRelease(), Globals.g_deploymentData.getOrder(Globals.g_order).getEncoding(), scriptFile.getAbsolutePath(), antLogFile.getAbsolutePath(), Globals.g_installData.getFilePath(), "install");
                                            } else {
                                                Logging.log.fine("Install script not found: " + scriptFile.getPath());
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            Logging.log.severe(e.getMessage());
                            Logging.logStackTrace(e);
                        }
                    }
                }
            }
            if (installRef != null && !installRef.endsWith("install.xml")) {
                if (!Globals.g_quietMode) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Chaining.this.m_panelExecute.stopTimer();
                        }
                    });
                }
            } else if (this.startTimerForITPackage(pd) && !Globals.g_quietMode) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Chaining.this.m_panelExecute.stopTimer();
                    }
                });
            }
        }
        return retVal;
    }

    private void setRegistryData(String version, String platform) {
        ProductData myprodData;
        WizardPromptedIface jrePanel;
        this.m_registryAccess.setInstallOrderNum(this.m_currentProdData.getProdCode(), version, platform, Globals.g_order);
        if (this.m_currentProdData.getProdCode().equals("base") && Globals.g_sid != null) {
            this.m_registryAccess.setInstallSetnumid(this.m_currentProdData.getProdCode(), version, platform, Globals.g_sid.getSetnumid());
        } else if ((this.m_currentProdData.getProdCode().equals("jmp") || this.m_currentProdData.getProdCode().equals("jmp64") || this.m_currentProdData.getProdCode().equals("jmpgenom") || this.m_currentProdData.getProdCode().equals("jmp64genom")) && Globals.g_jmpSID != null) {
            this.m_registryAccess.setInstallSetnumid(this.m_currentProdData.getProdCode(), version, platform, Globals.g_jmpSID.getSetnumid());
        } else if (this.m_currentProdData.getProdCode().equals("spds") && Globals.g_spdsSID != null) {
            this.m_registryAccess.setInstallSetnumid(this.m_currentProdData.getProdCode(), version, platform, Globals.g_spdsSID.getSetnumid());
        } else if (this.m_currentProdData.getProdCode().equals("simstudio") && Globals.g_simstudioSID != null) {
            this.m_registryAccess.setInstallSetnumid(this.m_currentProdData.getProdCode(), version, platform, Globals.g_simstudioSID.getSetnumid());
        } else if (this.m_currentProdData.getProdCode().equals("mominstall") && Globals.g_mominstallSID != null) {
            this.m_registryAccess.setInstallSetnumid(this.m_currentProdData.getProdCode(), version, platform, Globals.g_mominstallSID.getSetnumid());
        }
        this.m_registryAccess.setInstallDisplayName(this.m_currentProdData.getProdCode(), version, platform, this.m_currentProdData.getProdName());
        if (this.m_currentProdData.getLastPortDate().length() > 0) {
            this.m_registryAccess.setInstallLastPortDate(this.m_currentProdData.getProdCode(), version, platform, this.m_currentProdData.getLastPortDate());
        }
        this.m_registryAccess.setInstallStatus(this.m_currentProdData.getProdCode(), version, platform, Integer.toString(-1000), "", "");
        this.m_registryAccess.updateInstallTime(this.m_currentProdData.getProdCode(), version, platform);
        if ("privatejre".equalsIgnoreCase(this.m_currentProdData.getProdCode()) && ((jrePanel = (WizardPromptedIface)Globals.g_wizard.getPanel("jre")) == null || jrePanel.getLocation() == null) && (myprodData = Globals.g_deploymentData.getProduct(Globals.g_order, "javaruntime", false)) != null) {
            this.m_registryAccess.setInstallOrderNum(myprodData.getProdCode(), Globals.g_majorReleaseVersion, platform, Globals.g_order);
            this.m_registryAccess.setInstallDisplayName(myprodData.getProdCode(), Globals.g_majorReleaseVersion, platform, myprodData.getProdName());
            if (this.m_currentProdData.getLastPortDate().length() > 0) {
                this.m_registryAccess.setInstallLastPortDate(myprodData.getProdCode(), Globals.g_majorReleaseVersion, platform, myprodData.getLastPortDate());
            }
            this.m_registryAccess.setInstallStatus(myprodData.getProdCode(), Globals.g_majorReleaseVersion, platform, Integer.toString(-1000), "", "");
            this.m_registryAccess.updateInstallTime(myprodData.getProdCode(), Globals.g_majorReleaseVersion, platform);
        }
    }

    private int launchConfigScripts(String antTarget, boolean retrySetting) {
        int retVal = -1;
        this.m_antLog = "";
        String configLogsDir = null;
        configLogsDir = Globals.g_mode == 2 && !Globals.g_cmtNewConfigDir ? Globals.g_cmtConfigLogsDir : Globals.g_configData.getProperty("config.lev.logs.configure.dir", null);
        if (configLogsDir != null) {
            String prodCode = this.m_currentProdData.getProdCode();
            String prodName = this.m_currentProdData.getProdName();
            String timeStamp = null;
            this.resolveConfigProperties();
            File antScript = null;
            File antLogFile = null;
            File propertyFile = null;
            if ("reportMissingScript".equals(antTarget)) {
                antScript = new File(Globals.g_configData.getProperty("cfgwizard.config.script.file", ""));
                if (antScript != null && antScript.isFile()) {
                    propertyFile = this.saveConfigProperties(prodCode, prodName, antScript.getParent(), antTarget);
                    timeStamp = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss").format(new Date());
                    antLogFile = new File(configLogsDir, prodCode + "_" + antTarget + "_" + timeStamp + ".log");
                    retVal = Configure.runAntScript(this.m_currentProdData, antScript.getAbsolutePath(), antLogFile.getAbsolutePath(), propertyFile.getAbsolutePath(), retrySetting, antTarget);
                }
            } else {
                antScript = new File(Globals.g_configData.getProperty(prodCode + ".config.script.file", ""));
                if (antScript != null && antScript.isFile()) {
                    propertyFile = this.saveConfigProperties(prodCode, prodName, antScript.getParent(), antTarget);
                    timeStamp = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss").format(new Date());
                    antLogFile = new File(configLogsDir, prodCode + "_" + antTarget + "_" + timeStamp + ".log");
                    this.m_antLog = antLogFile.getAbsolutePath();
                    retVal = Configure.runAntScript(this.m_currentProdData, antScript.getAbsolutePath(), antLogFile.getAbsolutePath(), propertyFile.getAbsolutePath(), retrySetting, antTarget);
                    if (Globals.g_mode != 2 || Globals.g_cmtTask == 26) {
                        if (!antTarget.equalsIgnoreCase("initializeConfigDir")) {
                            this.addStatusEntries(prodCode, propertyFile, retVal);
                        }
                        if (prodCode.equalsIgnoreCase("metadatasrv")) {
                            Globals.g_msConfigured = true;
                        }
                    } else if (Globals.g_cmtTask == 5 || Globals.g_cmtTask == 11) {
                        boolean newFQID = this.updateStatusEntry(prodCode, propertyFile, retVal);
                        if (newFQID) {
                            this.loadConfigProperties();
                        }
                    } else if (prodCode.equalsIgnoreCase("metadatasrv")) {
                        if (Globals.g_cmtTask == 0) {
                            Properties instanceProps = this.m_currentProdData.getInstanceData().getProperties();
                            String adminPassword = instanceProps.getProperty("oma.person.admin.login.passwd", null);
                            if (adminPassword != null && adminPassword.length() > 0 && Globals.g_cmtConnectUser.equalsIgnoreCase(Globals.g_configData.getProperty("oma.person.admin.login.userid", ""))) {
                                Globals.g_cmtConnectPassword = adminPassword;
                            }
                        } else if (Globals.g_cmtTask == 2 && retVal == 0) {
                            Globals.g_metadataRemoved = true;
                        }
                    }
                    if (Globals.g_mode == 2 && Globals.g_cmtTask == 2 && retVal == 0) {
                        this.removeStatusEntry(this.m_currentProdData);
                    }
                    if (retVal == 0 && Globals.g_mode == 2 && Globals.g_cmtTask == 2 && prodCode.equalsIgnoreCase("cfgwizard") && antTarget.equalsIgnoreCase("unconfigure") && (Globals.g_cmtUnconfigureAll || Globals.g_metadataRemoved)) {
                        this.deleteLevdirroot(prodCode, antTarget);
                    }
                    if (retVal == 1) {
                        String target = "checkForErrors";
                        timeStamp = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss").format(new Date());
                        antLogFile = new File(configLogsDir, prodCode + "_" + target + "_" + timeStamp + ".log");
                        retVal = Configure.runAntScript(this.m_currentProdData, antScript.getAbsolutePath(), antLogFile.getAbsolutePath(), propertyFile.getAbsolutePath(), retrySetting, target);
                    }
                }
            }
            if (Globals.g_mode == 2 && (Globals.g_cmtTask == 5 || Globals.g_cmtTask == 4 || this.m_currentProdData.getType() == 5)) {
                String utilitiesDir;
                Properties objProps = MetadataAccess.getObjectProperties(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, this.m_currentProdData.getInstanceData().getFQID());
                if (objProps != null) {
                    if (this.m_currentProdData.getInstanceData().getProperties() == null) {
                        this.m_currentProdData.getInstanceData().setProperties(objProps);
                    } else {
                        String key = null;
                        String value = null;
                        Enumeration<?> e = objProps.propertyNames();
                        while (e.hasMoreElements()) {
                            key = (String)e.nextElement();
                            if (key == null || (value = objProps.getProperty(key, null)) == null) continue;
                            this.m_currentProdData.getInstanceData().getProperties().setProperty(key, value);
                            Globals.g_configData.setProperty(key, value);
                        }
                    }
                }
                if ((utilitiesDir = Globals.g_configData.getProperty("config.lev.utilities.dir", null)) != null) {
                    propertyFile = this.saveInstanceProperties(prodCode, prodName, antScript.getParent(), utilitiesDir, true);
                }
            }
        }
        return retVal;
    }

    private File saveConfigProperties(String prodCode, String prodName, String antSrcDir, String antTarget) {
        File propertyFile = null;
        if ("reportFailures".equalsIgnoreCase(antTarget)) {
            propertyFile = new File(Globals.g_tempLocation, prodCode.toLowerCase(Locale.ENGLISH) + ".configuration.properties");
        } else if (Globals.g_mode == 2 && Globals.g_processInstances) {
            propertyFile = this.saveInstanceProperties(prodCode, prodName, antSrcDir, null, false);
            if (Globals.g_debug && "updateConfigure".equalsIgnoreCase(antTarget)) {
                Utils.copyFile(propertyFile.getAbsolutePath(), Utils.joinPath(propertyFile.getParent(), "preupdate_" + propertyFile.getName()));
            }
        } else {
            Globals.g_configData.saveWithoutTokens();
            Globals.g_configData.saveWithPasswordHashes(Utils.joinPath(Utils.getSDWDataPath(false), "configRetry.properties"));
            String miniPropFile = Globals.g_configData.saveProductList(prodCode, prodName, antSrcDir, null, false);
            propertyFile = new File(miniPropFile);
            if (Globals.g_debug) {
                Utils.copyFile(miniPropFile, Utils.joinPath(propertyFile.getParent(), "preconfig_" + propertyFile.getName()));
            }
        }
        return propertyFile;
    }

    private File saveInstanceProperties(String prodCode, String prodName, String antSrcDir, String location, boolean removePasswords) {
        boolean valid = false;
        String key = null;
        String value = null;
        Properties notProps = new Properties();
        Properties props = new Properties();
        HashMap excludeList = DynamicDialogs.getSDMExcludeList(prodCode);
        Properties instanceProps = this.m_currentProdData.getInstanceData().getProperties();
        if (instanceProps != null) {
            Enumeration<Object> e = instanceProps.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                valid = Globals.g_cmtGlobalrootProps != null && Globals.g_cmtLevdirrootProps != null ? prodCode.equalsIgnoreCase("cfgwizard") || !Globals.g_cmtGlobalrootProps.containsKey(key) && !Globals.g_cmtLevdirrootProps.containsKey(key) : true;
                if (valid && removePasswords && Globals.g_configPasswords != null) {
                    boolean bl = valid = !Globals.g_configPasswords.containsKey(key);
                }
                if (!valid || (value = instanceProps.getProperty(key, null)) == null) continue;
                if (value.startsWith("@") && value.endsWith("@")) {
                    if (!Globals.g_debug) continue;
                    notProps.setProperty(key, value);
                    continue;
                }
                props.setProperty(key, value);
            }
        }
        String fqid = this.m_currentProdData.getInstanceData().getFQID();
        if (Utils.isWebAppServerCode(prodCode)) {
            props.setProperty("webappsrv.configobj.fqid", fqid);
        }
        if (!prodCode.equalsIgnoreCase(fqid)) {
            props.setProperty(prodCode + ".configobj.fqid", fqid);
        }
        String objectName = MetadataAccess.getObjectName(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, fqid);
        if (Globals.g_cmtTask == 5 && Globals.g_configDefaults.getDefault(prodCode + ".update_configobj_name", "false").equalsIgnoreCase("true") && PropertyRules.containsProperty(objectName = Globals.g_configDefaults.getDefault(prodCode + ".configobj.name", objectName))) {
            objectName = PropertyRules.resolveProperties(objectName, 0);
        }
        if (Utils.isWebAppServerCode(prodCode)) {
            props.setProperty("webappsrv.configobj.name", objectName);
        }
        props.setProperty(prodCode + ".configobj.name", objectName);
        Enumeration<Object> e = Globals.g_configData.getProperties().keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            boolean bl = valid = (Globals.g_cmtDynamicProps != null && Globals.g_cmtDynamicProps.containsKey(key) || !props.containsKey(key)) && !excludeList.containsKey(key) && (Globals.g_cmtExcludePasswds == null || !Globals.g_cmtExcludePasswds.containsKey(key));
            if (valid && removePasswords && Globals.g_configPasswords != null) {
                boolean bl2 = valid = !Globals.g_configPasswords.containsKey(key);
            }
            if (!valid || (value = Globals.g_configData.getProperty(key, null)) == null) continue;
            if (value.startsWith("@") && value.endsWith("@")) {
                if (!Globals.g_debug) continue;
                notProps.setProperty(key, value);
                continue;
            }
            props.setProperty(key, value);
        }
        if (Globals.g_cmtMachineAll != null) {
            props.setProperty("plan.machine.list", Globals.g_cmtMachineAll);
        }
        props.setProperty("iomsrv.metadatasrv.connection.is_required", "true");
        props.setProperty("iomsrv.metadatasrv.host", Globals.g_cmtConnectHost);
        props.setProperty("iomsrv.metadatasrv.port", Globals.g_cmtConnectPort);
        props.setProperty("metadata.connection.userid", Globals.g_cmtConnectUser);
        if (!removePasswords) {
            props.setProperty("metadata.connection.passwd", Globals.g_cmtConnectPassword);
        }
        if (Globals.g_cmtConnectRepos != null) {
            props.setProperty("oma.repository.foundation.name", Globals.g_cmtConnectRepos);
        }
        if (Globals.g_databaseUser != null && Globals.g_databasePassword != null) {
            props.setProperty("database.connection.userid", Globals.g_databaseUser);
            props.setProperty("database.connection.passwd", Globals.g_databasePassword);
        }
        props.setProperty("config.currprod.12byte", prodCode);
        props.setProperty("config.currprod.legalname", prodName);
        props.setProperty("install.currprod.config.dir", antSrcDir);
        props.setProperty("temp.dir", Globals.g_tempLocation);
        if (Globals.g_cmtTask == 11) {
            InstanceData instData = this.m_currentProdData.getInstanceData();
            if (instData == null) {
                Logging.log.severe("No InstanceData associated with the ProductData for 12byte: " + prodCode);
            } else {
                props.setProperty(prodCode + ".applyhotfix.from.id", instData.getHotFix());
                props.setProperty(prodCode + ".applyhotfix.to.id", instData.getNewerHotFix());
            }
        }
        if (Globals.g_cmtTask == 2 && prodCode.equalsIgnoreCase("cfgwizard")) {
            props.setProperty("config.lev.dir", Globals.g_cmtConfigDir);
            if (Globals.g_cmtUnconfigureAll) {
                props.setProperty("cfgwizard.unconfigure.all", "true");
            } else {
                props.setProperty("cfgwizard.unconfigure.all", "false");
            }
        }
        if (Globals.g_cmtTask == 2 && prodCode.equalsIgnoreCase("cfgwizard") && Globals.g_metadataRemoved) {
            props.setProperty("metadata.removed", "true");
        }
        if (Globals.g_cmtTask == 2 && prodCode.equalsIgnoreCase("cfgwizard") && Globals.g_levdirrootProps != null && Globals.g_levdirrootFQID != null) {
            e = Globals.g_levdirrootProps.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                value = Globals.g_levdirrootProps.getProperty(key, null);
                if (value == null) continue;
                props.setProperty(key, value);
            }
            props.setProperty("levdirroot.configobj.fqid", Globals.g_levdirrootFQID);
        } else if (Globals.g_levdirrootFQID != null) {
            props.setProperty("levdirroot.configobj.fqid", Globals.g_levdirrootFQID);
        }
        if (Globals.g_globalrootFQID != null) {
            props.setProperty("globalroot.configobj.fqid", Globals.g_globalrootFQID);
        }
        if (Globals.g_cmtRemoveContent != null) {
            props.setProperty("unconfigure.remove.user.content", Globals.g_cmtRemoveContent);
        }
        if (Globals.g_cmtRemoveFSContent != null) {
            props.setProperty("unconfigure.remove.fs.user.content", Globals.g_cmtRemoveFSContent);
        }
        if (Globals.g_cmtTask == 3) {
            props.setProperty("sas.setinit.file", Globals.g_sid.getSIDFile().toString());
        } else if (Globals.g_cmtTask == 5) {
            ProductData[] fromMaintData;
            String fromPropName = prodCode + ".maintenance.from.version";
            String fromVersion = null;
            fromVersion = this.m_currentProdData.getInstanceData().getNewProduct() ? "" : ((fromMaintData = Globals.g_deploymentData.getMaintenance(this.m_currentProdData.getInstanceData().getOrder(), prodCode, Utils.getOS_Suffix(), true)).length > 0 ? fromMaintData[0].getProdCustVersion() : this.m_currentProdData.getProdCustVersion());
            props.setProperty(fromPropName, fromVersion);
            String toPropName = prodCode + ".maintenance.to.version";
            String toVersion = null;
            ProductData toProdData = null;
            ProductData[] toMaintData = Globals.g_deploymentData.getMaintenance(Globals.g_order, prodCode, Utils.getOS_Suffix(), true);
            toProdData = toMaintData.length > 0 ? toMaintData[0] : Globals.g_deploymentData.getProduct(Globals.g_order, prodCode, true);
            toVersion = toProdData != null ? toProdData.getProdCustVersion() : fromVersion;
            props.setProperty(toPropName, toVersion);
        }
        if (DocPartUtils.getCurrentInstructionsFile() != null) {
            String origFile;
            if (prodCode.equalsIgnoreCase("cfgwizard") && (origFile = Globals.g_configData.getProperty("config.lev.instructions.file", null)) != null) {
                props.setProperty("config.lev.instructions.file.backup", origFile);
            }
            props.setProperty("config.lev.instructions.file", DocPartUtils.getCurrentInstructionsFile());
            props.setProperty("config.instructions.file.name", DocPartUtils.getCurrentInstructionsFileName());
        }
        props.remove(prodCode + ".previous.configobj.fqid");
        props.remove(prodCode + ".remove.status.xml.fqids");
        File propsFile = null;
        propsFile = location != null ? new File(location, prodCode.toLowerCase(Locale.ENGLISH) + ".configuration.properties") : new File(Globals.g_tempLocation, prodCode.toLowerCase(Locale.ENGLISH) + ".configuration.properties");
        try {
            FileOutputStream fos = new FileOutputStream(propsFile);
            props.store(fos, null);
            fos.close();
        }
        catch (Exception e2) {
            Logging.log.severe("Error writing configuration properties file: " + propsFile.toString());
            Logging.logStackTrace(e2);
        }
        if (Globals.g_debug && location == null) {
            File notPropsFile = new File(Globals.g_tempLocation, "not_" + propsFile.getName());
            try {
                FileOutputStream fos = new FileOutputStream(notPropsFile);
                notProps.store(fos, null);
                fos.close();
            }
            catch (Exception e3) {
                Logging.log.warning("Error saving omitted configuration properties file: " + notPropsFile.toString());
                Logging.logStackTrace(e3);
            }
        }
        return propsFile;
    }

    private void loadConfigProperties() {
        String prodCode = this.m_currentProdData.getProdCode();
        File propertyFile = new File(Globals.g_tempLocation, prodCode.toLowerCase(Locale.ENGLISH) + ".configuration.properties");
        try {
            if (propertyFile.isFile()) {
                FileInputStream fis = new FileInputStream(propertyFile);
                Properties configProps = new Properties();
                configProps.load(fis);
                fis.close();
                String key = null;
                String value = null;
                Enumeration<Object> e = configProps.keys();
                while (e.hasMoreElements()) {
                    key = (String)e.nextElement();
                    value = Globals.g_configData.getProperty(key, null);
                    if (value != null && (!value.startsWith("@") || !value.endsWith("@")) || (value = configProps.getProperty(key, null)) == null) continue;
                    Globals.g_configData.setProperty(key, value);
                }
            } else {
                Logging.log.info("Properties file does not exist: " + propertyFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            Logging.log.warning("Error loading properties file: " + propertyFile.getAbsolutePath());
            Logging.logStackTrace(e);
        }
    }

    private void addStatusEntries(String prodCode, File propertyFile, int retVal) {
        try {
            if (propertyFile.isFile()) {
                FileInputStream fis = new FileInputStream(propertyFile);
                Properties configProps = new Properties();
                configProps.load(fis);
                fis.close();
                String key = null;
                String fqid = null;
                String code = null;
                boolean found = false;
                Enumeration<Object> e = configProps.keys();
                while (e.hasMoreElements()) {
                    key = (String)e.nextElement();
                    if (key == null || !key.endsWith(".fqid") || !key.contains(".configobj") || (fqid = configProps.getProperty(key, null)) == null) continue;
                    code = key.substring(0, key.indexOf("."));
                    if (Globals.g_configStatus.setStatus(fqid, code, Globals.g_order)) {
                        Logging.log.info("Status entry created for " + code + ": " + fqid);
                    } else if (Globals.g_configStatus.updateOrder(fqid, Globals.g_order)) {
                        Logging.log.info("Order updated for " + fqid + ": " + Globals.g_order);
                    }
                    if (!code.equalsIgnoreCase(prodCode)) continue;
                    found = true;
                }
                if (!found && (retVal == 0 || retVal == 5) && Globals.g_configStatus.setStatus(prodCode, prodCode, Globals.g_order)) {
                    Logging.log.info("Status entry created for " + prodCode + ": " + prodCode);
                }
                Globals.g_configStatus.write();
            } else {
                Logging.log.info("Properties file does not exist: " + propertyFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            Logging.log.warning("Error loading properties file: " + propertyFile.getAbsolutePath());
            Logging.logStackTrace(e);
        }
    }

    private boolean removeStatusEntry(ProductData productData) {
        String fqid;
        String name;
        InstanceData instanceData;
        boolean success = false;
        if (productData != null && (instanceData = productData.getInstanceData()) != null && ((name = MetadataAccess.getObjectName(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, fqid = instanceData.getFQID())) == null || name.length() == 0)) {
            success = Globals.g_configStatus.removeStatusEntry(fqid);
        }
        if (success) {
            Globals.g_configStatus.write();
        }
        return success;
    }

    private boolean updateStatusEntry(String prodCode, File propertyFile, int retVal) {
        boolean newFQID = false;
        try {
            if (propertyFile.isFile()) {
                FileInputStream fis = new FileInputStream(propertyFile);
                Properties configProps = new Properties();
                configProps.load(fis);
                fis.close();
                String configobjFQID = null;
                String configobjFQIDchangedFrom = null;
                String configobjVersion = null;
                String removeStatusXmlFqidsList = null;
                if (prodCode.equalsIgnoreCase("cfgwizard")) {
                    configobjVersion = configProps.getProperty("levdirroot.configobj.version", null);
                } else {
                    configobjFQID = configProps.getProperty(prodCode + ".configobj.fqid", null);
                    configobjFQIDchangedFrom = configProps.getProperty(prodCode + ".previous.configobj.fqid", null);
                    configobjVersion = configProps.getProperty(prodCode + ".configobj.version", null);
                    removeStatusXmlFqidsList = configProps.getProperty(prodCode + ".remove.status.xml.fqids", null);
                }
                InstanceData instData = this.m_currentProdData.getInstanceData();
                String fqid = instData.getFQID();
                String hotfix = instData.getHotFix();
                String hotfixdate = instData.getHotFixDate();
                Logging.log.info("prodCode '" + prodCode + "'  configobjFQID '" + configobjFQID + "'  configobjFQIDchangedFrom '" + configobjFQIDchangedFrom + "'  configobjVersion '" + configobjVersion + "'  fqid '" + fqid + "'  hotfix '" + hotfix + "'  hotfixdate '" + hotfixdate + "'  ");
                if (null != configobjFQID && null != configobjFQIDchangedFrom && configobjFQID.length() == 17 && configobjFQIDchangedFrom.length() == 17 && !configobjFQIDchangedFrom.equals(configobjFQID)) {
                    boolean fqidUpdated = Globals.g_configStatus.updateFQID(configobjFQIDchangedFrom, configobjFQID);
                    instData.setFQID(configobjFQID);
                    fqid = configobjFQID;
                    if (fqidUpdated) {
                        Globals.g_configStatus.write();
                        Logging.log.info("Status entry and instData updated from fqid " + configobjFQIDchangedFrom + " to fqid " + configobjFQID + " for " + prodCode);
                    } else {
                        Logging.log.info("instData was updated, but the status entry was NOT updated from fqid " + configobjFQIDchangedFrom + " to fqid " + configobjFQID + " for " + prodCode);
                    }
                }
                if (retVal == 0 && Globals.g_cmtTask == 11) {
                    if (instData.hasNewerHotFix()) {
                        hotfix = instData.getNewerHotFix();
                    }
                    hotfixdate = this.DEFAULT_DATE_FORMAT.format(new Date());
                }
                if (configobjFQID != null && !configobjFQID.equalsIgnoreCase(fqid)) {
                    if (Globals.g_configStatus.setStatus(configobjFQID, prodCode, Globals.g_order, hotfix, hotfixdate)) {
                        Logging.log.info("Status entry created for " + prodCode + ": " + configobjFQID);
                    }
                    Globals.g_configStatus.write();
                    instData.setFQID(configobjFQID);
                    instData.setHotFix(hotfix);
                    instData.setHotFixDate(hotfixdate);
                    newFQID = true;
                } else if (Globals.g_cmtTask == 5) {
                    String maintToVersion = configProps.getProperty(prodCode + ".maintenance.to.version", null);
                    if (configobjVersion != null && maintToVersion != null && configobjVersion.equals(maintToVersion) && fqid != null) {
                        Globals.g_configStatus.updateOrder(fqid, Globals.g_order);
                        if (prodCode.equalsIgnoreCase("cfgwizard") && Globals.g_levdirrootFQID != null) {
                            Globals.g_configStatus.updateOrder(Globals.g_levdirrootFQID, Globals.g_order);
                        }
                        Globals.g_configStatus.write();
                        Logging.log.info("Status entry updated to order " + Globals.g_order + " for " + prodCode + ": " + fqid);
                    }
                } else if (Globals.g_cmtTask == 11 && fqid != null) {
                    Globals.g_configStatus.setStatus(fqid, prodCode, instData.getOrder(), hotfix, hotfixdate);
                    Globals.g_configStatus.write();
                    Logging.log.info("Status entry updated with hot fix \"" + hotfix + "\" for " + prodCode + ": " + fqid);
                }
                if (null != removeStatusXmlFqidsList) {
                    boolean bl = this.removeStatusXmlFqids(prodCode, removeStatusXmlFqidsList);
                }
            } else {
                Logging.log.info("Properties file does not exist: " + propertyFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            Logging.log.warning("Error loading properties file: " + propertyFile.getAbsolutePath());
            Logging.logStackTrace(e);
        }
        return newFQID;
    }

    private boolean removeStatusXmlFqids(String prodCode, String removeStatusXmlFqidsList) {
        boolean removedStatusXmlFqids = false;
        Logging.log.info("Remove the following FQIDs from the status.xml:  '" + removeStatusXmlFqidsList + "' as requested by prodCode " + prodCode);
        StringTokenizer tokens = new StringTokenizer(removeStatusXmlFqidsList, ",");
        int i = 0;
        while (tokens.hasMoreTokens()) {
            String fqidToRemove = tokens.nextToken();
            if (fqidToRemove.length() == 17) {
                boolean fqidRemoved = Globals.g_configStatus.removeStatusEntry(fqidToRemove);
                if (fqidRemoved) {
                    removedStatusXmlFqids = true;
                    Logging.log.info("FQID was removed from the status.xml:  '" + fqidToRemove + "' as requested by prodCode " + prodCode);
                } else {
                    Logging.log.warning("FQID was NOT removed from the status.xml:  '" + fqidToRemove + "' as requested by prodCode " + prodCode);
                }
            } else {
                Logging.log.warning("FQID was NOT removed from the status.xml because of bad length:  '" + fqidToRemove + "' as requested by prodCode " + prodCode);
            }
            ++i;
        }
        if (removedStatusXmlFqids) {
            Globals.g_configStatus.write();
        }
        return removedStatusXmlFqids;
    }

    private boolean checkSASPermissions() {
        boolean valid = true;
        boolean updateMode = false;
        if (Globals.g_cmtTask == 5) {
            updateMode = true;
        }
        if (Utils.getOS() != 1 && Utils.getOS() != 8) {
            boolean sasInstalled = false;
            if (Globals.g_machine != null) {
                String[] components = Globals.g_machine.getDeployedComponentIds();
                for (int i = 0; i < components.length && !sasInstalled; ++i) {
                    if (!components[i].equalsIgnoreCase("sasinstall")) continue;
                    sasInstalled = true;
                }
            }
            if (sasInstalled || updateMode) {
                String sasInstallLoc = null;
                ProductData sasProdData = null;
                sasProdData = Globals.g_sasinstallPlat != null ? Globals.g_deploymentData.getProduct(Globals.g_order, "base", Globals.g_sasinstallPlat, true) : Globals.g_deploymentData.getProduct(Globals.g_order, "base", true);
                if (sasProdData != null && this.m_registryAccess != null && this.m_registryAccess.open()) {
                    if (Globals.g_sasinstallPlat != null) {
                        sasInstallLoc = this.m_registryAccess.getInstallLoc("base", sasProdData.getProdVersion(), Globals.g_sasinstallPlat);
                        if (sasInstallLoc == null) {
                            sasInstallLoc = this.m_registryAccess.getInstallLoc("base", "default", Globals.g_sasinstallPlat);
                        }
                    } else {
                        sasInstallLoc = this.m_registryAccess.getInstallLoc("base", sasProdData.getProdVersion());
                        if (sasInstallLoc == null) {
                            sasInstallLoc = this.m_registryAccess.getInstallLoc("base", "default");
                        }
                    }
                    this.m_registryAccess.close();
                }
                if (sasInstallLoc != null) {
                    Logging.log.info("Checking SAS file permissions: " + sasInstallLoc);
                    File scriptFile = new File(Utils.joinPath(sasInstallLoc, "utilities", "bin"), "elsconf");
                    if (scriptFile.exists()) {
                        String[] command = new String[]{"/bin/sh", "-c", "./" + scriptFile.getName()};
                        try {
                            int action = 1;
                            while (action == 1) {
                                String installerPwd;
                                String setuid = null;
                                File setuidFile = new File(Utils.joinPath(sasInstallLoc, "utilities", "bin"), "setuid.sh");
                                if (setuidFile.isFile()) {
                                    setuid = setuidFile.toString();
                                }
                                if ((installerPwd = Globals.g_configData.getProperty("config.sudo.setuid.passwd", "")).length() > 0 && Globals.g_configData.getProperty("config.sudo.setuid.is_enabled", "false").equalsIgnoreCase("true")) {
                                    String[] setuidCommand = new String[]{"sudo", "-S", setuid};
                                    Logging.log.info("Attempting to run setuid command: " + Utils.concatArray(setuidCommand, " "));
                                    Utils.ProcessData processData = Utils.runProcess(setuidCommand, true, SasPasswordString.decode(installerPwd));
                                }
                                Process p = Runtime.getRuntime().exec(command, null, scriptFile.getParentFile());
                                p.waitFor();
                                int retVal = p.exitValue();
                                if (retVal != 0) {
                                    if (Globals.g_consoleMode) {
                                        ConsoleMode.busyMsgStop();
                                    }
                                    if ((action = this.m_panelExecute.promptForPermissions(setuid)) == 0) {
                                        this.m_abort = true;
                                    }
                                    if (!Globals.g_consoleMode) continue;
                                    ConsoleMode.busyMsgStart("");
                                    continue;
                                }
                                action = 2;
                                Logging.log.info("Critical SAS files have setuid permissions.");
                            }
                        }
                        catch (Exception e) {
                            Logging.logStackTrace(e);
                        }
                    }
                } else {
                    Logging.log.warning("Critical SAS Files were not found to check setuid permissions.");
                }
            }
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executePermsScript(String path) {
        String script = "perms.sh";
        String sasHomePath = Globals.g_wizardData.getPreference("SASHome", "");
        File scriptFile = new File(Utils.joinPath(sasHomePath, script));
        String copyScriptPath = Globals.g_setupLocation;
        File copyScript = new File(Utils.joinPath(copyScriptPath, script));
        if (Utils.getOS() != 1 && Utils.getOS() != 8 && Utils.getOS() != 6 && sasHomePath != null) {
            String content = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(copyScript);
                byte[] by = new byte[fis.available()];
                fis.read(by);
                content = new String(by);
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {
                        Logging.logStackTrace(e);
                    }
                }
            }
            if (content != null) {
                content = content.replaceAll("<INSTALL_DIR>", path);
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(scriptFile);
                    byte[] bt = content.getBytes();
                    fos.write(bt);
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception e) {
                            Logging.logStackTrace(e);
                        }
                    }
                }
                try {
                    FileMode md = new FileMode(scriptFile);
                    md.setPerm(448);
                    md.commit();
                    if (scriptFile.isFile()) {
                        String[] command = new String[]{"/bin/sh", "-c", scriptFile.toString()};
                        Process p = Runtime.getRuntime().exec(command);
                        p.waitFor();
                        int retVal = p.exitValue();
                        if (retVal != 0) {
                            Logging.log.warning("Error running perms.sh script. Exit code: " + p.exitValue());
                        } else {
                            Logging.log.info("Permissions set. Script perms.sh executed successfully on " + path);
                        }
                    } else {
                        Logging.log.warning("perms.sh file could not be found at SASHome: " + sasHomePath);
                    }
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCurrentProductOrderInstallDirs() {
        try {
            if (this.m_registryAccess != null && this.m_registryAccess.open()) {
                String logMsg = "";
                String order = this.m_currentProdData.getOrder();
                ProductData[] products = Globals.g_deploymentData.getProdsForPlat(order, Utils.getOS_Suffix(), true);
                for (int i = 0; i < products.length; ++i) {
                    String code = products[i].getProdCode();
                    String prodVersion = products[i].getProdVersion();
                    String prodName = products[i].getProdName();
                    String platform = products[i].getPlatform();
                    String location = null;
                    String currentInstallDir = Globals.g_configData.getProperty(code + ".install.dir", "");
                    if (currentInstallDir != "") continue;
                    location = this.m_registryAccess.getInstallLoc(code, prodVersion, platform);
                    if (location == null) {
                        location = this.m_registryAccess.getInstallLoc(code, "default", platform);
                    }
                    if (location != null) {
                        logMsg = String.format("Setting %s.install.dir to %s using the deployment registry.", code, location);
                        Logging.log.info(logMsg);
                        Globals.g_configData.setSDWProperty(code + ".install.dir", location);
                    } else {
                        logMsg = String.format("Not setting %s.install.dir as the value is not defined in the deployment registry.", code);
                        Logging.log.info(logMsg);
                    }
                    String displayName = this.m_registryAccess.getInstallDisplayName(code, prodVersion, platform);
                    if (displayName != null) {
                        logMsg = String.format("Setting %s.legal.name to %s using the deployment registry.", code, displayName);
                        Logging.log.info(logMsg);
                        Globals.g_configData.setSDWProperty(code + ".legal.name", displayName);
                    } else {
                        logMsg = String.format("Setting %s.legal.name to %s using product data from the order %s.", code, prodName, order);
                        Logging.log.info(logMsg);
                        Globals.g_configData.setSDWProperty(code + ".legal.name", prodName);
                    }
                    logMsg = String.format("Setting %s.version to %s using product data from the order %s.", code, prodVersion, order);
                    Logging.log.info(logMsg);
                    Globals.g_configData.setSDWProperty(code + ".version", prodVersion);
                }
            }
        }
        catch (Exception e) {
            Logging.log.severe(e.getMessage());
            Logging.logStackTrace(e);
        }
        finally {
            if (this.m_registryAccess != null) {
                this.m_registryAccess.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveConfigData() {
        DialogData dialogData;
        File configBundle;
        if (Globals.g_consoleMode) {
            Globals.g_configData.setSDWProperty("console.mode.is_enabled", "TRUE");
        }
        if (Globals.g_quietMode) {
            Globals.g_configData.setSDWProperty("quiet.mode.is_enabled", "TRUE");
        }
        String cfgwizardLoc = null;
        String deploywizLoc = null;
        if (Globals.g_mode == 2) {
            if (Globals.g_cmtTask == 26) {
                Globals.g_configData.setSDWProperty("config.object.properties.are_set", "True");
            } else {
                Globals.g_configData.setSDWProperty("config.object.properties.are_set", "False");
            }
            cfgwizardLoc = new File(Utils.getSDMHome(Globals.g_cmtSASHome) + File.separator + "products", Globals.g_deploymentData.getNewestSpsSku("cfgwizard", null, false).getSpsSku()).getAbsolutePath();
            Globals.g_configData.setSDWProperty("cfgwizard.install.dir", cfgwizardLoc);
            deploywizLoc = new File(Utils.getSDMHome(Globals.g_cmtSASHome), Globals.g_deploymentData.getProductDir(Globals.g_order, "deploywiz", true, false)).getAbsolutePath();
            Globals.g_configData.setSDWProperty("deploywiz.install.dir", deploywizLoc);
            configBundle = new File(Utils.getSDMHome(Globals.g_cmtSASHome) + File.separator + "product_data" + File.separator + Globals.g_deploymentData.getNewestSpsSku("cfgwizard", null, true).getSpsSku() + File.separator + "configure", "configBundle.xml");
            if (!configBundle.exists()) {
                configBundle = new File(DialogData.getLevUtilitiesConfigBundlePath());
                if (!this.m_hasSavedConfigBundle) {
                    try {
                        dialogData = DialogData.getConfigDialogData();
                        dialogData.writeToFile(configBundle);
                        this.m_hasSavedConfigBundle = true;
                        Logging.log.info("Successfully wrote configBundle.xml to /Lev/Utilities/ dir: " + configBundle.getAbsolutePath());
                    }
                    catch (Exception e) {
                        Logging.log.severe("Error writing configBundle.xml to /Lev/Utilities/ dir: " + configBundle.getAbsolutePath());
                        Logging.logStackTrace(e);
                    }
                }
            }
            Globals.g_configData.setSDWProperty("configuration.configbundle.file", configBundle.getAbsolutePath());
        } else {
            Globals.g_configData.setSDWProperty("config.object.properties.are_set", "True");
            cfgwizardLoc = new File(Utils.getSDMHome(Globals.g_wizardData.getPreference("SASHome", "")), Globals.g_deploymentData.getProductDir(Globals.g_order, "cfgwizard", true, false)).getAbsolutePath();
            Globals.g_configData.setSDWProperty("cfgwizard.install.dir", cfgwizardLoc);
            deploywizLoc = new File(Utils.getSDMHome(Globals.g_wizardData.getPreference("SASHome", "")), Globals.g_deploymentData.getProductDir(Globals.g_order, "deploywiz", true, false)).getAbsolutePath();
            Globals.g_configData.setSDWProperty("deploywiz.install.dir", deploywizLoc);
            configBundle = new File(Utils.joinPath(Globals.g_deploymentData.getProductDataDir(Globals.g_order, "cfgwizard", true, true), "configure", "configBundle.xml"));
            if (!configBundle.exists()) {
                configBundle = new File(DialogData.getTempConfigBundlePath());
                if (!this.m_hasSavedConfigBundle) {
                    try {
                        dialogData = DialogData.getConfigDialogData();
                        dialogData.writeToFile(configBundle);
                        this.m_hasSavedConfigBundle = true;
                        Logging.log.info("Successfully wrote configBundle.xml to temp dir: " + configBundle.getAbsolutePath());
                    }
                    catch (Exception e) {
                        Logging.log.severe("Error writing configBundle.xml to temp dir: " + configBundle.getAbsolutePath());
                        Logging.logStackTrace(e);
                    }
                }
            }
            Globals.g_configData.setSDWProperty("configuration.configbundle.file", configBundle.getAbsolutePath());
        }
        try {
            if (this.m_registryAccess != null && this.m_registryAccess.open()) {
                String displayName;
                String location;
                String version;
                String code;
                ProductData sasinstallData;
                ArrayList<String> mvaProductExclusions = new ArrayList<String>();
                if (Globals.g_sasinstallPlat != null && (sasinstallData = Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", true)) != null) {
                    mvaProductExclusions.add(sasinstallData.getSpsSku());
                    String[] mvaSkus = Globals.g_deploymentData.getOrder(Globals.g_order).getMVAAltSkus(sasinstallData.getSpsSku());
                    if (mvaSkus != null && mvaSkus.length > 0) {
                        mvaProductExclusions.addAll(Arrays.asList(Globals.g_deploymentData.getOrder(Globals.g_order).getMVAAltSkus(sasinstallData.getSpsSku())));
                    }
                }
                ProductData[] products = Globals.g_deploymentData.getProdsForPlat(Globals.g_order, Utils.getOS_Suffix(), true);
                for (int i = 0; i < products.length; ++i) {
                    String beaHome;
                    code = products[i].getProdCode();
                    version = products[i].getProdVersion();
                    String platform = products[i].getPlatform();
                    location = null;
                    if (!mvaProductExclusions.contains(products[i].getSpsSku())) {
                        if (products[i].getPrompt() || code.equalsIgnoreCase("javaruntime")) {
                            location = this.m_registryAccess.getInstallLoc(code, Globals.g_majorReleaseVersion);
                        } else if (code.equalsIgnoreCase("privatejre")) {
                            Logging.log.fine("os=" + Utils.getOS_Suffix());
                            Logging.log.fine("sas platform=" + Globals.g_sasinstallPlat);
                            if (Utils.getOS_Suffix() == "wx6") {
                                if (Globals.g_sasinstallPlat == null) {
                                    location = this.m_registryAccess.getInstallLoc(code, version, "wx6");
                                    if (location == null) {
                                        location = this.m_registryAccess.getInstallLoc(code, version, "win");
                                        Globals.g_sasinstallPlat = "win";
                                    }
                                } else {
                                    location = this.m_registryAccess.getInstallLoc(code, version, Globals.g_sasinstallPlat);
                                }
                            } else {
                                location = this.m_registryAccess.getInstallLoc(code, version, platform);
                            }
                        } else if (code.equalsIgnoreCase("jmp") && Globals.g_jmpPlat != null) {
                            location = this.m_registryAccess.getInstallLoc(code, version, Globals.g_jmpPlat);
                            if (location == null) {
                                location = this.m_registryAccess.getInstallLoc(code, "default", Globals.g_jmpPlat);
                            }
                        } else if (code.equalsIgnoreCase("pcfilesrv") && Globals.g_pcfilesrvPlat != null) {
                            location = this.m_registryAccess.getInstallLoc(code, version, Globals.g_pcfilesrvPlat);
                            if (location == null) {
                                location = this.m_registryAccess.getInstallLoc(code, "default", Globals.g_pcfilesrvPlat);
                            }
                        } else if (code.equalsIgnoreCase("eguide") && Globals.g_eguidePlat != null) {
                            location = this.m_registryAccess.getInstallLoc(code, version, Globals.g_eguidePlat);
                            if (location == null) {
                                location = this.m_registryAccess.getInstallLoc(code, "default", Globals.g_eguidePlat);
                            }
                        } else if (code.equalsIgnoreCase("msofficeint") && Globals.g_msofficeintPlat != null) {
                            location = this.m_registryAccess.getInstallLoc(code, version, Globals.g_msofficeintPlat);
                            if (location == null) {
                                location = this.m_registryAccess.getInstallLoc(code, "default", Globals.g_msofficeintPlat);
                            }
                        } else if (code.equalsIgnoreCase("msoffintva") && Globals.g_msoffintvaPlat != null) {
                            location = this.m_registryAccess.getInstallLoc(code, version, Globals.g_msoffintvaPlat);
                            if (location == null) {
                                location = this.m_registryAccess.getInstallLoc(code, "default", Globals.g_msoffintvaPlat);
                            }
                        } else {
                            location = this.m_registryAccess.getInstallLoc(code, version, platform);
                            if (location == null) {
                                location = this.m_registryAccess.getInstallLoc(code, "default", platform);
                            }
                        }
                        if (code.equalsIgnoreCase("weblogic") && (beaHome = ThirdParty.getBEAHomePath(location)) == null) {
                            location = ThirdParty.getWebLogicPath(location);
                        }
                    }
                    if (location == null) continue;
                    Globals.g_configData.setSDWProperty(code + ".install.dir", location);
                    Globals.g_configData.setSDWProperty(code + ".version", version);
                    displayName = this.m_registryAccess.getInstallDisplayName(code, version, platform);
                    if (displayName != null) {
                        Globals.g_configData.setSDWProperty(code + ".legal.name", displayName);
                    }
                    if (code.equalsIgnoreCase("base")) {
                        if (Utils.getOS() == 8) {
                            Globals.g_configData.setSDWProperty("sasinstall.install.dir", Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), "SASFoundation", version));
                        } else {
                            Globals.g_configData.setSDWProperty("sasinstall.install.dir", location);
                        }
                        Globals.g_configData.setSDWProperty("sasinstall.version", version);
                        if (displayName != null) {
                            Globals.g_configData.setSDWProperty("sasinstall.legal.name", "SAS Foundation");
                        }
                    }
                    if (code.equalsIgnoreCase("javaruntime")) {
                        if (Globals.g_jreHome == null) {
                            Globals.g_jreHome = location;
                        }
                        Logging.log.fine("buildJavaCommand=" + Utils.buildJavaCommand(location));
                        Globals.g_configData.setSDWProperty("java.jre.command", Utils.buildJavaCommand(location));
                        continue;
                    }
                    if (code.equalsIgnoreCase("weblogic")) {
                        String selectedVer;
                        if (Globals.g_configData.getProperty("bea.home.dir", null) == null && (beaHome = ThirdParty.getBEAHomePath(location)) != null) {
                            Globals.g_configData.setSDWProperty("bea.home.dir", beaHome);
                        }
                        if (Globals.g_configData.getProperty(code + ".selected.version", null) != null || (selectedVer = ThirdParty.getVersion(code, location, true)) == null) continue;
                        Globals.g_configData.setSDWProperty(code + ".selected.version", selectedVer);
                        continue;
                    }
                    if (!code.equalsIgnoreCase("websphereba") && !code.equalsIgnoreCase("webspherend")) continue;
                    HashMap<String, String> extractedIdentifiers = null;
                    String selectedVer = null;
                    selectedVer = ThirdParty.getVersion(code, location, true);
                    extractedIdentifiers = selectedVer != null ? ThirdParty.extractWebsphereVersionIdentifiers(selectedVer) : ThirdParty.extractWebsphereVersionIdentifiers(version);
                    for (String identifier : extractedIdentifiers.keySet()) {
                        Globals.g_configData.setSDWProperty(identifier, extractedIdentifiers.get(identifier));
                    }
                }
                if (Globals.g_configData.getProperty("jdk.install.dir", null) == null) {
                    String webSphereDir = null;
                    webSphereDir = Globals.g_configData.getProperty("webspherend.install.dir", null);
                    if (webSphereDir == null) {
                        webSphereDir = Globals.g_configData.getProperty("websphereba.install.dir", null);
                    }
                    if (webSphereDir != null) {
                        Globals.g_configData.setSDWProperty("jdk.install.dir", JREData.getPrivateJavaCommand());
                    }
                }
                if (Globals.g_sasinstallPlat != null) {
                    products = Globals.g_deploymentData.getProdsForPlat(Globals.g_order, Globals.g_sasinstallPlat, true);
                    for (int i = 0; i < products.length; ++i) {
                        code = products[i].getProdCode();
                        version = products[i].getProdVersion();
                        location = null;
                        location = this.m_registryAccess.getInstallLoc(code, version, Globals.g_sasinstallPlat);
                        if (location == null) {
                            location = this.m_registryAccess.getInstallLoc(code, "default", Globals.g_sasinstallPlat);
                        }
                        if (location == null) continue;
                        Globals.g_configData.setSDWProperty(code + ".install.dir", location);
                        Globals.g_configData.setSDWProperty(code + ".version", version);
                        displayName = this.m_registryAccess.getInstallDisplayName(code, version, Globals.g_sasinstallPlat);
                        if (displayName != null) {
                            Globals.g_configData.setSDWProperty(code + ".legal.name", displayName);
                        }
                        if (!code.equalsIgnoreCase("base")) continue;
                        if (Utils.getOS() == 8) {
                            Globals.g_configData.setSDWProperty("sasinstall.install.dir", Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), "SASFoundation", version));
                        } else {
                            Globals.g_configData.setSDWProperty("sasinstall.install.dir", location);
                        }
                        Globals.g_configData.setSDWProperty("sasinstall.version", version);
                        if (displayName == null) continue;
                        Globals.g_configData.setSDWProperty("sasinstall.legal.name", "SAS Foundation");
                    }
                }
                if (Utils.getOS() == 8) {
                    products = Globals.g_deploymentData.getProdsForPlat(Globals.g_order, "z64", true);
                    for (int i = 0; i < products.length; ++i) {
                        code = products[i].getProdCode();
                        version = products[i].getProdVersion();
                        location = null;
                        if (!code.equalsIgnoreCase("base")) continue;
                        location = this.m_registryAccess.getInstallLoc(code, version, "z64");
                        if (location == null) {
                            location = this.m_registryAccess.getInstallLoc(code, "default", "z64");
                        }
                        if (location == null) continue;
                        Logging.log.info("Install property set for z64.high.level.qualifier: " + location);
                        Globals.g_configData.setSDWProperty("z64.high.level.qualifier", location);
                    }
                }
            }
        }
        catch (Exception e) {
            Logging.log.severe(e.getMessage());
            Logging.logStackTrace(e);
        }
        finally {
            if (this.m_registryAccess != null) {
                this.m_registryAccess.close();
            }
        }
        String productCode = null;
        String displayName = null;
        ProductData[] products = Globals.g_deploymentData.getAllProducts(Globals.g_order, true);
        for (int i = 0; i < products.length; ++i) {
            productCode = products[i].getProdCode();
            displayName = Globals.g_configData.getProperty(productCode + ".legal.name", null);
            if (displayName != null) continue;
            Globals.g_configData.setSDWProperty(productCode + ".legal.name", products[i].getProdName());
            Globals.g_configData.setSDWProperty(productCode + ".version", products[i].getProdVersion());
        }
        if (Globals.g_vjrHome != null) {
            Globals.g_configData.setSDWProperty("vjr.install.dir", Globals.g_vjrHome);
        }
        if (Globals.g_configData.getProperty("config.migration.is_selected", "False").equalsIgnoreCase("False")) {
            Globals.g_configData.setSDWProperty("configure.target.enabled", "True");
        }
        Globals.g_configDefaults.save(Utils.joinPath(Globals.g_tempLocation, "all_config_default.properties"));
        String name = null;
        String value = null;
        Enumeration e = Globals.g_configDefaults.getNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            if (Globals.g_configKnownProps != null && Globals.g_configKnownProps.containsKey(name)) continue;
            value = Globals.g_configDefaults.getDefault(name, null);
            if (Globals.g_mode == 2) {
                if (value == null || Globals.g_configData.getProperty(name, null) != null) continue;
                Globals.g_configData.setProperty(name, value);
                continue;
            }
            if (value == null) continue;
            Globals.g_configData.setProperty(name, value);
        }
        if (Utils.getOS() == 8) {
            String sasHomeLoc = null;
            sasHomeLoc = Globals.g_mode == 2 ? Utils.joinPath(Globals.g_cmtSASHome, "install.properties") : Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), "install.properties");
            File mvsPropsFile = new File(sasHomeLoc);
            if (mvsPropsFile.isFile()) {
                Properties m_mvsInstallProperties = new Properties();
                Logging.log.info("Load mvs install properties file: " + mvsPropsFile.toString());
                try {
                    FileInputStream fis = new FileInputStream(mvsPropsFile);
                    m_mvsInstallProperties.load(fis);
                    fis.close();
                }
                catch (Exception e2) {
                    Logging.log.severe("Error loading mvs install properties file: " + mvsPropsFile.toString());
                    Logging.logStackTrace(e2);
                }
                Enumeration<?> e3 = m_mvsInstallProperties.propertyNames();
                while (e3.hasMoreElements()) {
                    name = (String)e3.nextElement();
                    value = m_mvsInstallProperties.getProperty(name, null);
                    if (value == null || !name.startsWith("zos.") && !name.startsWith("z64.") && !name.equalsIgnoreCase("cntl.qualifier")) continue;
                    Globals.g_configData.setSDWProperty(name, value);
                }
            } else {
                Logging.log.severe("Unable to find mvs install properties file: " + mvsPropsFile.toString());
            }
        }
        if (Globals.g_mode == 2 && !Globals.g_cmtNewConfigDir) {
            File dirFile;
            if (Globals.g_cmtConfigLogsDir != null && !(dirFile = new File(Globals.g_cmtConfigLogsDir)).isDirectory() && !dirFile.mkdirs()) {
                Logging.log.severe("Error creating configuration logs directory: " + dirFile.getPath());
            }
        } else {
            String dir = Globals.g_configData.getProperty("config.lev.logs.configure.dir", "");
            File dirFile = new File(dir);
            if (!dirFile.isDirectory() && !dirFile.mkdirs()) {
                Logging.log.severe("Error creating configuration logs directory: " + dir);
            }
            if (Globals.g_migrate) {
                File tempDir = new File(Globals.g_tempLocation);
                File[] tempFiles = tempDir.listFiles();
                File destFile = null;
                String fileName = null;
                String newName = null;
                String timeStamp = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss").format(new Date());
                for (int i = 0; i < tempFiles.length; ++i) {
                    if (!tempFiles[i].isFile() || !(fileName = tempFiles[i].getName()).toLowerCase(Locale.ENGLISH).endsWith("_gendefaults.log")) continue;
                    newName = fileName.substring(0, fileName.length() - 4) + "_" + timeStamp + ".log";
                    destFile = new File(dir, newName);
                    Utils.copyFile(tempFiles[i], destFile);
                }
            }
            if (!(dirFile = new File(dir = Globals.g_configData.getProperty("config.lev.utilities.dir", ""))).isDirectory() && !dirFile.mkdirs()) {
                Logging.log.severe("Error creating configuration utilities directory: " + dir);
            }
            if (Globals.g_migrate) {
                File destFile;
                File schemaFile = new File(Globals.g_configData.getProperty("config.migration.schema.file", ""));
                if (schemaFile.isFile() && !schemaFile.equals(destFile = new File(dir, "schema.xml"))) {
                    if (Utils.copyFile(schemaFile, destFile) == 0) {
                        Globals.g_configData.setSDWProperty("config.migration.schema.file", destFile.getAbsolutePath());
                    } else {
                        Logging.log.severe("Error copying migration schema file: " + schemaFile.getAbsolutePath() + " -> " + destFile.getAbsolutePath());
                    }
                }
                if (Globals.g_configStatus != null) {
                    File cfgStatus = Globals.g_configStatus.getFile();
                    ProductData prodData = Globals.g_deploymentData.getProduct(Globals.g_order, "sasinstall", true);
                    if (prodData != null) {
                        String sourceVersion = Globals.g_configData.getProperty("config.migration.sas.version", "");
                        String targetVersion = prodData.getProdSASRelease();
                        Logging.log.info("Migration source version: " + sourceVersion);
                        Logging.log.info("Migration target version: " + targetVersion);
                        if (sourceVersion.equalsIgnoreCase(targetVersion)) {
                            File smuMachine = new File(Globals.g_configData.getProperty("config.migration.package.tier.dir", ""));
                            if (smuMachine.isDirectory()) {
                                File smuStatus = new File(smuMachine, "status.xml");
                                if (smuStatus.isFile()) {
                                    ConfigStatus smuStatusData = null;
                                    try {
                                        smuStatusData = new ConfigStatus(smuStatus);
                                    }
                                    catch (Exception e4) {
                                        Logging.logStackTrace(e4);
                                    }
                                    if (smuStatusData != null) {
                                        ConfigStatus.StatusEntry[] smuStatusEntries = smuStatusData.getStatusEntries();
                                        ConfigStatus.StatusEntry[] statusEntries = Globals.g_configStatus.getStatusEntries();
                                        if (smuStatusEntries != null && statusEntries != null && Globals.g_planConfigs != null) {
                                            if (!cfgStatus.getParentFile().isDirectory()) {
                                                cfgStatus.getParentFile().mkdirs();
                                            }
                                            String prodToConfig = null;
                                            for (int i = 0; i < Globals.g_planConfigs.length; ++i) {
                                                int j;
                                                prodToConfig = Globals.g_planConfigs[i];
                                                boolean alreadyConfigured = false;
                                                for (j = 0; j < statusEntries.length && !alreadyConfigured; ++j) {
                                                    if (!statusEntries[j].getCode().equalsIgnoreCase(prodToConfig)) continue;
                                                    alreadyConfigured = true;
                                                }
                                                if (alreadyConfigured) continue;
                                                for (j = 0; j < smuStatusEntries.length; ++j) {
                                                    if (smuStatusEntries[j].getCode().equalsIgnoreCase(prodToConfig)) {
                                                        Globals.g_configStatus.setStatus(smuStatusEntries[j].getFQID(), smuStatusEntries[j].getCode(), Globals.g_order);
                                                        continue;
                                                    }
                                                    if (prodToConfig.equalsIgnoreCase("cfgwizard")) {
                                                        if (!smuStatusEntries[j].getCode().equalsIgnoreCase("globalroot") && !smuStatusEntries[j].getCode().equalsIgnoreCase("levdirroot")) continue;
                                                        Globals.g_configStatus.setStatus(smuStatusEntries[j].getFQID(), smuStatusEntries[j].getCode(), Globals.g_order);
                                                        continue;
                                                    }
                                                    if (!Utils.isWebAppServerCode(prodToConfig) || !smuStatusEntries[j].getCode().equalsIgnoreCase("webappsrv")) continue;
                                                    Globals.g_configStatus.setStatus(smuStatusEntries[j].getFQID(), smuStatusEntries[j].getCode(), Globals.g_order);
                                                }
                                            }
                                            Globals.g_configStatus.write();
                                        }
                                    } else {
                                        Logging.log.severe("Error loading status.xml file: " + smuStatus.getAbsolutePath() + " -> " + cfgStatus.getAbsolutePath());
                                    }
                                } else {
                                    Logging.log.severe("The status.xml file is missing from the migration package: " + smuStatus.getAbsolutePath());
                                }
                            } else {
                                Logging.log.severe("Machine not found in the migration package: " + smuMachine.getAbsolutePath());
                            }
                        }
                    }
                }
            }
        }
    }

    private void saveInstallData() {
        if (Globals.g_vjrHome != null) {
            Globals.g_installData.setProperty("vjr.install.dir", Globals.g_vjrHome);
        }
        Globals.g_installData.setProperty("os.localhost.machine.type", Utils.getOS_Suffix());
    }

    private void resolveConfigProperties() {
        String name = null;
        String value = null;
        Enumeration<Object> e = Globals.g_configData.getProperties().keys();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = Globals.g_configData.getProperty(name, null);
            if (value == null || !PropertyRules.containsProperty(value)) continue;
            Globals.g_configData.setProperty(name, PropertyRules.resolveProperties(value, 0));
        }
    }

    public boolean finished() {
        return this.m_finished;
    }

    public ProductData getCurrentInstallData() {
        return this.m_currentProdData;
    }

    public String getCurrentTarget() {
        return this.m_currentTarget;
    }

    public String getCurrentStageName() {
        return (String)this.m_stageNames.get(this.m_currentStage - 1);
    }

    public int getCurrentStage() {
        return this.m_currentStage;
    }

    public int getStageCount() {
        return this.m_stageCount;
    }

    public int getCurrentStep() {
        return this.m_currentStep;
    }

    public int getStepCount() {
        return this.m_stepCount;
    }

    public boolean oneInstalled() {
        return this.m_oneInstalled;
    }

    public boolean oneFailed() {
        return this.m_oneFailed;
    }

    private String getConfigErrorMsg(String prodCode) {
        String msg = null;
        File statusFile = new File(Globals.g_configData.getProperty("config.lev.logs.configure.dir", ""), prodCode.toLowerCase(Locale.ENGLISH) + "_config_status.properties");
        if (statusFile.isFile()) {
            Properties statusProps = new Properties();
            try {
                FileInputStream fis = new FileInputStream(statusFile);
                statusProps.load(fis);
                fis.close();
                msg = statusProps.getProperty("error.msg", null);
            }
            catch (Exception e) {
                msg = null;
                Logging.logStackTrace(e);
            }
        }
        return msg;
    }

    private void setConnectionProperties(File connectionFile) {
        Properties connectionProps = new Properties();
        try {
            if (Globals.g_mode == 2) {
                if (connectionFile.isFile()) {
                    FileInputStream fis = new FileInputStream(connectionFile);
                    connectionProps.load(fis);
                    fis.close();
                }
                if (Globals.g_cmtConnectHost != null && Globals.g_cmtConnectHost.length() > 0) {
                    connectionProps.setProperty("metadata.connection.host", Globals.g_cmtConnectHost);
                }
                if (Globals.g_cmtConnectPort != null) {
                    connectionProps.setProperty("metadata.connection.port", Globals.g_cmtConnectPort);
                }
                if (Globals.g_cmtConnectRepos != null) {
                    connectionProps.setProperty("metadata.connection.repository.name", Globals.g_cmtConnectRepos);
                }
                if (Globals.g_cmtConnectUser != null) {
                    connectionProps.setProperty("metadata.connection.userid", Globals.g_cmtConnectUser);
                }
            } else {
                String configLevelNum;
                String configLevelName;
                String configHomeDir;
                String configDirName;
                String configLogsDir;
                connectionProps.setProperty("metadata.connection.host", Globals.g_configData.getProperty("iomsrv.metadatasrv.host", ""));
                connectionProps.setProperty("metadata.connection.port", Globals.g_configData.getProperty("iomsrv.metadatasrv.port", ""));
                connectionProps.setProperty("metadata.connection.repository.name", Globals.g_configData.getProperty("oma.repository.foundation.name", ""));
                connectionProps.setProperty("metadata.connection.userid", Globals.g_configData.getProperty("oma.person.admin.login.userid", ""));
                String value = Globals.g_configData.getProperty("server.operation.type", null);
                if (value != null && value.length() > 0) {
                    connectionProps.setProperty("server.operation.type", value);
                }
                if ((value = Globals.g_configData.getProperty("metadatasrv.config.lev.appservercontext.dir", null)) != null && value.length() > 0) {
                    connectionProps.setProperty("metadatasrv.config.lev.appservercontext.dir", value);
                }
                if ((value = Globals.g_configData.getProperty("iomsrv.metadatasrv.config.dir.name", null)) != null && value.length() > 0) {
                    connectionProps.setProperty("iomsrv.metadatasrv.config.dir.name", value);
                }
                if ((value = Globals.g_configData.getProperty("iomsrv.metadatasrv.script.name", null)) != null && value.length() > 0) {
                    connectionProps.setProperty("iomsrv.metadatasrv.script.name", value);
                }
                if ((value = Globals.g_configData.getProperty("server.command.start.option", null)) != null && value.length() > 0) {
                    connectionProps.setProperty("server.command.start.option", value);
                }
                if ((value = Globals.g_configData.getProperty("server.command.stop.option", null)) != null && value.length() > 0) {
                    connectionProps.setProperty("server.command.stop.option", value);
                }
                if ((value = Globals.g_configData.getProperty("server.listener.timeout", null)) != null && value.length() > 0) {
                    connectionProps.setProperty("server.listener.timeout", value);
                }
                if ((configLogsDir = Globals.g_configData.getProperty("config.lev.logs.configure.dir", null)) != null && configLogsDir.length() > 0) {
                    connectionProps.setProperty("config.lev.logs.configure.dir", configLogsDir);
                }
                if ((configDirName = Globals.g_configData.getProperty("config.dir.name", null)) != null && configDirName.length() > 0) {
                    connectionProps.setProperty("config.dir.name", configDirName);
                }
                if ((configHomeDir = Globals.g_configData.getProperty("config.home.dir", null)) != null && configHomeDir.length() > 0) {
                    connectionProps.setProperty("config.home.dir", configHomeDir);
                }
                if ((configLevelName = Globals.g_configData.getProperty("config.level.name", null)) != null && configLevelName.length() > 0) {
                    connectionProps.setProperty("config.level.name", configLevelName);
                }
                if ((configLevelNum = Globals.g_configData.getProperty("config.level.num", null)) != null && configLevelNum.length() > 0) {
                    connectionProps.setProperty("config.level.num", configLevelNum);
                }
            }
            FileOutputStream fos = new FileOutputStream(connectionFile);
            connectionProps.store(fos, null);
            fos.close();
        }
        catch (Exception e) {
            Logging.log.severe("Error writing metadata connection properties file: " + connectionFile.toString());
            Logging.logStackTrace(e);
        }
    }

    private boolean productExist(String uninstallLoc) {
        File chkFile;
        boolean result = false;
        if (uninstallLoc != null && !uninstallLoc.equals("") && (chkFile = new File(uninstallLoc)).exists()) {
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeWindowsUninstallLink() {
        String host = Utils.getOS_Suffix();
        boolean bRemoveUninstallLink = true;
        Object result = null;
        String m_sashome = new File(Globals.g_startupLocation).getParent();
        m_sashome = Globals.g_wizardData.getPreference("SASHome", m_sashome);
        SASSharedComponents sc = new SASSharedComponents();
        try (RegistryAccess registryAccess = null;){
            RegistryData.setRegistry(m_sashome);
            registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
            registryAccess.open();
            String[] hosts = registryAccess.getInstallHosts();
            for (int h = 0; hosts != null && bRemoveUninstallLink && h < hosts.length; ++h) {
                String[] installedProductCodes = registryAccess.getInstallCodes(host);
                for (int i = 0; installedProductCodes != null && bRemoveUninstallLink && i < installedProductCodes.length; ++i) {
                    if (sc.isSharedComponent(installedProductCodes[i].toLowerCase())) continue;
                    String[] productVersions = registryAccess.getInstallVersions(installedProductCodes[i], host);
                    for (int j = 0; productVersions != null && bRemoveUninstallLink && j < productVersions.length; ++j) {
                        String[] languages = registryAccess.getMaintLanguages(installedProductCodes[i], productVersions[j], "0", hosts[h]);
                        if (languages.length == 0) {
                            if (!this.productExist(registryAccess.getMaintUninstallLoc(installedProductCodes[i], productVersions[j], hosts[h], "0"))) continue;
                            bRemoveUninstallLink = false;
                            continue;
                        }
                        for (int k = 0; languages != null && bRemoveUninstallLink && k < languages.length; ++k) {
                            if (!this.productExist(registryAccess.getMaintUninstallLoc(installedProductCodes[i], productVersions[j], hosts[h], "0", languages[k]))) continue;
                            bRemoveUninstallLink = false;
                        }
                    }
                }
            }
        }
        if (bRemoveUninstallLink) {
            Logging.log.info("Uninstall: All SAS software available for uninstall has been removed, deleting Windows Control panel Add/Remove link.");
            String uninstallKey = Utils.joinPath("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall", this.UNINSTALL_GUID);
            WinRegAPI.DelRegKeyValue(8, uninstallKey, "DisplayName");
            WinRegAPI.DelRegKeyValue(8, uninstallKey, "UninstallString");
            WinRegAPI.DelRegKeyValue(8, uninstallKey, "InstallLocation");
            WinRegAPI.DelRegKeyValue(8, uninstallKey, "Publisher");
            WinRegAPI.DelRegKeyValue(8, uninstallKey, "VersionMajor");
            WinRegAPI.DelRegKeyValue(8, uninstallKey, "DisplayVersion");
            WinRegAPI.DelRegKeyValue(8, uninstallKey, "DisplayIcon");
            WinRegAPI.DelRegKeyValue(8, uninstallKey, "URLInfoAbout");
            WinRegAPI.DelRegKey(8, uninstallKey);
        }
    }

    private void setupWindowsUninstallLink() {
        String UNINSTALL_EXE_LOCATION = Utils.joinPath(Utils.getSDMHome(Globals.g_wizardData.getPreference("SASHome", "")), "sasdm.exe");
        String uninstallKey = Utils.joinPath("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall", this.UNINSTALL_GUID);
        if (Utils.getOS_Suffix() == "wx6") {
            WinRegAPI.CreateRegKey32(8, uninstallKey);
            try {
                WinRegAPI.SetRegValue32(8, uninstallKey, "DisplayName", this.UNINSTALL_NAME, 109);
                WinRegAPI.SetRegValue32(8, uninstallKey, "UninstallString", "\"" + UNINSTALL_EXE_LOCATION + "\" -uninstall", 109);
                WinRegAPI.SetRegValue32(8, uninstallKey, "InstallLocation", Globals.g_wizardData.getPreference("SASHome", ""), 109);
                WinRegAPI.SetRegValue32(8, uninstallKey, "Publisher", "SAS Institute Inc.", 109);
                WinRegAPI.SetRegValue32(8, uninstallKey, "VersionMajor", Globals.g_majorReleaseVersion, 109);
                WinRegAPI.SetRegValue32(8, uninstallKey, "DisplayVersion", Globals.g_majorReleaseVersion, 109);
                WinRegAPI.SetRegValue32(8, uninstallKey, "DisplayIcon", UNINSTALL_EXE_LOCATION, 109);
                WinRegAPI.SetRegValue32(8, uninstallKey, "URLInfoAbout", "http://www.sas.com", 109);
            }
            catch (Exception e) {
                Logging.log.warning("Failed to set " + uninstallKey);
                Logging.logStackTrace(e);
            }
        } else {
            WinRegAPI.CreateRegKey(8, uninstallKey);
            try {
                WinRegAPI.SetRegValue(8, uninstallKey, "DisplayName", this.UNINSTALL_NAME, 109);
                WinRegAPI.SetRegValue(8, uninstallKey, "UninstallString", "\"" + UNINSTALL_EXE_LOCATION + "\" -uninstall", 109);
                WinRegAPI.SetRegValue(8, uninstallKey, "InstallLocation", Globals.g_wizardData.getPreference("SASHome", ""), 109);
                WinRegAPI.SetRegValue(8, uninstallKey, "Publisher", "SAS Institute Inc.", 109);
                WinRegAPI.SetRegValue(8, uninstallKey, "VersionMajor", Globals.g_majorReleaseVersion, 109);
                WinRegAPI.SetRegValue(8, uninstallKey, "DisplayVersion", Globals.g_majorReleaseVersion, 109);
                WinRegAPI.SetRegValue(8, uninstallKey, "DisplayIcon", UNINSTALL_EXE_LOCATION, 109);
                WinRegAPI.SetRegValue(8, uninstallKey, "URLInfoAbout", "http://www.sas.com", 109);
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
        this.m_uninstallDataAdded = true;
    }

    private static void createDeploymentRegistryViewLink() {
        String jreLoc = Utils.buildJavaCommand(System.getProperty("java.home"));
        Logging.log.fine("jreLoc=" + jreLoc);
        String depRegViewJar = Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), "deploymntreg", "sas.tools.viewregistry.jar");
        if (!new File(depRegViewJar).exists()) {
            Logging.log.warning("Deployment registry view jar not found : " + depRegViewJar);
        }
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(jreLoc, "-jar", depRegViewJar));
        ProcessBuilder pb = new ProcessBuilder(command);
        Logging.log.info("Creating deployoment registry view report with the command: " + ((Object)command).toString());
        File logsDir = new File(Globals.g_wizardData.getPreference("SASHome", ""), "InstallMisc/InstallLogs");
        pb.directory(logsDir);
        Logging.log.info("Deployment registry view is written to: " + pb.directory().getAbsolutePath());
        try {
            Process conf = pb.start();
            conf.waitFor();
            if (conf.exitValue() != 0) {
                Logging.log.info("Creating deployment registry veiw report failed with the following return code: " + conf.exitValue());
            }
        }
        catch (Exception e) {
            Logging.log.warning("The following exception occurred while creating the deployment registry view report");
            Logging.log.warning(Logging.getFormattedLogMsg(e));
        }
        if (!Globals.g_deploymentData.getOrder(Globals.g_order).isStandAlone()) {
            String htmlReport = Utils.joinPath(logsDir.getAbsolutePath(), "DeploymentRegistry.html");
            deploymentRegistryViewLink = Utils.pathToURL(htmlReport);
        }
    }

    public static String getDeploymentRegistryViewLink() {
        return deploymentRegistryViewLink;
    }

    public NotificationHandler getNotifier() {
        return NotificationHandler.defaultHandler();
    }

    public void setAbort(boolean mAbort) {
        this.m_abort = mAbort;
    }

    private void copyBeanShell() {
        String source_bsh = "";
        String destination_bsh = "";
        if (Globals.g_mode == 0 && !Globals.g_setupLocationSetFromCmdLine) {
            source_bsh = Utils.joinPath(Globals.g_deploymentData.getProductDir(Globals.g_order, "deploywiz", false, false), "deploywiz", "bsh.jar");
            destination_bsh = Utils.joinPath(Globals.g_setupLocation, "bsh.jar");
            File source_bsh_file = new File(source_bsh);
            File destination_bsh_file = new File(destination_bsh);
            if (!source_bsh_file.exists()) {
                Logging.log.warning("Copy beanshell from: " + source_bsh + " to: " + destination_bsh + " failed. Source file does not exist. The file bsh.jar may be wrong version and may result in configuration errors.");
            } else if (!destination_bsh_file.exists()) {
                Logging.log.warning("Copy beanshell from: " + source_bsh + " to: " + destination_bsh + " failed. Destination file does not exist. The file bsh.jar may be wrong version and may result in configuration errors.");
            } else if (!Utils.canWriteToPath(destination_bsh_file.getParent())) {
                Logging.log.warning("Copy beanshell from: " + source_bsh + " to: " + destination_bsh + " failed. Can not write to destination. The file bsh.jar may be wrong version and may result in configuration errors.");
            } else if (!destination_bsh_file.delete()) {
                Logging.log.warning("Copy beanshell from: " + source_bsh + " to: " + destination_bsh + " failed. Could not delete destination file. The file bsh.jar may be wrong version and may result in configuration errors.");
            } else if (Utils.copyFile(source_bsh, destination_bsh) != 0) {
                Logging.log.warning("Copy beanshell from: " + source_bsh + " to: " + destination_bsh + " failed. Could not copy bsh.jar. The file bsh.jar may be wrong version and may result in configuration errors.");
            } else {
                Logging.log.info("Copy beanshell from: " + source_bsh + " to: " + destination_bsh + " successful.");
            }
        }
    }

    private void deleteLevdirroot(String prodCode, String antTarget) {
        if (Globals.g_metadataRemoved) {
            boolean successRemoveLevdirrootFrStatus = Globals.g_configStatus.removeStatusEntry(Globals.g_levdirrootFQID);
            if (successRemoveLevdirrootFrStatus) {
                Globals.g_configStatus.write();
            } else {
                Logging.log.severe("Error removing levdirroot " + Globals.g_levdirrootFQID + " from status.xml when metadatasrv was unconfigured.");
            }
        } else {
            String globalrootFQID = null;
            Boolean needToRemoveLevdirrootFrStatusXML = false;
            Boolean allConfigInstancesRemoved = true;
            for (int i = 0; i < Globals.g_instances.length; ++i) {
                InstanceData instanceData = Globals.g_instances[i].getInstanceData();
                if (null != instanceData) {
                    String productCode = instanceData.getCode();
                    String productFQID = instanceData.getFQID();
                    if (!productCode.equalsIgnoreCase("globalroot")) {
                        ConfigStatus.StatusEntry statusEntry = Globals.g_configStatus.getStatusEntry(productFQID);
                        if (null == statusEntry) continue;
                        allConfigInstancesRemoved = false;
                        Logging.log.warning("productCode '" + productCode + "' productFQID '" + productFQID + "' still exists in status.xml");
                        continue;
                    }
                    globalrootFQID = productFQID;
                    continue;
                }
                Logging.log.warning("Unexpected: Found a null instanceData from Globals.g_instances.getInstanceData().  Globals.g_instances.length " + Globals.g_instances.length + "  index " + i);
            }
            if (allConfigInstancesRemoved.booleanValue()) {
                if (null == globalrootFQID) {
                    if (null == Globals.g_globalrootFQID) {
                        ConfigStatus.StatusEntry[] statusEntries = Globals.g_configStatus.getStatusEntries();
                        for (int j = 0; j < statusEntries.length; ++j) {
                            if (!statusEntries[j].getCode().equalsIgnoreCase("globalroot")) continue;
                            globalrootFQID = statusEntries[j].getFQID();
                        }
                    } else {
                        globalrootFQID = Globals.g_globalrootFQID;
                    }
                }
                if (null != Globals.g_levdirrootFQID && Globals.g_levdirrootFQID.length() == 17) {
                    if (null != globalrootFQID && globalrootFQID.length() == 17) {
                        String levdirrootDeps = MetadataAccess.metaQuery(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, "<xmlselect search=\"SoftwareComponent[@Id NE '" + globalrootFQID + "'][DependsOnComponents/*[@Id='" + Globals.g_levdirrootFQID + "']]\"/>");
                        if (levdirrootDeps.length() == 0) {
                            String objectDeletedFrMeta = MetadataAccess.deleteMetadataByFQID(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, "SoftwareComponent", Globals.g_levdirrootFQID);
                            if (objectDeletedFrMeta.length() > 0) {
                                needToRemoveLevdirrootFrStatusXML = true;
                            } else {
                                Logging.log.severe("Error deleting levdirroot " + Globals.g_levdirrootFQID + " from metadata.  Zero length string returned.");
                            }
                        } else {
                            Logging.log.warning("levdirroot " + Globals.g_levdirrootFQID + " still has SoftwareComponent dependents.  Not going to remove levdirroot from metadata.  Dependents: " + levdirrootDeps);
                        }
                        if (needToRemoveLevdirrootFrStatusXML.booleanValue()) {
                            boolean successRemoveLevdirrootFrStatus = Globals.g_configStatus.removeStatusEntry(Globals.g_levdirrootFQID);
                            if (successRemoveLevdirrootFrStatus) {
                                Globals.g_configStatus.write();
                            } else {
                                Logging.log.severe("Error removing levdirroot " + Globals.g_levdirrootFQID + " from status.xml");
                            }
                        }
                    } else {
                        Logging.log.severe("Unable to obtain globalroot FQID.  Thus, unable to remove levdirroot " + Globals.g_levdirrootFQID + " from metadata or status.xml");
                    }
                } else {
                    Logging.log.severe("Globals.g_levdirrootFQID is either null or not length 17.  Thus, unable to remove levdirroot from metadata or status.xml");
                }
            } else {
                Logging.log.warning("levdirroot " + Globals.g_levdirrootFQID + " was not removed from metadata or status.xml because of an apparent failure during a 12byte's unconfigure");
            }
        }
    }
}

