/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Language;
import com.sas.ssn.Logging;
import com.sas.ssn.PanelConfigMaint;
import com.sas.ssn.PanelFinish;
import com.sas.ssn.PropsParser;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import java.io.File;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class ChainConfigMaint
extends Thread {
    private boolean m_abort = false;
    private boolean m_finished = false;
    private SSNResource bundle = new SSNResource(PanelFinish.class);
    private String m_sdmInstallDir = null;
    private ArrayList m_listData = null;
    private PanelConfigMaint m_panelConfigMaint = null;

    public ChainConfigMaint(ArrayList listData, PanelConfigMaint panelConfigMaint, String sdmInstallDir) {
        this.setPriority(1);
        this.m_listData = listData;
        this.m_panelConfigMaint = panelConfigMaint;
        this.m_sdmInstallDir = sdmInstallDir;
    }

    @Override
    public void run() {
        String docFile = null;
        String docLink = null;
        int cfgcount = 0;
        int returnCode = 0;
        if (this.m_listData.size() > 0) {
            Globals.g_configUpdateText = this.bundle.getString("PanelFinish.ConfigUpdateHeader.txt") + "<br>";
        }
        PanelConfigMaint.ListData listElement = null;
        for (int i = 0; i < this.m_listData.size(); ++i) {
            listElement = (PanelConfigMaint.ListData)this.m_listData.get(i);
            if (!listElement.getSelected()) continue;
            returnCode = this.launchSDM(listElement);
            if (returnCode != 0) {
                int sdmStatus;
                int promptVal = this.m_panelConfigMaint.retryPrompt(i == this.m_listData.size() - 1, listElement);
                if (promptVal == 1) {
                    --i;
                    continue;
                }
                ++cfgcount;
                if (returnCode != -9998) {
                    Globals.g_errorConfiguration = true;
                    Globals.g_wizardData.load();
                }
                if ((sdmStatus = listElement.getStatus()) == 5) {
                    Globals.g_configUpdateText = Globals.g_configUpdateText + this.bundle.messageString("PanelFinish.ConfigUpdateCancel.txt", cfgcount + ". ", Utils.joinPath(listElement.getConfigDir(), listElement.getConfigLev()));
                } else {
                    Globals.g_configUpdateText = Globals.g_configUpdateText + this.bundle.messageString("PanelFinish.ConfigUpdateError.txt", cfgcount + ". ", Utils.joinPath(listElement.getConfigDir(), listElement.getConfigLev()));
                    docFile = Utils.joinPath(listElement.getConfigDir(), listElement.getConfigLev(), Utils.joinPath("Documents", "ConfigurationErrors.html"));
                    if (new File(docFile).isFile()) {
                        docLink = "<a href=\"" + Utils.pathToURL(docFile) + "\">" + docFile + "</a><br><br>";
                    }
                    if (docLink != null) {
                        Globals.g_configUpdateText = Globals.g_configUpdateText + this.bundle.messageString("PanelFinish.ConfigUpdateErrorFile.txt", docLink);
                        docLink = null;
                    } else {
                        Globals.g_configUpdateText = Globals.g_configUpdateText + this.bundle.messageString("PanelFinish.ConfigUpdateMissingLink.txt");
                    }
                }
                if (promptVal != 0) continue;
                i = this.m_listData.size();
                continue;
            }
            Globals.g_configUpdateText = Globals.g_configUpdateText + this.bundle.messageString("PanelFinish.ConfigUpdateSuccess.txt", ++cfgcount + ". ", Utils.joinPath(listElement.getConfigDir(), listElement.getConfigLev()));
            docFile = Utils.joinPath(listElement.getConfigDir(), listElement.getConfigLev(), Utils.joinPath("Documents", "UpdateInstructions.html"));
            if (new File(docFile).isFile()) {
                docLink = "<a href=\"" + Utils.pathToURL(docFile) + "\">" + docFile + "</a><br><br>";
            }
            if (docLink != null) {
                Globals.g_configUpdateText = Globals.g_configUpdateText + this.bundle.messageString("PanelFinish.ConfigUpdateSuccessFile.txt", docLink);
                docLink = null;
                continue;
            }
            Globals.g_configUpdateText = Globals.g_configUpdateText + this.bundle.messageString("PanelFinish.ConfigUpdateMissingLink.txt");
        }
        boolean bl = this.m_finished = !this.m_abort;
        if (!Globals.g_quietMode) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChainConfigMaint.this.m_panelConfigMaint.morphForSummary();
                }
            });
        }
    }

    private int launchSDM(PanelConfigMaint.ListData listElement) {
        int returnCode = 0;
        int status = 1;
        listElement.setStatus(status);
        status = 3;
        String javaArgs = this.getSDMCommand();
        if (javaArgs != null) {
            String configDir = Utils.joinPath(listElement.getConfigDir(), listElement.getConfigLev());
            String javaCmd = "\"" + new File(System.getProperty("java.home"), "bin/java").getAbsolutePath() + "\"";
            javaArgs = javaArgs + " -configdir \"" + configDir + "\" -applyconfigmaint -maintorder " + Globals.g_order + " -lang " + Language.gs_SelectedLanguage + " -skiptempdelete";
            if (Globals.g_debug) {
                javaArgs = javaArgs + " -debug";
            }
            if (Globals.g_consoleMode) {
                javaArgs = javaArgs + " -console";
            }
            if (Globals.g_fqHostNameOverride != null) {
                javaArgs = javaArgs + " -confighostname " + Globals.g_fqHostNameOverride;
            }
            if (Globals.g_javaOptions != null) {
                javaArgs = javaArgs + " -javaoptions \"" + Globals.g_javaOptions + "\"";
            }
            if (Globals.g_logLevel != 0) {
                javaArgs = javaArgs + " -loglevel " + Globals.g_logLevel;
            }
            if (Globals.g_allowContinue) {
                javaArgs = javaArgs + " -allowcontinue";
            }
            if (Globals.g_tempLocation != null) {
                javaArgs = javaArgs + " -templocation " + Globals.g_tempLocation;
            }
            String fullCmd = javaCmd + " " + javaArgs;
            Logging.log.info("Launching: " + fullCmd);
            returnCode = Utils.runProcess(fullCmd).getExitValue();
            Logging.log.info("Return Code: " + Integer.toString(returnCode));
            if (returnCode == 0) {
                status = 2;
            } else if (returnCode == -2 || returnCode == -9998) {
                status = 5;
            }
        }
        listElement.setStatus(status);
        return returnCode;
    }

    public String getSDMCommand() {
        String command = null;
        PropsParser sdmProps = new PropsParser(true);
        File sasdminiFile = new File(this.m_sdmInstallDir, "sasdm.ini");
        try {
            sdmProps.load(sasdminiFile, null);
            command = sdmProps.getINIValue("default", "launcherargs", null);
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
        }
        if (command == null) {
            Logging.log.severe("No launcherargs found in [default] section of sasdm.ini: " + sasdminiFile);
        }
        return command;
    }

    public boolean finished() {
        return this.m_finished;
    }
}

