/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConfigureData;
import com.sas.ssn.Globals;
import com.sas.ssn.OsLevelCheck;
import com.sas.ssn.ProductData;
import com.sas.ssn.Utils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BatchFile {
    private static final BatchFile INSTANCE = new BatchFile();
    private String TIMESTAMP_FORMAT = "yyyy-MM-dd-HH.mm.ss";
    private String timeStamp = new SimpleDateFormat(this.TIMESTAMP_FORMAT).format(new Date());
    private String BATCH_FILE_NAME = null;
    private PrintWriter out = null;
    private boolean _exists = false;
    private boolean _empty = true;
    private String productName = null;
    private String depotLocation = Utils.joinPath(Globals.g_startupLocation, "products");
    private String divider = "--------------------------------------------------------------------------------";

    private BatchFile() {
    }

    public static BatchFile getInstance() {
        return INSTANCE;
    }

    public void createBatchFile() throws IOException, SecurityException {
        this.BATCH_FILE_NAME = Globals.g_order + "_sysreq_" + this.timeStamp + ".bat";
        Globals.g_batchFile = Utils.joinPath(Utils.getBatchFilePath(true), this.BATCH_FILE_NAME);
        String osname = System.getProperty("os.name");
        String osversion = System.getProperty("os.version");
        String ossuffix = Utils.getOS_Suffix().equals("wx6") ? "64-bit" : "32-bit";
        this.close();
        this.out = new PrintWriter(new BufferedWriter(new FileWriter(Globals.g_batchFile, true)));
        this.out.println(":: " + this.divider);
        this.out.println(":: This is a batch system requirements file created from order " + Globals.g_order + " at");
        this.out.println(":: " + this.timeStamp + ". The host was " + ConfigureData.getDefaultHost() + " and was running on a");
        this.out.println(":: " + OsLevelCheck.getOsVersionDescription() + " machine.");
        this.out.println("::");
        this.out.println(":: The following products were used to create this batch file:");
        this.out.println("::");
        for (ProductData productData : Globals.g_selectedInstalls) {
            this.out.println(":: " + productData.getProdName());
            if (!productData.getProdName().equals("SAS Foundation")) continue;
            for (String sasProduct : Globals.g_selectedMVAProducts) {
                this.out.println("::\t\u2022 " + Globals.g_deploymentData.getSpsSku(sasProduct).getDisplayName("en"));
            }
        }
        this.out.println("::");
        this.out.println(":: 1. Any entry listed as \"(REQUIRED)\" MUST be run to ensure the selected");
        this.out.println("::    products will install properly. For batch files created on 64-bit Windows,");
        this.out.println("::    there may be required entries that also reference 32-bit operating systems.");
        this.out.println(":: 2. Any entry listed as \"(OPTIONAL)\" is not needed for the selected products");
        this.out.println("::    but are required by other products in " + Globals.g_order + ". Optional entries may be");
        this.out.println("::    removed without affecting the installation of the selected products, but this");
        this.out.println("::    is NOT recommended.");
        this.out.println(":: 3. This batch file is only designed to run on machine(s) matching the operating");
        this.out.println("::    system on which it was created. To run the batch file on other machines, the");
        this.out.println("::    path to the executables below must be correct. To ensure the accuracy of this");
        this.out.println("::    batch file, the target depot should be in a location matching the paths in");
        this.out.println("::    this batch file rather than altering the paths in this batch file. If you must");
        this.out.println("::    use a different location, SAS recommends changing the SET variable rather than");
        this.out.println("::    the command for each requirement listed below.");
        this.out.println("::");
        this.out.println("set DEPOT_HOME=" + this.depotLocation);
        this.out.println("::");
        this.out.flush();
        this.setExist(true);
    }

    public void addCommandLines(String commandLine, ProductData productData) {
        if (!productData.getProdName().equals(this.productName)) {
            this.out.println(":: " + this.divider);
            if (productData.isRequired()) {
                this.out.println(":: " + productData.getProdName() + " (REQUIRED)");
            } else {
                this.out.println(":: " + productData.getProdName() + " (OPTIONAL)");
            }
        }
        if (commandLine.contains(this.depotLocation)) {
            commandLine = commandLine.replace(this.depotLocation, "%DEPOT_HOME%");
        }
        this.out.println(commandLine);
        this.out.flush();
        this.productName = productData.getProdName();
        this.setEmpty(false);
    }

    public void deleteBatchFile() throws SecurityException {
        File folder = new File(Utils.getBatchFilePath(false));
        if (folder.exists() && folder.listFiles().length <= 1) {
            Utils.deleteFolder(folder);
        } else {
            new File(Globals.g_batchFile).delete();
        }
        this.setEmpty(true);
        this.setExist(false);
    }

    public void close() {
        if (this._exists) {
            this.out.close();
            if (this._empty) {
                this.deleteBatchFile();
            }
        }
    }

    public boolean doesExist() {
        return this._exists;
    }

    public void setExist(boolean exists) {
        this._exists = exists;
    }

    public boolean isEmpty() {
        return this._empty;
    }

    public void setEmpty(boolean empty) {
        this._empty = empty;
    }

    public String getBatchFileName() {
        return this.BATCH_FILE_NAME;
    }
}

