/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFJobInstance;
import com.platform.LSFJobFlow.ui.AbstractJobShape;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import java.awt.Image;

class OtherBatchJobShape
extends AbstractJobShape {
    public OtherBatchJobShape(JFJob jFJob, int n, int n2) {
        super(jFJob, n, n2);
        if (jFJob != null && "Yes".equals(jFJob.getAttribute("OnHold"))) {
            this.setOnHold(true);
        } else {
            this.setOnHold(false);
        }
        this.curImage = this.imageLoader.getOtherBatchJobDefImage();
    }

    public OtherBatchJobShape(String string, int n, int n2) {
        super(string, n, n2);
        this.jobDefObj = new JFJob(string, "otherbatch");
        if ("Yes".equals(this.jobDefObj.getAttribute("OnHold"))) {
            this.setOnHold(true);
        } else {
            this.setOnHold(false);
        }
        this.curImage = this.imageLoader.getOtherBatchJobDefImage();
    }

    public OtherBatchJobShape(JFJobInstance jFJobInstance, int n, int n2) {
        super(jFJobInstance, n, n2);
        if (jFJobInstance.isOnHold()) {
            this.setOnHold(true);
        } else {
            this.setOnHold(false);
        }
        this.curImage = this.imageLoader.getOtherBatchJobInstanceImage(jFJobInstance);
    }

    @Override
    public boolean updateImage() {
        Image image = this.imageLoader.getOtherBatchJobDefImage();
        if (this.curImage == image) {
            return false;
        }
        this.curImage = image;
        return true;
    }

    @Override
    public String getRuntimeAttributesStr() {
        String string = null;
        if (this.jobInstObj != null) {
            String string2 = null;
            if (this.jobDefObj != null) {
                string2 = this.jobDefObj.getAttribute("JobCmdLine");
            }
            if (string2 == null) {
                string2 = "";
            }
            string = JFUtility.alignString("[" + JFResourceBundle.getString("Job_name") + "]", 20) + ": " + this.name;
            string = string + "\n" + JFUtility.alignString("[" + JFResourceBundle.getString("Job_ID") + "]", 20) + ": " + String.valueOf(this.jobInstObj.getInstanceId());
            String string3 = null;
            string3 = this.owner != null ? this.owner : this.jobDefObj.getAttribute("UserName");
            string = string + "\n" + JFUtility.alignString("[" + JFResourceBundle.getString("Submitter") + "]", 20) + ": " + string3;
            string = string + "\n" + JFUtility.alignString("[" + JFResourceBundle.getString("Command") + "]", 20) + ": " + string2;
            string = string + "\n" + JFUtility.alignString("[" + JFResourceBundle.getString("State") + "]", 20) + ": " + this.getCurStateString();
            string = string + "\n" + JFUtility.alignString("[" + JFResourceBundle.getString("Details") + "]", 20) + ": " + this.jobInstObj.getDetail();
            if (this.state == 6 || this.state == 9) {
                string = string + "\n" + JFUtility.alignString("[" + JFResourceBundle.getString("Exit_code") + "]", 20) + ": " + String.valueOf(this.jobInstObj.getStatus());
                string = string + "\n" + JFUtility.alignString("[" + JFResourceBundle.getString("CPU_usage") + "]", 20) + ": " + String.valueOf(this.jobInstObj.getCPUUsage() + " seconds");
            }
            Object var4_4 = null;
            string = string + "\n" + JFUtility.alignString("[" + JFResourceBundle.getString("Start_time") + "]", 20) + ": ";
            String string4 = this.jobInstObj.getStartTimeString();
            if (string4 != null) {
                string = string + string4;
            }
            string = string + "\n" + JFUtility.alignString("[" + JFResourceBundle.getString("Finish_time") + "]", 20) + ": ";
            string4 = this.jobInstObj.getFinishTimeString();
            if (string4 != null) {
                string = string + string4;
            }
        }
        return string;
    }
}

