/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.platform.LSFJobFlow.ui.JFDescriptionPane;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class JFVariableEvaluatorBean
extends JPanel {
    static final String ERR_WIN_TITLE = JFResourceBundle.getString("VariableEvaluatorBean$TITLE_inputErrWin");
    private int curSeqNo = 0;
    private boolean m_editable = false;
    private boolean m_isJFAdmin = false;
    private String m_currentUserName;
    private JFJob jobDef = null;
    private JFDescriptionPane jFDescriptionPane;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JTextField nameFLD;

    public JFVariableEvaluatorBean() {
        this.initComponents();
        this.setInputAccessibleInfo();
        this.m_editable = true;
        this.m_currentUserName = JFLoginManager.getUserName();
        this.curSeqNo = 0;
        this.reset();
    }

    public void reset() {
        if (this.jobDef != null) {
            this.nameFLD.setText(this.jobDef.getName());
        }
        this.jFDescriptionPane.setText("");
    }

    public void reset(String string) {
        this.reset();
        if (string != null) {
            this.nameFLD.setText(string);
        }
    }

    JFJob getDefaultJob(String string) throws Exception {
        this.reset(string);
        return this.createJob(null);
    }

    JFJob getDefaultJob() throws Exception {
        return this.getDefaultJob("M" + String.valueOf(++this.curSeqNo));
    }

    public void setJobDefinition(JFJob jFJob) {
        this.jobDef = jFJob;
        this.reset();
        if (jFJob == null) {
            return;
        }
        this.nameFLD.setText(jFJob.getName());
        this.jFDescriptionPane.setText(jFJob.getAttribute("Description"));
    }

    public void updateDefinition() throws Exception {
        if (!this.m_editable) {
            throw new Exception(JFResourceBundle.getString("VariableEvaluatorBean$ERR_nonEditableErr"));
        }
        if (this.jobDef == null) {
            throw new Exception(JFResourceBundle.getString("VariableEvaluatorBean$ERR_noJobDefErr"));
        }
        this.jobDef = this.createJob(this.jobDef);
    }

    public JFJob getJobDefinition() throws Exception {
        return this.createJob(null);
    }

    JFJob createJob(JFJob jFJob) throws Exception {
        JFJob jFJob2 = null;
        String string = this.nameFLD.getText();
        if (!JFUtility.isValidJobFlowIdentity(string)) {
            throw new Exception(JFResourceBundle.getString("VariableEvaluatorBean$ERR_jobNameInvalid"));
        }
        if (jFJob == null) {
            jFJob2 = new JFJob(string.trim(), "manual");
        } else {
            jFJob2 = jFJob;
            jFJob2.setName(string);
            jFJob2.removeAllAttributes();
        }
        jFJob2.setAttribute("UserName", this.m_currentUserName);
        if (this.jFDescriptionPane.getText() != null) {
            jFJob2.setAttribute("Description", this.jFDescriptionPane.getText().trim());
        }
        jFJob2.validate();
        return jFJob2;
    }

    public JPanel getBeanPanel() {
        return this;
    }

    public void setEditable(boolean bl) {
        this.m_editable = bl;
        this.nameFLD.setEnabled(bl);
        this.nameFLD.setEnabled(bl);
        this.nameFLD.setOpaque(bl);
        this.jFDescriptionPane.setEditable(bl);
        this.jFDescriptionPane.setEnabled(bl);
        this.jFDescriptionPane.setOpaque(bl);
    }

    public void setJFAdmin(boolean bl) {
        this.m_isJFAdmin = bl;
    }

    private void setInputAccessibleInfo() {
        this.jLabel4.setLabelFor(this.nameFLD);
        this.nameFLD.getAccessibleContext().setAccessibleName(this.jLabel4.getText());
        this.nameFLD.getAccessibleContext().setAccessibleDescription(this.nameFLD.getToolTipText());
        this.jLabel2.setLabelFor(this.jScrollPane1);
        this.jScrollPane1.getAccessibleContext().setAccessibleName(this.jLabel2.getText());
        this.jScrollPane1.getAccessibleContext().setAccessibleDescription(this.jScrollPane1.getToolTipText());
    }

    private void initComponents() {
        this.jLabel4 = new JLabel();
        this.nameFLD = new JTextField();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jFDescriptionPane = new JFDescriptionPane();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(JFResourceBundle.getString("Define_variable_evaluator")));
        this.getAccessibleContext().setAccessibleName(JFResourceBundle.getString("Define_variable_evaluator"));
        this.jLabel4.setHorizontalAlignment(11);
        this.jLabel4.setText(JFResourceBundle.getString("Name_"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.nameFLD.setToolTipText(JFResourceBundle.getString("VariableEvaluatorBean$TIP_nameFLD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.nameFLD, gridBagConstraints);
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText(JFResourceBundle.getString("Description_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 5, 137, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jScrollPane1.setToolTipText(JFResourceBundle.getString("JFManualJobDefinition$TIP_descriptionFLD"));
        this.jScrollPane1.setPreferredSize(new Dimension(300, 100));
        this.jFDescriptionPane.setToolTipText(JFResourceBundle.getString("JFManualJobDefinition$TIP_descriptionFLD"));
        this.jScrollPane1.setViewportView(this.jFDescriptionPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.insets = new Insets(7, 6, 3, 3);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }
}

