/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFAdminManager;
import com.platform.LSFJobFlow.api.JFCommon;
import com.platform.LSFJobFlow.api.JFUTFConverter;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import com.platform.LSFJobFlow.ui.JFVariableUpdateDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JFVariableDefinitionDialog
extends JDialog {
    private DefaultListModel m_listModel = new DefaultListModel();
    private JPanel m_definitionPanel = new JPanel();
    private JPanel m_buttonPanel = new JPanel();
    private JButton m_okButton = new JButton();
    private JButton m_applyButton = new JButton();
    private JButton m_cancelButton = new JButton();
    private JButton m_addButton = new JButton();
    private JButton m_removeButton = new JButton();
    private JButton m_editButton = new JButton();
    private JList m_variableList = new JList(this.m_listModel);
    private JScrollPane m_scrollPane = new JScrollPane(this.m_variableList);
    private JFVariableUpdateDialog m_varUpdateDialog = null;
    private Properties m_environment = null;
    private boolean m_allowVariableAdd = true;
    private boolean m_allowVariableRemove = true;
    private boolean m_allowVariableEdit = true;
    private boolean m_isSubflow = false;
    private boolean m_isFlowarray = false;
    private String m_itemName = null;
    private int m_arrayfirstindex = 0;
    private int m_arraylastindex = 0;
    private long m_flowid = 0L;
    private static final String VARVAL_SEPARATOR = " = ";
    private String m_productTitle = null;
    private static final String PRODUCT_TITLE = JFAdminManager.getProductShortName();
    private HashMap m_operations = new HashMap();
    private Properties m_envbak = null;

    public static void main(String[] stringArray) {
        new JFVariableDefinitionDialog((Frame)new JFrame(), null).show();
    }

    public JFVariableDefinitionDialog(Frame frame, Properties properties, long l) {
        super(frame, true);
        this.refresh(properties);
        this.m_flowid = l;
        this.m_productTitle = PRODUCT_TITLE;
        this.m_variableList.setToolTipText("");
        this.m_variableList.setSelectionMode(0);
        this.m_variableList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                this.setBackground(bl ? Color.blue : Color.white);
                this.setForeground(bl ? Color.white : Color.black);
                this.setText(object.toString());
                return this;
            }
        });
        this.m_variableList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JFVariableDefinitionDialog.this.setButtonOnSelection();
            }
        });
        this.m_scrollPane.setToolTipText("");
        this.m_scrollPane.setMinimumSize(new Dimension(300, 100));
        this.m_scrollPane.setPreferredSize(new Dimension(300, 100));
        this.m_scrollPane.setViewportView(this.m_variableList);
        this.m_buttonPanel.setLayout(new FlowLayout(1));
        this.m_definitionPanel.setLayout(new GridBagLayout());
        this.m_definitionPanel.setBorder(new TitledBorder(JFResourceBundle.getString("Definitions")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 3;
        this.m_definitionPanel.add((Component)this.m_scrollPane, gridBagConstraints);
        this.m_addButton.setEnabled(this.m_allowVariableAdd);
        this.m_addButton.setText(JFResourceBundle.getString("BUTTON_ADD..."));
        this.m_addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFVariableDefinitionDialog.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        this.m_definitionPanel.add((Component)this.m_addButton, gridBagConstraints);
        this.m_removeButton.setEnabled(this.m_allowVariableRemove && !this.m_variableList.isSelectionEmpty());
        this.m_removeButton.setText(JFResourceBundle.getString("BUTTON_REMOVE"));
        this.m_removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFVariableDefinitionDialog.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.m_definitionPanel.add((Component)this.m_removeButton, gridBagConstraints);
        this.m_editButton.setEnabled(this.m_allowVariableEdit && !this.m_variableList.isSelectionEmpty());
        this.m_editButton.setText(JFResourceBundle.getString("BUTTON_EDIT..."));
        this.m_editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFVariableDefinitionDialog.this.editButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.m_definitionPanel.add((Component)this.m_editButton, gridBagConstraints);
        this.m_okButton.setEnabled(true);
        this.m_okButton.setText(JFResourceBundle.getString("BUTTON_OK"));
        this.m_okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFVariableDefinitionDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.m_buttonPanel.add(this.m_okButton);
        this.m_cancelButton.setEnabled(true);
        this.m_cancelButton.setText(JFResourceBundle.getString("BUTTON_CANCEL"));
        this.m_cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFVariableDefinitionDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.m_buttonPanel.add(this.m_cancelButton);
        this.m_applyButton.setEnabled(false);
        this.m_applyButton.setText(JFResourceBundle.getString("BUTTON_APPLY"));
        this.m_applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFVariableDefinitionDialog.this.applyButtonActionPerformed(actionEvent);
            }
        });
        this.m_buttonPanel.add(this.m_applyButton);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JFVariableDefinitionDialog.this.closeDialog(windowEvent);
            }
        });
        this.getContentPane().add((Component)this.m_definitionPanel, "North");
        this.getContentPane().add((Component)this.m_buttonPanel, "South");
        this.getRootPane().setDefaultButton(this.m_okButton);
        this.setResizable(false);
        this.pack();
    }

    public void setProductName(String string) {
        this.m_productTitle = PRODUCT_TITLE + ": " + string;
    }

    public void setItemAtrributes(String string, boolean bl, int n, int n2) {
        if (bl) {
            this.m_isSubflow = true;
        } else {
            this.m_isFlowarray = true;
            this.m_arrayfirstindex = n;
            this.m_arraylastindex = n2;
        }
        this.m_itemName = string;
        this.m_definitionPanel.setBorder(new TitledBorder(string));
    }

    public Properties getVarProperties() {
        return this.m_environment;
    }

    public JFVariableDefinitionDialog(Frame frame, Properties properties) {
        this(frame, properties, 0L);
    }

    public void refresh(Properties properties) {
        this.m_environment = properties;
        this.m_envbak = (Properties)this.m_environment.clone();
        this.populateList(this.m_environment);
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        Frame frame = JFUtility.getMainFrame(this);
        this.m_varUpdateDialog = new JFVariableUpdateDialog(frame);
        this.m_varUpdateDialog.setLocationRelativeTo(this);
        this.m_varUpdateDialog.enableVariableName(true);
        this.m_varUpdateDialog.setBorderTitle(JFResourceBundle.getString("Add_Variable"));
        if (this.m_flowid > 0L) {
            this.m_varUpdateDialog.setTitle(JFResourceBundle.getString("TITLE_FLOW_VARIABLES"));
        } else if (this.m_flowid == 0L) {
            this.m_varUpdateDialog.setTitle(JFResourceBundle.getString("TITLE_GLOBAL_VARIABLES"));
        } else {
            this.m_varUpdateDialog.setTitle(JFResourceBundle.getString("TITLE_INPUT_VARIABLES"));
        }
        this.m_varUpdateDialog.setVisible(true);
        String string = this.m_varUpdateDialog.getVariableName();
        String string2 = this.m_varUpdateDialog.getVariableValue();
        if (JFCommon.isBuiltInVariableName((String)string)) {
            JOptionPane.showMessageDialog(this, JFResourceBundle.getString("MSG_BUILTIN_VAR"));
            return;
        }
        if (!this.isUniqueVariable(string)) {
            int n = JOptionPane.showConfirmDialog(this, JFResourceBundle.getString("MSG_overwriteVariable"), this.m_productTitle, 0, 2);
            if (n == 1) {
                return;
            }
            this.m_environment.remove(this.m_variableList.getSelectedValue());
        }
        if (string != null && string2 != null) {
            this.m_operations.put(string, string2);
            this.m_applyButton.setEnabled(true);
            string2 = JFUTFConverter.fromUnicodeEscape((String)string2);
            this.m_environment.setProperty(string, string2);
            this.populateList(this.m_environment);
        }
    }

    private void editButtonActionPerformed(ActionEvent actionEvent) {
        if (this.m_variableList.isSelectionEmpty()) {
            return;
        }
        String string = (String)this.m_variableList.getSelectedValue();
        int n = string.indexOf(VARVAL_SEPARATOR);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + VARVAL_SEPARATOR.length(), string.length());
        Frame frame = JFUtility.getMainFrame(this);
        this.m_varUpdateDialog = new JFVariableUpdateDialog(frame);
        this.m_varUpdateDialog.setLocationRelativeTo(this);
        this.m_varUpdateDialog.enableVariableName(false);
        this.m_varUpdateDialog.setVariableName(string2);
        this.m_varUpdateDialog.setVariableValue(string3);
        this.m_varUpdateDialog.setBorderTitle(JFResourceBundle.getString("Edit_Variable"));
        if (this.m_flowid > 0L) {
            this.m_varUpdateDialog.setTitle(JFResourceBundle.getString("TITLE_FLOW_VARIABLES"));
        } else if (this.m_flowid == 0L) {
            this.m_varUpdateDialog.setTitle(JFResourceBundle.getString("TITLE_GLOBAL_VARIABLES"));
        } else {
            this.m_varUpdateDialog.setTitle(JFResourceBundle.getString("TITLE_INPUT_VARIABLES"));
        }
        this.m_varUpdateDialog.setVisible(true);
        string2 = this.m_varUpdateDialog.getVariableName();
        string3 = this.m_varUpdateDialog.getVariableValue();
        if (string2 != null && string3 != null) {
            this.m_operations.put(string2, string3);
            this.m_applyButton.setEnabled(true);
            string3 = JFUTFConverter.fromUnicodeEscape((String)string3);
            this.m_environment.remove(this.m_variableList.getSelectedValue());
            this.m_environment.setProperty(string2, string3);
            this.populateList(this.m_environment);
        }
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        if (this.m_variableList.isSelectionEmpty()) {
            return;
        }
        String string = (String)this.m_variableList.getSelectedValue();
        string = string.substring(0, string.indexOf(VARVAL_SEPARATOR));
        this.m_operations.put(string, null);
        this.m_applyButton.setEnabled(true);
        this.m_environment.remove(string);
        this.populateList(this.m_environment);
    }

    private void excuteOperations() {
        if (this.m_flowid < 0L) {
            return;
        }
        Iterator iterator = this.m_operations.entrySet().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        try {
            String string;
            JFAdminManager jFAdminManager;
            while (iterator.hasNext()) {
                jFAdminManager = iterator.next();
                String string2 = (String)jFAdminManager.getKey();
                string = (String)jFAdminManager.getValue();
                if (string != null) {
                    stringBuffer.append(string2 + "=" + string + ";");
                    continue;
                }
                if (!this.isVarExist(this.m_envbak, string2)) continue;
                stringBuffer2.append(string2 + ";");
            }
            jFAdminManager = new JFAdminManager();
            if (this.m_flowid == 0L) {
                if (stringBuffer.length() > 0) {
                    jFAdminManager.setGlobalVariables(stringBuffer.toString());
                }
                if (stringBuffer2.length() > 0) {
                    jFAdminManager.removeGlobalVariables(stringBuffer2.toString());
                }
            } else {
                if (stringBuffer.length() > 0) {
                    if (this.m_isSubflow || this.m_isFlowarray) {
                        int n = this.m_itemName.indexOf(":");
                        string = this.m_itemName.substring(n + 1);
                        n = string.indexOf(":");
                        jFAdminManager.setItemVariableValues(this.m_flowid, string.substring(n + 1), stringBuffer.toString());
                    } else {
                        jFAdminManager.setVariableValues(this.m_flowid, stringBuffer.toString());
                    }
                }
                if (stringBuffer2.length() > 0) {
                    if (this.m_isSubflow || this.m_isFlowarray) {
                        int n = this.m_itemName.indexOf(":");
                        string = this.m_itemName.substring(n + 1);
                        n = string.indexOf(":");
                        jFAdminManager.removeItemLocalVariables(this.m_flowid, string.substring(n + 1), stringBuffer2.toString());
                    } else {
                        jFAdminManager.removeLocalVariables(this.m_flowid, stringBuffer2.toString());
                    }
                }
            }
        }
        catch (Exception exception) {
            JFUtility.showAppException(this, exception);
        }
        this.m_operations.clear();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.excuteOperations();
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void applyButtonActionPerformed(ActionEvent actionEvent) {
        this.excuteOperations();
        this.m_applyButton.setEnabled(false);
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void setButtonOnSelection() {
        int n;
        String string;
        String string2;
        boolean bl = !this.m_variableList.isSelectionEmpty();
        boolean bl2 = false;
        if (bl && JFCommon.isBuiltInVariableName((String)(string2 = (string = (String)this.m_variableList.getSelectedValue()).substring(0, n = string.indexOf(VARVAL_SEPARATOR))))) {
            bl2 = true;
        }
        this.m_removeButton.setEnabled(this.m_allowVariableRemove && bl && !bl2);
        this.m_editButton.setEnabled(this.m_allowVariableEdit && bl && !bl2);
    }

    private boolean populateList(Properties properties) {
        this.m_listModel.clear();
        if (properties == null || properties.size() == 0) {
            return false;
        }
        Enumeration<Object> enumeration = properties.propertyNames();
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        Collections.sort(vector);
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            string2 = JFUTFConverter.fromUnicodeEscape((String)string2);
            this.m_listModel.addElement(string + VARVAL_SEPARATOR + string2);
        }
        return true;
    }

    private boolean isUniqueVariable(String string) {
        if (string == null) {
            return true;
        }
        Enumeration<?> enumeration = this.m_environment.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = this.m_environment.getProperty(string2);
            if (!string.equals(string2)) continue;
            this.m_variableList.setSelectedValue(string2 + VARVAL_SEPARATOR + string3, false);
            return false;
        }
        return true;
    }

    private boolean isVarExist(Properties properties, String string) {
        if (properties == null) {
            return false;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public long getFlowId() {
        return this.m_flowid;
    }
}

