/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFAdminManager;
import com.platform.LSFJobFlow.api.JFCalendar;
import com.platform.LSFJobFlow.api.JFCalendarManager;
import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFTimeEvent;
import com.platform.LSFJobFlow.ui.JFEventBeanINF;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFSASTimeEventBean;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JFTimeEventBean
implements JFEventBeanINF,
ActionListener {
    private static final String SYSTEM = "Sys";
    private JFSASTimeEventBean bean;
    private boolean m_daemonExist;

    public JFTimeEventBean() {
        Vector vector = new Vector();
        vector = this.getCalendarName();
        this.bean = new JFSASTimeEventBean(vector);
        if (this.isDaemonExist()) {
            this.bean.setDaemonExist(true);
        } else {
            this.bean.setDaemonExist(false);
        }
        this.bean.setCalendarEditable();
        this.bean.setActionListener(this);
    }

    private int getIndex(Vector vector, String string) {
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.elementAt(i);
            if (string.compareTo(string2) >= 1) continue;
            return i;
        }
        return vector.size();
    }

    private Vector getCalendarName() {
        Vector<String> vector = new Vector<String>();
        try {
            JFCalendarManager jFCalendarManager = new JFCalendarManager();
            String[] stringArray = jFCalendarManager.getAllCalendarNames();
            for (int i = 0; i < stringArray.length; ++i) {
                vector.insertElementAt(stringArray[i], this.getIndex(vector, stringArray[i]));
            }
            this.setDaemonExist(true);
            return vector;
        }
        catch (Exception exception) {
            this.setDaemonExist(false);
            return vector;
        }
    }

    private boolean isDaemonExist() {
        return this.m_daemonExist;
    }

    private void setDaemonExist(boolean bl) {
        this.m_daemonExist = bl;
    }

    @Override
    public JFEvent getEvent() throws Exception {
        return this.bean.getEvent();
    }

    public void setEnableOccurrence(boolean bl) {
        this.bean.setEnableOccurrence(bl);
    }

    public void setInitEndAfterCheckBox(boolean bl) {
        this.bean.setInitEndAfterCheckBox(bl);
    }

    @Override
    public void setEvent(JFEvent jFEvent) throws Exception {
        if (jFEvent == null) {
            return;
        }
        JFTimeEvent jFTimeEvent = (JFTimeEvent)jFEvent;
        this.bean.setEvent(jFTimeEvent.getCalendarName(), jFTimeEvent.getUser(), jFTimeEvent.getHour(), jFTimeEvent.getMinute(), jFTimeEvent.getDuration(), jFTimeEvent.getOccurrences(), jFTimeEvent.getAttribute("Description"), jFTimeEvent.getAttribute("TimeZone"), jFTimeEvent.getAttribute("CalExpr"), jFTimeEvent.getAttribute("CalDesc"), jFTimeEvent.getAttribute("CalCreationTime"), jFTimeEvent.getAttribute("LastTimeEvent"), jFTimeEvent.getAttribute("NextTimeEvent"), jFTimeEvent.getAttribute("TimeZoneType"), jFTimeEvent.getTimeZoneID());
    }

    @Override
    public void setEditable(boolean bl) {
        this.bean.setEditable(bl);
    }

    @Override
    public String getSupportedEventTypeName() {
        return JFResourceBundle.getString("Time_Event");
    }

    public void refreshData() {
        this.bean.refreshData(this.getCalendarName());
        if (this.isDaemonExist()) {
            this.bean.setDaemonExist(true);
        } else {
            this.bean.setDaemonExist(false);
        }
        this.bean.setCalendarEditable();
    }

    @Override
    public JPanel getBeanPanel() {
        return this.bean.getBeanPanel();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("refresh")) {
            this.refreshData();
        }
    }

    public static void main(String[] stringArray) {
        JFTimeEventBean jFTimeEventBean = new JFTimeEventBean();
        JFrame jFrame = new JFrame();
        try {
            JFCalendarManager jFCalendarManager = new JFCalendarManager();
            JFCalendar jFCalendar = new JFCalendar("cal1", "2001/1/1", "kawong", "hello");
            JFCalendar jFCalendar2 = new JFCalendar("cal2", "2002/1/2", "kawong", "hello2");
            jFCalendarManager.addCalendar(jFCalendar);
            jFCalendarManager.addCalendar(jFCalendar2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        jFrame.getContentPane().add(jFTimeEventBean.getBeanPanel());
        jFrame.show();
        jFrame.pack();
    }

    @Override
    public void reset() {
        this.bean.reset();
    }

    @Override
    public void showAllComponents() {
    }

    private String getServerTime() {
        try {
            return new JFAdminManager().getServerTime();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

