/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFTemplateParameterDef;
import com.platform.LSFJobFlow.api.JFTemplateParameterDefList;
import com.platform.LSFJobFlow.api.JFTemplateParameterList;
import com.platform.LSFJobFlow.ui.JFPropertyTabCellRenderer;
import com.platform.LSFJobFlow.ui.JFTabCellEditor;
import com.platform.LSFJobFlow.ui.JFUtility;
import com.platform.LSFJobFlow.ui.model.JFParamLine;
import com.platform.LSFJobFlow.ui.model.JFRepeatElemLine;
import com.platform.LSFJobFlow.ui.model.JFTemplateTableModel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;

public class JFPropertyEditorTab
extends JTable
implements MouseListener {
    private JFTemplateTableModel m_model;
    private String m_lastSelectedParamName;
    private boolean m_updated = false;
    private boolean m_editable = true;

    public JFPropertyEditorTab() {
        this.initTable(null, null);
    }

    public JFPropertyEditorTab(JFTemplateParameterList jFTemplateParameterList, JFTemplateParameterDefList jFTemplateParameterDefList) {
        this.initTable(jFTemplateParameterList, jFTemplateParameterDefList);
    }

    public void setEditable(boolean bl) {
        this.m_editable = bl;
        if (this.m_model != null) {
            this.m_model.setEditable(bl);
        }
    }

    public String[] getInputMissingParamList() {
        return this.m_model.getInputMissingParamList();
    }

    public JFTemplateParameterList getUpdatedParameterList() {
        return this.m_model.getUpdatedParameterList();
    }

    public void initTable(JFTemplateParameterList jFTemplateParameterList, JFTemplateParameterDefList jFTemplateParameterDefList) {
        this.m_model = new JFTemplateTableModel(jFTemplateParameterList, jFTemplateParameterDefList);
        this.m_model.setEditable(this.m_editable);
        this.setModel(this.m_model);
        TableColumnModel tableColumnModel = this.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(25);
        tableColumnModel.getColumn(0).setMaxWidth(25);
        tableColumnModel.getColumn(0).setMinWidth(25);
        tableColumnModel.getColumn(1).setPreferredWidth(180);
        tableColumnModel.getColumn(2).setPreferredWidth(230);
        this.getTableHeader().setReorderingAllowed(false);
        this.rowHeight = 20;
        this.setSelectionMode(0);
        this.addMouseListener(this);
        this.setDefaultRenderer(new String("").getClass(), new JFPropertyTabCellRenderer());
        this.m_updated = false;
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        JFParamLine jFParamLine = this.m_model.getParameterLine(n);
        if (n2 != 2 || jFParamLine == null) {
            return super.getCellEditor(n, n2);
        }
        return new JFTabCellEditor(jFParamLine);
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        int n = this.getSelectedRow();
        JFParamLine jFParamLine = this.m_model.getParameterLine(n);
        JFTabCellEditor jFTabCellEditor = (JFTabCellEditor)changeEvent.getSource();
        String string = (String)jFTabCellEditor.getCellEditorValue();
        if (string != null && string.length() > 0) {
            try {
                JFTemplateParameterDef jFTemplateParameterDef = jFParamLine.getParameterDefinition();
                if (jFTemplateParameterDef != null) {
                    jFTemplateParameterDef.validate(string);
                }
            }
            catch (Exception exception) {
                JFUtility.showAppException(this, exception);
                jFTabCellEditor.resetToInitialValue();
            }
            if (jFParamLine instanceof JFRepeatElemLine) {
                this.m_model.appendNewRepeatElement((JFRepeatElemLine)jFParamLine);
            }
        }
        this.m_updated = true;
        super.editingStopped(changeEvent);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        if (this.m_model == null) {
            return;
        }
        int n = this.getSelectedRow();
        String string = null;
        if (n >= 0) {
            JFParamLine jFParamLine = this.m_model.getParameterLine(n);
            if (jFParamLine != null) {
                string = jFParamLine.getParameterName();
            }
            if (this.m_lastSelectedParamName != null && !this.m_lastSelectedParamName.equals(string)) {
                this.m_model.removeEmptyRepeatElementLine(this.m_lastSelectedParamName);
            }
            this.m_lastSelectedParamName = string;
        }
    }

    public void stopCellEditing() {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.getSelectedColumn();
        int n2 = this.getSelectedRow();
        if (n == 0 && n2 >= 0) {
            this.m_model.reverseExpansionOnRepeatParam(n2);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

