/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.ui.JFResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class JFProjectDialog
extends JDialog
implements ActionListener,
MouseListener {
    private static DefaultListModel m_model = null;
    private JButton m_addButton;
    private JButton m_removeButton;
    private JButton m_okButton;
    private JButton m_cancelButton;
    private JList m_list;
    private JTextField m_projectNameFLD;
    private boolean m_editable;
    private boolean m_isOKpressed;

    public JFProjectDialog(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.initGUI();
    }

    public JFProjectDialog(JDialog jDialog) {
        super((Dialog)jDialog, true);
        this.initGUI();
    }

    public static synchronized String[] getProjectListModel() {
        if (m_model == null || m_model.size() == 0) {
            return null;
        }
        String[] stringArray = new String[m_model.size()];
        for (int i = 0; i < m_model.size(); ++i) {
            stringArray[i] = (String)m_model.elementAt(i);
        }
        return stringArray;
    }

    public static synchronized void setProjectListModel(String[] stringArray) {
        m_model = new DefaultListModel();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            m_model.addElement(stringArray[i]);
        }
    }

    public String selectProjectName(String string, boolean bl) {
        this.m_isOKpressed = false;
        this.m_projectNameFLD.setText(string);
        this.setEditable(bl);
        this.setVisible(true);
        if (this.m_isOKpressed) {
            return this.m_projectNameFLD.getText();
        }
        return null;
    }

    private void initGUI() {
        this.m_editable = true;
        this.setTitle(JFResourceBundle.getString("Project_Name_Dialog"));
        this.getContentPane().setLayout(new BorderLayout());
        if (m_model == null) {
            m_model = new DefaultListModel();
        }
        this.m_list = new JList(m_model);
        this.m_list.addMouseListener(this);
        this.m_list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                this.setBackground(bl ? Color.blue : Color.white);
                this.setForeground(bl ? Color.white : Color.black);
                this.setText(object.toString());
                return this;
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.m_list);
        JPanel jPanel = new JPanel(new GridLayout(6, 1));
        this.m_addButton = new JButton(JFResourceBundle.getString("Add"));
        this.m_addButton.setSize(new Dimension(90, 30));
        this.m_addButton.addActionListener(this);
        this.m_removeButton = new JButton(JFResourceBundle.getString("Remove"));
        this.m_removeButton.setSize(new Dimension(90, 30));
        this.m_removeButton.addActionListener(this);
        jPanel.add(this.m_addButton);
        jPanel.add(this.m_removeButton);
        for (int i = 0; i < 4; ++i) {
            jPanel.add(Box.createHorizontalStrut(50));
        }
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel(JFResourceBundle.getString("Project_Name") + ": ");
        this.m_projectNameFLD = new JTextField(15);
        jLabel.setLabelFor(this.m_projectNameFLD);
        this.m_projectNameFLD.getAccessibleContext().setAccessibleName(jLabel.getText());
        jPanel2.add(jLabel);
        jPanel2.add(this.m_projectNameFLD);
        JPanel jPanel3 = new JPanel();
        this.m_okButton = new JButton(JFResourceBundle.getString("OK"));
        this.m_okButton.addActionListener(this);
        this.m_cancelButton = new JButton(JFResourceBundle.getString("Cancel"));
        this.m_cancelButton.addActionListener(this);
        jPanel3.add(this.m_okButton);
        jPanel3.add(this.m_cancelButton);
        JPanel jPanel4 = new JPanel(new GridLayout(2, 1));
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        this.getContentPane().add((Component)new JLabel(JFResourceBundle.getString("Project_s_List") + ": "), "North");
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)jPanel, "East");
        this.getContentPane().add((Component)jPanel4, "South");
        this.getRootPane().setDefaultButton(this.m_okButton);
    }

    private void addComp(Component component, JPanel jPanel, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        jPanel.add(component, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_okButton) {
            this.m_isOKpressed = true;
            this.setVisible(false);
            this.dispose();
        } else if (actionEvent.getSource() == this.m_cancelButton) {
            this.m_isOKpressed = false;
            this.dispose();
        } else if (actionEvent.getSource() == this.m_addButton) {
            String string = this.m_projectNameFLD.getText();
            if (string == null || string.length() <= 0) {
                return;
            }
            string.trim();
            if (m_model.indexOf(string) >= 0) {
                return;
            }
            m_model.addElement(string);
        } else if (actionEvent.getSource() == this.m_removeButton) {
            if (this.m_list.getSelectedIndex() < 0) {
                return;
            }
            m_model.removeElementAt(this.m_list.getSelectedIndex());
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && (mouseEvent.getModifiers() & 0x10) == 16 && mouseEvent.getSource() == this.m_list) {
            this.m_projectNameFLD.setText((String)this.m_list.getSelectedValue());
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void setEditable(boolean bl) {
        this.m_editable = bl;
        this.m_addButton.setEnabled(bl);
        this.m_removeButton.setEnabled(bl);
        this.m_okButton.setEnabled(bl);
        this.m_list.setEnabled(bl);
        this.m_projectNameFLD.setEditable(bl);
        this.m_projectNameFLD.setEnabled(bl);
        this.m_projectNameFLD.setOpaque(bl);
    }

    public void reset() {
        this.m_projectNameFLD.setText("");
    }
}

