/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.ui.JFPrintOptionsDialog;
import java.awt.Frame;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;

public class JFPrintOptionsManager {
    private static JFPrintOptionsManager m_instance;
    private boolean m_isPrintPageNumber = true;
    private PageFormat m_pageFormat;

    private JFPrintOptionsManager() {
    }

    public static JFPrintOptionsManager getInstance() {
        if (m_instance == null) {
            m_instance = new JFPrintOptionsManager();
        }
        return m_instance;
    }

    public void showPageSetupDialog() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                if (JFPrintOptionsManager.this.m_pageFormat == null) {
                    JFPrintOptionsManager.this.m_pageFormat = printerJob.defaultPage();
                }
                JFPrintOptionsManager.this.m_pageFormat = printerJob.pageDialog(JFPrintOptionsManager.this.m_pageFormat);
            }
        };
        thread.start();
    }

    public PageFormat getPageFormat() {
        if (this.m_pageFormat == null) {
            this.m_pageFormat = PrinterJob.getPrinterJob().defaultPage();
        }
        return this.m_pageFormat;
    }

    public void showPrintOptionsDialog(Frame frame) {
        JFPrintOptionsDialog jFPrintOptionsDialog = new JFPrintOptionsDialog(frame, true);
        jFPrintOptionsDialog.setPrintPageNumber(this.m_isPrintPageNumber);
        jFPrintOptionsDialog.setLocationRelativeTo(frame);
        jFPrintOptionsDialog.setVisible(true);
        this.m_isPrintPageNumber = jFPrintOptionsDialog.isPrintPageNumber();
    }

    public boolean isPrintPageNumber() {
        return this.m_isPrintPageNumber;
    }
}

