/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.ui.AbstractImageShape;
import com.platform.LSFJobFlow.ui.JobFlowShapeINF;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.QuadCurve2D;
import java.util.List;

class JFInternalProxyEventShape
implements JobFlowShapeINF {
    static final int MINI_RECT_WIDTH = 4;
    static final int MINI_RECT_HEIGHT = 4;
    List locations = null;
    AbstractImageShape eventSource = null;
    AbstractImageShape eventDest = null;
    int x0;
    int y0;
    int x1;
    int y1;
    float m_ctrlX;
    float m_ctrlY;
    boolean selectedFlag = true;

    public JFInternalProxyEventShape(List list, AbstractImageShape abstractImageShape, AbstractImageShape abstractImageShape2) {
        this.eventSource = abstractImageShape;
        this.eventDest = abstractImageShape2;
        this.locations = list;
        this.selectedFlag = false;
    }

    public AbstractImageShape getSourceShape() {
        return this.eventSource;
    }

    public AbstractImageShape getDestShape() {
        return this.eventDest;
    }

    @Override
    public int distanceSq(int n, int n2) {
        float f = (float)n - this.m_ctrlX;
        float f2 = (float)n2 - this.m_ctrlY;
        return Math.abs((int)((f * f + f2 * f2) * 10000.0f) + this.eventSource.distanceSq(n, n2) * 100 + this.eventDest.distanceSq(n, n2));
    }

    public void resetDestShape(AbstractImageShape abstractImageShape) {
        if (abstractImageShape != null) {
            this.eventDest = abstractImageShape;
        }
    }

    public List getLocations() {
        return this.locations;
    }

    public void setLocations(List list) {
        this.locations = list;
    }

    public boolean associateWith(AbstractImageShape abstractImageShape) {
        return abstractImageShape == this.eventSource || abstractImageShape == this.eventDest;
    }

    @Override
    public boolean contains(int n, int n2, Graphics2D graphics2D) {
        QuadCurve2D.Float float_ = new QuadCurve2D.Float(this.x0, this.y0, this.m_ctrlX, this.m_ctrlY, this.x1, this.y1);
        double d = (double)n - 2.5;
        double d2 = (double)n2 - 2.5;
        if (d < 0.0) {
            d = 0.0;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        return float_.intersects(d, d2, 5.0, 5.0);
    }

    @Override
    public boolean intersects(JobFlowShapeINF jobFlowShapeINF, Graphics2D graphics2D) {
        QuadCurve2D.Float float_ = new QuadCurve2D.Float(this.x0, this.y0, this.m_ctrlX, this.m_ctrlY, this.x1, this.y1);
        if (float_ == null) {
            return false;
        }
        Rectangle rectangle = jobFlowShapeINF.getOutline(graphics2D);
        if (rectangle == null) {
            return false;
        }
        return float_.intersects(rectangle);
    }

    public Point getUpperLeftBound() {
        this.calculateEndPoints();
        QuadCurve2D.Float float_ = new QuadCurve2D.Float(this.x0, this.y0, this.m_ctrlX, this.m_ctrlY, this.x1, this.y1);
        return float_.getBounds().getLocation();
    }

    public Point getBottomRightBound() {
        this.calculateEndPoints();
        QuadCurve2D.Float float_ = new QuadCurve2D.Float(this.x0, this.y0, this.m_ctrlX, this.m_ctrlY, this.x1, this.y1);
        Rectangle rectangle = float_.getBounds();
        return new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        this.calculateEndPoints();
        QuadCurve2D.Float float_ = new QuadCurve2D.Float(this.x0, this.y0, this.m_ctrlX, this.m_ctrlY, this.x1, this.y1);
        Stroke stroke = graphics2D.getStroke();
        float[] fArray = new float[]{8.0f, 3.0f};
        BasicStroke basicStroke = new BasicStroke(1.1f, 0, 0, 10.0f, fArray, 0.0f);
        graphics2D.setStroke(basicStroke);
        graphics2D.draw(float_);
        graphics2D.setStroke(stroke);
        double d = (double)this.x1 - (double)this.m_ctrlX;
        double d2 = (double)this.y1 - (double)this.m_ctrlY;
        double d3 = Math.atan(d2 / d) * 180.0 / 3.141569;
        int n = (int)d3;
        n = d >= 0.0 ? 180 - n : -n;
        graphics2D.fillArc(this.x1 - 17, this.y1 - 17, 35, 35, n - 17, 35);
        if (this.selectedFlag && (this.x0 != this.x1 || this.y0 != this.y1)) {
            if (this.x0 <= this.x1 && this.y0 <= this.y1) {
                graphics2D.drawRect(this.x0, this.y0, 4, 4);
                graphics2D.drawRect(this.x1 - 4, this.y1 - 4, 4, 4);
            } else if (this.x0 <= this.x1 && this.y0 > this.y1) {
                graphics2D.drawRect(this.x0, this.y0 - 4, 4, 4);
                graphics2D.drawRect(this.x1 - 4, this.y1, 4, 4);
            } else if (this.x0 > this.x1 && this.y0 <= this.y1) {
                graphics2D.drawRect(this.x0 - 4, this.y0, 4, 4);
                graphics2D.drawRect(this.x1, this.y1 - 4, 4, 4);
            } else {
                graphics2D.drawRect(this.x0 - 4, this.y0 - 4, 4, 4);
                graphics2D.drawRect(this.x1, this.y1, 4, 4);
            }
        }
    }

    @Override
    public void erase(Graphics2D graphics2D) {
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.white);
        this.selectedFlag = true;
        this.draw(graphics2D);
        this.selectedFlag = false;
        graphics2D.setColor(color);
    }

    @Override
    public void drawOutline(Graphics2D graphics2D) {
        this.calculateEndPoints();
        QuadCurve2D.Float float_ = new QuadCurve2D.Float(this.x0, this.y0, this.m_ctrlX, this.m_ctrlY, this.x1, this.y1);
        graphics2D.draw(float_);
    }

    @Override
    public Rectangle getOutline(Graphics2D graphics2D) {
        QuadCurve2D.Float float_ = new QuadCurve2D.Float(this.x0, this.y0, this.m_ctrlX, this.m_ctrlY, this.x1, this.y1);
        if (float_ == null) {
            return null;
        }
        Rectangle rectangle = float_.getBounds();
        if (rectangle == null) {
            return null;
        }
        if (rectangle.isEmpty()) {
            rectangle.grow(5, 5);
        }
        return rectangle;
    }

    public String toString() {
        return "proxies";
    }

    @Override
    public String getTipString() {
        return this.toString();
    }

    @Override
    public void setSelected(boolean bl) {
        this.selectedFlag = bl;
    }

    @Override
    public boolean isSelected() {
        return this.selectedFlag;
    }

    void calculateEndPoints() {
        this.x0 = this.eventSource.getX();
        this.y0 = this.eventSource.getY();
        this.x1 = this.eventDest.getX();
        this.y1 = this.eventDest.getY();
        Rectangle rectangle = this.eventSource.getImageOutline();
        Rectangle rectangle2 = this.eventDest.getImageOutline();
        if (this.x0 != this.x1 || this.y0 != this.y1) {
            if (this.x0 + rectangle.width < this.x1) {
                this.x0 += rectangle.width;
                this.y0 += rectangle.height / 2;
                this.y1 += rectangle2.height / 2;
            } else if (this.x1 + rectangle2.width < this.x0) {
                this.x1 += rectangle2.width;
                this.y1 += rectangle2.height / 2;
                this.y0 += rectangle.height / 2;
            } else if (this.y0 < this.y1) {
                this.x0 += rectangle.width / 2;
                this.y0 += rectangle.height;
                this.x1 += rectangle2.width / 2;
            } else {
                this.x1 += rectangle2.width / 2;
                this.y1 += rectangle2.height;
                this.x0 += rectangle.width / 2;
            }
        }
        this.calcCtrlPoint();
    }

    private void calcCtrlPoint() {
        float f = this.x0;
        float f2 = this.y0;
        float f3 = this.x1;
        float f4 = this.y1;
        float f5 = 0.6f;
        this.m_ctrlX = (f + f3 - (f2 - f4) * f5) / 2.0f;
        this.m_ctrlY = (f2 + f4 + (f - f3) * f5) / 2.0f;
    }

    @Override
    public String getRuntimeAttributesStr() {
        return null;
    }
}

