/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFFileEvent;
import com.platform.LSFJobFlow.ui.JFDescriptionPane;
import com.platform.LSFJobFlow.ui.JFEventBeanINF;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class JFFileEventBean
extends JPanel
implements JFEventBeanINF {
    boolean m_isEditable = true;
    public static final String Description = "Description";
    private JButton ctrlBrowseBtn;
    private JLabel ctrlConditionLbl;
    private JTextField ctrlFileNameEdit;
    private JLabel ctrlFileNameLbl;
    private JComboBox ctrlFunctionCombo;
    private JLabel ctrlMeasurementLbl;
    private JComboBox ctrlOperatorCombo;
    private JTextField ctrlValueEdit;
    private JLabel descriptionLbl;
    private JFDescriptionPane jFDescriptionPane1;
    private JScrollPane jScrollPane2;
    private JComboBox m_unitSelector;
    private static final String[] ageOperators = new String[]{JFResourceBundle.getString("Greater_than"), JFResourceBundle.getString("Greater_than_or_equal_to"), JFResourceBundle.getString("Equal_to"), JFResourceBundle.getString("Less_than"), JFResourceBundle.getString("Less_than_or_equal_to"), JFResourceBundle.getString("Not_equal_to")};
    private DefaultComboBoxModel ageOperatorsTranslate = new DefaultComboBoxModel<String>(new String[]{">", ">=", "==", "<", "<=", "!="});
    private static final String ERROR_MSG = JFResourceBundle.getString("JFFileEventBean$ERR_nullField");

    public JFFileEventBean() {
        this.initComponents();
        this.setInputAccessibleInfo();
        this.m_isEditable = true;
        this.updateFromEvent_(null);
    }

    @Override
    public JPanel getBeanPanel() {
        return this;
    }

    @Override
    public void setEvent(JFEvent jFEvent) throws Exception {
        if (null == jFEvent) {
            this.updateFromEvent_(null);
        } else {
            if (!(jFEvent instanceof JFFileEvent)) {
                throw new Exception(JFResourceBundle.getString("FileEventBean$ERR_eventNotObject"));
            }
            this.updateFromEvent_((JFFileEvent)jFEvent);
        }
    }

    @Override
    public JFEvent getEvent() throws Exception {
        String string = this.ctrlFileNameEdit.getText();
        if (string == null || string.equals("")) {
            throw new Exception(JFResourceBundle.getString("FileEventBean$ERR_emptyFileName"));
        }
        int n = this.ctrlFunctionCombo.getSelectedIndex();
        String string2 = null;
        String string3 = (String)this.ageOperatorsTranslate.getElementAt(this.ctrlOperatorCombo.getSelectedIndex());
        String string4 = this.ctrlValueEdit.getText();
        long l = -1L;
        switch (n) {
            case 0: {
                string2 = "exist";
                string3 = null;
                l = -1L;
                break;
            }
            case 1: {
                string2 = "exist";
                string3 = "!";
                l = -1L;
                break;
            }
            case 2: {
                string2 = "arrival";
                string3 = null;
                l = -1L;
                break;
            }
            case 3: {
                try {
                    l = Long.parseLong(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Exception(JFResourceBundle.getString("FileEventBean$ERR_invalidAge0"));
                }
                if (l < 0L) {
                    throw new Exception(JFResourceBundle.getString("FileEventBean$ERR_invalidAge"));
                }
                string2 = "age";
                break;
            }
            case 4: {
                try {
                    switch (this.m_unitSelector.getSelectedIndex()) {
                        case 0: {
                            l = Long.parseLong(string4);
                            break;
                        }
                        case 1: {
                            l = (long)(Float.parseFloat(string4) * 1024.0f);
                            break;
                        }
                        case 2: {
                            l = (long)(Float.parseFloat(string4) * 1024.0f * 1024.0f);
                            break;
                        }
                        default: {
                            l = Long.parseLong(string4);
                            break;
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Exception(JFResourceBundle.getString("FileEventBean$ERR_invalidSize0"));
                }
                if (l < 0L) {
                    throw new Exception(JFResourceBundle.getString("FileEventBean$ERR_invalidSize"));
                }
                string2 = "size";
                break;
            }
            default: {
                string2 = null;
            }
        }
        if (string2 != null) {
            JFFileEvent jFFileEvent = new JFFileEvent(string, string2, string3, l);
            jFFileEvent.setAttribute(Description, this.jFDescriptionPane1.getText());
            return jFFileEvent;
        }
        return null;
    }

    @Override
    public void reset() {
        this.ctrlFileNameEdit.setText("");
        this.ctrlFunctionCombo.setSelectedIndex(0);
        this.ctrlValueEdit.setText("");
        this.jFDescriptionPane1.setText("");
        this.m_unitSelector.setSelectedIndex(0);
    }

    @Override
    public void setEditable(boolean bl) {
        this.m_isEditable = bl;
        this.ctrlFileNameEdit.setEditable(bl);
        this.ctrlFileNameEdit.setEnabled(bl);
        this.ctrlFileNameEdit.setOpaque(bl);
        this.ctrlBrowseBtn.setEnabled(bl);
        this.ctrlFunctionCombo.setEnabled(bl);
        this.ctrlFunctionCombo.setOpaque(bl);
        this.jFDescriptionPane1.setEditable(bl);
        this.jFDescriptionPane1.setOpaque(bl);
        this.ctrlOperatorCombo.setEnabled(bl);
        this.ctrlOperatorCombo.setOpaque(bl);
        this.ctrlValueEdit.setEditable(bl);
        this.ctrlValueEdit.setOpaque(bl);
        this.ctrlValueEdit.setEnabled(bl);
        this.m_unitSelector.setEnabled(bl);
        this.m_unitSelector.setOpaque(bl);
    }

    @Override
    public String getSupportedEventTypeName() {
        return JFResourceBundle.getString("File_Event");
    }

    @Override
    public void showAllComponents() {
        this.ctrlOperatorCombo.setVisible(true);
        this.ctrlValueEdit.setVisible(true);
        this.ctrlMeasurementLbl.setVisible(true);
        this.m_unitSelector.setVisible(true);
    }

    private void setInputAccessibleInfo() {
        this.ctrlFileNameLbl.setLabelFor(this.ctrlFileNameEdit);
        this.ctrlFileNameEdit.getAccessibleContext().setAccessibleName(this.ctrlFileNameLbl.getText());
        this.ctrlFileNameEdit.getAccessibleContext().setAccessibleDescription(this.ctrlFileNameEdit.getToolTipText());
        this.ctrlBrowseBtn.getAccessibleContext().setAccessibleName(this.ctrlBrowseBtn.getText());
        this.ctrlBrowseBtn.getAccessibleContext().setAccessibleDescription(this.ctrlBrowseBtn.getToolTipText());
        this.ctrlConditionLbl.setLabelFor(this.ctrlFunctionCombo);
        this.ctrlFunctionCombo.getAccessibleContext().setAccessibleName(this.ctrlConditionLbl.getText());
        this.ctrlFunctionCombo.getAccessibleContext().setAccessibleDescription(this.ctrlFunctionCombo.getToolTipText());
        this.ctrlOperatorCombo.getAccessibleContext().setAccessibleName(this.ctrlFunctionCombo.getToolTipText());
        this.ctrlMeasurementLbl.setLabelFor(this.ctrlValueEdit);
        this.ctrlValueEdit.getAccessibleContext().setAccessibleName(this.ctrlMeasurementLbl.getText());
        this.ctrlValueEdit.getAccessibleContext().setAccessibleDescription(this.ctrlValueEdit.getToolTipText());
        this.descriptionLbl.setLabelFor(this.jScrollPane2);
        this.jScrollPane2.getAccessibleContext().setAccessibleName(this.descriptionLbl.getText());
    }

    private void initComponents() {
        this.ctrlFileNameLbl = new JLabel();
        this.ctrlFileNameEdit = new JTextField();
        this.ctrlBrowseBtn = new JButton();
        this.ctrlConditionLbl = new JLabel();
        this.ctrlFunctionCombo = new JComboBox();
        this.ctrlOperatorCombo = new JComboBox();
        this.ctrlValueEdit = new JTextField();
        this.ctrlMeasurementLbl = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jFDescriptionPane1 = new JFDescriptionPane();
        this.descriptionLbl = new JLabel();
        this.m_unitSelector = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.ctrlFileNameLbl.setText(JFResourceBundle.getString("File_name_"));
        this.ctrlFileNameLbl.setToolTipText(JFResourceBundle.getString("file_name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.ctrlFileNameLbl, gridBagConstraints);
        this.ctrlFileNameEdit.setToolTipText(JFResourceBundle.getString("FileEventBean$TIP_fileNameFLD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 166;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.ctrlFileNameEdit, gridBagConstraints);
        this.ctrlBrowseBtn.setText(JFResourceBundle.getString("Browse..."));
        this.ctrlBrowseBtn.setToolTipText(JFResourceBundle.getString("browse_for_file"));
        this.ctrlBrowseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFFileEventBean.this.ctrlBrowseBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.ctrlBrowseBtn, gridBagConstraints);
        this.ctrlConditionLbl.setText(JFResourceBundle.getString("Condition_"));
        this.ctrlConditionLbl.setToolTipText(JFResourceBundle.getString("FileEventBean$TIP_condition"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.ctrlConditionLbl, gridBagConstraints);
        this.ctrlFunctionCombo.setModel(new DefaultComboBoxModel<String>(new String[]{JFResourceBundle.getString("exists"), JFResourceBundle.getString("does_not_exist"), JFResourceBundle.getString("arrival"), JFResourceBundle.getString("age"), JFResourceBundle.getString("size")}));
        this.ctrlFunctionCombo.setToolTipText(JFResourceBundle.getString("FileEventBean$TIP_conditionFLD"));
        this.ctrlFunctionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFFileEventBean.this.ctrlFunctionComboActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.ctrlFunctionCombo, gridBagConstraints);
        this.ctrlOperatorCombo.setModel(new DefaultComboBoxModel<String>(ageOperators));
        this.ctrlOperatorCombo.setToolTipText(JFResourceBundle.getString("operator"));
        this.ctrlOperatorCombo.setEnabled(false);
        this.ctrlOperatorCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFFileEventBean.this.ctrlOperatorComboActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.ctrlOperatorCombo, gridBagConstraints);
        this.ctrlValueEdit.setEditable(false);
        this.ctrlValueEdit.setText("0");
        this.ctrlValueEdit.setToolTipText(JFResourceBundle.getString("JFFileEventBean$TIP_valueFLD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 32;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.ctrlValueEdit, gridBagConstraints);
        this.ctrlMeasurementLbl.setText(JFResourceBundle.getString("minutes"));
        this.ctrlMeasurementLbl.setToolTipText(JFResourceBundle.getString("JFFileEventBean$TIP_measurement_unit"));
        this.ctrlMeasurementLbl.setMaximumSize(new Dimension(70, 17));
        this.ctrlMeasurementLbl.setMinimumSize(new Dimension(70, 17));
        this.ctrlMeasurementLbl.setPreferredSize(new Dimension(70, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.ctrlMeasurementLbl, gridBagConstraints);
        this.jScrollPane2.setMinimumSize(new Dimension(200, 100));
        this.jScrollPane2.setPreferredSize(new Dimension(200, 100));
        this.jFDescriptionPane1.setToolTipText(JFResourceBundle.getString("FileEventBean$TIP_descriptionFLD"));
        this.jFDescriptionPane1.setMinimumSize(new Dimension(200, 100));
        this.jFDescriptionPane1.setPreferredSize(new Dimension(6, 6));
        this.jScrollPane2.setViewportView(this.jFDescriptionPane1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        this.descriptionLbl.setText(JFResourceBundle.getString("Description_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.descriptionLbl, gridBagConstraints);
        this.m_unitSelector.setModel(new DefaultComboBoxModel<String>(new String[]{JFResourceBundle.getString("bytes"), JFResourceBundle.getString("Kbytes"), JFResourceBundle.getString("Mbytes")}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.m_unitSelector, gridBagConstraints);
    }

    private void ctrlOperatorComboActionPerformed(ActionEvent actionEvent) {
    }

    private void ctrlBrowseBtnActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        if (0 == jFileChooser.showOpenDialog(this)) {
            this.ctrlFileNameEdit.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void ctrlFunctionComboActionPerformed(ActionEvent actionEvent) {
        int n = this.ctrlFunctionCombo.getSelectedIndex();
        String string = null;
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.ctrlOperatorCombo.setVisible(false);
                this.ctrlValueEdit.setVisible(false);
                this.ctrlMeasurementLbl.setVisible(false);
                this.m_unitSelector.setVisible(false);
                break;
            }
            case 3: {
                this.m_unitSelector.setVisible(false);
                this.ctrlOperatorCombo.setVisible(true);
                this.ctrlValueEdit.setVisible(true);
                this.ctrlMeasurementLbl.setVisible(true);
                string = this.ctrlValueEdit.getText();
                if (string == null || string.length() <= 0) {
                    this.ctrlValueEdit.setText("0");
                }
                if (!this.m_isEditable) break;
                this.ctrlValueEdit.requestFocus();
                break;
            }
            case 4: {
                this.ctrlOperatorCombo.setVisible(true);
                this.ctrlValueEdit.setVisible(true);
                this.ctrlMeasurementLbl.setVisible(false);
                this.m_unitSelector.setVisible(true);
                string = this.ctrlValueEdit.getText();
                if (string == null || string.length() <= 0) {
                    this.ctrlValueEdit.setText("0");
                }
                this.ctrlOperatorCombo.setVisible(true);
                this.ctrlValueEdit.setVisible(true);
                if (!this.m_isEditable) break;
                this.ctrlValueEdit.requestFocus();
                break;
            }
            default: {
                this.ctrlOperatorCombo.setVisible(false);
                this.ctrlValueEdit.setVisible(false);
                this.ctrlMeasurementLbl.setVisible(false);
                this.m_unitSelector.setVisible(false);
            }
        }
    }

    private void updateFromEvent_(JFFileEvent jFFileEvent) {
        if (jFFileEvent == null) {
            this.ctrlFunctionCombo.setSelectedIndex(0);
            return;
        }
        this.reset();
        String string = jFFileEvent.getEventType();
        String string2 = jFFileEvent.getOperator();
        long l = jFFileEvent.getLongValue();
        if (null != jFFileEvent.getFileName()) {
            this.ctrlFileNameEdit.setText(jFFileEvent.getFileName());
        }
        if (string == null) {
            return;
        }
        if (string.equals("exist")) {
            if (string2 != null && string2.equals("!")) {
                this.ctrlFunctionCombo.setSelectedIndex(1);
            } else {
                this.ctrlFunctionCombo.setSelectedIndex(0);
            }
        } else if (string.equals("arrival")) {
            this.ctrlFunctionCombo.setSelectedIndex(2);
        } else if (string.equals("age")) {
            this.ctrlFunctionCombo.setSelectedIndex(3);
        } else if (string.equals("size")) {
            this.ctrlFunctionCombo.setSelectedIndex(4);
        }
        if (string2 != null) {
            if (string2.equals(">")) {
                this.ctrlOperatorCombo.setSelectedIndex(0);
            } else if (string2.equals(">=")) {
                this.ctrlOperatorCombo.setSelectedIndex(1);
            } else if (string2.equals("==")) {
                this.ctrlOperatorCombo.setSelectedIndex(2);
            } else if (string2.equals("<")) {
                this.ctrlOperatorCombo.setSelectedIndex(3);
            } else if (string2.equals("<=")) {
                this.ctrlOperatorCombo.setSelectedIndex(4);
            } else if (string2.equals("!=")) {
                this.ctrlOperatorCombo.setSelectedIndex(5);
            }
        }
        if (l != -1L) {
            String string3 = String.valueOf(l);
            DecimalFormat decimalFormat = new DecimalFormat("#.##");
            if (string != null && string.equals("size")) {
                if (l >= 0x100000L) {
                    string3 = decimalFormat.format((double)l / 1048576.0);
                    this.m_unitSelector.setSelectedIndex(2);
                } else if (l >= 1024L) {
                    string3 = decimalFormat.format((double)l / 1024.0);
                    this.m_unitSelector.setSelectedIndex(1);
                } else {
                    string3 = String.valueOf(l);
                    this.m_unitSelector.setSelectedIndex(0);
                }
            }
            this.ctrlValueEdit.setText(string3);
        }
        if (jFFileEvent.getAttribute(Description) != null) {
            this.jFDescriptionPane1.setText(jFFileEvent.getAttribute(Description));
        }
    }
}

