/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.ui.JFCommand;

class JFCommandManager {
    public static final int MAX_CMD_NUM = 8;
    CommandStack m_undoList = new CommandStack(8);
    CommandStack m_redoList = new CommandStack(8);

    public void execute(JFCommand jFCommand) {
        if (jFCommand == null) {
            return;
        }
        jFCommand.doIt();
        this.m_undoList.push(jFCommand);
        this.m_redoList.empty();
    }

    public void postExecute(JFCommand jFCommand) {
        if (jFCommand == null) {
            return;
        }
        this.m_undoList.push(jFCommand);
        this.m_redoList.empty();
    }

    public void undo() {
        JFCommand jFCommand = this.m_undoList.pop();
        if (jFCommand != null) {
            jFCommand.undoIt();
            this.m_redoList.push(jFCommand);
        }
    }

    public void redo() {
        JFCommand jFCommand = this.m_redoList.pop();
        if (jFCommand != null) {
            jFCommand.doIt();
            this.m_undoList.push(jFCommand);
        }
    }

    public void reset() {
        this.m_undoList.empty();
        this.m_redoList.empty();
    }

    public boolean isUndoable() {
        return !this.m_undoList.isEmpty();
    }

    public boolean isRedoable() {
        return !this.m_redoList.isEmpty();
    }

    public class CommandStack {
        JFCommand[] m_cmdList = null;
        int m_stackSize = -1;
        int m_top = -1;
        int m_size = 0;

        public CommandStack(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Parameter <stackSize> should not be negative");
            }
            this.m_stackSize = n;
            this.m_cmdList = new JFCommand[n];
            this.m_top = -1;
            this.m_size = 0;
        }

        public void push(JFCommand jFCommand) {
            if (jFCommand == null) {
                return;
            }
            this.m_top = (this.m_top + 1) % this.m_stackSize;
            this.m_cmdList[this.m_top] = jFCommand;
            if (this.m_size < this.m_stackSize) {
                ++this.m_size;
            }
        }

        public JFCommand pop() {
            if (this.m_size <= 0) {
                return null;
            }
            JFCommand jFCommand = this.m_cmdList[this.m_top];
            this.m_top = (this.m_top - 1 + this.m_stackSize) % this.m_stackSize;
            --this.m_size;
            return jFCommand;
        }

        public JFCommand peek() {
            return this.m_cmdList[this.m_top];
        }

        public void empty() {
            this.m_top = -1;
            this.m_size = 0;
        }

        public boolean isEmpty() {
            return this.m_size <= 0;
        }
    }
}

