/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class JFArrayIndexDialog
extends JDialog
implements ActionListener {
    private JButton m_addButton;
    private JButton m_removeButton;
    private JButton m_okButton;
    private JButton m_cancelButton;
    private JList m_list;
    private DefaultListModel m_model;
    private JTextField m_startField;
    private JTextField m_endField;
    private JTextField m_stepField;
    private boolean m_editable;
    private boolean m_isOkPressed;
    private static final int MAX_INT = Integer.MAX_VALUE;

    public JFArrayIndexDialog(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.initGUI();
    }

    public JFArrayIndexDialog() {
        this.initGUI();
    }

    public void initGUI() {
        this.m_editable = true;
        this.getContentPane().setLayout(new BorderLayout());
        this.m_model = new DefaultListModel();
        this.m_list = new JList(this.m_model);
        this.m_list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                this.setBackground(bl ? Color.blue : Color.white);
                this.setForeground(bl ? Color.white : Color.black);
                this.setText(object.toString());
                return this;
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.m_list);
        JPanel jPanel = new JPanel(new GridLayout(8, 1));
        this.m_addButton = new JButton(JFResourceBundle.getString("Add"));
        this.m_addButton.setSize(new Dimension(90, 30));
        this.m_addButton.addActionListener(this);
        this.m_removeButton = new JButton(JFResourceBundle.getString("Remove"));
        this.m_removeButton.setSize(new Dimension(90, 30));
        this.m_removeButton.addActionListener(this);
        jPanel.add(this.m_addButton);
        jPanel.add(this.m_removeButton);
        for (int i = 0; i < 3; ++i) {
            jPanel.add(Box.createHorizontalStrut(50));
        }
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        JPanel jPanel4 = new JPanel(new GridLayout(1, 2));
        JLabel jLabel = new JLabel(JFResourceBundle.getString("Start_"), 4);
        jLabel.setSize(new Dimension(50, 20));
        this.m_startField = new JTextField("", 5);
        this.m_startField.setToolTipText(JFResourceBundle.getString("JFArrayIndexDialog$TIP_startFLD"));
        jLabel.setLabelFor(this.m_startField);
        this.m_startField.getAccessibleContext().setAccessibleName(jLabel.getText());
        this.m_startField.getAccessibleContext().setAccessibleDescription(this.m_startField.getToolTipText());
        JLabel jLabel2 = new JLabel(JFResourceBundle.getString("End_"), 4);
        jLabel2.setSize(new Dimension(50, 20));
        this.m_endField = new JTextField("", 5);
        this.m_endField.setToolTipText(JFResourceBundle.getString("JFArrayIndexDialog$TIP_endFLD"));
        jLabel2.setLabelFor(this.m_endField);
        this.m_endField.getAccessibleContext().setAccessibleName(jLabel2.getText());
        this.m_endField.getAccessibleContext().setAccessibleDescription(this.m_endField.getToolTipText());
        JLabel jLabel3 = new JLabel(JFResourceBundle.getString("Step_"), 4);
        jLabel3.setSize(new Dimension(50, 20));
        this.m_stepField = new JTextField("", 5);
        this.m_stepField.setToolTipText(JFResourceBundle.getString("JFArrayIndexDialog$TIP_stepFLD"));
        jLabel3.setLabelFor(this.m_stepField);
        this.m_stepField.getAccessibleContext().setAccessibleName(jLabel3.getText());
        this.m_stepField.getAccessibleContext().setAccessibleDescription(this.m_stepField.getToolTipText());
        jPanel2.add(jLabel);
        jPanel2.add(this.m_startField);
        jPanel3.add(jLabel2);
        jPanel3.add(this.m_endField);
        jPanel4.add(jLabel3);
        jPanel4.add(this.m_stepField);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        this.m_okButton = new JButton(JFResourceBundle.getString("OK"));
        this.m_okButton.addActionListener(this);
        this.m_cancelButton = new JButton(JFResourceBundle.getString("Cancel"));
        this.m_cancelButton.addActionListener(this);
        jPanel5.add(this.m_okButton);
        jPanel5.add(this.m_cancelButton);
        this.getContentPane().add((Component)new JLabel(JFResourceBundle.getString("Index_s_List") + ": "), "North");
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)jPanel, "East");
        this.getContentPane().add((Component)jPanel5, "South");
        this.setTitle(JFResourceBundle.getString("JobArrayIndexExpression$TITLE"));
        this.pack();
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.m_okButton);
    }

    public void addComp(Component component, JPanel jPanel, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        jPanel.add(component, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_addButton) {
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            string2 = this.m_startField.getText().trim();
            string3 = this.m_endField.getText().trim();
            string4 = this.m_stepField.getText().trim();
            String string5 = new Integer(Integer.MAX_VALUE).toString();
            try {
                int n = 0;
                int n2 = -1;
                int n3 = -1;
                n = Integer.parseInt(JFArrayIndexDialog.substituteVariables(string2, string5));
                if (n <= 0) {
                    throw new Exception();
                }
                string = string2;
                if (string3 != null && !string3.equals("")) {
                    n3 = Integer.parseInt(JFArrayIndexDialog.substituteVariables(string3, string5));
                    if (n != Integer.MAX_VALUE && n3 < n) {
                        throw new Exception();
                    }
                    string = string + "-" + string3;
                }
                if (string4 != null && !string4.equals("")) {
                    n2 = Integer.parseInt(JFArrayIndexDialog.substituteVariables(string4, string5));
                    if (n2 <= 0) {
                        throw new Exception();
                    }
                    string = string + ":" + string4;
                }
            }
            catch (Exception exception) {
                JFUtility.showAppErrorMsg(this, JFResourceBundle.getString("JFArrayIndexDialog$ERR_InvalidIndexExpr"));
                return;
            }
            this.m_model.addElement(string);
            this.reset();
        } else if (actionEvent.getSource() == this.m_removeButton) {
            Object[] objectArray = this.m_list.getSelectedValues();
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    this.m_model.removeElement(objectArray[i]);
                }
            }
        } else if (actionEvent.getSource() == this.m_okButton) {
            if (this.m_editable) {
                this.m_isOkPressed = true;
            }
            this.dispose();
        } else if (actionEvent.getSource() == this.m_cancelButton) {
            this.m_isOkPressed = false;
            this.dispose();
        }
    }

    public String getIndex() {
        String string = "[";
        for (int i = 0; i < this.m_model.size(); ++i) {
            string = string + ((String)this.m_model.elementAt(i)).trim() + ",";
        }
        if (string.equals("[")) {
            return "";
        }
        return string.substring(0, string.length() - 1) + "]";
    }

    public void setIndex(String string) {
        String string2 = null;
        this.m_model.removeAllElements();
        if (string.length() < 2) {
            return;
        }
        if (string.charAt(0) != '[' || string.charAt(string.length() - 1) != ']') {
            return;
        }
        string = string.substring(1, string.length() - 1);
        String string3 = new Integer(Integer.MAX_VALUE).toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                int n;
                String string4;
                int n2;
                String string5;
                String string6 = stringTokenizer.nextToken();
                if (string6.indexOf("-") == -1) {
                    string5 = string6.trim();
                    n2 = Integer.parseInt(JFArrayIndexDialog.substituteVariables(string5, string3));
                    if (n2 <= 0) {
                        throw new Exception();
                    }
                    string2 = string5;
                } else if (string6.indexOf(":") == -1) {
                    string5 = string6.substring(0, string6.indexOf("-")).trim();
                    string4 = string6.substring(string6.indexOf("-") + 1, string6.length()).trim();
                    n2 = Integer.parseInt(JFArrayIndexDialog.substituteVariables(string5, string3));
                    n = Integer.parseInt(JFArrayIndexDialog.substituteVariables(string4, string3));
                    if (n2 <= 0 || n <= 0) {
                        throw new Exception();
                    }
                    if (n2 != Integer.MAX_VALUE && n < n2) {
                        throw new Exception();
                    }
                    string2 = string5 + "-" + string4;
                } else {
                    string5 = string6.substring(0, string6.indexOf("-")).trim();
                    string4 = string6.substring(string6.indexOf("-") + 1, string6.indexOf(":")).trim();
                    String string7 = string6.substring(string6.indexOf(":") + 1, string6.length()).trim();
                    n2 = Integer.parseInt(JFArrayIndexDialog.substituteVariables(string5, string3));
                    n = Integer.parseInt(JFArrayIndexDialog.substituteVariables(string4, string3));
                    int n3 = Integer.parseInt(JFArrayIndexDialog.substituteVariables(string7, string3));
                    if (n2 <= 0 || n <= 0 || n3 <= 0) {
                        throw new Exception();
                    }
                    if (n2 != Integer.MAX_VALUE && n < n2) {
                        throw new Exception();
                    }
                    string2 = string5 + "-" + string4 + ":" + string7;
                }
                if (string2 == null) {
                    throw new Exception();
                }
                this.m_model.addElement(string2);
                string2 = null;
            }
            catch (Exception exception) {}
        }
        this.reset();
    }

    private static String substituteVariables(String string, String string2) {
        return JFUtility.substituteVariables(string, null, string2);
    }

    public static void checkArrayIndex(String string) throws Exception {
        if (string == null) {
            throw new Exception();
        }
        String string2 = null;
        String string3 = JFArrayIndexDialog.substituteVariables(string, new Integer(Integer.MAX_VALUE).toString());
        boolean bl = string.equals(string3);
        if (string3.length() < 2) {
            throw new Exception(JFResourceBundle.getString("JFArrayIndexDialog$ERR_InvalidIndexExpr"));
        }
        if (string3.charAt(0) != '[' || string3.charAt(string3.length() - 1) != ']') {
            throw new Exception(JFResourceBundle.getString("JFArrayIndexDialog$ERR_InvalidIndexExpr"));
        }
        if ((string3 = string3.substring(1, string3.length() - 1).trim()).length() <= 0) {
            throw new Exception(JFResourceBundle.getString("JFArrayIndexDialog$ERR_InvalidIndexExpr"));
        }
        int n = string3.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (string3.charAt(i) != ',') continue;
            ++n2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        if (n2 + 1 != stringTokenizer.countTokens()) {
            throw new Exception(JFResourceBundle.getString("JFArrayIndexDialog$ERR_InvalidIndexExpr"));
        }
        try {
            ArrayList<IndexItem> arrayList = new ArrayList<IndexItem>(3);
            while (stringTokenizer.hasMoreTokens()) {
                String string4;
                int n3;
                int n4;
                int n5;
                String string5;
                String string6 = stringTokenizer.nextToken();
                if (string6.indexOf("-") == -1) {
                    string5 = string6.trim();
                    n5 = Integer.parseInt(string5);
                    if (n5 <= 0) {
                        throw new Exception();
                    }
                    n4 = n5;
                    n3 = 1;
                } else if (string6.indexOf(":") == -1) {
                    string5 = string6.substring(0, string6.indexOf("-")).trim();
                    string4 = string6.substring(string6.indexOf("-") + 1, string6.length()).trim();
                    n5 = Integer.parseInt(string5);
                    n4 = Integer.parseInt(string4);
                    if (n5 <= 0 || n4 <= 0) {
                        throw new Exception();
                    }
                    if (n5 != Integer.MAX_VALUE && n4 < n5) {
                        throw new Exception();
                    }
                    n3 = 1;
                } else {
                    string5 = string6.substring(0, string6.indexOf("-")).trim();
                    string4 = string6.substring(string6.indexOf("-") + 1, string6.indexOf(":")).trim();
                    string2 = string6.substring(string6.indexOf(":") + 1, string6.length()).trim();
                    n5 = Integer.parseInt(string5);
                    n4 = Integer.parseInt(string4);
                    n3 = Integer.parseInt(string2);
                    if (n5 <= 0 || n4 <= 0 || n3 < 1) {
                        throw new Exception();
                    }
                    if (n5 != Integer.MAX_VALUE && n4 < n5) {
                        throw new Exception();
                    }
                }
                if (!bl) continue;
                IndexItem indexItem = new IndexItem(n5, n4, n3);
                int n6 = arrayList.size();
                for (int i = 0; i < n6; ++i) {
                    if (!indexItem.isDuplicate((IndexItem)arrayList.get(i))) continue;
                    throw new Exception();
                }
                arrayList.add(indexItem);
            }
        }
        catch (Exception exception) {
            throw new Exception(JFResourceBundle.getString("JFArrayIndexDialog$ERR_InvalidIndexExpr"));
        }
    }

    public void setEditable(boolean bl) {
        this.m_editable = bl;
        this.m_startField.setEnabled(bl);
        this.m_startField.setOpaque(bl);
        this.m_endField.setEnabled(bl);
        this.m_endField.setOpaque(bl);
        this.m_stepField.setEnabled(bl);
        this.m_stepField.setOpaque(bl);
        this.m_addButton.setEnabled(bl);
        this.m_removeButton.setEnabled(bl);
        this.m_okButton.setEnabled(bl);
        this.m_list.setEnabled(bl);
    }

    public void reset() {
        this.m_startField.setText("");
        this.m_endField.setText("");
        this.m_stepField.setText("");
    }

    public boolean isOkPressed() {
        return this.m_isOkPressed;
    }

    public static void main(String[] stringArray) {
        JFArrayIndexDialog jFArrayIndexDialog = new JFArrayIndexDialog();
        jFArrayIndexDialog.setSize(300, 300);
        jFArrayIndexDialog.show();
    }

    static class IndexItem {
        int m_start = 0;
        int m_end = 0;
        int m_step = 0;

        public IndexItem(int n, int n2, int n3) {
            this.m_start = n;
            this.m_end = n2;
            this.m_step = n3;
        }

        public boolean isDuplicate(IndexItem indexItem) {
            if (this.m_start > indexItem.m_end || this.m_end < indexItem.m_start) {
                return false;
            }
            for (int i = this.m_start; i <= this.m_end; i += this.m_step) {
                for (int j = indexItem.m_start; j <= indexItem.m_end; j += indexItem.m_step) {
                    if (j != i) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

