/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFJobInstance;
import com.platform.LSFJobFlow.api.JFTemplateJob;
import com.platform.LSFJobFlow.ui.AbstractImageShape;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import com.platform.LSFJobFlow.ui.SyscallBroker;
import java.text.MessageFormat;
import java.util.Properties;

abstract class AbstractJobShape
extends AbstractImageShape {
    JFJob jobDefObj = null;
    JFJobInstance jobInstObj = null;

    public AbstractJobShape(JFJob jFJob, int n, int n2) {
        super(n, n2, false);
        this.jobDefObj = jFJob;
        if (this.jobDefObj != null) {
            this.name = this.jobDefObj.getName();
        }
        if (jFJob == null) {
            this.isDummyShape = true;
        } else if (jFJob instanceof JFTemplateJob) {
            JFTemplateJob jFTemplateJob = (JFTemplateJob)jFJob;
            if (jFTemplateJob.getTemplateData() == null || jFTemplateJob.getTemplateData().getTemplateDefinition() == null || !jFTemplateJob.getTemplateData().hasAllRequiredSubmissionParams()) {
                this.isDummyShape = true;
            }
        } else {
            String string = jFJob.getAttribute("JobCmdLine");
            if (string == null || string.length() <= 0) {
                this.isDummyShape = true;
            }
        }
    }

    public AbstractJobShape(String string, int n, int n2) {
        super(string, n, n2);
    }

    public AbstractJobShape(JFJobInstance jFJobInstance, int n, int n2) {
        super(n, n2, true);
        this.jobInstObj = jFJobInstance;
        this.owner = jFJobInstance.getOwner();
        if (this.jobInstObj != null) {
            this.jobDefObj = this.jobInstObj.getJobDefinition();
            int n3 = this.jobInstObj.getState();
            switch (n3) {
                case 1: {
                    this.state = 0;
                    break;
                }
                case 2: {
                    this.state = 1;
                    break;
                }
                case 3: {
                    this.state = 2;
                    break;
                }
                case 4: {
                    this.state = 3;
                    break;
                }
                case 5: {
                    if (this.jobInstObj.isPending()) {
                        this.state = 10;
                        break;
                    }
                    this.state = 4;
                    break;
                }
                case 6: {
                    this.state = 5;
                    break;
                }
                case 7: {
                    this.state = 6;
                    break;
                }
                case 8: {
                    this.state = 7;
                    break;
                }
                case 9: {
                    this.state = 9;
                    break;
                }
                default: {
                    this.state = -1;
                }
            }
        }
        if (this.jobInstObj != null) {
            this.name = JFUtility.getShortInstanceName(this.jobInstObj.getName());
        }
    }

    public JFJob getDefObj() {
        if (this.jobDefObj != null) {
            this.jobDefObj.setAttribute("PositionX", String.valueOf(this.x));
            this.jobDefObj.setAttribute("PositionY", String.valueOf(this.y));
        }
        return this.jobDefObj;
    }

    public void setDefObj(JFJob jFJob) {
        if (jFJob != null) {
            this.jobDefObj = jFJob;
            this.isDummyShape = false;
        }
    }

    public JFJobInstance getInstanceObj() {
        return this.jobInstObj;
    }

    public abstract boolean updateImage();

    @Override
    public String toString() {
        return JFResourceBundle.getString("Job") + "[" + this.name + "]";
    }

    @Override
    public String getTipString() {
        if (this.isInstance) {
            Object[] objectArray = new Object[]{this.toString(), this.getCurStateString()};
            String string = JFResourceBundle.getString("A_is_B");
            MessageFormat messageFormat = new MessageFormat(string);
            return messageFormat.format(objectArray);
        }
        return this.toString();
    }

    @Override
    public String getRuntimeAttributesStr() {
        String string = null;
        if (this.jobInstObj != null) {
            String string2 = null;
            if (this.jobDefObj != null) {
                string2 = this.jobDefObj.getAttribute("JobCmdLine");
            }
            if (string2 == null) {
                string2 = "";
            }
            string = JFUtility.alignString("[" + JFResourceBundle.getString("Job_name") + "]", 20) + ": " + this.name;
            string = string + "\n" + JFUtility.alignString("[" + JFResourceBundle.getString("Job_ID") + "]", 20) + ": " + String.valueOf(this.jobInstObj.getInstanceId());
            String string3 = null;
            string3 = this.owner != null ? this.owner : this.jobDefObj.getAttribute("UserName");
            string = string + "\n" + JFUtility.alignString("[" + JFResourceBundle.getString("Submitter") + "]", 20) + ": " + string3;
            string = string + "\n" + JFUtility.alignString("[" + JFResourceBundle.getString("Command") + "]", 20) + ": " + string2;
            string = string + "\n" + JFUtility.alignString("[" + JFResourceBundle.getString("State") + "]", 20) + ": " + this.getCurStateString();
            if (this.state == 6 || this.state == 9) {
                string = string + "\n" + JFUtility.alignString("[" + JFResourceBundle.getString("Exit_code") + "]", 20) + ": " + String.valueOf(this.jobInstObj.getStatus());
                string = string + "\n" + JFUtility.alignString("[" + JFResourceBundle.getString("CPU_usage") + "]", 20) + ": " + String.valueOf(this.jobInstObj.getCPUUsage() + " seconds");
            }
            Object var4_4 = null;
            string = string + "\n" + JFUtility.alignString("[" + JFResourceBundle.getString("Start_time") + "]", 20) + ": ";
            String string4 = this.jobInstObj.getStartTimeString();
            if (string4 != null) {
                string = string + string4;
            }
            string = string + "\n" + JFUtility.alignString("[" + JFResourceBundle.getString("Finish_time") + "]", 20) + ": ";
            string4 = this.jobInstObj.getFinishTimeString();
            if (string4 != null) {
                string = string + string4;
            }
        }
        return string;
    }

    @Override
    public void update() {
        this.updateState();
    }

    private String getRuntimeFromLSF() {
        SyscallBroker syscallBroker = new SyscallBroker();
        Properties properties = null;
        int n = 10000;
        String string = "bjobs -l " + this.jobInstObj.getInstanceId();
        try {
            properties = syscallBroker.executeSysCall(n, string);
        }
        catch (Exception exception) {
            return null;
        }
        if (properties == null || properties.getProperty("stdout") == null) {
            return null;
        }
        return properties.getProperty("stdout");
    }

    private void updateState() {
        int n = this.jobInstObj.getState();
        switch (n) {
            case 1: {
                this.state = 0;
                break;
            }
            case 2: {
                this.state = 1;
                break;
            }
            case 3: {
                this.state = 2;
                break;
            }
            case 4: {
                this.state = 3;
                break;
            }
            case 5: {
                this.state = 4;
                break;
            }
            case 6: {
                this.state = 5;
                break;
            }
            case 7: {
                this.state = 6;
                break;
            }
            case 8: {
                this.state = 7;
                break;
            }
            case 9: {
                this.state = 9;
                break;
            }
            default: {
                this.state = -1;
            }
        }
    }
}

