/*
 * Decompiled with CFR 0.152.
 */
package com.sas.publicobjects.etl.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sas.publicobjects.etl.util.model.Link;
import com.sas.publicobjects.etl.util.model.Registry;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.http.client.utils.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestUtility {
    Logger log = LogManager.getLogger(this.getClass());
    public static String REST_LOGON_TICKET_SERVICE_NAME = "LogonTicketService REST";
    public static String REST_SERVICE_REGISTRY_SERVICE_NAME = "ServiceRegistry REST";
    public static String REST_SERVICE_REGISTRY_PATH = "/SASWIPClientAccess/rest/";
    public static String REST_HTTP_URI_SCHEME = "http://";
    Logger _logger = LogManager.getLogger(RestUtility.class);

    public String getLogonServiceURI(URI registryURI) {
        return this.getServiceURIFromRegistry(registryURI, REST_LOGON_TICKET_SERVICE_NAME);
    }

    public String getServiceURIFromRegistry(URI registryURI, String serviceName) {
        String returnValue = "";
        RestTemplate template = new RestTemplate();
        URI targetURI = null;
        try {
            targetURI = registryURI.getPort() == 0 ? new URIBuilder().setScheme(registryURI.getScheme()).setHost(registryURI.getHost()).setPath(REST_SERVICE_REGISTRY_PATH).build() : new URIBuilder().setScheme(registryURI.getScheme()).setHost(registryURI.getHost()).setPort(registryURI.getPort()).setPath(REST_SERVICE_REGISTRY_PATH).build();
        }
        catch (URISyntaxException se) {
            this._logger.error((Object)se);
        }
        String _registryService = targetURI.toString();
        HashMap vars = new HashMap();
        String servicesXML = (String)template.getForObject(_registryService, String.class, vars);
        if (servicesXML.length() > 0) {
            Registry reg = null;
            ObjectMapper m = new ObjectMapper();
            try {
                reg = (Registry)m.readValue(servicesXML, Registry.class);
            }
            catch (IOException e) {
                this.log.error("Error parsing", (Throwable)e);
                return returnValue;
            }
            if (reg != null) {
                for (Link link : reg.getLinks()) {
                    if (link.getRel().compareTo(serviceName) != 0) continue;
                    returnValue = link.getHref();
                    return returnValue;
                }
            }
        }
        return returnValue;
    }

    public String getTGTURIString(URI registryURI, String userName, String userPass) {
        List locations;
        String returnValue = null;
        RestTemplate template = this.getRestTemplateSimple();
        HttpHeaders headers = this.getHTTPHeadersSimple();
        HttpEntity TGTentity = new HttpEntity((Object)("username=" + userName + "&" + "password" + "=" + userPass), (MultiValueMap)headers);
        this.logHeaders((HttpEntity<String>)TGTentity);
        String logonServiceString = this.getLogonServiceURI(registryURI);
        HttpStatus statusCode = null;
        this.log.trace("Obtained TGT from: " + logonServiceString);
        ResponseEntity TGTresult = template.exchange(logonServiceString, HttpMethod.POST, TGTentity, String.class, new Object[0]);
        this.logHeaders((ResponseEntity<String>)TGTresult);
        statusCode = TGTresult.getStatusCode();
        if (!(statusCode == HttpStatus.CREATED | statusCode == HttpStatus.OK)) {
            this.log.error("Invalid status code: " + statusCode.toString());
        }
        if (TGTresult.hasBody() && (locations = TGTresult.getHeaders().get((Object)"Location")).size() > 0) {
            returnValue = (String)locations.get(0);
        }
        this.log.debug("Obtained TGT URI: " + returnValue);
        return returnValue;
    }

    public void logHeaders(HttpEntity<String> request) {
        if (this.log.isTraceEnabled() && request != null) {
            this.log.trace("HTTP Request: ");
            HttpHeaders headers = request.getHeaders();
            this.logHeaders(headers);
            String requestBody = (String)request.getBody();
            if (requestBody.length() > 0) {
                this.log.trace("\tHTTP Request Body: \t" + requestBody);
            }
        }
    }

    public void logHeaders(ResponseEntity<String> response) {
        if (this.log.isTraceEnabled() && response != null) {
            this.log.trace("HTTP Response: " + response.getStatusCode());
            HttpHeaders heads = response.getHeaders();
            this.logHeaders(heads);
            String responseBody = (String)response.getBody();
            if (responseBody.length() > 0) {
                this.log.trace("\tHTTP Response Body: \t" + responseBody);
            }
        }
    }

    public void logHeaders(HttpHeaders heads) {
        if (this.log.isTraceEnabled() && heads != null && heads.size() > 0) {
            Set keySet = heads.keySet();
            for (String key : keySet) {
                List values = heads.get((Object)key);
                if (values.size() == 1) {
                    this.log.trace("\t\t" + key + ": " + (String)values.get(0));
                    continue;
                }
                this.log.trace("\t\t" + key + ": " + values.toString());
            }
        }
    }

    public String getSGTString(String tgtURIString, String serviceURI) {
        String returnValue = null;
        RestTemplate template = this.getRestTemplateSimple();
        HttpHeaders headers = this.getHTTPHeadersSimple();
        HttpEntity SGTentity = new HttpEntity((Object)("service=" + serviceURI), (MultiValueMap)headers);
        this.log.debug("Obtaining SGT for service: " + serviceURI);
        this.logHeaders((HttpEntity<String>)SGTentity);
        ResponseEntity SGTresult = template.exchange(tgtURIString, HttpMethod.POST, SGTentity, String.class, new Object[0]);
        this.logHeaders((ResponseEntity<String>)SGTresult);
        returnValue = (String)SGTresult.getBody();
        this.log.trace("Obtained SGT: " + returnValue);
        return returnValue;
    }

    private RestTemplate getRestTemplateSimple() {
        RestTemplate template = new RestTemplate();
        FormHttpMessageConverter formHttpMessageConverter = new FormHttpMessageConverter();
        StringHttpMessageConverter stringHttpMessageConverternew = new StringHttpMessageConverter();
        ArrayList<Object> con = new ArrayList<Object>();
        con.add(formHttpMessageConverter);
        con.add(stringHttpMessageConverternew);
        template.setMessageConverters(con);
        return template;
    }

    private HttpHeaders getHTTPHeadersSimple() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_PLAIN);
        ArrayList<MediaType> acceptHeaders = new ArrayList<MediaType>();
        acceptHeaders.add(MediaType.TEXT_PLAIN);
        headers.setAccept(acceptHeaders);
        return headers;
    }
}

