/*
 * Decompiled with CFR 0.152.
 */
package com.sas.publicobjects.etl.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sas.publicobjects.etl.util.RestUtility;
import com.sas.publicobjects.etl.util.model.Service;
import com.sas.publicobjects.etl.util.model.Services;
import com.sas.services.user.UserIdentityInterface;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

public class RestSession {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private URI _serviceRegistryURI = null;
    private String _serverName;
    private String _userName;
    private String _userPass;
    private String _tgtURIString;
    private Map<String, String> _serviceTickets = new HashMap<String, String>();
    private RestUtility _ru = new RestUtility();

    RestSession(URI serviceRegistryURI, String username, String password) {
        this._serviceRegistryURI = serviceRegistryURI;
        if (null != this._serviceRegistryURI) {
            this.setServerName(serviceRegistryURI.getHost());
        }
        this._userName = username;
        this._userPass = password;
    }

    RestSession(URI serviceRegistryURI, UserIdentityInterface identity) {
        this._serviceRegistryURI = serviceRegistryURI;
        if (null != this._serviceRegistryURI) {
            this.setServerName(serviceRegistryURI.getHost());
        }
        this._userName = (String)identity.getPrincipal();
        this._userPass = (String)identity.getCredential();
    }

    public String getRestTGTURIString() {
        String returnValue = "";
        return returnValue;
    }

    public String getServiceTicket(String serviceURIString) {
        String returnValue = "";
        if (this._serviceTickets.containsKey(serviceURIString)) {
            returnValue = this._serviceTickets.get(serviceURIString);
            this.log.debug("Using existing service ticket \"" + returnValue + "\" for service: " + serviceURIString);
        } else {
            if (this._tgtURIString == null || this._tgtURIString.length() == 0) {
                this.log.debug("Fetching new TGT for service ticket.");
                this._tgtURIString = this._ru.getTGTURIString(this._serviceRegistryURI, this._userName, this._userPass);
            }
            if ((returnValue = this._ru.getSGTString(this._tgtURIString, serviceURIString)).length() > 0) {
                this._serviceTickets.put(serviceURIString, returnValue);
            }
        }
        return returnValue;
    }

    public String getServerName() {
        return this._serverName;
    }

    public void setServerName(String _serverName) {
        this._serverName = _serverName;
    }

    public RestUtility getRestUtility() {
        return this._ru;
    }

    public void setRestUtility(RestUtility _ru) {
        this._ru = _ru;
    }

    public String getServiceURI(String serviceURI) {
        String returnValue = null;
        String serviceTicket = this.getServiceTicket(serviceURI);
        if (serviceTicket != null && serviceTicket.length() > 0) {
            returnValue = this.addQueryToURIString(serviceURI, "ticket", serviceTicket);
        }
        return returnValue;
    }

    public String addQueryToURIString(String serviceURI, String key, String value) {
        String returnValue = "";
        try {
            URI current = new URI(serviceURI);
            if (current != null) {
                String queryStr = current.getQuery();
                queryStr = queryStr != null && queryStr.length() > 0 ? queryStr + "&" + key + "=" + value : key + "=" + value;
                URI target = new URI(current.getScheme(), current.getAuthority(), current.getPath(), queryStr, current.getFragment());
                returnValue = target.toString();
            }
        }
        catch (URISyntaxException ex) {
            this.log.error("error encoding URI: " + serviceURI, (Throwable)ex);
            returnValue = serviceURI;
        }
        return returnValue;
    }

    public Services getServicesREST() {
        return this.getServices("REST");
    }

    public Services getServices() {
        String types = "";
        return this.getServices(types);
    }

    public Services getServices(String types) {
        Services returnValue = null;
        RestTemplate template = new RestTemplate();
        RestUtility _ru = new RestUtility();
        String _registryService = _ru.getServiceURIFromRegistry(this._serviceRegistryURI, RestUtility.REST_SERVICE_REGISTRY_SERVICE_NAME);
        if (types != null && types.length() > 0) {
            _registryService = this.addQueryToURIString(_registryService, "types", "REST");
        }
        HashMap vars = new HashMap();
        String uri = this.getServiceURI(_registryService);
        String servicesXML = (String)template.getForObject(uri, String.class, vars);
        if (servicesXML.length() > 0) {
            ObjectMapper m = new ObjectMapper();
            try {
                returnValue = (Services)m.readValue(servicesXML, Services.class);
            }
            catch (IOException e) {
                this.log.error("Error parsing", (Throwable)e);
                return returnValue;
            }
        }
        return returnValue;
    }

    public String getServiceURIByName(String serviceName) {
        String returnValue = null;
        Services services = this.getServices();
        if (services != null) {
            for (Service link : services.getServices()) {
                if (!link.getName().equalsIgnoreCase(serviceName)) continue;
                returnValue = link.getUrl();
                return returnValue;
            }
        }
        return returnValue;
    }
}

