/*
 * Decompiled with CFR 0.152.
 */
package com.sas.publicobjects.etl;

import com.sas.etl.migration.UpgradeJobAction;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.impl.JobImpl;
import com.sas.metadata.remote.impl.JobImpl_Stub;
import com.sas.prompts.definitions.BaseFileDefinition;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.publicobjects.etl.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.etl.JobInterface;
import com.sas.services.information.metadata.prompt.BaseOMRPromptInterface;
import com.sas.services.information.metadata.prompt.OMRPromptDefinitionInterface;
import com.sas.services.information.metadata.prompt.OMRPromptGroupInterface;
import com.sas.services.information.metadata.prompt.PromptsPersistUtil;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.ProcessStatus;
import com.sas.services.util.UpgradeInterface;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.SubstitutionProperties;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

public class Job
extends Metadata
implements JobInterface,
SubstitutionProperties,
LocalizableProperties,
UpgradeInterface {
    private static final String APPLICATION_SERVER = ".ApplicationServer";
    private static final long serialVersionUID = -1107133479654435095L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    public static final UsageVersion FAILED_UPGRADE_VERSION = new UsageVersion(0, 5);
    private static final String MAIN_JOB_FILE_PATH = "JobSrcCodeFile.FilePath";
    private static final String MAIN_JOB_FILE_PATH_SERVER = "JobSrcCodeFile.FilePath.ApplicationServer";
    private static final String JOB_PREPROCESS_FILE_PATH = "JobPreProcess.FilePath";
    private static final String JOB_PREPROCESS_FILE_PATH_SERVER = "JobPreProcess.FilePath.ApplicationServer";
    private static final String JOB_POSTPROCESS_FILE_PATH = "JobPostProcess.FilePath";
    private static final String JOB_POSTPROCESS_FILE_PATH_SERVER = "JobPostProcess.FilePath.ApplicationServer";
    private static final String JOB_STEP_FILE_PATH = "JobStep.FilePath";
    private static final String JOB_STEP_FILE_PATH_SERVER = "JobStep.FilePath.ApplicationServer";
    public static final String PROPERTY_SUFFIX_DIRPATH = "DirPath";

    public Job() throws RemoteException {
    }

    public Job(Object o) throws RemoteException {
        super(o);
        this.setCompatibility(FAILED_UPGRADE_VERSION, CURRENT_VERSION);
    }

    public Job(com.sas.metadata.remote.Job o) throws RemoteException {
        super((Object)o);
        this.setCompatibility(FAILED_UPGRADE_VERSION, CURRENT_VERSION);
    }

    public Job(JobImpl o) throws RemoteException {
        super((Object)o);
        this.setCompatibility(FAILED_UPGRADE_VERSION, CURRENT_VERSION);
    }

    public Job(JobImpl_Stub o) throws RemoteException {
        super((Object)o);
        this.setCompatibility(FAILED_UPGRADE_VERSION, CURRENT_VERSION);
    }

    public Job(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        if (repos == null || name == null || parent == null) {
            throw new IllegalArgumentException();
        }
        OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
        try {
            com.sas.metadata.remote.Job job = (com.sas.metadata.remote.Job)omirepository.createMetadata(name, "Job");
            job.setPublicType("Job");
            job.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
            this._repositoryObject = job;
            this._repositoryFlag = 2;
            this.setRepository(repos);
            try {
                parent.addItem((MetadataInterface)this);
            }
            catch (ServiceException serviceException) {}
        }
        catch (ServiceException ex) {
            this.logThrowable(Level.WARN, ex.getMessage(), "com.sas.services.information.metadata.OMRDocument", ex);
        }
    }

    public String getType() throws RemoteException {
        if (this._repositoryObject != null) {
            PrimaryType pt = (PrimaryType)this._repositoryObject;
            return pt.getPublicType();
        }
        return "Job";
    }

    public PropertyList getLocalizableProperties() {
        PropertyList list = this.getDefaultLocalizableProperties();
        try {
            List prompts = this.getPrompts();
            if (prompts.size() > 0) {
                list.addBlankLine();
                list.addComment("Prompts");
            }
            for (int i = 0; i < prompts.size(); ++i) {
                OMRPromptGroupInterface promptGroup;
                PromptGroupInterface promptGroupI;
                BaseOMRPromptInterface prompt = (BaseOMRPromptInterface)prompts.get(i);
                if (!(prompt instanceof OMRPromptGroupInterface) || !((promptGroupI = (promptGroup = (OMRPromptGroupInterface)prompt).getPromptGroup()) instanceof LocalizableProperties)) continue;
                list.addProperty("Prompts[" + i + "]", ((LocalizableProperties)promptGroupI).getLocalizableProperties());
            }
        }
        catch (ServiceException e) {
            try {
                this.logMessage(Level.ERROR, "Error getting prompt information", ((Object)((Object)this)).getClass().getName(), e);
            }
            catch (RemoteException remoteException) {}
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return list;
    }

    public void setLocalizableProperties(PropertyMap map) {
        this.setDefaultLocalizableProperties(map);
        try {
            List prompts = this.getPrompts();
            for (int i = 0; i < prompts.size(); ++i) {
                OMRPromptGroupInterface promptGroup;
                PromptGroupInterface promptGroupI;
                BaseOMRPromptInterface prompt = (BaseOMRPromptInterface)prompts.get(0);
                if (!(prompt instanceof OMRPromptGroupInterface) || !((promptGroupI = (promptGroup = (OMRPromptGroupInterface)prompt).getPromptGroup()) instanceof LocalizableProperties)) continue;
                ((LocalizableProperties)promptGroupI).setLocalizableProperties(map.getNestedProperties("Prompts[" + i + "]"));
                PromptsPersistUtil.updateGroupSmartObject((PromptGroupInterface)promptGroupI, (UserContextInterface)this.getRepository().getUserContext(), (OMRPromptGroupInterface)promptGroup, null);
            }
        }
        catch (ServiceException ex) {
            try {
                this.logMessage(Level.ERROR, "Error getting prompt information", ((Object)((Object)this)).getClass().getName(), ex);
            }
            catch (RemoteException remoteException) {}
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void upgradeFromPreviousVersion() throws ServiceException, RemoteException {
        if (this._repositoryObject != null && this._repositoryObject instanceof com.sas.metadata.remote.Job) {
            com.sas.metadata.remote.Job smartOMRJob = (com.sas.metadata.remote.Job)this._repositoryObject;
            ProcessStatus status = new ProcessStatus(LogManager.getLogger((String)"com.sas.publicobjects.etl"), ProcessStatus.generateLoggingName((CMetadata)smartOMRJob));
            if ("SCHEDULER_BRIDGE_JOB".equalsIgnoreCase(smartOMRJob.getTransformRole())) {
                status.addInfo("Excluding migration for Scheduler Bridge Job");
                return;
            }
            if (this.getUsageVersion().compareTo((Object)FAILED_UPGRADE_VERSION) < 0) {
                smartOMRJob.setUsageVersion(FAILED_UPGRADE_VERSION.encode());
                try {
                    smartOMRJob.updateMetadataAll();
                }
                catch (MdException e) {
                    this.logThrowable(Level.ERROR, e.getMessage(), ((Object)((Object)this)).getClass().getName(), e);
                    throw new ServiceException((Throwable)e, e.getLocalizedMessage());
                }
            }
            this.ensureFolder();
            try {
                com.sas.metadata.remote.Job omrJob = smartOMRJob;
                UpgradeJobAction.upgradeJob((ProcessStatus)status, (com.sas.metadata.remote.Job)omrJob, (UserContextInterface)this._repository.getUserContext());
                if (!status.hasErrors()) {
                    String publicType = omrJob.getPublicType();
                    if ("Job".equals(publicType)) {
                        if (omrJob.getUsageVersion() != CURRENT_VERSION.encode()) {
                            omrJob.setUsageVersion(CURRENT_VERSION.encode());
                        }
                    } else if (publicType == null || publicType.length() == 0) {
                        omrJob.setPublicType("Job");
                        if (omrJob.getUsageVersion() != CURRENT_VERSION.encode()) {
                            omrJob.setUsageVersion(CURRENT_VERSION.encode());
                        }
                    }
                    omrJob.updateMetadataAll();
                }
            }
            catch (MdException e) {
                this.setUsageVersionFailedUpgrade();
                this.logThrowable(Level.ERROR, e.getMessage(), ((Object)((Object)this)).getClass().getName(), e);
                Throwable cause = e.getCause();
                Throwable rootCause = e;
                if (cause != null) {
                    rootCause = cause;
                }
                ServiceException se = new ServiceException((Throwable)e, rootCause.getLocalizedMessage());
                throw se;
            }
            catch (Throwable e) {
                this.setUsageVersionFailedUpgrade();
                this.logThrowable(Level.ERROR, e.getMessage(), ((Object)((Object)this)).getClass().getName(), e);
                Throwable cause = e.getCause();
                Throwable rootCause = e;
                if (cause != null) {
                    rootCause = cause;
                }
                ServiceException se = new ServiceException(e, rootCause.getLocalizedMessage());
                throw se;
            }
            finally {
                UpgradeJobAction.resetState();
                ProcessStatus globalStatus = ProcessStatus.getGlobalStatus();
                if (globalStatus != null) {
                    globalStatus.addStatus(status);
                } else {
                    status.logStatus();
                }
            }
        }
    }

    private void ensureFolder() throws ServiceException, RemoteException {
        String folderName;
        FolderInterface sharedData;
        FolderInterface targetFolder = this.getParent();
        if (targetFolder == null && (targetFolder = (sharedData = FolderUtil.makeSharedDataFolder((MetadataInterface)this)).getSubfolder(folderName = RB.getStringResource("Job.OrphanJobFolderName.txt"))) == null) {
            targetFolder = sharedData.makeSubfolder(folderName);
            targetFolder.update();
        }
        this.validateNameAndFolder(targetFolder);
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUsageVersionFailedUpgrade() {
        ChildServerInterface cTransaction = null;
        try {
            cTransaction = this._repository.getServer().newChild(true);
            MetadataInterface jobChildSmartObject = cTransaction.fetch(this.getEntityKey(), true);
            Object o = jobChildSmartObject.getRepositoryEntity();
            if (o != null && o instanceof com.sas.metadata.remote.Job) {
                com.sas.metadata.remote.Job jobObject = (com.sas.metadata.remote.Job)o;
                if (jobObject.getPublicType() == null || jobObject.getPublicType().length() == 0) {
                    jobObject.setPublicType(this.getType());
                }
                if (jobObject.getUsageVersion() != FAILED_UPGRADE_VERSION.encode()) {
                    jobObject.setUsageVersion(FAILED_UPGRADE_VERSION.encode());
                }
            }
            cTransaction.commit();
        }
        catch (RemoteException e) {
            try {
                this.logThrowable(Level.ERROR, e.getMessage(), ((Object)((Object)this)).getClass().getName(), e);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        catch (ServiceException e) {
            try {
                this.logThrowable(Level.ERROR, e.getMessage(), ((Object)((Object)this)).getClass().getName(), e);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        finally {
            if (cTransaction != null) {
                try {
                    cTransaction.destroy();
                }
                catch (ServiceException e) {
                }
                catch (RemoteException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyList getSubstitutionProperties() {
        PropertyList props = new PropertyList();
        try {
            com.sas.metadata.remote.Job smartJob = (com.sas.metadata.remote.Job)this._repositoryObject;
            MdObjectStore store = smartJob.getObjectStore().getFactory().createObjectStore(null, "com.sas.publicobjects.Job.getSubstitutionProperties");
            try {
                AssociationList lActivities;
                AssociationList lJobTargets;
                AssociationList lJobSources;
                com.sas.metadata.remote.Job mdJob = (com.sas.metadata.remote.Job)store.getFactory().createComplexMetadataObject(store, (CMetadata)smartJob);
                Text srcCode = mdJob.getSourceCode();
                if (srcCode != null && srcCode instanceof File) {
                    File jobFile = (File)srcCode;
                    this.addFileToSubstitutionProperties(props, jobFile, MAIN_JOB_FILE_PATH, MAIN_JOB_FILE_PATH_SERVER);
                    AssociationList l_dirs = jobFile.getDirectories();
                    if (l_dirs.size() > 0) {
                        Directory dir = (Directory)l_dirs.get(0);
                        this.addDirectoryPathToSubstitutionProperties(props, dir, PROPERTY_SUFFIX_DIRPATH);
                    }
                }
                if ((lJobSources = mdJob.getTransformationSources()) != null) {
                    for (int i = 0; i < lJobSources.size(); ++i) {
                        Object mdJobSource = lJobSources.get(i);
                        if (!(mdJobSource instanceof AbstractTransformation)) continue;
                        int count = i + 1;
                        this.addTxFileToSubstituionProperties(props, (AbstractTransformation)mdJobSource, JOB_PREPROCESS_FILE_PATH, JOB_PREPROCESS_FILE_PATH_SERVER, count);
                    }
                }
                if ((lJobTargets = mdJob.getTransformationTargets()) != null) {
                    for (int i = 0; i < lJobTargets.size(); ++i) {
                        Object mdJobTarget = lJobTargets.get(i);
                        if (!(mdJobTarget instanceof AbstractTransformation)) continue;
                        int count = i + 1;
                        this.addTxFileToSubstituionProperties(props, (AbstractTransformation)mdJobTarget, JOB_POSTPROCESS_FILE_PATH, JOB_POSTPROCESS_FILE_PATH_SERVER, count);
                    }
                }
                if (!(lActivities = mdJob.getJobActivities()).isEmpty()) {
                    TransformationActivity mdActivity = (TransformationActivity)lActivities.get(0);
                    AssociationList lSteps = mdActivity.getSteps();
                    for (int i = 0; i < lSteps.size(); ++i) {
                        AssociationList lStepTargets;
                        TransformationStep mdStep = (TransformationStep)lSteps.get(i);
                        int count = i + 1;
                        this.addTxFileToSubstituionProperties(props, (AbstractTransformation)mdStep, JOB_STEP_FILE_PATH, JOB_STEP_FILE_PATH_SERVER, count);
                        String stepName = "JobStep[" + count + "]";
                        String filePath = ".FilePath";
                        String serverPath = APPLICATION_SERVER;
                        AssociationList lStepSources = mdStep.getTransformationSources();
                        if (lStepSources != null) {
                            String localFilePath = stepName + ".PreProcess" + filePath;
                            String localServerPath = localFilePath + serverPath;
                            for (int j = 0; j < lStepSources.size(); ++j) {
                                Object mdStepSource = lStepSources.get(j);
                                if (!(mdStepSource instanceof AbstractTransformation)) continue;
                                int sscount = j + 1;
                                this.addTxFileToSubstituionProperties(props, (AbstractTransformation)mdStepSource, localFilePath, localServerPath, sscount);
                            }
                        }
                        if ((lStepTargets = mdStep.getTransformationTargets()) != null) {
                            String localFilePath = stepName + ".PostProcess" + filePath;
                            String localServerPath = localFilePath + serverPath;
                            for (int j = 0; j < lStepTargets.size(); ++j) {
                                Object mdStepTarget = lStepTargets.get(j);
                                if (!(mdStepTarget instanceof AbstractTransformation)) continue;
                                int sscount = j + 1;
                                this.addTxFileToSubstituionProperties(props, (AbstractTransformation)mdStepTarget, localFilePath, localServerPath, sscount);
                            }
                        }
                        AssociationList lTransformations = mdStep.getTransformations();
                        String localFilePath = stepName + ".Transformations" + filePath;
                        String localServerPath = localFilePath + serverPath;
                        for (int k = 0; k < lTransformations.size(); ++k) {
                            Transformation mdTransformation = (Transformation)lTransformations.get(k);
                            int ttcount = k + 1;
                            if (mdTransformation instanceof Job) continue;
                            this.addTxFileToSubstituionProperties(props, (AbstractTransformation)mdTransformation, localFilePath, localServerPath, ttcount);
                        }
                    }
                }
            }
            catch (MdException e) {
                this.logThrowable(Level.WARN, e.getMessage(), "com.sas.services.information.metadata.OMRDocument", e);
            }
            finally {
                store.dispose();
            }
            List prompts = this.getPrompts();
            for (BaseOMRPromptInterface prompt : prompts) {
                OMRPromptDefinitionInterface smartPromptDef;
                PromptDefinitionInterface promptDef;
                if (prompt instanceof OMRPromptDefinitionInterface && (promptDef = (smartPromptDef = (OMRPromptDefinitionInterface)prompt).getPromptDefinition()) instanceof BaseFileDefinition) {
                    BaseFileDefinition promptFileDef = (BaseFileDefinition)promptDef;
                    PropertyList pdefProps = promptFileDef.getSubstitutionProperties();
                    props.addProperty(promptFileDef.getPromptName(), pdefProps);
                }
                if (!(prompt instanceof OMRPromptGroupInterface)) continue;
                OMRPromptGroupInterface promptGroup = (OMRPromptGroupInterface)prompt;
                PromptGroupInterface promptGroupI = promptGroup.getPromptGroup();
                List promptDefs = promptGroupI.getPromptDefinitions(true);
                for (PromptDefinitionInterface promptDef2 : promptDefs) {
                    if (!(promptDef2 instanceof SubstitutionProperties)) continue;
                    SubstitutionProperties promptFileDef = (SubstitutionProperties)promptDef2;
                    PropertyList pdefProps = promptFileDef.getSubstitutionProperties();
                    props.addProperty(promptDef2.getPromptName(), pdefProps);
                }
            }
        }
        catch (ServiceException e) {
            try {
                this.logMessage(Level.ERROR, "Error getting prompt substitution information", ((Object)((Object)this)).getClass().getName(), e);
            }
            catch (RemoteException remoteException) {}
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubstitutionProperties(PropertyMap map) {
        try {
            com.sas.metadata.remote.Job smartJob = (com.sas.metadata.remote.Job)this._repositoryObject;
            MdObjectStore store = smartJob.getObjectStore().getFactory().createObjectStore(null, "com.sas.publicobjects.etl.Job.setSubstitutionProperties");
            try {
                AssociationList lActivities;
                AssociationList lJobTargets;
                AssociationList lJobSources;
                com.sas.metadata.remote.Job mdJob = (com.sas.metadata.remote.Job)store.getFactory().createComplexMetadataObject(store, (CMetadata)smartJob);
                Text srcCode = mdJob.getSourceCode();
                if (srcCode != null && srcCode instanceof File) {
                    File jobFile = (File)srcCode;
                    this.setFileFromSubstitutionProperties(map, jobFile, MAIN_JOB_FILE_PATH);
                    this.setServerNameOnFile(map, MAIN_JOB_FILE_PATH, 0, jobFile);
                    String transformRole = smartJob.getTransformRole();
                    if (transformRole.equalsIgnoreCase("SCHEDULER_JOB")) {
                        AssociationList l_dirs = jobFile.getDirectories();
                        String reposID = jobFile.getRepositoryID();
                        Directory dir = null;
                        if (l_dirs.size() > 0) {
                            dir = (Directory)l_dirs.get(0);
                            this.setDirPathFromSubstitutionProperties(map, dir, PROPERTY_SUFFIX_DIRPATH, store, reposID, jobFile, (List)l_dirs);
                        } else {
                            this.setDirPathFromSubstitutionProperties(map, dir, PROPERTY_SUFFIX_DIRPATH, store, reposID, jobFile, (List)l_dirs);
                        }
                    }
                }
                if ((lJobSources = mdJob.getTransformationSources()) != null) {
                    for (int i = 0; i < lJobSources.size(); ++i) {
                        Object mdJobSource = lJobSources.get(i);
                        if (!(mdJobSource instanceof AbstractTransformation)) continue;
                        int count = i + 1;
                        this.setTxFileFromSubstituionProperties(map, (AbstractTransformation)mdJobSource, JOB_PREPROCESS_FILE_PATH, count);
                    }
                }
                if ((lJobTargets = mdJob.getTransformationTargets()) != null) {
                    for (int i = 0; i < lJobTargets.size(); ++i) {
                        Object mdJobTarget = lJobTargets.get(i);
                        if (!(mdJobTarget instanceof AbstractTransformation)) continue;
                        int count = i + 1;
                        this.setTxFileFromSubstituionProperties(map, (AbstractTransformation)mdJobTarget, JOB_POSTPROCESS_FILE_PATH, count);
                    }
                }
                if (!(lActivities = mdJob.getJobActivities()).isEmpty()) {
                    TransformationActivity mdActivity = (TransformationActivity)lActivities.get(0);
                    AssociationList lSteps = mdActivity.getSteps();
                    for (int i = 0; i < lSteps.size(); ++i) {
                        AssociationList lStepTargets;
                        TransformationStep mdStep = (TransformationStep)lSteps.get(i);
                        int count = i + 1;
                        this.setTxFileFromSubstituionProperties(map, (AbstractTransformation)mdStep, JOB_STEP_FILE_PATH, count);
                        String stepName = "JobStep[" + count + "]";
                        String filePath = ".FilePath";
                        AssociationList lStepSources = mdStep.getTransformationSources();
                        if (lStepSources != null) {
                            String localFilePath = stepName + ".PreProcess" + filePath;
                            for (int j = 0; j < lStepSources.size(); ++j) {
                                Object mdStepSource = lStepSources.get(j);
                                if (!(mdStepSource instanceof AbstractTransformation)) continue;
                                int sscount = j + 1;
                                this.setTxFileFromSubstituionProperties(map, (AbstractTransformation)mdStepSource, localFilePath, sscount);
                            }
                        }
                        if ((lStepTargets = mdStep.getTransformationTargets()) != null) {
                            String localFilePath = stepName + ".PostProcess" + filePath;
                            for (int j = 0; j < lStepTargets.size(); ++j) {
                                Object mdStepTarget = lStepTargets.get(j);
                                if (!(mdStepTarget instanceof AbstractTransformation)) continue;
                                int sscount = j + 1;
                                this.setTxFileFromSubstituionProperties(map, (AbstractTransformation)mdStepTarget, localFilePath, sscount);
                            }
                        }
                        AssociationList lTransformations = mdStep.getTransformations();
                        String localFilePath = stepName + ".Transformations" + filePath;
                        for (int k = 0; k < lTransformations.size(); ++k) {
                            Transformation mdTransformation = (Transformation)lTransformations.get(k);
                            int ttcount = k + 1;
                            if (mdTransformation instanceof Job) continue;
                            this.setTxFileFromSubstituionProperties(map, (AbstractTransformation)mdTransformation, localFilePath, ttcount);
                        }
                    }
                }
                store.updatedMetadataAll();
            }
            catch (MdException e) {
                this.logThrowable(Level.WARN, e.getMessage(), "com.sas.publicobject.etl.Job", e);
            }
            finally {
                store.dispose();
            }
            List prompts = this.getPrompts();
            for (BaseOMRPromptInterface prompt : prompts) {
                OMRPromptDefinitionInterface smartPromptDef;
                PromptDefinitionInterface promptDef;
                if (prompt instanceof OMRPromptDefinitionInterface && (promptDef = (smartPromptDef = (OMRPromptDefinitionInterface)prompt).getPromptDefinition()) instanceof SubstitutionProperties) {
                    SubstitutionProperties promptFileDef = (SubstitutionProperties)promptDef;
                    promptFileDef.setSubstitutionProperties(map);
                    prompt.update();
                }
                if (!(prompt instanceof OMRPromptGroupInterface)) continue;
                OMRPromptGroupInterface promptGroup = (OMRPromptGroupInterface)prompt;
                PromptGroupInterface promptGroupI = promptGroup.getPromptGroup();
                List promptDefs = promptGroupI.getPromptDefinitions(true);
                for (PromptDefinitionInterface promptDef2 : promptDefs) {
                    if (!(promptDef2 instanceof SubstitutionProperties)) continue;
                    SubstitutionProperties promptFileDef = (SubstitutionProperties)promptDef2;
                    promptFileDef.setSubstitutionProperties(map.getNestedProperties(promptDef2.getPromptName()));
                }
                PromptsPersistUtil.updateGroupSmartObject((PromptGroupInterface)promptGroupI, (UserContextInterface)this.getRepository().getUserContext(), (OMRPromptGroupInterface)promptGroup, null);
                promptGroup.update();
            }
        }
        catch (ServiceException e) {
            try {
                this.logMessage(Level.ERROR, "Error setting prompt substitution information", ((Object)((Object)this)).getClass().getName(), e);
            }
            catch (RemoteException remoteException) {}
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void addTxFileToSubstituionProperties(PropertyList props, AbstractTransformation tx, String fileLocationName, String fileServerLocationName, int count) throws RemoteException, MdException {
        Text mdText = tx.getSourceCode();
        if (mdText instanceof File) {
            File mdFile = (File)mdText;
            String newFileLocationName = this.fixKeyForCount(fileLocationName, count);
            String newAppServerName = newFileLocationName + APPLICATION_SERVER;
            this.addFileToSubstitutionProperties(props, mdFile, newFileLocationName, newAppServerName);
        }
    }

    private void setTxFileFromSubstituionProperties(PropertyMap props, AbstractTransformation tx, String fileLocationName, int count) throws RemoteException, MdException {
        Text mdText = tx.getSourceCode();
        if (mdText instanceof File) {
            File mdFile = (File)mdText;
            this.setFileFromSubstitutionProperties(props, mdFile, this.fixKeyForCount(fileLocationName, count));
            this.setServerNameOnFile(props, fileLocationName, count, mdFile);
        }
    }

    private void setServerNameOnFile(PropertyMap props, String fileLocationName, int count, File mdFile) throws RemoteException, MdException {
        String serverName = props.getProperty(this.fixKeyForCount(fileLocationName, count) + APPLICATION_SERVER);
        if (serverName != null) {
            boolean setNewServer = false;
            AssociationList servers = mdFile.getDeployedComponents();
            if (servers != null && servers.size() > 0) {
                DeployedComponent serverInterface = (DeployedComponent)servers.get(0);
                if (!serverInterface.getName().equals(serverName)) {
                    setNewServer = true;
                    servers.remove(serverInterface);
                }
            } else {
                setNewServer = true;
            }
            if (setNewServer) {
                int flags = 268435852;
                String options = "<XMLSELECT search=\"*[@ClassIdentifier='SAS Application Server' and @Name='" + serverName + "']\"/>";
                String template = "";
                List foundServers = mdFile.getObjectStore().getFactory().getOMIUtil().getMetadataObjectsSubset(mdFile.getObjectStore(), "A0000001." + mdFile.getRepositoryID(), "ServerContext", flags, template + options, false);
                if (foundServers != null && foundServers.size() == 1) {
                    mdFile.getDeployedComponents().addAll((Collection)foundServers);
                } else {
                    this.logMessage(Level.DEBUG, "Unable to find server named: " + serverName, ((Object)((Object)this)).getClass().getPackage().getName(), null);
                }
            }
        }
    }

    private String fixKeyForCount(String fileLocationName, int count) {
        String returnValue = fileLocationName;
        if (count > 0) {
            int insertIndex = fileLocationName.indexOf(".FilePath");
            returnValue = fileLocationName.subSequence(0, insertIndex) + "[" + count + "].FilePath";
        }
        return returnValue;
    }

    private void addFileToSubstitutionProperties(PropertyList props, File mdFile, String fileLocationName, String fileServerLocationName) throws RemoteException, MdException {
        if (mdFile != null) {
            DeployedComponent dc;
            String serverName;
            AssociationList Servers;
            String location = mdFile.getFileName();
            if (location != null && location.length() > 0) {
                props.addProperty(fileLocationName, location);
            }
            if ((Servers = mdFile.getDeployedComponents()).size() > 0 && (serverName = (dc = (DeployedComponent)Servers.get(0)).getName()) != null && serverName.length() > 0) {
                props.addProperty(fileServerLocationName, serverName);
            }
        }
    }

    private void addDirectoryPathToSubstitutionProperties(PropertyList props, Directory mdFile, String fileLocationName) throws RemoteException, MdException {
        String location;
        if (mdFile != null && (location = mdFile.getDirectoryName()) != null && location.length() > 0) {
            props.addProperty(fileLocationName, location);
        }
    }

    private void setFileFromSubstitutionProperties(PropertyMap map, File mdFile, String mainFilePath) throws RemoteException, MdException {
        String existingName;
        String newValue;
        if (!(mdFile == null || (newValue = map.getProperty(mainFilePath)) == null || (existingName = mdFile.getFileName()) != null && existingName.equals(newValue))) {
            mdFile.setFileName(newValue);
            java.io.File localFile = new java.io.File(newValue);
            String shortName = localFile.getName();
            mdFile.setName(shortName);
        }
    }

    private void setDirPathFromSubstitutionProperties(PropertyMap map, Directory mdDir, String dirPath, MdObjectStore store, String reposID, File mdFile, List l_dirs) throws RemoteException, MdException {
        String newValue = map.getProperty(dirPath);
        if (newValue == null) {
            return;
        }
        String normalizeValue = newValue.replace("\\", "/");
        if (normalizeValue.endsWith("/")) {
            normalizeValue = normalizeValue.substring(0, normalizeValue.length() - 1);
        }
        String dirObjectName = normalizeValue.substring(normalizeValue.lastIndexOf("/") + 1);
        boolean createDir = false;
        if (mdDir != null && normalizeValue != null) {
            String existingName = mdDir.getDirectoryName();
            String currentDirObjectName = mdDir.getName();
            if (currentDirObjectName.equals(dirObjectName) && existingName != null && existingName.equals(normalizeValue)) {
                mdFile.setDirectories((AssociationList)l_dirs);
            } else {
                createDir = true;
            }
        }
        if (mdDir == null || createDir) {
            Directory dir;
            String strSelect = "<XMLSELECT search=\"Directory[@Name='" + dirObjectName + "' and @DirectoryName='" + normalizeValue + "']\" />";
            int OMIFLAG_MULTI_TEMPLATE = 8588;
            List l_existingDirs = store.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, "A0000001." + mdFile.getRepositoryID(), "Directory", OMIFLAG_MULTI_TEMPLATE, strSelect);
            if (l_existingDirs.size() > 0) {
                dir = (Directory)l_existingDirs.get(0);
            } else {
                dir = (Directory)store.getFactory().createComplexMetadataObject(store, dirObjectName, "Directory", reposID);
                dir.setDirectoryName(normalizeValue);
            }
            l_dirs.clear();
            l_dirs.add(dir);
            mdFile.setDirectories((AssociationList)l_dirs);
        }
    }
}

