/*
 * Decompiled with CFR 0.152.
 */
package com.sas.publicobjects.etl;

import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASFileRef;
import com.sas.metadata.remote.impl.ExternalTableImpl;
import com.sas.metadata.remote.impl.ExternalTableImpl_Stub;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.publicobjects.etl.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRColumn;
import com.sas.services.information.metadata.OMRExternalFile;
import com.sas.services.information.metadata.prompt.BaseOMRPromptInterface;
import com.sas.services.information.metadata.prompt.OMRPromptGroupInterface;
import com.sas.services.information.metadata.prompt.PromptsPersistUtil;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.Names;
import com.sas.services.util.ProcessStatus;
import com.sas.services.util.UpgradeInterface;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.SubstitutionProperties;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import com.sas.wadmin.prompts.conversion.DISEntityConverter;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.prefs.BackingStoreException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

public class ExternalFile
extends OMRExternalFile
implements Remote,
SubstitutionProperties,
LocalizableProperties,
UpgradeInterface {
    private static final long serialVersionUID = -7508655905489444303L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    public static final UsageVersion FAILED_UPGRADE_VERSION = new UsageVersion(0, 5);
    public static final String TABLE_COLUMN_DEPENDENCIES_TEMPLATE = "<Templates><ExternalTable><Columns/></ExternalTable></Templates>";
    private static final String MAIN_FILE_PATH = "OwningFile.FilePath";
    private static final String MAIN_FILE_PATH_SERVER = "OwningFile.FilePath.ApplicationServer";
    private static final String FORMAT_FILE_PATH = "FormatFile.FilePath";
    private static final String FORMAT_FILE_PATH_SERVER = "FormatFile.FilePath.ApplicationServer";
    private static final String COBOL_FILE_PATH = "CobolFormatFile.FilePath";
    private static final String COBOL_FILE_PATH_SERVER = "CobolFormatFile.FilePath.ApplicationServer";
    private static final String USERWRITTEN_FILE_PATH = "UserWrittenSourceCode.FilePath";
    private static final String USER_WRITTEN_FILE_PATH_SERVER = "UserWrittenSourceCode.FilePath.ApplicationServer";

    public ExternalFile() throws RemoteException {
    }

    public ExternalFile(Class o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public ExternalFile(ExternalTable o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public ExternalFile(ExternalTableImpl o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public ExternalFile(ExternalTableImpl_Stub o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public ExternalFile(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        if (repos == null || name == null || parent == null) {
            throw new IllegalArgumentException();
        }
        OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
        try {
            ExternalTable externalFile = (ExternalTable)omirepository.createMetadata(name, "ExternalTable");
            externalFile.setPublicType("ExternalFile");
            externalFile.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
            this._repositoryObject = externalFile;
            this._repositoryFlag = 2;
            this.setRepository(repos);
            try {
                parent.addItem((MetadataInterface)this);
            }
            catch (ServiceException serviceException) {}
        }
        catch (ServiceException ex) {
            this.logThrowable(Level.WARN, ex.getMessage(), "com.sas.services.information.metadata.OMRDocument", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyList getSubstitutionProperties() {
        PropertyList props = new PropertyList();
        try {
            ExternalTable smartExternalFile = (ExternalTable)this._repositoryObject;
            MdObjectStore store = smartExternalFile.getObjectStore().getFactory().createObjectStore(null, "com.sas.publicobject.ExternalFile.getSubstitutionProperties");
            try {
                ExternalTable externalFile = (ExternalTable)store.getFactory().createComplexMetadataObject(store, (CMetadata)smartExternalFile);
                File mdFile = externalFile.getOwningFile();
                this.addFileToSubstitutionProperties(props, mdFile, MAIN_FILE_PATH, MAIN_FILE_PATH_SERVER);
                AssociationList lCMs = externalFile.getTargetTransformations();
                for (AbstractTransformation mdTransformation : lCMs) {
                    AssociationList lSourceFiles;
                    if (!(mdTransformation instanceof ClassifierMap)) continue;
                    ClassifierMap mdCM = (ClassifierMap)mdTransformation;
                    if ("FormatFile".equals(mdCM.getTransformRole())) {
                        AssociationList lFiles = mdCM.getTransformationSources();
                        if (lFiles.isEmpty()) continue;
                        File mdEFFFile = (File)lFiles.get(0);
                        this.addFileToSubstitutionProperties(props, mdEFFFile, FORMAT_FILE_PATH, FORMAT_FILE_PATH_SERVER);
                        AssociationList lCobolCMs = mdEFFFile.getTargetTransformations();
                        for (ClassifierMap mdCobolCM : lCobolCMs) {
                            AssociationList lCobolFiles;
                            if (!"CobolFormatFile".equals(mdCobolCM.getTransformRole()) || (lCobolFiles = mdCobolCM.getTransformationSources()).isEmpty()) continue;
                            File mdCopyBookFile = (File)lCobolFiles.get(0);
                            this.addFileToSubstitutionProperties(props, mdCopyBookFile, COBOL_FILE_PATH, COBOL_FILE_PATH_SERVER);
                        }
                        continue;
                    }
                    if (!"UserWrittenSourceCode".equals(mdCM.getTransformRole())) continue;
                    boolean found = false;
                    AssociationList lUWSourceFiles = mdCM.getSourceCodes();
                    if (!lUWSourceFiles.isEmpty() && lUWSourceFiles.get(0) instanceof File) {
                        File mdSourceFile = (File)lUWSourceFiles.get(0);
                        this.addFileToSubstitutionProperties(props, mdSourceFile, USERWRITTEN_FILE_PATH, USER_WRITTEN_FILE_PATH_SERVER);
                        found = true;
                    }
                    if (found || (lSourceFiles = mdCM.getTransformationSources()).isEmpty() || !(lSourceFiles.get(0) instanceof File)) continue;
                    File mdSourceFile = (File)lSourceFiles.get(0);
                    this.addFileToSubstitutionProperties(props, mdSourceFile, USERWRITTEN_FILE_PATH, USER_WRITTEN_FILE_PATH_SERVER);
                }
            }
            catch (MdException e) {
                this.logThrowable(Level.WARN, e.getMessage(), "com.sas.services.information.metadata.OMRDocument", e);
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return props;
    }

    private void addFileToSubstitutionProperties(PropertyList props, File mdFile, String fileLocationName, String fileServerLocationName) throws RemoteException, MdException {
        if (mdFile != null) {
            AssociationList lFileRefs = mdFile.getFileRefs();
            if (!lFileRefs.isEmpty()) {
                DeployedComponent dc;
                String serverName;
                AssociationList Servers;
                SASFileRef mdFileRef = (SASFileRef)lFileRefs.get(0);
                String location = mdFile.getFileName();
                if (location != null && location.length() > 0) {
                    props.addProperty(fileLocationName, location);
                }
                if ((Servers = mdFileRef.getDeployedComponents()).size() > 0 && (serverName = (dc = (DeployedComponent)Servers.get(0)).getName()) != null && serverName.length() > 0) {
                    props.addProperty(fileServerLocationName, serverName);
                }
            } else {
                DeployedComponent dc;
                String serverName;
                AssociationList Servers;
                String location = mdFile.getFileName();
                if (location != null && location.length() > 0) {
                    props.addProperty(fileLocationName, location);
                }
                if ((Servers = mdFile.getDeployedComponents()).size() > 0 && (serverName = (dc = (DeployedComponent)Servers.get(0)).getName()) != null && serverName.length() > 0) {
                    props.addProperty(fileServerLocationName, serverName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubstitutionProperties(PropertyMap map) {
        try {
            ExternalTable smartExternalFile = (ExternalTable)this._repositoryObject;
            MdObjectStore store = smartExternalFile.getObjectStore().getFactory().createObjectStore(null, "com.sas.publicobject.ExternalFile.setSubstitutionProperties");
            try {
                ExternalTable externalFile = (ExternalTable)store.getFactory().createComplexMetadataObject(store, (CMetadata)smartExternalFile);
                AssociationList files = externalFile.getOwningFiles(true);
                if (!files.isEmpty()) {
                    File mdFile = externalFile.getOwningFile();
                    this.setFileFromSubstitutionProperties(map, mdFile, MAIN_FILE_PATH);
                }
                AssociationList lCMs = externalFile.getTargetTransformations(true);
                for (AbstractTransformation mdTransformation : lCMs) {
                    AssociationList lSourceFiles;
                    if (!(mdTransformation instanceof ClassifierMap)) continue;
                    ClassifierMap mdCM = (ClassifierMap)mdTransformation;
                    if ("FormatFile".equals(mdCM.getTransformRole())) {
                        AssociationList lFiles = mdCM.getTransformationSources(true);
                        if (lFiles.isEmpty()) continue;
                        File mdEFFFile = (File)lFiles.get(0);
                        this.setFileFromSubstitutionProperties(map, mdEFFFile, FORMAT_FILE_PATH);
                        AssociationList lCobolCMs = mdEFFFile.getTargetTransformations(true);
                        for (ClassifierMap mdCobolCM : lCobolCMs) {
                            AssociationList lCobolFiles;
                            if (!"CobolFormatFile".equals(mdCobolCM.getTransformRole()) || (lCobolFiles = mdCobolCM.getTransformationSources(true)).isEmpty()) continue;
                            File mdCopyBookFile = (File)lCobolFiles.get(0);
                            this.setFileFromSubstitutionProperties(map, mdCopyBookFile, COBOL_FILE_PATH);
                        }
                        continue;
                    }
                    if (!"UserWrittenSourceCode".equals(mdCM.getTransformRole())) continue;
                    boolean fileset = false;
                    AssociationList lUWSourceFiles = mdCM.getSourceCodes(true);
                    if (!lUWSourceFiles.isEmpty() && lUWSourceFiles.get(0) instanceof File) {
                        File mdSourceFile = (File)lUWSourceFiles.get(0);
                        this.setFileFromSubstitutionProperties(map, mdSourceFile, USERWRITTEN_FILE_PATH);
                        fileset = true;
                    }
                    if (fileset || (lSourceFiles = mdCM.getTransformationSources(true)).isEmpty() || !(lSourceFiles.get(0) instanceof File)) continue;
                    File mdSourceFile = (File)lSourceFiles.get(0);
                    this.setFileFromSubstitutionProperties(map, mdSourceFile, USERWRITTEN_FILE_PATH);
                }
                store.updatedMetadataAll();
            }
            catch (MdException e) {
                this.logThrowable(Level.WARN, e.getMessage(), "com.sas.publicobject.etl.ExternalFile", e);
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void setFileFromSubstitutionProperties(PropertyMap map, File mdFile, String mainFilePath) throws RemoteException, MdException {
        String existingName;
        String newValue;
        if (!(mdFile == null || (newValue = map.getProperty(mainFilePath)) == null || (existingName = mdFile.getFileName()) != null && existingName.equals(newValue))) {
            mdFile.setFileName(newValue);
            java.io.File localFile = new java.io.File(newValue);
            String shortName = localFile.getName();
            mdFile.setName(shortName);
            AssociationList lFileRefs = mdFile.getFileRefs();
            if (!lFileRefs.isEmpty()) {
                SASFileRef mdFileRef = (SASFileRef)lFileRefs.get(0);
                mdFileRef.setName(shortName);
            }
        }
    }

    public void upgradeFromPreviousVersion() throws ServiceException, RemoteException {
        if (this._repositoryObject != null && this._repositoryObject instanceof ExternalTable) {
            ExternalTable smartExternalFile = (ExternalTable)this._repositoryObject;
            ProcessStatus status = new ProcessStatus(LogManager.getLogger((String)"com.sas.publicobjects.etl"), ProcessStatus.generateLoggingName((CMetadata)smartExternalFile));
            try {
                this.prepareExternalFileUpgrade(smartExternalFile);
                this.ensureFolder();
                DISEntityConverter converter = new DISEntityConverter((MdObjectStore)smartExternalFile.getObjectStore(), (Root)smartExternalFile, this.getRepository().getUserContext());
                PromptGroupInterface prompt = converter.convert2Prompt(false, true);
                if (prompt != null) {
                    String message = Message.format((String)RB.getStringResource("ExternalFile.CreatedNewPrompt.fmt.txt"), (Object[])new Object[]{prompt, this.getName()});
                    this.logMessage(Level.INFO, message);
                    status.addInfo(message);
                }
                AssociationList columns = smartExternalFile.getColumns(true);
                ArrayList<String> lSASColumnNames = new ArrayList<String>();
                ArrayList<Column> lColumns = new ArrayList<Column>();
                for (Column column : columns) {
                    column.setPublicType("Column");
                    column.setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
                    String sasColName = column.getSASColumnName();
                    if (sasColName == null || sasColName.length() == 0) {
                        lColumns.add(column);
                        continue;
                    }
                    lSASColumnNames.add(sasColName);
                }
                this.fixSASColumnNames(status, lColumns, lSASColumnNames);
                this.migrateUWSourceFileReferences(smartExternalFile, status);
                smartExternalFile.setPublicType("ExternalFile");
                smartExternalFile.setUsageVersion(CURRENT_VERSION.encode());
                smartExternalFile.updateMetadataAll();
            }
            catch (MdException e) {
                status.addErrorException(ProcessStatus.generateLoggingName((CMetadata)smartExternalFile), (Throwable)e);
                this.logThrowable(Level.ERROR, e.getMessage(), this.getClass().getName(), e);
                throw new ServiceException((Throwable)e, e.getLocalizedMessage());
            }
            catch (BackingStoreException e) {
                status.addErrorException(ProcessStatus.generateLoggingName((CMetadata)smartExternalFile), (Throwable)e);
                this.logThrowable(Level.ERROR, e.getMessage(), this.getClass().getName(), e);
                throw new ServiceException((Throwable)e, e.getLocalizedMessage());
            }
            finally {
                ProcessStatus globalStatus = ProcessStatus.getGlobalStatus();
                if (globalStatus != null) {
                    globalStatus.addStatus(status);
                } else {
                    status.logStatus();
                }
            }
        }
    }

    private void migrateUWSourceFileReferences(ExternalTable smartExternalFile, ProcessStatus status) throws RemoteException, MdException {
        AssociationList tgtTransformations = smartExternalFile.getTargetTransformations();
        for (AbstractTransformation mdTransformation : tgtTransformations) {
            String message;
            AssociationList lSourceFiles;
            ClassifierMap mdCM;
            if (!(mdTransformation instanceof ClassifierMap) || !"UserWrittenSourceCode".equals((mdCM = (ClassifierMap)mdTransformation).getTransformRole()) || (lSourceFiles = mdCM.getTransformationSources()).isEmpty() || !(lSourceFiles.get(0) instanceof File)) continue;
            File mdSourceFile = (File)lSourceFiles.get(0);
            AssociationList luwSrcFiles = mdCM.getSourceCodes();
            if (luwSrcFiles.isEmpty()) {
                lSourceFiles.remove(mdSourceFile);
                luwSrcFiles.add(mdSourceFile);
                message = Message.format((String)RB.getStringResource("ExternalFile.MovedFileReference.fmt.txt"), (Object[])new Object[]{mdSourceFile.getFileName(), this.getName()});
                this.logMessage(Level.INFO, message);
                status.addInfo(message);
                continue;
            }
            lSourceFiles.remove(mdSourceFile);
            message = Message.format((String)RB.getStringResource("ExternalFile.RemovedFileReference.fmt.txt"), (Object[])new Object[]{mdSourceFile.getFileName(), this.getName()});
            this.logMessage(Level.INFO, message);
            status.addInfo(message);
            mdSourceFile.delete();
        }
    }

    private void ensureFolder() throws ServiceException, RemoteException {
        String folderName;
        FolderInterface sharedData;
        FolderInterface targetFolder = this.getParent();
        if (targetFolder == null && (targetFolder = (sharedData = FolderUtil.makeSharedDataFolder((MetadataInterface)this)).getSubfolder(folderName = RB.getStringResource("ExternalFile.OrphanExternalFileFolderName.txt"))) == null) {
            targetFolder = sharedData.makeSubfolder(folderName);
        }
        this.validateNameAndFolder(targetFolder);
        this.update();
    }

    private void fixSASColumnNames(ProcessStatus status, List lColumns, List lUniqueSASColumnNames) throws RemoteException {
        for (Column column : lColumns) {
            String metaName = column.getName();
            String newSASColumnName = null;
            try {
                if (metaName != null && metaName.length() > 0) {
                    newSASColumnName = Names.mapNameToSASVariableName((String)metaName, (Collection)lUniqueSASColumnNames);
                } else {
                    String tName = Names.generateName((int)32);
                    newSASColumnName = Names.mapNameToSASVariableName((String)tName, (Collection)lUniqueSASColumnNames);
                }
            }
            catch (IllegalArgumentException e) {
                this.logThrowable(Level.ERROR, e.getMessage(), this.getClass().getName(), e);
            }
            lUniqueSASColumnNames.add(newSASColumnName);
            String oldName = column.getSASColumnName();
            String message = Message.format((String)RB.getStringResource("ExternalFile.SetSASColumnName.fmt.txt"), (Object[])new Object[]{column.getName(), oldName, newSASColumnName, this.getName()});
            this.logMessage(Level.WARN, message);
            status.addWarning(ProcessStatus.generateLoggingName((CMetadata)column), message);
            column.setSASColumnName(newSASColumnName);
        }
    }

    private void prepareExternalFileUpgrade(ExternalTable jomaTableObject) throws RemoteException, MdException {
        ExternalTable table = this.getExternalFileMetadataObject((MdObjectStore)jomaTableObject.getObjectStore(), jomaTableObject.getId(), TABLE_COLUMN_DEPENDENCIES_TEMPLATE);
        if (!table.getPublicType().equals("ExternalFile")) {
            table.setPublicType("ExternalFile");
        }
        if (table.getUsageVersion() < FAILED_UPGRADE_VERSION.encode()) {
            table.setUsageVersion(FAILED_UPGRADE_VERSION.encode());
        }
        AssociationList columns = table.getColumns();
        for (Column column : columns) {
            if (!column.getPublicType().equals("Column")) {
                column.setPublicType("Column");
            }
            if (!(column.getUsageVersion() < FAILED_UPGRADE_VERSION.encode())) continue;
            column.setUsageVersion(FAILED_UPGRADE_VERSION.encode());
        }
        table.updateMetadataAll();
    }

    public PropertyList getLocalizableProperties() {
        PropertyList list = this.getDefaultLocalizableProperties();
        try {
            List prompts = this.getPrompts();
            if (prompts.size() > 0) {
                list.addBlankLine();
                list.addComment("Prompts");
            }
            for (int i = 0; i < prompts.size(); ++i) {
                OMRPromptGroupInterface promptGroup;
                PromptGroupInterface promptGroupI;
                BaseOMRPromptInterface prompt = (BaseOMRPromptInterface)prompts.get(i);
                if (!(prompt instanceof OMRPromptGroupInterface) || !((promptGroupI = (promptGroup = (OMRPromptGroupInterface)prompt).getPromptGroup()) instanceof LocalizableProperties)) continue;
                list.addProperty("Prompts[" + i + "]", ((LocalizableProperties)promptGroupI).getLocalizableProperties());
            }
        }
        catch (ServiceException e) {
            try {
                this.logMessage(Level.ERROR, "Error getting prompt information", this.getClass().getName(), e);
            }
            catch (RemoteException remoteException) {}
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return list;
    }

    public void setLocalizableProperties(PropertyMap map) {
        this.setDefaultLocalizableProperties(map);
        try {
            List prompts = this.getPrompts();
            for (int i = 0; i < prompts.size(); ++i) {
                OMRPromptGroupInterface promptGroup;
                PromptGroupInterface promptGroupI;
                BaseOMRPromptInterface prompt = (BaseOMRPromptInterface)prompts.get(0);
                if (!(prompt instanceof OMRPromptGroupInterface) || !((promptGroupI = (promptGroup = (OMRPromptGroupInterface)prompt).getPromptGroup()) instanceof LocalizableProperties)) continue;
                ((LocalizableProperties)promptGroupI).setLocalizableProperties(map.getNestedProperties("Prompts[" + i + "]"));
                PromptsPersistUtil.updateGroupSmartObject((PromptGroupInterface)promptGroupI, (UserContextInterface)this.getRepository().getUserContext(), (OMRPromptGroupInterface)promptGroup, null);
            }
        }
        catch (ServiceException ex) {
            try {
                this.logMessage(Level.ERROR, "Error getting prompt information", this.getClass().getName(), ex);
            }
            catch (RemoteException remoteException) {}
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private ExternalTable getExternalFileMetadataObject(MdObjectStore store, String fqid, String template) throws MdException, RemoteException {
        String type = "ExternalTable";
        int options = 268;
        CMetadata object = store.getFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, type, fqid, null, null, template, options);
        return (ExternalTable)object;
    }
}

