/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.shareddimension;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.olapschema.OLAPSchemaConnectionType;
import com.sas.metadata.logical.server.DirectoryPathSubstitutionType;
import com.sas.metadata.logical.shareddimension.RB;
import com.sas.metadata.logical.shareddimension.SharedDimensionConnectionValidator;
import com.sas.metadata.logical.shareddimension.SharedDimensionImportItem;
import com.sas.metadata.logical.shareddimension.SharedDimensionNameValidator;
import com.sas.metadata.logical.shareddimension.SharedDimensionNestedImportItem;
import com.sas.metadata.logical.shareddimension.SharedDimensionUtilities;
import com.sas.metadata.logical.table.TableConnectionType;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionValidatorInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportNameValidatorInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.NestedImportItemInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.StatusMessageUtil;
import com.sas.metadata.remote.Aggregation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.CalculatedMember;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.Hierarchy;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SharedDimension;
import com.sas.metadata.remote.Transformation;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class SharedDimensionImportListener
extends AbstractImportListener {
    protected static final Class[] CONNECTION_TYPES = new Class[]{OLAPSchemaConnectionType.class, TableConnectionType.class};
    protected static final Class[] SUBSTITUTION_TYPES = new Class[]{DirectoryPathSubstitutionType.class};
    private static final String EMPTY = "";
    private static final String GENFOLDER = "GENFOLDER";
    private static final String DIMFOLDER = "DIMFOLDER";
    private static final String REORG_REQUIRED = "REORGANIZE_REQUIRED";
    private static final String NRACKS = "NRACKS";
    private static final String CUBEFOLDER = "CUBEFOLDER";
    private static final String CLASSIFIER_MAP = "_ClassifierMap";
    private static final String STARDIM = "STARDIM";
    private static final String DIM_KEY_CUSTOM_ASSOC_SUFFIX = "_DimKey";
    private static final String DIM_KEY_DIMENSION = "DimKeyDimension";
    private static final String FACT_KEY_CUSTOM_ASSOC_SUFFIX = "_FactKey";
    private static final String FACT_KEY_DIMENSION = "FactKeyDimension";
    private static final String DIMENSION_GEN_FOLDER = "DimensionGenFolder";

    public SharedDimensionImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public ImportItemInterface createImportItem(String name, String id, TransportableTypeInterface type) {
        return new SharedDimensionImportItem(name, id, type);
    }

    public Class[] getSubstitutionTypes() {
        return SUBSTITUTION_TYPES;
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int iRC = 0;
        if (operation.isProjectRepository()) {
            iRC = 8;
            throw new MetadataPromotionException(RB.getStringResource("SharedDimensionImportListener.ProjectRepos.txt"));
        }
        int index = 1;
        Iterator iterImportItems = objects.iterator();
        while (iterImportItems.hasNext() && iRC == 0) {
            SharedDimensionImportItem importItem = (SharedDimensionImportItem)((Object)iterImportItems.next());
            UsageVersion version = importItem.getUsageVersion();
            if (!version.equals((Object)new UsageVersion(1, 0))) {
                iRC = 8;
                String msg = RB.getStringResource("SharedDimensionImportListener.VersionNotSupported.fmt");
                throw new MetadataPromotionException(UtilMisc.getMessage((String)msg, (Object)importItem.getName()));
            }
            ++index;
        }
        iRC = this.analyzeObjectsForOverwrite(operation, objects);
        return iRC;
    }

    public Class[] getConnectionTypes() {
        return CONNECTION_TYPES;
    }

    public ImportNameValidatorInterface getNameValidatorInterface() {
        return new SharedDimensionNameValidator();
    }

    public ConnectionValidatorInterface[] getConnectionValidatorInterfaces() {
        ConnectionValidatorInterface[] validators = new ConnectionValidatorInterface[]{new SharedDimensionConnectionValidator()};
        return validators;
    }

    public int updateConnectionPoints(ImportOperationInterface operation, List objects, List connections) throws MetadataPromotionException {
        try {
            return this.updateColumnAssociations(operation, operation.getMetadataFactory(), operation.getConnectionManager().getConnections(true), connections);
        }
        catch (RemoteException e) {
            throw new MetadataPromotionException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateColumnAssociations(ImportOperationInterface operation, MdFactory factory, List lConnectionPoints, List lUpdatedConnections) throws RemoteException, MetadataPromotionException {
        int iRC = 0;
        boolean tableNotFound = false;
        boolean columnNotFound = false;
        ArrayList<ConnectionPointInterface> lColumnCPs = new ArrayList<ConnectionPointInterface>();
        ArrayList<ConnectionPointInterface> lTableCPs = new ArrayList<ConnectionPointInterface>();
        for (ConnectionPointInterface connPoint : lConnectionPoints) {
            if (connPoint.isActive() && "Column".equals(connPoint.getMetadataType())) {
                lColumnCPs.add(connPoint);
                continue;
            }
            if (!connPoint.isConnectionForImportType("SharedDimension") || !"PhysicalTable".equals(connPoint.getMetadataType()) && !"TableCollection".equals(connPoint.getMetadataType()) || !this.isSharedDimensionBeingImported(connPoint)) continue;
            lTableCPs.add(connPoint);
        }
        HashMap<String, ArrayList<ConnectionPointInterface>> mapColumns = new HashMap<String, ArrayList<ConnectionPointInterface>>();
        for (ConnectionPointInterface cpColumn : lColumnCPs) {
            String sColumnSearch = cpColumn.getSourceSearchString();
            String sTableSearch = "[Table/*";
            int iStartIndex = sColumnSearch.indexOf(sTableSearch) + sTableSearch.length();
            sTableSearch = sColumnSearch.substring(iStartIndex);
            sTableSearch = sTableSearch.replaceFirst("]/", "][");
            sTableSearch = '*' + sTableSearch;
            ArrayList<ConnectionPointInterface> lColumns = (ArrayList<ConnectionPointInterface>)mapColumns.get(sTableSearch);
            if (lColumns != null) {
                lColumns.add(cpColumn);
                continue;
            }
            lColumns = new ArrayList<ConnectionPointInterface>();
            lColumns.add(cpColumn);
            mapColumns.put(sTableSearch, lColumns);
        }
        MdObjectStore mdStore = factory.createObjectStore(null, "SharedDimensionImportListener:updateColumnAssociations");
        try {
            String msg;
            for (String sTableSearch : mapColumns.keySet()) {
                DataTable mdTable = null;
                ConnectionPointInterface cpTable2 = null;
                for (ConnectionPointInterface cpTable2 : lTableCPs) {
                    if (!sTableSearch.equals(cpTable2.getSourceSearchString())) continue;
                    if (cpTable2.getTargetID() == null) break;
                    mdTable = (DataTable)factory.createComplexMetadataObject(mdStore, cpTable2.getName(), cpTable2.getMetadataType(), cpTable2.getTargetID());
                    break;
                }
                if (mdTable == null) continue;
                List lSourceColumns = (List)mapColumns.get(sTableSearch);
                ArrayList lTargetColumns = new ArrayList(mdTable.getColumns());
                if (lSourceColumns == null || lSourceColumns.isEmpty() || lTargetColumns == null || lTargetColumns.isEmpty()) continue;
                for (ConnectionPointInterface cpColumn : lSourceColumns) {
                    String sColumnName = cpColumn.getName();
                    boolean targetColumnFound = false;
                    Iterator iterTargetColumns = lTargetColumns.iterator();
                    while (iterTargetColumns.hasNext()) {
                        Column mdColumn = (Column)iterTargetColumns.next();
                        if (!sColumnName.equals(mdColumn.getName())) continue;
                        cpColumn.setTargetID(mdColumn.getFQID());
                        lUpdatedConnections.add(cpColumn);
                        iterTargetColumns.remove();
                        targetColumnFound = true;
                        break;
                    }
                    if (targetColumnFound) continue;
                    String sharedDimensionName = this.findSharedDimensionName(cpTable2);
                    String msg2 = UtilMisc.getMessage((String)RB.getStringResource("SharedDimensionImportListener.ColumnForTableNotFound.fmt"), (Object)mdTable.getName(), (Object)sharedDimensionName, (Object)cpColumn.getName());
                    operation.getLogger().warn((Object)msg2);
                    columnNotFound = true;
                    iRC = 4;
                }
            }
            for (ConnectionPointInterface cpTable : lTableCPs) {
                if (cpTable.getTargetID() != null) continue;
                String msg3 = UtilMisc.getMessage((String)RB.getStringResource("SharedDimensionImportListener.TableNotFound.fmt"), (Object)cpTable.getName(), (Object)this.findSharedDimensionName(cpTable));
                operation.getLogger().warn((Object)msg3);
                tableNotFound = true;
                iRC = 4;
            }
            if (tableNotFound) {
                msg = RB.getStringResource("SharedDimensionImportListener.TablesNotFound.txt");
                operation.getLogger().warn((Object)msg);
                iRC = 4;
            }
            if (columnNotFound) {
                msg = RB.getStringResource("SharedDimensionImportListener.ColumnsNotFound.txt");
                operation.getLogger().warn((Object)msg);
                iRC = 4;
            }
        }
        catch (MdException mde) {
            operation.getLogger().error((Object)mde.getLocalizedMessage());
            iRC = 8;
        }
        finally {
            mdStore.dispose();
        }
        return iRC;
    }

    private String findSharedDimensionName(ConnectionPointInterface cpTable) throws MetadataPromotionException, RemoteException {
        String sharedDimensionName = EMPTY;
        if (cpTable.isConnectionForImportType("SharedDimension")) {
            List assocObjects = cpTable.getAssociatedObjects();
            for (int i = 0; i < assocObjects.size(); ++i) {
                PromotionItemInterface item = (PromotionItemInterface)assocObjects.get(i);
                if (!(item instanceof SharedDimensionImportItem)) continue;
                sharedDimensionName = item.getName();
                break;
            }
        }
        return sharedDimensionName;
    }

    private boolean isSharedDimensionBeingImported(ConnectionPointInterface cpTable) throws MetadataPromotionException, RemoteException {
        boolean stateAdd = false;
        if (cpTable.isConnectionForImportType("SharedDimension")) {
            List assocObjects = cpTable.getAssociatedObjects();
            for (int i = 0; i < assocObjects.size(); ++i) {
                PromotionItemInterface item = (PromotionItemInterface)assocObjects.get(i);
                if (!(item instanceof SharedDimensionImportItem)) continue;
                SharedDimensionImportItem sharedDimensionItem = (SharedDimensionImportItem)item;
                boolean bl = stateAdd = sharedDimensionItem.getImportState() != 0;
                if (stateAdd) break;
            }
        }
        return stateAdd;
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int iRC = 0;
        MdObjectStore mdStore = null;
        try {
            int dimNo = 0;
            int dimCount = objects.size();
            Iterator iterItems = objects.iterator();
            while (iterItems.hasNext()) {
                String dirName;
                Directory sharedDimDir;
                String oldName;
                String nameToCheck;
                NestedImportItemInterface nii;
                int niiNum;
                Hierarchy hier;
                String newName;
                mdStore = operation.getMetadataFactory().createObjectStore(null, "SharedDimensionImportListener.updateObjects");
                SharedDimensionImportItem importItem = (SharedDimensionImportItem)((Object)iterItems.next());
                this.fireDisplayMessage(StatusMessageUtil.createUpdatingMessage((TypeInterface)importItem.getTypeInterface(), (String)importItem.getName(), (int)(++dimNo), (int)dimCount));
                SharedDimension mdSharedDimension = this.getSharedDimensionMetadatObject(mdStore, (ImportItemInterface)importItem, true);
                String originalUniqueName = mdSharedDimension.getUniqueName();
                mdSharedDimension.setUniqueName(EMPTY);
                AssociationList properties = mdSharedDimension.getProperties();
                for (int i = properties.size() - 1; i >= 0; --i) {
                    Property prop = (Property)properties.get(i);
                    if (prop.getName().equals(GENFOLDER)) {
                        prop.delete();
                        continue;
                    }
                    if (!prop.getName().equals(DIMFOLDER)) continue;
                    prop.delete();
                }
                String sdName = mdSharedDimension.getName();
                AssociationList referObjects = mdSharedDimension.getReferencedObjects();
                for (int i = referObjects.size() - 1; i >= 0; --i) {
                    CustomAssociation custom = (CustomAssociation)referObjects.get(i);
                    String partnerName = custom.getPartnerName();
                    if (partnerName.equalsIgnoreCase(DIMENSION_GEN_FOLDER)) {
                        custom.delete();
                        continue;
                    }
                    if (!partnerName.equalsIgnoreCase(FACT_KEY_DIMENSION)) continue;
                    custom.setName(sdName + FACT_KEY_CUSTOM_ASSOC_SUFFIX);
                }
                AssociationList customAssocs = mdSharedDimension.getCustomAssociations();
                for (int i = customAssocs.size() - 1; i >= 0; --i) {
                    CustomAssociation custom = (CustomAssociation)customAssocs.get(i);
                    String partnerName = custom.getPartnerName();
                    if (!partnerName.equalsIgnoreCase(DIM_KEY_DIMENSION)) continue;
                    custom.setName(sdName + DIM_KEY_CUSTOM_ASSOC_SUFFIX);
                }
                AssociationList targetTrans = mdSharedDimension.getTargetTransformations();
                for (int i = targetTrans.size() - 1; i >= 0; --i) {
                    AssociationList sources;
                    ClassifierMap classMap = (ClassifierMap)targetTrans.get(i);
                    if (!classMap.getTransformRole().equalsIgnoreCase(STARDIM) || (sources = classMap.getTransformationSources()).size() <= 0) continue;
                    CMetadata obj = (CMetadata)sources.get(0);
                    classMap.setName(sdName + "_" + obj.getName() + CLASSIFIER_MAP);
                }
                HashMap<String, Level> sharedDimLevelsByName = new HashMap<String, Level>();
                AssociationList levels = mdSharedDimension.getLevels();
                for (int i = 0; i < levels.size(); ++i) {
                    Level level = (Level)levels.get(i);
                    sharedDimLevelsByName.put(level.getName(), level);
                    AssociationList levProperties = level.getProperties();
                    for (int j = levProperties.size() - 1; j >= 0; --j) {
                        Property prop = (Property)levProperties.get(i);
                        if (!prop.getName().equals(REORG_REQUIRED)) continue;
                        prop.delete();
                    }
                }
                HashMap<String, Hierarchy> sharedDimHiersByName = new HashMap<String, Hierarchy>();
                AssociationList hierarchies = mdSharedDimension.getHierarchies();
                for (int i = 0; i < hierarchies.size(); ++i) {
                    Hierarchy hier2 = (Hierarchy)hierarchies.get(i);
                    sharedDimHiersByName.put(hier2.getName(), hier2);
                }
                List nestedItems = importItem.getNestedItems();
                ArrayList<NestedImportItemInterface> newLevels = new ArrayList<NestedImportItemInterface>();
                ArrayList<NestedImportItemInterface> newHierarchies = new ArrayList<NestedImportItemInterface>();
                for (int i = 0; i < nestedItems.size(); ++i) {
                    Map calcMbrs;
                    String name;
                    NestedImportItemInterface nii2 = (NestedImportItemInterface)nestedItems.get(i);
                    if (nii2.getImportState() == 1) {
                        TypeInterface typeInterface = nii2.getTypeInterface();
                        String publicType = typeInterface.getPublicType();
                        if (publicType.equalsIgnoreCase("Hierarchy")) {
                            newHierarchies.add(nii2);
                        } else if (publicType.equalsIgnoreCase("Level")) {
                            newLevels.add(nii2);
                        }
                    }
                    if (!(nii2 instanceof SharedDimensionNestedImportItem)) continue;
                    Map nuniques = ((SharedDimensionNestedImportItem)nii2).getNuniquesToDelete();
                    if (nuniques != null && !nuniques.isEmpty()) {
                        String levelName = nii2.getName();
                        for (String fqid : nuniques.keySet()) {
                            name = (String)nuniques.get(fqid);
                            operation.getMetadataFactory().deleteMetadataObjects(name, "Measure", fqid, null);
                            operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("SharedDimensionImportListener.DeleteNunique.fmt"), (Object)name, (Object)levelName));
                            iRC |= 4;
                        }
                    }
                    if ((calcMbrs = ((SharedDimensionNestedImportItem)nii2).getCalcMembersToDelete()) == null || calcMbrs.isEmpty()) continue;
                    for (String fqid : calcMbrs.keySet()) {
                        name = (String)calcMbrs.get(fqid);
                        operation.getMetadataFactory().deleteMetadataObjects(name, "CalculatedMember", fqid, null);
                    }
                }
                if (hierarchies.size() == 1 && !(newName = mdSharedDimension.getName()).equals((hier = (Hierarchy)hierarchies.get(0)).getName())) {
                    hier.setName(newName);
                    operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("SharedDimensionImportListener.RenameHierarchy.fmt"), (Object)newName));
                    iRC |= 4;
                }
                AssociationList cubes = mdSharedDimension.getCubes();
                HashMap<String, String> levelNames = new HashMap<String, String>();
                HashMap<String, String> hierNames = new HashMap<String, String>();
                for (int cubeNum = 0; cubeNum < cubes.size(); ++cubeNum) {
                    Cube cube = (Cube)cubes.get(cubeNum);
                    AssociationList cubeHierarchies = cube.getHierarchies();
                    if (!newLevels.isEmpty() || !newHierarchies.isEmpty()) {
                        for (int cubeHierNum = 0; cubeHierNum < cubeHierarchies.size(); ++cubeHierNum) {
                            Hierarchy cubeHier = (Hierarchy)cubeHierarchies.get(cubeHierNum);
                            if (hierarchies.contains((Object)cubeHier)) continue;
                            if (!newHierarchies.isEmpty()) {
                                hierNames.put(cubeHier.getName().toUpperCase(), cubeHier.getName());
                            }
                            if (newLevels.isEmpty()) continue;
                            AssociationList cubeLevels = cubeHier.getLevels();
                            for (int cubeLevNum = 0; cubeLevNum < cubeLevels.size(); ++cubeLevNum) {
                                Level cubeLevel = (Level)cubeLevels.get(cubeLevNum);
                                levelNames.put(cubeLevel.getName().toUpperCase(), cubeLevel.getName());
                            }
                        }
                    }
                    for (int hierNum = 0; hierNum < hierarchies.size(); ++hierNum) {
                        Hierarchy hier3 = (Hierarchy)hierarchies.get(hierNum);
                        if (cubeHierarchies.contains((Object)hier3)) continue;
                        cubeHierarchies.add((Object)hier3);
                    }
                    AssociationList aggregations = cube.getAggregations();
                    for (int aggrNum = 0; aggrNum < aggregations.size(); ++aggrNum) {
                        Aggregation aggr = (Aggregation)aggregations.get(aggrNum);
                        if (aggr.getNway() == 1) {
                            AssociationList aggrlevels = aggr.getLevels();
                            for (int levNum = 0; levNum < levels.size(); ++levNum) {
                                Level level = (Level)levels.get(levNum);
                                if (aggrlevels.contains((Object)level)) continue;
                                aggrlevels.add((Object)level);
                            }
                        }
                        AssociationList aggrProperties = aggr.getProperties();
                        for (int propNum = aggrProperties.size() - 1; propNum >= 0; --propNum) {
                            Property prop = (Property)aggrProperties.get(propNum);
                            if (!prop.getName().equalsIgnoreCase(NRACKS)) continue;
                            prop.delete();
                        }
                    }
                    AssociationList cubeProperties = cube.getProperties();
                    for (int propNum = cubeProperties.size() - 1; propNum >= 0; --propNum) {
                        Property prop = (Property)cubeProperties.get(propNum);
                        if (!prop.getName().equalsIgnoreCase(GENFOLDER)) continue;
                        prop.delete();
                    }
                    cube.setCubeName(EMPTY);
                }
                Random rand = new Random();
                for (niiNum = 0; niiNum < newHierarchies.size(); ++niiNum) {
                    nii = (NestedImportItemInterface)newHierarchies.get(niiNum);
                    nameToCheck = nii.getName();
                    oldName = nii.getName();
                    StringBuffer newName2 = null;
                    boolean good = false;
                    while (!good) {
                        if (newName2 != null) {
                            nameToCheck = newName2.toString();
                        }
                        if (hierNames.containsKey(nameToCheck.toUpperCase())) {
                            newName2 = this.getUniqueName(rand, oldName);
                            continue;
                        }
                        good = true;
                    }
                    if (newName2 == null) continue;
                    Hierarchy hier4 = (Hierarchy)sharedDimHiersByName.get(oldName);
                    hier4.setName(newName2.toString());
                    operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("SharedDimensionImportListener.HierarchyNameConflict.fmt"), (Object)oldName, (Object)newName2.toString()));
                    iRC |= 4;
                }
                for (niiNum = 0; niiNum < newLevels.size(); ++niiNum) {
                    nii = (NestedImportItemInterface)newLevels.get(niiNum);
                    nameToCheck = nii.getName();
                    oldName = nii.getName();
                    StringBuffer newName3 = null;
                    boolean good = false;
                    while (!good) {
                        if (newName3 != null) {
                            nameToCheck = newName3.toString();
                        }
                        if (levelNames.containsKey(nameToCheck.toUpperCase())) {
                            newName3 = this.getUniqueName(rand, oldName);
                            continue;
                        }
                        good = true;
                    }
                    if (newName3 == null) continue;
                    Level lev = (Level)sharedDimLevelsByName.get(oldName);
                    lev.setName(newName3.toString());
                    operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("SharedDimensionImportListener.LevelNameConflict.fmt"), (Object)oldName, (Object)newName3.toString()));
                    iRC |= 4;
                }
                if (importItem.getImportState() == 2 && !SharedDimensionUtilities.isBlank(originalUniqueName)) {
                    Log importLogger = operation.getLogger();
                    importLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("SharedDimensionImportListener.OverwrittenDimMustBeRebuilt.fmt"), (Object)mdSharedDimension.getName()));
                    iRC |= 4;
                }
                if ((sharedDimDir = mdSharedDimension.getAssociatedDirectory()) != null && ((dirName = sharedDimDir.getDirectoryName()) == null || Strings.trimmedLength((String)dirName) == 0)) {
                    Log importLogger = operation.getLogger();
                    importLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("SharedDimensionImportListener.DirectoryBlank.fmt"), (Object)mdSharedDimension.getName()));
                    iRC = 4;
                }
                mdSharedDimension.touch();
                mdStore.updatedMetadataAll();
                if (mdStore != null) {
                    mdStore.dispose();
                }
                mdStore = null;
            }
        }
        catch (MdException mde) {
            throw new MetadataPromotionException((Throwable)mde);
        }
        catch (RemoteException e) {
            throw new MetadataPromotionException((Throwable)e);
        }
        finally {
            try {
                if (mdStore != null) {
                    mdStore.dispose();
                }
            }
            catch (RemoteException e) {
                throw new MetadataPromotionException((Throwable)e);
            }
        }
        return iRC;
    }

    private StringBuffer getUniqueName(Random rand, String name) {
        StringBuffer newName = new StringBuffer();
        int suffix = rand.nextInt(99999) + 1;
        if (name.length() > 26) {
            name = name.substring(0, 26);
        }
        newName.append(name);
        newName.append("_");
        newName.append(suffix);
        return newName;
    }

    private SharedDimension getSharedDimensionMetadatObject(MdObjectStore mdStore, ImportItemInterface importItem, boolean getCubes) throws RemoteException, MdException {
        int iOptions = 268;
        String template = EMPTY;
        template = getCubes ? "<Templates><SharedDimension><Hierarchies/><Levels/><Cubes/><Properties/><ReferencedObjects/><CustomAssociations/><TargetTransformations/></SharedDimension><Level><Properties/></Level><Cube><Properties/><Hierarchies/><Aggregations/></Cube><Hierarchy><Levels/></Hierarchy><Aggregation><Levels/><Properties search=\"*[@Name='NRACKS']\"/></Aggregation><CustomAssociation><AssociatedObjects/></CustomAssociation><ClassifierMap><TransformationSources/></ClassifierMap></Templates>" : "<Templates><SharedDimension><Hierarchies/><Levels/><Cubes search=\"*[not(@CubeName='')]\"/></SharedDimension><Hierarchy><CalculatedMembers/></Hierarchy><Cube><Properties/><AssociatedFile/><NextGeneration/></Cube><File><Directories/></File><Level><SourceTransformations/></Level><Transformation><TransformationTargets/></Transformation></Templates>";
        return (SharedDimension)mdStore.getFactory().getOMIUtil().getMetadataAllDepths((MdStore)mdStore, "SharedDimension", importItem.getTargetID(), null, null, template, iOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int analyzeObjectsForOverwrite(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int iRC = 0;
        MdObjectStore mdStore = null;
        try {
            ArrayList<ImportItemInterface> objectsToOverwrite = new ArrayList<ImportItemInterface>();
            for (ImportItemInterface importItem : objects) {
                if (importItem.getImportState() != 2) continue;
                objectsToOverwrite.add(importItem);
            }
            if (objectsToOverwrite.isEmpty()) {
                int iterator = iRC;
                return iterator;
            }
            mdStore = operation.getMetadataFactory().createObjectStore(null, "SharedDimensionImportListener.updateObjects");
            int dimNo = 0;
            int count = objectsToOverwrite.size();
            for (ImportItemInterface importItem : objectsToOverwrite) {
                SharedDimensionNestedImportItem nii;
                String name;
                SharedDimension mdSharedDimension = null;
                AssociationList hiers = null;
                AssociationList levels = null;
                List nestedItems = importItem.getNestedItems();
                if (nestedItems.isEmpty()) continue;
                mdSharedDimension = this.getSharedDimensionMetadatObject(mdStore, importItem, false);
                this.fireDisplayMessage(StatusMessageUtil.createAnalyzingMessage((TypeInterface)importItem.getTypeInterface(), (String)importItem.getName(), (int)(++dimNo), (int)count));
                AssociationList cubes = mdSharedDimension.getCubes();
                for (int cubeNum = 0; cubeNum < cubes.size(); ++cubeNum) {
                    Cube cube = (Cube)cubes.get(cubeNum);
                    Cube nextGen = cube.getNextGeneration();
                    if (nextGen == null) continue;
                    iRC = 8;
                    String msg = UtilMisc.getMessage((String)RB.getStringResource("SharedDimensionImportListener.NextGen.fmt"), (Object)mdSharedDimension.getName());
                    throw new MetadataPromotionException(msg);
                }
                hiers = mdSharedDimension.getHierarchies();
                levels = mdSharedDimension.getLevels();
                HashMap<String, Hierarchy> hierMap = new HashMap<String, Hierarchy>();
                for (int hierNum = 0; hierNum < hiers.size(); ++hierNum) {
                    Hierarchy hier = (Hierarchy)hiers.get(hierNum);
                    hierMap.put(hier.getName(), hier);
                }
                HashMap<String, Level> levelMap = new HashMap<String, Level>();
                for (int levNum = 0; levNum < levels.size(); ++levNum) {
                    Level level = (Level)levels.get(levNum);
                    levelMap.put(level.getName(), level);
                }
                for (int i = 0; i < nestedItems.size(); ++i) {
                    NestedImportItemInterface nestedItem = (NestedImportItemInterface)nestedItems.get(i);
                    TypeInterface typeInterface = nestedItem.getTypeInterface();
                    String publicType = typeInterface.getPublicType();
                    name = nestedItem.getName();
                    if (publicType.equalsIgnoreCase("Hierarchy")) {
                        Hierarchy hier = (Hierarchy)hierMap.get(name);
                        if (hier != null) {
                            nestedItem.setTargetID(hier.getFQID());
                            nestedItem.setImportState(2);
                            hierMap.remove(name);
                            continue;
                        }
                        nestedItem.setImportState(1);
                        continue;
                    }
                    if (!publicType.equalsIgnoreCase("Level")) continue;
                    Level level = (Level)levelMap.get(name);
                    if (level != null) {
                        nestedItem.setTargetID(level.getFQID());
                        nestedItem.setImportState(2);
                        levelMap.remove(name);
                        continue;
                    }
                    nestedItem.setImportState(1);
                }
                TransportableTypeInterface typeInterface = (TransportableTypeInterface)Factory.getInstance().getTypeInterface("Hierarchy");
                for (String name2 : hierMap.keySet()) {
                    Hierarchy hier = (Hierarchy)hierMap.get(name2);
                    nii = new SharedDimensionNestedImportItem(hier.getName(), hier.getId(), typeInterface);
                    nii.setImportState(3);
                    nii.setTargetID(hier.getId());
                    importItem.addNestedItem((NestedImportItemInterface)nii);
                    operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("SharedDimensionImportListener.Hierarchy.Deleted.fmt"), (Object)nii.getName(), (Object)mdSharedDimension.getName()));
                    iRC |= 4;
                    AssociationList calcMbrs = hier.getCalculatedMembers();
                    if (calcMbrs.isEmpty()) continue;
                    HashMap<String, String> calcMbrsToDelete = new HashMap<String, String>();
                    for (int cm = 0; cm < calcMbrs.size(); ++cm) {
                        CalculatedMember mbr = (CalculatedMember)calcMbrs.get(cm);
                        calcMbrsToDelete.put(mbr.getFQID(), mbr.getName());
                    }
                    nii.setCalcMembersToDelete(calcMbrsToDelete);
                }
                typeInterface = (TransportableTypeInterface)Factory.getInstance().getTypeInterface("Level");
                for (String name2 : levelMap.keySet()) {
                    Level level = (Level)levelMap.get(name2);
                    nii = new SharedDimensionNestedImportItem(level.getName(), level.getId(), typeInterface);
                    nii.setImportState(3);
                    nii.setTargetID(level.getId());
                    importItem.addNestedItem((NestedImportItemInterface)nii);
                    operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("SharedDimensionImportListener.Level.Deleted.fmt"), (Object)nii.getName(), (Object)mdSharedDimension.getName()));
                    AssociationList sourceTransformations = level.getSourceTransformations();
                    if (!sourceTransformations.isEmpty()) {
                        HashMap<String, String> nuniques = new HashMap<String, String>();
                        for (int transNum = 0; transNum < sourceTransformations.size(); ++transNum) {
                            Transformation transform = (Transformation)sourceTransformations.get(transNum);
                            AssociationList targets = transform.getTransformationTargets();
                            if (targets.isEmpty()) continue;
                            CMetadata mdObj = (CMetadata)targets.get(0);
                            nuniques.put(mdObj.getFQID(), mdObj.getName());
                        }
                        nii.setNuniquesToDelete(nuniques);
                    }
                    iRC |= 4;
                }
                if (cubes.size() > 0) {
                    operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("SharedDimensionImportListener.DimWillBeUpdated.fmt"), (Object)mdSharedDimension.getName()));
                    operation.getLogger().warn((Object)RB.getStringResource("SharedDimensionImportListener.RebuildDim.txt"));
                    operation.getLogger().warn((Object)RB.getStringResource("SharedDimensionImportListener.StartListCubes.txt"));
                    operation.getLogger().warn((Object)RB.getStringResource("SharedDimensionImportListener.StartListCubes1.txt"));
                    iRC |= 4;
                }
                for (int cubeNum = 0; cubeNum < cubes.size(); ++cubeNum) {
                    AssociationList directories;
                    Cube cube = (Cube)cubes.get(cubeNum);
                    MdOMIUtil mdOMIUTil = operation.getMetadataFactory().getOMIUtil();
                    name = mdOMIUTil.getObjectPath(mdStore, (PrimaryType)cube, false);
                    String physPath = EMPTY;
                    File cubeFile = cube.getAssociatedFile();
                    if (cubeFile != null && !(directories = cubeFile.getDirectories()).isEmpty()) {
                        Directory dir = (Directory)directories.get(0);
                        physPath = dir.getDirectoryName();
                    }
                    AssociationList properties = cube.getProperties();
                    Property cubeFolder = null;
                    for (int propNum = 0; propNum < properties.size() && cubeFolder == null; ++propNum) {
                        Property prop = (Property)properties.get(propNum);
                        if (!CUBEFOLDER.equalsIgnoreCase(prop.getName())) continue;
                        cubeFolder = prop;
                    }
                    String cubeFolderName = EMPTY;
                    if (cubeFolder != null) {
                        cubeFolderName = cubeFolder.getDefaultValue();
                    }
                    operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("SharedDimensionImportListener.Cube.fmt"), (Object)name, (Object)cubeFolderName, (Object)physPath));
                }
            }
        }
        catch (RemoteException re) {
            operation.getLogger().error((Object)re.getLocalizedMessage());
            iRC |= 8;
        }
        catch (MdException e) {
            operation.getLogger().error((Object)e.getLocalizedMessage());
            iRC |= 8;
        }
        catch (LogicalTypeException e) {
            operation.getLogger().error((Object)e.getLocalizedMessage());
            iRC |= 8;
        }
        finally {
            try {
                if (mdStore != null) {
                    mdStore.dispose();
                }
            }
            catch (RemoteException e) {
                throw new MetadataPromotionException((Throwable)e);
            }
        }
        return iRC;
    }
}

