/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.shareddimension;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.RelatedObjectsInterface;
import com.sas.metadata.logical.SimpleLogicalObject;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.document.DocumentUtil;
import com.sas.metadata.logical.note.NoteUtil;
import com.sas.metadata.logical.shareddimension.RB;
import com.sas.metadata.promotion.DefaultExportItem;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.SharedDimension;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class SharedDimensionExportItem
extends DefaultExportItem
implements RelatedObjectsInterface {
    public SharedDimensionExportItem(String name, String id, TransportableTypeInterface type) {
        super(name, id, type);
    }

    public List getRelatedObjects(int relationshipType) throws LogicalTypeException {
        ArrayList<SimpleLogicalObject> relatedObjects = new ArrayList<SimpleLogicalObject>(32);
        try {
            MdFactory factory = this._exportOperation.getMetadataFactory();
            MdObjectStore mdStore = factory.createObjectStore(null, "SharedDimensionExportItem.getRelatedObjects");
            MdOMIUtil mdUtil = factory.getOMIUtil();
            try {
                int options = 268;
                SharedDimension sharedDimension = (SharedDimension)mdUtil.getMetadataAllDepths((MdStore)mdStore, "SharedDimension", this.getID(), null, null, "<Templates><SharedDimension><Notes/><Documents/><Cubes/><TargetTransformations/></SharedDimension><PhysicalTable><TablePackages/></PhysicalTable><ClassifierMap><TransformationSources/></ClassifierMap></Templates>", options);
                if (sharedDimension == null) {
                    throw new LogicalTypeException(RB.getStringResource("SharedDimensionExportItem.ObjNotFound.txt"));
                }
                if (relationshipType == 0) {
                    relatedObjects.addAll(DocumentUtil.getDependentDocuments((Root)sharedDimension));
                    relatedObjects.addAll(NoteUtil.getDependentNotes((Root)sharedDimension));
                    AssociationList alTargetTran = sharedDimension.getTargetTransformations();
                    for (int i = 0; i < alTargetTran.size(); ++i) {
                        ClassifierMap map = (ClassifierMap)alTargetTran.get(i);
                        AssociationList alClassSource = map.getTransformationSources();
                        if (alClassSource == null || alClassSource.size() <= 0) continue;
                        PhysicalTable physTable = (PhysicalTable)alClassSource.get(0);
                        this.addTableObjectAsRelatedObject((Root)physTable, relatedObjects);
                        this.addLibraryForTable(physTable, relatedObjects);
                    }
                    AssociationList alSchema = sharedDimension.getAssociatedOLAPSchemas();
                    if (alSchema != null && alSchema.size() > 0) {
                        for (int i = 0; i < alSchema.size(); ++i) {
                            OLAPSchema schema = (OLAPSchema)alSchema.get(i);
                            if (schema == null) continue;
                            this.addSchemaObjectAsRelatedObject((Root)schema, relatedObjects);
                        }
                    }
                } else if (relationshipType == 1) {
                    AssociationList alCubes = sharedDimension.getCubes();
                    for (int i = 0; i < alCubes.size(); ++i) {
                        Cube cube = (Cube)alCubes.get(i);
                        TypeInterface ti = Factory.getInstance().getTypeInterface("Cube");
                        SimpleLogicalObject simpObject = new SimpleLogicalObject(cube.getName(), cube.getFQID(), ti);
                        relatedObjects.add(simpObject);
                    }
                }
            }
            catch (MdException e) {
                throw new LogicalTypeException((Exception)((Object)e));
            }
            finally {
                mdStore.dispose();
            }
        }
        catch (RemoteException re) {
            throw new LogicalTypeException((Exception)re);
        }
        return relatedObjects;
    }

    private void addLibraryForTable(PhysicalTable physTable, List relatedObjects) throws RemoteException, MdException, LogicalTypeException {
        AssociationList alList = physTable.getTablePackages();
        if (alList != null && alList.size() > 0) {
            Object tpackage = alList.get(0);
            if (tpackage instanceof DatabaseSchema) {
                Object packageObj;
                DatabaseSchema schema = (DatabaseSchema)tpackage;
                AssociationList usedByPackages = schema.getUsedByPackages();
                if (usedByPackages != null && usedByPackages.size() > 0 && (packageObj = usedByPackages.get(0)) instanceof SASLibrary) {
                    this.addLibraryObjectAsRelatedObject((Root)packageObj, relatedObjects);
                }
            } else if (tpackage instanceof SASLibrary) {
                this.addLibraryObjectAsRelatedObject((Root)tpackage, relatedObjects);
            }
        }
    }

    private void addSchemaObjectAsRelatedObject(Root obj, List relatedObjects) throws LogicalTypeException {
        try {
            TypeInterface ti = Factory.getInstance().getTypeInterface("OLAPSchema");
            SimpleLogicalObject simpObject = new SimpleLogicalObject(obj.getName(), obj.getFQID(), ti);
            relatedObjects.add(simpObject);
        }
        catch (RemoteException re) {
            throw new LogicalTypeException((Exception)re);
        }
    }

    private void addTableObjectAsRelatedObject(Root obj, List relatedObjects) throws LogicalTypeException {
        try {
            TypeInterface ti = Factory.getInstance().getTypeInterface("Table");
            SimpleLogicalObject simpObject = new SimpleLogicalObject(obj.getName(), obj.getFQID(), ti);
            relatedObjects.add(simpObject);
        }
        catch (RemoteException re) {
            throw new LogicalTypeException((Exception)re);
        }
    }

    private void addLibraryObjectAsRelatedObject(Root obj, List relatedObjects) throws LogicalTypeException {
        try {
            TypeInterface ti = Factory.getInstance().getTypeInterface("Library");
            SimpleLogicalObject simpObject = new SimpleLogicalObject(obj.getName(), obj.getFQID(), ti);
            relatedObjects.add(simpObject);
        }
        catch (RemoteException re) {
            throw new LogicalTypeException((Exception)re);
        }
    }
}

