/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.shareddimension;

import com.sas.editor.LogListHolder;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObject;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.shareddimension.RB;
import com.sas.metadata.logical.shareddimension.SharedDimensionUtilities;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.olapadmin.utilities.SavePanel;
import com.sas.olapadmin.utilities.SaveSasLogActionListener;
import com.sas.olapadmin.utilities.WsRunCode;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.visuals.WsLogPropertyTab;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SharedDimension
extends LogicalObject {
    public UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String BLANK_STRING = "";
    private static final String MAX_RETRIES = "   MAX_RETRIES            = ";
    private static final String MAX_RETRY_WAIT = "   MAX_RETRY_WAIT         = ";
    private static final String MIN_RETRY_WAIT = "   MIN_RETRY_WAIT         = ";
    private static final String MAX_RETRY_ATTEMPT_KEY = "ProcOlap.MaxRetry";
    private static final String MAX_RETRY_SECONDS_KEY = "ProcOlap.MaxWait";
    private static final String MIN_RETRY_SECONDS_KEY = "ProcOlap.MinWait";
    int MAXNAMELENGTH = 32;

    public SharedDimension(com.sas.metadata.remote.SharedDimension inputSharedDimension, TypeInterface type, Factory factory) throws RemoteException {
        super((Root)inputSharedDimension, type, factory);
        this.setCompatibility(this.OLDEST_VERSION, CURRENT_VERSION);
    }

    public boolean isDeleteAllowed() throws LogicalTypeException, RemoteException {
        boolean allowed = super.isDeleteAllowed();
        if (!allowed) {
            return allowed;
        }
        allowed = !this.isUsedByCube();
        return allowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUsedByCube() throws LogicalTypeException {
        boolean isUsedByCube = false;
        MdObjectStore objectStore = null;
        try {
            objectStore = Workspace.getMdFactory().createObjectStore(null, "SharedDimension.isDeleteAllowed");
            com.sas.metadata.remote.SharedDimension jomaSharedDimension = this.getJomaSharedDimension(null, objectStore);
            AssociationList cubes = jomaSharedDimension.getCubes();
            isUsedByCube = cubes.size() != 0;
        }
        catch (MdException mderror) {
            throw new LogicalTypeException((Exception)((Object)mderror));
        }
        catch (RemoteException remoteException) {
        }
        finally {
            try {
                if (objectStore != null) {
                    objectStore.dispose();
                }
            }
            catch (RemoteException remoteException) {}
        }
        return isUsedByCube;
    }

    public boolean delete(OperationUserInteractionInterface oui) throws LogicalTypeException, RemoteException {
        String progressText = this.getProgressMessageForDelete();
        oui.updateProgress(progressText);
        if (this.isUsedByCube()) {
            String messageText = UtilMisc.getMessage((String)RB.getStringResource("SharedDimension.Error.NoDeleteUsedByCube.fmt"), (Object)this.getName());
            MessageUtil.displayMessage((String)messageText, (int)0);
            return false;
        }
        boolean deleted = true;
        MdObjectStore objectStore = null;
        com.sas.metadata.remote.SharedDimension jomaSharedDimension = null;
        try {
            objectStore = Workspace.getMdFactory().createObjectStore(null, "SharedDimension.delete");
            jomaSharedDimension = this.getJomaSharedDimension(oui, objectStore);
            String cubeName = jomaSharedDimension.getUniqueName();
            if (SharedDimensionUtilities.isBlank(cubeName)) {
                Workspace.getMdFactory().deleteMetadataObject((CMetadata)jomaSharedDimension);
            } else if (!oui.isUserInteractionSupported()) {
                deleted = false;
                Logger logger = LogManager.getLogger((String)"com.sas.metadata.logical.shareddimension");
                logger.error(UtilMisc.getMessage((String)RB.getStringResource("SharedDimension.Error.NoBatchDelete.fmt"), (Object)jomaSharedDimension.getName()));
            } else {
                deleted = this.submitDeleteCode(jomaSharedDimension);
                this.sendDeletedObjectEvent(jomaSharedDimension);
            }
        }
        catch (MdException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        catch (WsAppServerFailException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        finally {
            if (objectStore != null && !objectStore.isDisposed()) {
                objectStore.dispose();
            }
        }
        return deleted;
    }

    private void sendDeletedObjectEvent(com.sas.metadata.remote.SharedDimension jomaSharedDimension) throws RemoteException, MdException {
        HashMap<String, String> map = new HashMap<String, String>();
        String xmlselect = "<XMLSELECT search=\"@Id='" + jomaSharedDimension.getFQID() + "'\"/>";
        String reposid = "A0000001." + jomaSharedDimension.getRepositoryID();
        int doesObjectExist = Workspace.getMdFactory().getOMIUtil().doesObjectExist(reposid, "SharedDimension", xmlselect);
        if (doesObjectExist == 0) {
            map.put(jomaSharedDimension.getFQID(), jomaSharedDimension.getCMetadataType());
            Workspace.getMdFactory().getOMIUtil().deleteMetadataObjects(map);
            Workspace.getMdFactory().fireMdObjectsDeleted(new MdFactoryEvent(Workspace.getMdFactory().getInstance(), map));
        }
    }

    private boolean submitDeleteCode(com.sas.metadata.remote.SharedDimension jomaSharedDimension) throws LogicalTypeException, MdException, RemoteException, WsAppServerFailException {
        boolean deleted = true;
        WsAppServer applicationServer = null;
        try {
            applicationServer = WsRunCode.getServer();
            if (applicationServer != null) {
                applicationServer.openSASCodeSession();
                applicationServer.submitSASCode(this.generateCodeDelete().toString());
                Workspace.getDefaultLogger().warn((Object)applicationServer.getLogBuffer());
            } else {
                deleted = false;
            }
        }
        catch (WsAppServerCodeException e) {
            this.displayAppServerLog(applicationServer, e);
        }
        catch (Exception ae) {
            throw new LogicalTypeException(ae);
        }
        finally {
            if (applicationServer != null) {
                applicationServer.closeSASCodeSession();
            }
        }
        return deleted;
    }

    public boolean isRenameAllowed() throws LogicalTypeException {
        return false;
    }

    private com.sas.metadata.remote.SharedDimension getJomaSharedDimension(OperationUserInteractionInterface oui, MdObjectStore objectStore) throws LogicalTypeException {
        com.sas.metadata.remote.SharedDimension jomaSharedDimension = null;
        ArrayList<String> sharedDimensionAssociations = new ArrayList<String>();
        sharedDimensionAssociations.add("Trees");
        String template = "<Templates><Tree><Members/></Tree></Templates>";
        try {
            jomaSharedDimension = (com.sas.metadata.remote.SharedDimension)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((MdStore)objectStore, this.getTypeInterface().getMetadataType(), this.getID(), null, sharedDimensionAssociations, template, 12);
        }
        catch (MdException e) {
            this.handleException(jomaSharedDimension, oui, (Exception)((Object)e));
        }
        catch (RemoteException e) {
            this.handleException(jomaSharedDimension, oui, e);
        }
        return jomaSharedDimension;
    }

    private void handleException(com.sas.metadata.remote.SharedDimension jomaSharedDimension, OperationUserInteractionInterface oui, Exception e) throws LogicalTypeException {
        String folderName = BLANK_STRING;
        try {
            if (jomaSharedDimension != null) {
                Tree tree = (Tree)jomaSharedDimension.getTrees().get(0);
                folderName = tree.getName();
            }
        }
        catch (RemoteException re) {
            throw new LogicalTypeException((Exception)re);
        }
        catch (Exception e1) {
            throw new LogicalTypeException(e1);
        }
        if (oui != null && oui.continueOperationWithPrompting()) {
            String messageText = UtilMisc.getMessage((String)RB.getStringResource("SharedDimension.Error.DelExcpOccrd.fmt.txt"), (Object)this.getName(), (Object)folderName, (Object)UtilMisc.getExceptionMessageText((Exception)e));
            int choice = oui.displayMessage(RB.getStringResource("SharedDimension.Error.window.title"), messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
            OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting((OperationUserInteractionInterface)oui, (int)choice);
        }
    }

    private StringBuffer generateCodeDelete() throws RemoteException, LogicalTypeException {
        MdObjectStore objectStore = Workspace.getMdFactory().createObjectStore(null, "SharedDimension.generateCodeDelete");
        com.sas.metadata.remote.SharedDimension jomaSharedDimension = this.getJomaSharedDimension(null, objectStore);
        StringBuffer deleteCode = new StringBuffer();
        try {
            if (jomaSharedDimension != null) {
                deleteCode.append("OPTIONS VALIDVARNAME=ANY;").append(NEWLINE);
                deleteCode.append("PROC OLAP DELETE");
                deleteCode.append(this.getReconnectionString()).append(";").append(NEWLINE);
                deleteCode.append("METASVR OLAP_SCHEMA=");
                deleteCode.append("\"").append(jomaSharedDimension.getAssociatedOLAPSchema()).append("\"");
                deleteCode.append(";").append(NEWLINE);
                deleteCode.append("DIMENSION ");
                String name = Strings.quoteForSAS((String)jomaSharedDimension.getName());
                deleteCode.append(name);
                deleteCode.append(" SHARED;");
                deleteCode.append(NEWLINE).append("RUN;");
            }
        }
        catch (MdException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        finally {
            if (objectStore != null) {
                objectStore.dispose();
            }
        }
        return deleteCode;
    }

    private String getReconnectionString() {
        WorkspaceFile m_appDefaultsFile;
        StringBuffer code = new StringBuffer();
        Workspace workspace = Workspace.getWorkspace();
        if (workspace != null && (m_appDefaultsFile = Workspace.getWorkspace().getAppDefaultsFile()) != null) {
            String retries = m_appDefaultsFile.getPropertyString(MAX_RETRY_ATTEMPT_KEY, "3");
            code.append(NEWLINE).append(MAX_RETRIES).append(retries);
            String max = m_appDefaultsFile.getPropertyString(MAX_RETRY_SECONDS_KEY, "60");
            code.append(NEWLINE).append(MAX_RETRY_WAIT).append(max);
            String min = m_appDefaultsFile.getPropertyString(MIN_RETRY_SECONDS_KEY, "30");
            code.append(NEWLINE).append(MIN_RETRY_WAIT).append(min);
        }
        return code.toString();
    }

    private void displayAppServerLog(WsAppServer applicationServer, WsAppServerCodeException e) throws LogicalTypeException, WsAppServerFailException {
        WsLogPropertyTab logPropertyTab = new WsLogPropertyTab(1);
        LogListHolder logData = applicationServer.getLog();
        logPropertyTab.appendText(logData);
        logPropertyTab.scrollToTop();
        SavePanel panel = new SavePanel((WAPanel)logPropertyTab);
        panel.setPreferredSize(new Dimension(400, 350));
        panel.setSaveActionListener((ActionListener)new SaveSasLogActionListener(logData));
        MessageUtil.displayDetailsMessage((String)e.getLocalizedMessage(), (String)RB.getStringResource("SharedDimension.Error.window.title"), (int)0, (JComponent)panel);
    }
}

