/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.olapschema;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.RelatedObjectsInterface;
import com.sas.metadata.logical.SimpleLogicalObject;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.document.DocumentUtil;
import com.sas.metadata.logical.note.NoteUtil;
import com.sas.metadata.logical.olapschema.RB;
import com.sas.metadata.promotion.DefaultExportItem;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.Root;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class OLAPSchemaExportItem
extends DefaultExportItem
implements RelatedObjectsInterface {
    public OLAPSchemaExportItem(String name, String id, TransportableTypeInterface type) {
        super(name, id, type);
    }

    public List getRelatedObjects(int relationshipType) throws LogicalTypeException {
        ArrayList<SimpleLogicalObject> relatedObjects = new ArrayList<SimpleLogicalObject>(0);
        try {
            MdObjectStore store = this._exportOperation.getMetadataFactory().createObjectStore(null, "OLAPSchemaExportItem:getRelatedObjects");
            MdOMIUtil mdUtil = this._exportOperation.getMetadataFactory().getOMIUtil();
            try {
                int options = 268;
                OLAPSchema olapSchema = (OLAPSchema)mdUtil.getMetadataAllDepths((MdStore)store, "OLAPSchema", this.getID(), null, null, null, options);
                if (olapSchema == null) {
                    throw new LogicalTypeException(RB.getStringResource("OLAPSchemaExportItem.ObjNotFound.txt"));
                }
                if (relationshipType == 0) {
                    relatedObjects.addAll(NoteUtil.getDependentNotes((Root)olapSchema));
                    relatedObjects.addAll(DocumentUtil.getDependentDocuments((Root)olapSchema));
                } else if (relationshipType == 1) {
                    String SCHEMA_CONSUMEDBY_TEMPLATE = "<Templates><OLAPSchema><Cubes/></OLAPSchema></Templates>";
                    OLAPSchema schema = (OLAPSchema)mdUtil.getMetadataAllDepths((MdStore)store, "OLAPSchema", this.getID(), null, null, "<Templates><OLAPSchema><Cubes/></OLAPSchema></Templates>", options);
                    if (schema == null) {
                        throw new LogicalTypeException(RB.getStringResource("OLAPSchemaExportItem.ObjNotFound.txt"));
                    }
                    AssociationList cubes = schema.getCubes();
                    for (int i = 0; cubes != null && i < cubes.size(); ++i) {
                        Cube cube = (Cube)cubes.get(i);
                        TypeInterface ti = Factory.getInstance().getTypeInterface("Cube");
                        SimpleLogicalObject logicalCube = new SimpleLogicalObject(cube.getName(), cube.getFQID(), ti);
                        relatedObjects.add(logicalCube);
                    }
                }
            }
            catch (MdException e) {
                throw new LogicalTypeException((Exception)((Object)e));
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException re) {
            throw new LogicalTypeException((Exception)re);
        }
        return relatedObjects;
    }
}

