/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.olapschema;

import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.olapschema.OLAPSchemaImportItem;
import com.sas.metadata.logical.olapschema.RB;
import com.sas.metadata.logical.server.AppServerConnectionType;
import com.sas.metadata.promotion.ConnectionPoint;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionValidatorInterface;
import com.sas.metadata.promotion.DefaultImportItem;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.ValidationResponse;
import com.sas.metadata.remote.MdFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OLAPSchemaConnectionValidator
implements ConnectionValidatorInterface {
    public void validate(ValidationResponse response, ImportOperationInterface importOperation, ConnectionPointInterface connection) {
        String targetID = connection.getTargetID();
        try {
            List items = importOperation.getImportItems("OLAPSchema");
            ArrayList<String> targetList = new ArrayList<String>();
            for (int j = 0; j < items.size(); ++j) {
                OLAPSchemaImportItem item = (OLAPSchemaImportItem)((Object)items.get(j));
                List conns = item.getConnectionPoints();
                for (int i = 0; i < conns.size(); ++i) {
                    ConnectionPoint connPoint = (ConnectionPoint)conns.get(i);
                    if (connPoint.getMetadataType() != "ServerContext") continue;
                    targetList.add(connPoint.getTargetID());
                }
            }
            targetList.remove(connection.getTargetID());
            String targetObjectID = connection.getTargetID();
            if (targetList.contains(targetObjectID)) {
                response.setReturnCode(2);
                String str = RB.getStringResource("OLAPSchemaConnectionValidator.ServerSelectedError.fmt");
                response.setMessage(UtilMisc.getMessage((String)str, (Object)connection.getName()));
                return;
            }
            String options = "<Templates><ServerContext Name=\"\"><DataPackages/><UsingComponents/></ServerContext><LogicalServer Name=\"\" ClassIdentifier=\"\"/></Templates>";
            int flags = 260;
            MdFactory factory = importOperation.getMetadataFactory();
            String connectionType = connection.getMetadataType();
            Map serverMap = factory.getOMIUtil().getMetadataNoCache(connectionType, targetID, options, flags);
            String serverName = (String)serverMap.get("Name");
            if (serverMap.size() > 0) {
                boolean serverFound = false;
                List logicalServers = (List)serverMap.get("UsingComponents");
                if (logicalServers != null && logicalServers.size() > 0) {
                    for (Map map : logicalServers) {
                        String classID;
                        String metadataType = (String)map.get("MetadataObjectType");
                        if (!metadataType.equals("LogicalServer") || !"f3f46472-1e31-11d5-87c2-00c04f38f9f6".equals(classID = (String)map.get("ClassIdentifier"))) continue;
                        serverFound = true;
                        break;
                    }
                }
                if (!serverFound) {
                    response.setReturnCode(2);
                    String str = RB.getStringResource("OLAPSchemaConnectionValidator.NoOLAPServerError.fmt");
                    response.setMessage(UtilMisc.getMessage((String)str, (Object)serverName));
                    return;
                }
                String schemaName = "";
                String deployedSchemaName = "";
                boolean connectionValid = true;
                List dataPackages = (List)serverMap.get("DataPackages");
                if (dataPackages != null && dataPackages.size() > 0) {
                    Iterator iter = dataPackages.iterator();
                    while (iter.hasNext() && connectionValid) {
                        Map datapackagesMap = (Map)iter.next();
                        String metadataType = (String)datapackagesMap.get("MetadataObjectType");
                        if (!metadataType.equals("OLAPSchema")) continue;
                        connectionValid = false;
                        List associatedObjs = connection.getAssociatedObjects();
                        boolean deployedSchemaIsUpdate = false;
                        boolean found = false;
                        for (int i = 0; i < associatedObjs.size() && !found; ++i) {
                            DefaultImportItem d = (DefaultImportItem)associatedObjs.get(i);
                            if (!d.getTypeInterface().getMetadataType().equals("OLAPSchema")) continue;
                            deployedSchemaName = d.getName();
                            deployedSchemaIsUpdate = d.getImportState() != 1;
                            found = true;
                        }
                        String id = (String)datapackagesMap.get("Id");
                        options = "<Templates><OLAPSchema Name=\"\"/></Templates>";
                        Map schemaMap = factory.getOMIUtil().getMetadataNoCache("OLAPSchema", id, options, flags);
                        schemaName = (String)schemaMap.get("Name");
                        if (!deployedSchemaIsUpdate || !found || !deployedSchemaName.equals(schemaName)) continue;
                        connectionValid = true;
                    }
                }
                if (!connectionValid) {
                    response.setReturnCode(2);
                    String str = RB.getStringResource("OLAPSchemaConnectionValidator.OLAPSchemaExistsError.fmt");
                    response.setMessage(UtilMisc.getMessage((String)str, (Object)deployedSchemaName, (Object)serverName, (Object)schemaName));
                    return;
                }
            }
        }
        catch (Exception e) {
            response.setReturnCode(2);
            String str = RB.getStringResource("OLAPSchemaConnectionValidator.MetadataError.fmt");
            response.setMessage(UtilMisc.getMessage((String)str, (Object)e.getLocalizedMessage()));
            return;
        }
    }

    public String getConnectionTypeName() {
        return AppServerConnectionType.class.getName();
    }
}

