/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.olapschema;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidAuthType;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidCredHandle;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidResourceSpec;
import com.sas.meta.SASOMI.ISecurityPackage.NotTrustedUser;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObject;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.cube.CubeUtilities;
import com.sas.metadata.logical.olapschema.OLAPSchemaNameValidator;
import com.sas.metadata.logical.olapschema.RB;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.util.Names;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.StringHolder;

public class OLAPSchema
extends LogicalObject {
    private static StringBuffer XML_SELECT = new StringBuffer();
    private static final String REPLACE_REPOSITORY = "_REPLACE_REPOSITORY_TEMPLATE_";
    private static final int FLAGS = 8580;
    private static final String REPLACE_SEARCH = "_REPLACE_SEARCH_TEMPLATE_";
    private static final String OLAPCUBECONNECTION = "OLAPCubeConnection";
    public static final UsageVersion CURRENT_VERSION;
    public static final UsageVersion FAILED_MIGRATION_VERSION;

    public OLAPSchema(com.sas.metadata.remote.OLAPSchema inputSchema, TypeInterface type, Factory factory) throws RemoteException {
        super((Root)inputSchema, type, factory);
        this.setCompatibility(FAILED_MIGRATION_VERSION, CURRENT_VERSION);
    }

    private com.sas.metadata.remote.OLAPSchema getJomaOLAPSchema(OperationUserInteractionInterface oui, MdObjectStore objectStore) throws LogicalTypeException {
        com.sas.metadata.remote.OLAPSchema jomaOLAPSchema = null;
        try {
            jomaOLAPSchema = (com.sas.metadata.remote.OLAPSchema)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((MdStore)objectStore, this.getTypeInterface().getMetadataType(), this.getID(), null, null, null, 264);
        }
        catch (MdException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        catch (RemoteException e) {
            throw new LogicalTypeException((Exception)e);
        }
        return jomaOLAPSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String schemaName, OperationUserInteractionInterface oui) throws LogicalTypeException {
        com.sas.metadata.remote.OLAPSchema jomaOLAPSchema = null;
        AssociationList cubes = null;
        MdObjectStore store = null;
        HashMap<String, String> map = null;
        try {
            FolderInterface parentFolder;
            Object parentObject;
            Names.validateOMRObjectName((String)schemaName, (boolean)true);
            MetadataInterface mi = UtilPlatformServices.getSmartObject((SimpleLogicalObjectInterface)this);
            List parents = mi.getParents();
            if (parents != null && parents.size() == 1 && (parentObject = parents.get(0)) instanceof FolderInterface && (parentFolder = (FolderInterface)parentObject).hasDuplicate(schemaName, this.getTypeInterface().getPublicType())) {
                LogicalTypeException loe = new LogicalTypeException(UtilMisc.getMessage((String)RB.getStringResource("OLAPSchema.DuplicateObjectFound.fmt"), (Object)schemaName));
                throw loe;
            }
            store = Workspace.getMdFactory().createObjectStore(null, "OLAPSchema.rename");
            jomaOLAPSchema = this.getJomaOLAPSchema(null, store);
            boolean unique = OLAPSchemaNameValidator.isOLAPSchemaNameUnique(schemaName, store.getFactory().getOMIUtil().getFoundationReposID());
            if (!unique) {
                LogicalTypeException loe = new LogicalTypeException(UtilMisc.getMessage((String)RB.getStringResource("OLAPSchemaImportListener.NameNotUnique.fmt"), (Object)schemaName));
                throw loe;
            }
            if (jomaOLAPSchema != null) {
                Cube cube;
                int i;
                map = new HashMap<String, String>();
                map.put(jomaOLAPSchema.getFQID(), jomaOLAPSchema.getCMetadataType());
                jomaOLAPSchema.setName(schemaName);
                cubes = jomaOLAPSchema.getCubes(true);
                for (i = cubes.size() - 1; i >= 0; --i) {
                    cube = (Cube)cubes.get(i);
                    AssociationList classifierMaps = cube.getTargetClassifierMaps(true);
                    if (classifierMaps.isEmpty()) continue;
                    ClassifierMap classifierMap = (ClassifierMap)classifierMaps.get(0);
                    AssociationList properties = classifierMap.getProperties(true);
                    for (int j = properties.size() - 1; j >= 0; --j) {
                        Property property = (Property)properties.get(j);
                        if (!property.getName().equalsIgnoreCase(OLAPCUBECONNECTION)) continue;
                        property.setDefaultValue(cube.getName() + "/" + jomaOLAPSchema.getName());
                    }
                }
                for (i = cubes.size() - 1; i >= 0; --i) {
                    cube = (Cube)cubes.get(i);
                    cube.touch();
                    Job jomaJob = CubeUtilities.getJobCube(cube);
                    jomaJob.touch();
                    cube.updateMetadataAll();
                }
                jomaOLAPSchema.touch();
                jomaOLAPSchema.updateMetadataAll();
                MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
                Workspace.getMdFactory().fireMdObjectsModified(new MdFactoryEvent(factory, map));
            }
        }
        catch (MdException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        catch (ServiceException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        catch (RemoteException e) {
            throw new LogicalTypeException((Exception)e);
        }
        catch (IllegalArgumentException e) {
            oui.displayMessage(RB.getStringResource("OLAPSchema.RenameError.title.txt"), e.getLocalizedMessage(), 2, OperationUserInteractionInterface.OK_CHOICE_SET);
        }
        finally {
            try {
                if (store != null) {
                    store.dispose();
                }
            }
            catch (RemoteException e) {
                throw new LogicalTypeException((Exception)e);
            }
        }
    }

    private static boolean getPermissions(String permission, CMetadata inputOLAPSchema, String metadataType) throws GenericError, MdException, RemoteException, InvalidResourceSpec, NotTrustedUser, InvalidCredHandle {
        boolean hasPermissions = true;
        IOMI omiHandle = Workspace.getWorkspace().getCMRHandle();
        ISecurity_1_1 security = Workspace.getMdFactory().getConnection().MakeISecurityConnection(omiHandle);
        String credential = "";
        String resource = "OMSOBJ:" + metadataType + "/" + inputOLAPSchema.getFQID();
        StringHolder permissionCondition = new StringHolder();
        BooleanHolder authorized = new BooleanHolder();
        security.IsAuthorized(credential, resource, permission, permissionCondition, authorized);
        hasPermissions = authorized.value;
        return hasPermissions;
    }

    private boolean isAllowed() throws LogicalTypeException {
        boolean canDo = false;
        MdObjectStore store = null;
        try {
            store = Workspace.getMdFactory().createObjectStore(null, "OLAPSchema.isAllowed");
            com.sas.metadata.remote.OLAPSchema jomaOLAPSchema = this.getJomaOLAPSchema(null, store);
            if (jomaOLAPSchema != null) {
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)jomaOLAPSchema, null, null, "", 8);
                boolean canWriteAllSchema = OLAPSchema.getPermissions("WriteMetadata", (CMetadata)jomaOLAPSchema, "OLAPSchema");
                boolean canReadAllSchema = OLAPSchema.getPermissions("ReadMetadata", (CMetadata)jomaOLAPSchema, "OLAPSchema");
                canDo = canWriteAllSchema & canReadAllSchema;
                if (canDo) {
                    String xmlselect;
                    int totalNumberOfCubes;
                    AssociationList cubes = jomaOLAPSchema.getCubes(true);
                    int nonHiddenCubes = cubes.size();
                    boolean bl = canDo = nonHiddenCubes == (totalNumberOfCubes = OLAPSchema.getNumberOfItems(xmlselect = OLAPSchema.getXMLSelectSearchTemplate(this.getID())));
                    if (canDo) {
                        for (int i = cubes.size() - 1; i >= 0 && canDo; --i) {
                            Cube jomaCube = (Cube)cubes.get(i);
                            boolean canWriteAllCube = OLAPSchema.getPermissions("WriteMetadata", (CMetadata)jomaCube, "Cube");
                            boolean canReadAllCube = OLAPSchema.getPermissions("ReadMetadata", (CMetadata)jomaCube, "Cube");
                            canDo = canWriteAllCube & canReadAllCube;
                        }
                    }
                }
            }
        }
        catch (InvalidCredHandle mderror) {
            throw new LogicalTypeException((Exception)((Object)mderror));
        }
        catch (InvalidResourceSpec mderror) {
            throw new LogicalTypeException((Exception)((Object)mderror));
        }
        catch (GenericError mderror) {
            throw new LogicalTypeException((Exception)((Object)mderror));
        }
        catch (NotTrustedUser mderror) {
            throw new LogicalTypeException((Exception)((Object)mderror));
        }
        catch (MdException mderror) {
            throw new LogicalTypeException((Exception)((Object)mderror));
        }
        catch (RemoteException re) {
            throw new LogicalTypeException((Exception)re);
        }
        finally {
            try {
                if (store != null) {
                    store.dispose();
                }
            }
            catch (RemoteException e) {
                throw new LogicalTypeException((Exception)e);
            }
        }
        return canDo;
    }

    public boolean isRenameAllowed() throws LogicalTypeException {
        boolean allowed = super.isRenameAllowed();
        if (!allowed) {
            return allowed;
        }
        return this.isAllowed();
    }

    private boolean isBlank(String value) {
        return value == null || Strings.trimmedLength((String)value) == 0;
    }

    public boolean isCheckOutAllowed() {
        return false;
    }

    public boolean isFetchAllowed() {
        return false;
    }

    public boolean isValidName() {
        boolean validName = true;
        String name = this.getName();
        if (this.isBlank(name) || name.length() > 32) {
            validName = false;
        }
        return validName;
    }

    private static String getXMLSelectSearchTemplate(String inputID) throws MdException, RemoteException {
        String xmlSelectTemplate = "";
        String repository = Workspace.getMdFactory().getOMIUtil().getFoundationReposID();
        xmlSelectTemplate = XML_SELECT.toString();
        xmlSelectTemplate = xmlSelectTemplate.replaceAll(REPLACE_REPOSITORY, repository);
        StringBuffer template = new StringBuffer();
        template.append("OLAPSchema[@Id = '");
        template.append(inputID);
        template.append("']");
        xmlSelectTemplate = xmlSelectTemplate.replaceAll(REPLACE_SEARCH, Matcher.quoteReplacement(template.toString()));
        return xmlSelectTemplate;
    }

    public static int getNumberOfItems(String template) throws MdException {
        int numberOfItems = 0;
        try {
            VariableArray2dOfStringHolder returnAuths = new VariableArray2dOfStringHolder();
            IOMI omiHandle = Workspace.getWorkspace().getCMRHandle();
            ISecurity_1_1 security = Workspace.getMdFactory().getConnection().MakeISecurityConnection(omiHandle);
            security.GetAuthorizations("getCountNoSecurity", "", template, "Cubes", returnAuths);
            numberOfItems = Integer.valueOf(returnAuths.value[0][1]);
            Workspace.getMdFactory().getConnection().closeISecurityConnection((ISecurity)security);
        }
        catch (RemoteException error) {
            throw new MdException((Throwable)error);
        }
        catch (MdException error) {
            throw new MdException((Throwable)error);
        }
        catch (InvalidAuthType error) {
            throw new MdException((Throwable)error);
        }
        catch (InvalidCredHandle error) {
            throw new MdException((Throwable)error);
        }
        catch (NotTrustedUser error) {
            throw new MdException((Throwable)error);
        }
        catch (GenericError error) {
            throw new MdException((Throwable)error);
        }
        catch (InvalidResourceSpec error) {
            throw new MdException((Throwable)error);
        }
        return numberOfItems;
    }

    public boolean hasCubes() throws MdException, RemoteException {
        boolean cubes = false;
        String xmlselect = OLAPSchema.getXMLSelectSearchTemplate(this.getID());
        int numberOfCubes = OLAPSchema.getNumberOfItems(xmlselect);
        cubes = numberOfCubes > 0;
        return cubes;
    }

    public boolean delete(OperationUserInteractionInterface ouii) throws LogicalTypeException, RemoteException {
        String progressText = this.getProgressMessageForDelete();
        ouii.updateProgress(progressText);
        MdObjectStore objectStore = Workspace.getMdFactory().createObjectStore(null, "OLAPSchema.delete");
        boolean deleted = false;
        try {
            com.sas.metadata.remote.OLAPSchema jomaOLAPSchema = this.getJomaOLAPSchema(ouii, objectStore);
            if (!this.hasCubes()) {
                Workspace.getMdFactory().deleteMetadataObject((CMetadata)jomaOLAPSchema);
                deleted = true;
            } else {
                ouii.displayMessage(RB.getStringResource("OLAPSchemaError.window.title"), RB.getStringResource("OLAPSchemaError.HasCubes.txt"), 2, OperationUserInteractionInterface.OK_CHOICE_SET);
            }
        }
        catch (MdException error) {
            throw new LogicalTypeException((Exception)((Object)error));
        }
        finally {
            objectStore.dispose();
        }
        return deleted;
    }

    static {
        XML_SELECT.append("<GetMetadataObjects><Reposid>");
        XML_SELECT.append(REPLACE_REPOSITORY);
        XML_SELECT.append("</Reposid><Type>");
        XML_SELECT.append("OLAPSchema");
        XML_SELECT.append("</Type><Objects/><NS>SAS</NS><Flags>");
        XML_SELECT.append(8580);
        XML_SELECT.append("</Flags><Options><XMLSelect search=\"");
        XML_SELECT.append(REPLACE_SEARCH);
        XML_SELECT.append("\"/>");
        XML_SELECT.append("<Templates><OLAPSchema><Cubes/></OLAPSchema></Templates></Options></GetMetadataObjects>");
        CURRENT_VERSION = new UsageVersion(1, 0);
        FAILED_MIGRATION_VERSION = new UsageVersion(0, 0);
    }
}

