/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.jobcube;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObject;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.jobcube.RB;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.util.UsageVersion;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;

public class JobCubeObject
extends LogicalObject {
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public JobCubeObject(Job mdoJob, TypeInterface type, Factory factory) throws RemoteException {
        super((Root)mdoJob, type, factory);
        this.setCompatibility(CURRENT_VERSION, CURRENT_VERSION);
    }

    public boolean delete(OperationUserInteractionInterface oui) throws LogicalTypeException, RemoteException {
        oui.updateProgress(UtilMisc.getMessage((String)RB.getStringResource("JobCubeObject.Progress.Deleting.fmt.txt"), (Object)this.getName()));
        boolean deleted = false;
        MdObjectStore objectStore = null;
        try {
            objectStore = Workspace.getMdFactory().createObjectStore(null, "JobCubeObject.delete");
            Job jomaJob = this.getJomaJob(oui, objectStore);
            Workspace.getMdFactory().deleteMetadataObject((CMetadata)jomaJob);
            deleted = true;
        }
        catch (MdException error) {
            throw new LogicalTypeException((Exception)((Object)error));
        }
        finally {
            if (objectStore != null) {
                objectStore.dispose();
            }
        }
        return deleted;
    }

    public void rename(String name, OperationUserInteractionInterface opUI) throws LogicalTypeException {
        String oldName = this.getName();
        try {
            super.rename(name, opUI);
        }
        catch (RemoteException error) {
            throw new LogicalTypeException((Exception)error);
        }
        if (!oldName.equals(this.getName())) {
            try {
                MdObjectStore objectStore = null;
                try {
                    Cube jomaCube;
                    objectStore = Workspace.getMdFactory().createObjectStore(null, "JobCubeObject.rename");
                    Job jomaJob = this.getJomaJob(opUI, objectStore);
                    if (jomaJob != null && (jomaCube = this.getJomaCube(opUI, jomaJob)) != null) {
                        jomaCube.touch();
                        jomaCube.updateMetadataAll();
                    }
                }
                catch (MdException error) {
                    throw new LogicalTypeException((Exception)((Object)error));
                }
                finally {
                    if (objectStore != null) {
                        objectStore.dispose();
                    }
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    private Cube getJomaCube(OperationUserInteractionInterface opUI, Job jomaJob) throws RemoteException, MdException {
        Object target;
        ClassifierMap map;
        AssociationList targets;
        TransformationStep step;
        AssociationList transformations;
        TransformationActivity activity;
        AssociationList steps;
        Cube jomaCube = null;
        AssociationList activities = jomaJob.getJobActivities();
        if (!(activities.isEmpty() || (steps = (activity = (TransformationActivity)activities.get(0)).getSteps()).isEmpty() || (transformations = (step = (TransformationStep)steps.get(0)).getTransformations()).isEmpty() || (targets = (map = (ClassifierMap)transformations.get(0)).getClassifierTargets()).isEmpty() || !((target = targets.get(0)) instanceof Cube))) {
            jomaCube = (Cube)target;
        }
        return jomaCube;
    }

    private Job getJomaJob(OperationUserInteractionInterface oui, MdObjectStore objectStore) throws MdException, RemoteException {
        Job jomaJob = null;
        jomaJob = (Job)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((MdStore)objectStore, this.getTypeInterface().getMetadataType(), this.getID(), null, null, null, 264);
        return jomaJob;
    }
}

