/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.jobcube;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.cube.CubeImportItem;
import com.sas.metadata.logical.jobcube.JobCubeImportItem;
import com.sas.metadata.logical.jobcube.RB;
import com.sas.metadata.logical.server.AppServerConnectionType;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.DefaultImportItem;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.util.UsageVersion;
import java.util.Iterator;
import java.util.List;

public class JobCubeImportListener
extends AbstractImportListener {
    protected static final Class[] CONNECTION_TYPES = new Class[]{AppServerConnectionType.class};

    public JobCubeImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public Class[] getConnectionTypes() {
        return CONNECTION_TYPES;
    }

    public ImportItemInterface createImportItem(String name, String id, TransportableTypeInterface type) {
        return new JobCubeImportItem(name, id, type);
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int iRC = 0;
        Iterator iterImportItems = objects.iterator();
        while (iterImportItems.hasNext() && iRC == 0) {
            JobCubeImportItem jobcubeImportItem = (JobCubeImportItem)((Object)iterImportItems.next());
            UsageVersion version = jobcubeImportItem.getUsageVersion();
            if (!version.equals((Object)new UsageVersion(1, 0))) {
                iRC = 8;
                String msg = RB.getStringResource("JobCubeImportListener.VersionNotSupported.fmt");
                throw new MetadataPromotionException(UtilMisc.getMessage((String)msg, (Object)jobcubeImportItem.getName()));
            }
            List connectionPoints = jobcubeImportItem.getConnectionPoints();
            boolean cubeFound = false;
            String cubeName = "";
            for (int i = 0; i < connectionPoints.size() && !cubeFound; ++i) {
                ConnectionPointInterface conn = (ConnectionPointInterface)connectionPoints.get(i);
                String publicType = conn.getPublicType();
                if (publicType == null || !publicType.equals("Cube")) continue;
                String sCubeSearch = conn.getSourceSearchString();
                String temp = sCubeSearch.substring("*[@Name='".length());
                cubeName = temp.substring(0, temp.indexOf("']"));
                List allObjects = operation.getAllPromotionItems();
                for (int j = 0; j < allObjects.size() && !cubeFound; ++j) {
                    DefaultImportItem item = (DefaultImportItem)allObjects.get(j);
                    if (!(item instanceof CubeImportItem) || !item.getOriginalName().equals(cubeName)) continue;
                    cubeFound = true;
                }
            }
            if (cubeFound) continue;
            String msg = RB.getStringResource("JobCubeImportListener.CubeNotImportedError.fmt");
            throw new MetadataPromotionException(UtilMisc.getMessage((String)msg, (Object)cubeName));
        }
        return iRC;
    }
}

