/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.jobcube;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.RelatedObjectsInterface;
import com.sas.metadata.logical.SimpleLogicalObject;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.common.PrivateObjectImportUtility;
import com.sas.metadata.logical.document.DocumentUtil;
import com.sas.metadata.logical.note.NoteUtil;
import com.sas.metadata.promotion.DefaultExportItem;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Classifier;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class JobCubeExportItem
extends DefaultExportItem
implements RelatedObjectsInterface {
    public JobCubeExportItem(String name, String id, TransportableTypeInterface type) {
        super(name, id, type);
    }

    public List getRelatedObjects(int relationshipType) throws LogicalTypeException {
        ArrayList<Object> relObjects = new ArrayList<Object>();
        try {
            MdFactory factory = this._exportOperation.getMetadataFactory();
            MdObjectStore mdStore = factory.createObjectStore(null, "JobCubeExportItem.getRelatedObjects");
            int iOptions = 284;
            try {
                Job mdJob = (Job)factory.getOMIUtil().getMetadataAllDepths((MdStore)mdStore, "Job", this.getID(), null, null, "<Templates><Job><Documents/><JobActivities/><Notes/></Job><ClassifierMap><ClassifierSources/><ClassifierTargets/><SourceSpecifications/></ClassifierMap><TransformationActivity><Steps/></TransformationActivity><TransformationStep><Documents/><Notes/><Transformations/></TransformationStep><WorkTable><TablePackage/></WorkTable></Templates>", iOptions);
                if (mdJob == null) {
                    throw new LogicalTypeException(UtilMisc.getMessage((String)"JobCubeExportItem.ObjNotFound.txt", (Object)this.getName()));
                }
                if (relationshipType == 0) {
                    relObjects.addAll(NoteUtil.getDependentNotes((Root)mdJob));
                    relObjects.addAll(DocumentUtil.getDependentDocuments((Root)mdJob));
                    AssociationList lActivities = mdJob.getJobActivities();
                    if (!lActivities.isEmpty()) {
                        TransformationActivity mdActivity = (TransformationActivity)lActivities.get(0);
                        AssociationList lSteps = mdActivity.getSteps();
                        for (TransformationStep mdStep : lSteps) {
                            AssociationList lCMs = mdStep.getTransformations();
                            for (Transformation mdTransformation : lCMs) {
                                if (!(mdTransformation instanceof ClassifierMap)) continue;
                                ClassifierMap mdCM = (ClassifierMap)mdTransformation;
                                AssociationList lTargets = mdCM.getClassifierTargets();
                                for (Classifier mdClassifier : lTargets) {
                                    if (!(mdClassifier instanceof Cube)) continue;
                                    TypeInterface ti = Factory.getInstance().getTypeInterface("Cube");
                                    SimpleLogicalObject simpleCube = new SimpleLogicalObject(mdClassifier.getName(), mdClassifier.getFQID(), ti);
                                    relObjects.add(simpleCube);
                                }
                            }
                        }
                    }
                } else if (relationshipType == 1) {
                    AssociationList jfJobs = mdJob.getJFJobs();
                    for (JFJob jfJob : jfJobs) {
                        SimpleLogicalObjectInterface simpleJfJob = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)jfJob);
                        if (simpleJfJob == null) continue;
                        relObjects.add(simpleJfJob);
                    }
                }
            }
            catch (MdException mde) {
                throw new LogicalTypeException((Exception)((Object)mde));
            }
            finally {
                mdStore.dispose();
            }
            return relObjects;
        }
        catch (RemoteException e) {
            throw new LogicalTypeException((Exception)e);
        }
    }
}

