/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.cube;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidAuthType;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidCredHandle;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidResourceSpec;
import com.sas.meta.SASOMI.ISecurityPackage.NotTrustedUser;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.util.XMLUtil;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CubeUtilities {
    public static StringBuffer XML_SELECT_PER_OLAPSCHEMA = new StringBuffer();
    public static final String REPLACE_SEARCH = "_REPLACE_SEARCH_PER_OLAPSCHEMA_TEMPLATE_";
    public static final String REPLACE_TYPE = "_REPLACE_TYPE_";
    public static final String REPLACE_REPOSITORY = "_REPLACE_REPOSITORY_TEMPLATE_";
    public static final String REPLACE_OLAPSCHEMA = "_REPLACE_OLAPSCHEMA_TEMPLATE_";
    public static final String TEMPLATE = "<Templates></Templates>";
    private static final int FLAGS = 24704;
    public static final String REPLACE_ID = "_REPLACE_ID_TEMPLATE_";
    public static final String REPLACE_ASSOCIATED = "_REPLACE_ASSOCIATED_TEMPLATE_";
    public static StringBuffer XML_SELECT;
    public static final String CUBE_DEPENDENCIES_TEMPLATE = "<Templates><Cube><Notes/><Documents/><TargetClassifierMaps/><ReachThruTables/><TargetTransformations/><SourceTransformations/></Cube><PhysicalTable><TablePackages/></PhysicalTable><ClassifierMap><ClassifierSources/><TransformationSources/><Steps/></ClassifierMap><TransformationStep><Activities/></TransformationStep><TransformationActivity><Jobs/></TransformationActivity></Templates>";

    public static boolean isCubeNameUnique(String inputCube, OLAPSchema olapSchema) {
        String xmlselect = "";
        boolean isUnique = false;
        if (olapSchema != null) {
            try {
                String repository = Workspace.getMdFactory().getOMIUtil().getFoundationReposID();
                String olapSchemaID = olapSchema.getFQID();
                xmlselect = XML_SELECT_PER_OLAPSCHEMA.toString();
                xmlselect = xmlselect.replaceAll(REPLACE_REPOSITORY, repository);
                StringBuffer template = new StringBuffer();
                template.append("Cube[@Name = '");
                String normalizedName = XMLUtil.normalize((String)inputCube);
                template.append(normalizedName);
                template.append("']");
                xmlselect = xmlselect.replaceAll(REPLACE_SEARCH, template.toString());
                xmlselect = xmlselect.replaceAll(REPLACE_TYPE, "CUBE");
                xmlselect = xmlselect.replaceAll(REPLACE_OLAPSCHEMA, olapSchemaID);
                isUnique = CubeUtilities.getNumberOfItems(xmlselect) == 0;
            }
            catch (RemoteException e) {
                isUnique = false;
            }
            catch (MdException e) {
                isUnique = false;
            }
        } else {
            isUnique = true;
        }
        return isUnique;
    }

    public static boolean isCubeNameUniqueToFolder(String inputCube, Tree inputFolder) {
        boolean nameUnique = true;
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            String sFQID = inputFolder.getFQID();
            String sType = inputFolder.getCMetadataType();
            String sKey = sFQID + "/" + sType;
            FolderInterface folderObject = (FolderInterface)server.fetch(sKey, false);
            nameUnique = !folderObject.hasDuplicate(inputCube, "Cube");
        }
        catch (RemoteException e) {
            nameUnique = false;
        }
        catch (ServiceException e) {
            nameUnique = false;
        }
        return nameUnique;
    }

    public static String getRepositoryName(Tree inputObject) {
        String repositoryName = "";
        try {
            String repositoryFQID = CubeUtilities.getRepositoryFQID(inputObject);
            repositoryName = Workspace.getMdFactory().getRepositoryUtil().getRepositoryName(repositoryFQID);
        }
        catch (RemoteException e) {
            repositoryName = "";
        }
        catch (MdException e) {
            repositoryName = "";
        }
        return repositoryName;
    }

    public static String getRepositoryFQID(Tree inputObject) {
        String repositoryFQID = "";
        try {
            repositoryFQID = Workspace.getWorkspace().isChangeManagementOn() ? Workspace.getWorkspace().getProjectRepositoryId() : Workspace.getMdFactory().getOMIUtil().getReposIdFromMetadataObject((CMetadata)inputObject);
        }
        catch (RemoteException e) {
            repositoryFQID = "";
        }
        return repositoryFQID;
    }

    public static boolean isCubeNameUniqueToOLAPSchema(String inputCube, OLAPSchema inputSchema) {
        return CubeUtilities.isCubeNameUniqueToOLAPSchema(inputCube, inputSchema, Workspace.getMdFactory());
    }

    public static boolean isCubeNameUniqueToOLAPSchema(String inputCube, OLAPSchema inputSchema, MdFactory factory) {
        boolean numberOfItems = false;
        try {
            String folderID = inputSchema.getFQID();
            String xmlselect = "";
            xmlselect = CubeUtilities.getXMLSelectSearchTemplate(inputCube, factory);
            xmlselect = xmlselect.replaceAll(REPLACE_ASSOCIATED, "[AssociatedOLAPSchema/*[@Id='");
            xmlselect = xmlselect.replaceAll(REPLACE_ID, folderID);
            numberOfItems = CubeUtilities.getNumberOfItems(xmlselect, factory) == 0;
        }
        catch (RemoteException e) {
            numberOfItems = false;
        }
        catch (MdException e) {
            numberOfItems = false;
        }
        return numberOfItems;
    }

    public static boolean isCubeNameUniqueToOLAPSchema(String cubeName, String schemaID) {
        return CubeUtilities.isCubeNameUniqueToOLAPSchema(cubeName, schemaID, Workspace.getWorkspace().getMdObjectFactory());
    }

    public static boolean isCubeNameUniqueToOLAPSchema(String cubeName, String schemaID, MdFactory factory) {
        boolean numberOfItems = false;
        try {
            String xmlselect = CubeUtilities.getXMLSelectSearchTemplate(cubeName, factory);
            xmlselect = xmlselect.replaceAll(REPLACE_ASSOCIATED, "[AssociatedOLAPSchema/*[@Id='");
            xmlselect = xmlselect.replaceAll(REPLACE_ID, schemaID);
            numberOfItems = CubeUtilities.getNumberOfItems(xmlselect, factory) == 0;
        }
        catch (RemoteException e) {
            numberOfItems = false;
        }
        catch (MdException e) {
            numberOfItems = false;
        }
        return numberOfItems;
    }

    public static boolean isCubeNameUniqueToOLAPSchemaUsingNames(String cubeName, String schemaName) {
        return CubeUtilities.isCubeNameUniqueToOLAPSchemaUsingNames(cubeName, schemaName, Workspace.getMdFactory());
    }

    public static boolean isCubeNameUniqueToOLAPSchemaUsingNames(String cubeName, String schemaName, MdFactory factory) {
        boolean numberOfItems = false;
        try {
            String xmlselect = CubeUtilities.getXMLSelectSearchTemplate(cubeName, factory);
            xmlselect = xmlselect.replaceAll(REPLACE_ASSOCIATED, "[AssociatedOLAPSchema/*[@Name='");
            xmlselect = xmlselect.replaceAll(REPLACE_ID, schemaName);
            numberOfItems = CubeUtilities.getNumberOfItems(xmlselect, factory) == 0;
        }
        catch (RemoteException e) {
            numberOfItems = false;
        }
        catch (MdException e) {
            numberOfItems = false;
        }
        return numberOfItems;
    }

    private static String getXMLSelectSearchTemplate(String inputName, MdFactory factory) throws MdException, RemoteException {
        String xmlSelectTemplate = "";
        String repository = factory.getOMIUtil().getFoundationReposID();
        xmlSelectTemplate = XML_SELECT.toString();
        xmlSelectTemplate = xmlSelectTemplate.replaceAll(REPLACE_REPOSITORY, repository);
        StringBuffer template = new StringBuffer();
        template.append("Cube[@Name = '");
        String normalizedName = XMLUtil.normalize((String)inputName);
        template.append(normalizedName);
        template.append("']");
        xmlSelectTemplate = xmlSelectTemplate.replaceAll(REPLACE_SEARCH, template.toString());
        xmlSelectTemplate = xmlSelectTemplate.replaceAll(REPLACE_TYPE, "CUBE");
        return xmlSelectTemplate;
    }

    public static int getNumberOfItems(String template) {
        return CubeUtilities.getNumberOfItems(template, Workspace.getWorkspace().getMdObjectFactory());
    }

    public static int getNumberOfItems(String template, MdFactory factory) {
        int numberOfItems = 0;
        try {
            MdOMRConnection connection = factory.getConnection();
            VariableArray2dOfStringHolder returnAuths = new VariableArray2dOfStringHolder();
            IOMI omiHandle = connection.getCMRHandle();
            ISecurity_1_1 security = connection.MakeISecurityConnection(omiHandle);
            security.GetAuthorizations("getCountNoSecurity", "", template, "", returnAuths);
            numberOfItems = Integer.valueOf(returnAuths.value[0][1]);
            connection.closeISecurityConnection((ISecurity)security);
        }
        catch (RemoteException error) {
            numberOfItems = 0;
        }
        catch (MdException error) {
            numberOfItems = 0;
        }
        catch (InvalidAuthType error) {
            numberOfItems = 0;
        }
        catch (InvalidCredHandle error) {
            numberOfItems = 0;
        }
        catch (NotTrustedUser error) {
            numberOfItems = 0;
        }
        catch (GenericError error) {
            numberOfItems = 0;
        }
        catch (InvalidResourceSpec error) {
            numberOfItems = 0;
        }
        return numberOfItems;
    }

    public static List getOLAPSchemas(MdObjectStore objectStore) throws MdException, RemoteException {
        List olapSchemaList = null;
        olapSchemaList = CubeUtilities.getCMetadataList("OLAPSchema", objectStore);
        CubeUtilities.sort(olapSchemaList);
        return Collections.unmodifiableList(olapSchemaList);
    }

    public static Job getJobCube(Cube jomaCube) throws MdException, RemoteException {
        TransformationActivity activity;
        AssociationList jobs;
        TransformationStep step;
        AssociationList activities;
        ClassifierMap loadMap;
        AssociationList steps;
        AssociationList classifierMaps;
        Job job = null;
        if (!(jomaCube == null || (classifierMaps = jomaCube.getTargetClassifierMaps()).isEmpty() || (steps = (loadMap = (ClassifierMap)classifierMaps.get(0)).getSteps(true)).isEmpty() || (activities = (step = (TransformationStep)steps.get(0)).getActivities(true)).isEmpty() || (jobs = (activity = (TransformationActivity)activities.get(0)).getJobs(true)).isEmpty() || (activities = (job = (Job)jobs.get(0)).getJobActivities(true)).size() <= 1)) {
            job = null;
        }
        return job;
    }

    private static List getCMetadataList(String metadataType, MdObjectStore objectStore) throws MdException, RemoteException {
        ArrayList metadataList = new ArrayList();
        List temp = null;
        int flags = 8456;
        List tempAll = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)objectStore, CubeUtilities.getRepositoryFoundationFQID(), metadataType, flags, "");
        temp = Workspace.removeCheckouts((List)tempAll);
        for (int i = temp.size() - 1; i >= 0; --i) {
            metadataList.add(0, temp.get(i));
        }
        return metadataList;
    }

    public static String getRepositoryFoundationFQID() throws MdException, RemoteException {
        String foundationFQID = "";
        foundationFQID = Workspace.getMdFactory().getOMIUtil().getFoundationReposID();
        return foundationFQID;
    }

    private static void sort(List sorted) {
        int i;
        ArrayList<ComparableObject> sortList = new ArrayList<ComparableObject>();
        for (i = sorted.size() - 1; i >= 0; --i) {
            sortList.add(new ComparableObject(sorted.get(i)));
        }
        Collections.sort(sortList);
        sorted.clear();
        for (i = sortList.size() - 1; i >= 0; --i) {
            ComparableObject sortedObject = (ComparableObject)sortList.get(i);
            sorted.add(0, sortedObject.getObject());
        }
    }

    static {
        XML_SELECT_PER_OLAPSCHEMA.append("<GetMetadataObjects><Reposid>");
        XML_SELECT_PER_OLAPSCHEMA.append(REPLACE_REPOSITORY);
        XML_SELECT_PER_OLAPSCHEMA.append("</Reposid><Type>");
        XML_SELECT_PER_OLAPSCHEMA.append(REPLACE_TYPE);
        XML_SELECT_PER_OLAPSCHEMA.append("</Type><Objects/><NS>SAS</NS><Flags>");
        XML_SELECT_PER_OLAPSCHEMA.append(24704);
        XML_SELECT_PER_OLAPSCHEMA.append("</Flags><Options>");
        XML_SELECT_PER_OLAPSCHEMA.append("<XMLSelect search=\"");
        XML_SELECT_PER_OLAPSCHEMA.append(REPLACE_SEARCH);
        XML_SELECT_PER_OLAPSCHEMA.append("[AssociatedOLAPSchema/*[@Id='");
        XML_SELECT_PER_OLAPSCHEMA.append(REPLACE_OLAPSCHEMA);
        XML_SELECT_PER_OLAPSCHEMA.append("']]\"/>");
        XML_SELECT_PER_OLAPSCHEMA.append(TEMPLATE);
        XML_SELECT_PER_OLAPSCHEMA.append("</Options>");
        XML_SELECT_PER_OLAPSCHEMA.append("</GetMetadataObjects>");
        XML_SELECT = new StringBuffer();
        XML_SELECT.append("<GetMetadataObjects><Reposid>");
        XML_SELECT.append(REPLACE_REPOSITORY);
        XML_SELECT.append("</Reposid><Type>");
        XML_SELECT.append(REPLACE_TYPE);
        XML_SELECT.append("</Type><Objects/><NS>SAS</NS><Flags>");
        XML_SELECT.append(24704);
        XML_SELECT.append("</Flags><Options>");
        XML_SELECT.append("<XMLSelect search=\"");
        XML_SELECT.append(REPLACE_SEARCH);
        XML_SELECT.append(REPLACE_ASSOCIATED);
        XML_SELECT.append(REPLACE_ID);
        XML_SELECT.append("']]\"/>");
        XML_SELECT.append(TEMPLATE);
        XML_SELECT.append("</Options>");
        XML_SELECT.append("</GetMetadataObjects>");
    }

    private static class ComparableObject
    implements Comparable {
        Object compareObject;

        ComparableObject(Object inputCompareObject) {
            this.compareObject = inputCompareObject;
        }

        Object getObject() {
            return this.compareObject;
        }

        public int compareTo(Object obj) {
            int compnum = this.toString().compareTo(obj.toString());
            return compnum;
        }

        public String toString() {
            return this.compareObject.toString();
        }
    }
}

