/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.cube;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.SimpleLogicalObject;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.cube.CubeExportItem;
import com.sas.metadata.logical.cube.RB;
import com.sas.metadata.logical.jobcube.JobCubeExportItem;
import com.sas.metadata.logical.olapschema.OLAPSchemaConnectionType;
import com.sas.metadata.logical.table.TableConnectionType;
import com.sas.metadata.promotion.AbstractExportListener;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;

public class CubeExportListener
extends AbstractExportListener {
    public static final String CUBE_DEPENDENCIES_TEMPLATE = "<Templates><Cube><TargetClassifierMaps/></Cube><ClassifierMap><Steps/></ClassifierMap><TransformationActivity><Jobs/></TransformationActivity><TransformationStep><Activities/></TransformationStep></Templates>";
    protected static final Class[] CONNECTION_TYPES = new Class[]{OLAPSchemaConnectionType.class, TableConnectionType.class};

    public CubeExportListener(TransportableTypeInterface type) {
        super(type);
    }

    public ExportItemInterface createExportItem(String name, String id, TransportableTypeInterface type) {
        return new CubeExportItem(name, id, type);
    }

    public Class[] getConnectionTypes() {
        return CONNECTION_TYPES;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int analyzeObjectsToExport(ExportOperationInterface operation, List objects) throws MdException {
        int rc = 0;
        String cubeNames = new String();
        boolean longListOfCubes = false;
        boolean errorNoMatchingJobs = false;
        MdObjectStore mdStore = null;
        try {
            try {
                mdStore = operation.getMetadataFactory().createObjectStore(null, "CubeExportListener.analyzeobjectsToExport");
                for (int i = 0; i < objects.size(); ++i) {
                    String msg;
                    Cube nextGeneration;
                    UsageVersion usageVersion;
                    CubeExportItem cubeExportItem = (CubeExportItem)((Object)objects.get(i));
                    SimpleLogicalObject jobForCube = null;
                    try {
                        int iOptions = 284;
                        Cube mdCube = (Cube)operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)mdStore, "Cube", cubeExportItem.getID(), null, null, CUBE_DEPENDENCIES_TEMPLATE, iOptions);
                        if (mdCube == null) {
                            int n = rc = 8;
                            return n;
                        }
                        usageVersion = UsageVersion.decode((double)mdCube.getUsageVersion());
                        nextGeneration = mdCube.getNextGeneration();
                        AssociationList lmaps = mdCube.getTargetClassifierMaps();
                        if (!lmaps.isEmpty()) {
                            ClassifierMap mdCM = (ClassifierMap)lmaps.get(0);
                            AssociationList lSteps = mdCM.getSteps();
                            for (TransformationStep mdStep : lSteps) {
                                AssociationList lTAs = mdStep.getActivities();
                                for (TransformationActivity mdActivity : lTAs) {
                                    AssociationList lJobs = mdActivity.getJobs();
                                    for (Job mdJob : lJobs) {
                                        TypeInterface ti = Factory.getInstance().getTypeInterface("Job.CubeBuild");
                                        jobForCube = new SimpleLogicalObject(mdJob.getName(), mdJob.getFQID(), ti);
                                    }
                                }
                            }
                        }
                    }
                    catch (RemoteException e) {
                        throw new MdException((Throwable)e);
                    }
                    catch (LogicalTypeException le) {
                        throw new MdException((Throwable)le);
                    }
                    Map items = operation.getExportItems();
                    boolean found = false;
                    List jobs = (List)items.get("Job.CubeBuild");
                    if (jobs == null) {
                        found = false;
                    } else {
                        for (int j = 0; j < jobs.size() && !found; ++j) {
                            JobCubeExportItem cubeItem = (JobCubeExportItem)((Object)jobs.get(j));
                            if (jobForCube == null || !cubeItem.getID().equals(jobForCube.getID())) continue;
                            found = true;
                        }
                    }
                    if (!found) {
                        rc = 8;
                        errorNoMatchingJobs = true;
                        if (cubeNames.length() > 2000) {
                            longListOfCubes = true;
                        } else {
                            cubeNames = cubeNames.length() != 0 ? cubeNames + ", " + cubeExportItem.getName() : cubeNames + cubeExportItem.getName();
                        }
                    }
                    if (!(usageVersion.equals((Object)new UsageVersion(4, 0)) || usageVersion.equals((Object)new UsageVersion(4, 1)) || usageVersion.equals((Object)new UsageVersion(5, 0)))) {
                        rc = 8;
                        msg = RB.getStringResource("CubeExportListener.VersionNotSupported.fmt");
                        throw new MdException(UtilMisc.getMessage((String)msg, (Object)cubeExportItem.getName()));
                    }
                    if (nextGeneration == null) continue;
                    rc = 8;
                    msg = RB.getStringResource("CubeExportListener.CubeIsNotCurrentGeneration.fmt");
                    throw new MdException(UtilMisc.getMessage((String)msg, (Object)cubeExportItem.getName()));
                }
                if (rc != 8) return rc;
                if (!errorNoMatchingJobs) return rc;
                String msg = "";
                if (longListOfCubes) {
                    msg = RB.getStringResource("CubeExportListener.JobsNotExportedError2.fmt");
                    throw new MdException(UtilMisc.getMessage((String)msg, (Object)cubeNames));
                }
                msg = RB.getStringResource("CubeExportListener.JobsNotExportedError.fmt");
                throw new MdException(UtilMisc.getMessage((String)msg, (Object)cubeNames));
            }
            finally {
                try {
                    if (mdStore != null) {
                        mdStore.dispose();
                    }
                }
                catch (RemoteException e) {
                    throw new MdException((Throwable)e);
                }
            }
        }
        catch (RemoteException e) {
            throw new MdException((Throwable)e);
        }
    }
}

